/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChange;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoDs.Except;

public class HostStateThread
extends Thread
implements AstorDefs {
    private AstorTree parent;
    private TangoHost host;
    private DevState devstate = DevState.UNKNOWN;
    private int readInfoPeriod;
    boolean stop_it = false;
    private boolean running = true;
    private DevState previous_state = DevState.UNKNOWN;
    private String[] prev_running = null;
    private String[] prev_stopped = null;
    private static String stateAttr = "HostState";
    private static String[] serversAttr = new String[]{"RunningServers", "StoppedServers"};
    private static String[] filters = new String[0];
    private TangoEventsAdapter event_supplier = null;
    private StateEventListener state_listener = null;
    private ServerEventListener[] server_listener = null;

    public HostStateThread(AstorTree parent, TangoHost host) {
        this.parent = parent;
        this.host = host;
        this.readInfoPeriod = AstorUtil.getStarterReadPeriod() / 2;
    }

    public synchronized void updateData() {
        this.notify();
    }

    public boolean is_alive() {
        boolean b = this.running;
        this.running = false;
        return b;
    }

    private void readState() {
        block3: {
            this.devstate = DevState.UNKNOWN;
            try {
                DeviceData argout = this.host.command_inout("State");
                this.devstate = argout.extractDevState();
                this.host.except = null;
            }
            catch (DevFailed e) {
                this.host.except = e;
                this.devstate = DevState.FAULT;
                if (!this.host.getName().equals("orion")) break block3;
                Except.print_exception((Exception)((Object)e));
            }
        }
        this.updateHost(this.devstate);
        if (this.host.check_notifd) {
            int notifyd_state = this.readNotifydState();
            this.updateHost(notifyd_state);
        }
    }

    public void run() {
        this.readState();
        try {
            HostStateThread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        while (!this.stop_it) {
            long t0 = System.currentTimeMillis();
            if (this.host.do_polling) {
                if (!this.host.use_events) {
                    this.readState();
                }
                if (this.host.poll_serv_lists) {
                    if (this.host.use_events) {
                        this.subscribeChangeServerEvent();
                    } else if (this.devstate != DevState.FAULT) {
                        this.controlServers();
                    }
                }
            } else if (!this.host.use_events) {
                this.updateHost(DevState.UNKNOWN);
            }
            this.running = true;
            this.wait_next_loop(t0);
        }
        this.unsubscribeServersEvent();
        this.unsubscribeStateEvent();
    }

    public synchronized void wait_next_loop(long t0) {
        try {
            long t1 = System.currentTimeMillis();
            long time_to_sleep = (long)this.readInfoPeriod - (t1 - t0);
            if (time_to_sleep <= 0L) {
                time_to_sleep = 100L;
            }
            this.wait(time_to_sleep);
        }
        catch (InterruptedException e) {
            System.out.println(e);
        }
    }

    public synchronized void updateHost(DevState state) {
        if (state == this.previous_state) {
            return;
        }
        this.previous_state = state;
        this.host.state = state == DevState.ON ? 3 : (state == DevState.MOVING ? 4 : (state == DevState.ALARM ? 2 : (state == DevState.FAULT ? 1 : 0)));
        this.parent.updateState();
    }

    public synchronized void updateHost(int notifyd_state) {
        if (this.host.notifyd_state == notifyd_state) {
            return;
        }
        this.host.notifyd_state = notifyd_state;
        this.parent.updateState();
        if (this.host.info_dialog != null) {
            this.host.info_dialog.updateData();
        }
    }

    public synchronized void updateHost(String[] running, String[] stopped) {
        TangoServer server;
        int i;
        boolean changed = false;
        if (this.prev_running == null || this.prev_stopped == null) {
            changed = true;
        } else if (running != null && this.prev_running.length != running.length || stopped != null && this.prev_stopped.length != stopped.length) {
            changed = true;
        } else if (running == null || stopped == null) {
            changed = true;
        } else {
            for (i = 0; i < running.length && !changed; ++i) {
                if (this.prev_running[i].equals(running[i])) continue;
                changed = true;
            }
            for (i = 0; i < stopped.length && !changed; ++i) {
                if (this.prev_stopped[i].equals(stopped[i])) continue;
                changed = true;
            }
        }
        if (!changed) {
            return;
        }
        for (i = this.host.nbServers() - 1; i >= 0; --i) {
            server = this.host.getServer(i);
            boolean found = false;
            if (server.isRunning()) {
                found = true;
            } else if (stopped != null) {
                for (int j = 0; !found && j < stopped.length; ++j) {
                    found = server.getName().equals(stopped[j]);
                }
            }
            if (found) continue;
            this.host.removeServer(i);
        }
        if (running == null) {
            running = new String[]{};
        }
        for (i = 0; i < running.length; ++i) {
            try {
                server = this.host.getServer(running[i]);
                if (server == null) {
                    this.host.addServer(new TangoServer(running[i], true));
                    continue;
                }
                server.setRunning(true);
                continue;
            }
            catch (DevFailed e) {
                // empty catch block
            }
        }
        if (stopped == null) {
            stopped = new String[]{};
        }
        for (i = 0; i < stopped.length; ++i) {
            try {
                server = this.host.getServer(stopped[i]);
                if (server == null) {
                    this.host.addServer(new TangoServer(stopped[i], false));
                    continue;
                }
                server.setRunning(false);
                continue;
            }
            catch (DevFailed e) {
                Except.print_exception((Exception)((Object)e));
            }
        }
        this.prev_running = new String[running.length];
        this.prev_stopped = new String[stopped.length];
        System.arraycopy(running, 0, this.prev_running, 0, running.length);
        System.arraycopy(stopped, 0, this.prev_stopped, 0, stopped.length);
        if (this.host.info_dialog != null) {
            this.host.info_dialog.updateData();
        }
    }

    private synchronized void controlServers() {
        String[] runningServers = new String[]{};
        String[] stoppedServers = new String[]{};
        try {
            DeviceData din = new DeviceData();
            din.insert(this.host.all_servers);
            DeviceData dout = this.host.command_inout("DevGetRunningServers", din);
            runningServers = dout.extractStringArray();
            DeviceData dout2 = this.host.command_inout("DevGetStopServers", din);
            stoppedServers = dout2.extractStringArray();
        }
        catch (DevFailed e) {
            this.host.except = e;
            return;
        }
        catch (Exception e) {
            try {
                Except.throw_exception((String)e.toString(), (String)"Cannont extract Data", (String)"HostStateThread");
            }
            catch (DevFailed df) {
                this.host.except = df;
                return;
            }
        }
        this.updateHost(runningServers, stoppedServers);
    }

    public void subscribeChangeStateEvent() {
        long t0 = System.currentTimeMillis();
        String strerror = null;
        try {
            if (this.event_supplier == null) {
                this.event_supplier = new TangoEventsAdapter((DeviceProxy)this.host);
            }
            if (this.state_listener == null) {
                this.state_listener = new StateEventListener();
                this.event_supplier.addTangoChangeListener((ITangoChangeListener)this.state_listener, stateAttr, filters);
            }
        }
        catch (DevFailed e) {
            this.state_listener = null;
            this.readState();
            this.host.use_events = false;
            strerror = "subscribeChangeStateEvent() for " + this.host.name() + " FAILED !\n" + e.errors[0].desc;
            Except.print_exception((Exception)((Object)e));
        }
        catch (Exception e) {
            this.state_listener = null;
            strerror = "subscribeChangeStateEvent() for " + this.host.name() + " FAILED !" + e.toString();
            e.printStackTrace();
        }
        long t1 = System.currentTimeMillis();
        if (AstorUtil.getDebug()) {
            if (strerror != null) {
                System.out.println(strerror);
            } else {
                System.out.println("subscribeChangeStateEvent() " + this.host.name() + " : " + (t1 - t0) + " ms");
            }
        }
        this.parent.updateMonitor(strerror);
    }

    private void subscribeChangeServerEvent() {
        int i;
        this.controlServers();
        try {
            if (this.event_supplier == null) {
                this.event_supplier = new TangoEventsAdapter((DeviceProxy)this.host);
            }
        }
        catch (DevFailed e) {
            this.event_supplier = null;
            System.out.println("subscribeChangeServerEvent() for " + this.host.name() + " FAILED !");
            Except.print_exception((Exception)((Object)e));
            return;
        }
        catch (Exception e) {
            this.event_supplier = null;
            System.out.println("subscribeChangeServerEvent() for " + this.host.name() + " FAILED !");
            System.out.println(e);
            return;
        }
        if (this.server_listener == null) {
            this.server_listener = new ServerEventListener[serversAttr.length];
            for (i = 0; i < serversAttr.length; ++i) {
                this.server_listener[i] = null;
            }
        }
        for (i = 0; i < serversAttr.length; ++i) {
            if (this.server_listener[i] != null) continue;
            try {
                this.server_listener[i] = new ServerEventListener();
                this.event_supplier.addTangoChangeListener((ITangoChangeListener)this.server_listener[i], serversAttr[i], filters);
                if (!AstorUtil.getDebug()) continue;
                System.out.println("subscribeChangeServerEvent() for " + this.host.name() + "/" + serversAttr[i] + " OK!");
                continue;
            }
            catch (DevFailed e) {
                this.server_listener[i] = null;
                System.out.println("subscribeChangeServerEvent() for " + this.host.name() + " FAILED !");
                Except.print_exception((Exception)((Object)e));
                this.host.use_events = false;
                return;
            }
            catch (Exception e) {
                this.server_listener[i] = null;
                System.out.println("subscribeChangeServerEvent() for " + this.host.name() + " FAILED !");
                System.out.println(e);
                this.host.use_events = false;
                return;
            }
        }
    }

    public void unsubscribeStateEvent() {
        if (this.event_supplier != null && this.state_listener != null) {
            try {
                this.event_supplier.removeTangoChangeListener((ITangoChangeListener)this.state_listener, stateAttr);
                if (AstorUtil.getDebug()) {
                    System.out.println("unsubscribe event for " + this.host.getName() + "/" + stateAttr);
                }
            }
            catch (DevFailed e) {
                System.out.println("Failed to unsubscribe event for " + stateAttr);
                Except.print_exception((Exception)((Object)e));
            }
        }
    }

    public void unsubscribeServersEvent() {
        if (this.event_supplier != null && this.server_listener != null) {
            try {
                for (int i = 0; i < serversAttr.length; ++i) {
                    this.event_supplier.removeTangoChangeListener((ITangoChangeListener)this.server_listener[i], serversAttr[i]);
                    if (!AstorUtil.getDebug()) continue;
                    System.out.println("unsubscribe event for " + this.host.getName() + "/" + serversAttr[i]);
                }
            }
            catch (DevFailed e) {
                System.out.println("Failed to unsubscribe event for " + stateAttr);
                Except.print_exception((Exception)((Object)e));
            }
        }
    }

    private int readNotifydState() {
        if (!this.host.check_notifd) {
            return 3;
        }
        int notifyd_state = 0;
        try {
            boolean running;
            DeviceData dout = this.host.command_inout("NotifyDaemonState");
            boolean bl = running = dout.extractDevState() == DevState.ON;
            notifyd_state = running ? 3 : 1;
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("NOTIFY_NOT_AVAILABLE") || e.errors[0].reason.equals("API_CommandNotFound") || e.errors[0].reason.equals("TangoApi_DEVICE_NOT_EXPORTED")) {
                notifyd_state = 0;
            } else {
                notifyd_state = 0;
                Except.print_exception((Exception)((Object)e));
            }
        }
        catch (Exception e) {
            try {
                notifyd_state = 0;
                Except.throw_exception((String)e.toString(), (String)"Cannot extract Data", (String)"HostStateThread");
            }
            catch (DevFailed df) {
                Except.print_exception((Exception)((Object)df));
            }
        }
        return notifyd_state;
    }

    class ServerEventListener
    implements ITangoChangeListener {
        ServerEventListener() {
        }

        public void change(TangoChangeEvent event) {
            TangoChange tc = (TangoChange)event.getSource();
            String devname = tc.getEventSupplier().name();
            String[] servers = new String[]{};
            String attname = null;
            try {
                DeviceAttribute attr = event.getValue();
                attname = attr.getName();
                servers = attr.extractStringArray();
                if (AstorUtil.getDebug()) {
                    System.out.println(devname + "/" + attr.getName() + " changed " + " : ");
                }
            }
            catch (DevFailed e) {
                if (e.errors[0].reason.equals("API_EventTimeout")) {
                    System.out.println("HostStataThread.ServerEventListener" + devname + " : API_EventTimeout");
                } else {
                    Except.print_exception((Exception)((Object)e));
                }
            }
            catch (Exception e) {
                System.out.println("AstorEvent." + devname);
                System.out.println(e);
                System.out.println("HostStateThread.ServerEventListener : could not extract data!");
            }
            if (attname != null) {
                if (attname.equals(serversAttr[0])) {
                    HostStateThread.this.updateHost(servers, HostStateThread.this.prev_stopped);
                } else {
                    HostStateThread.this.updateHost(HostStateThread.this.prev_running, servers);
                }
            }
        }
    }

    class StateEventListener
    implements ITangoChangeListener {
        StateEventListener() {
        }

        public void change(TangoChangeEvent event) {
            TangoChange tc = (TangoChange)event.getSource();
            String devname = tc.getEventSupplier().name();
            HostStateThread.this.devstate = DevState.UNKNOWN;
            int notifyd_state = 3;
            try {
                DeviceAttribute attr = event.getValue();
                short state_value = attr.extractShort();
                HostStateThread.this.devstate = DevState.from_int((int)state_value);
                notifyd_state = HostStateThread.this.readNotifydState();
            }
            catch (DevFailed e) {
                HostStateThread.this.devstate = DevState.ALARM;
                notifyd_state = 0;
                if (e.errors[0].reason.equals("API_EventTimeout")) {
                    System.out.println("HostStateThread.StateEventListener" + devname + " : API_EventTimeout");
                    try {
                        HostStateThread.this.host.ping();
                    }
                    catch (DevFailed e2) {
                        HostStateThread.this.devstate = DevState.FAULT;
                    }
                } else if (e.errors[0].reason.equals("TangoApi_CANNOT_IMPORT_DEVICE")) {
                    System.out.println("HostStateThread.StateEventListener" + devname + " : TangoApi_CANNOT_IMPORT_DEVICE");
                    HostStateThread.this.devstate = DevState.FAULT;
                }
            }
            catch (Exception e) {
                System.out.println("AstorEvent." + devname);
                System.out.println(e);
                System.out.println("HostStateThread.StateEventListener : could not extract data!");
                HostStateThread.this.devstate = DevState.UNKNOWN;
            }
            HostStateThread.this.updateHost(HostStateThread.this.devstate);
            HostStateThread.this.updateHost(notifyd_state);
        }
    }
}

