/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.Monitor;
import admin.astor.ServersTree;
import admin.astor.TangoHost;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.Except;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CtrlServersDialog
extends JDialog {
    private static final String separator = "___________________________________________________";
    private Astor parent;
    private TangoHost[] hosts;
    private JTextArea dbInfoArea;
    private JTextArea servInfoArea;
    private JPanel buttonPanel;
    private JPanel middlePanel;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;

    public CtrlServersDialog(Astor parent, TangoHost[] hosts) {
        super((Frame)parent, false);
        this.parent = parent;
        this.hosts = hosts;
        this.initComponents();
        this.pack();
        new DisplayThread().start();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.middlePanel = new JPanel();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CtrlServersDialog.this.closeDialog(evt);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        this.cancelButton.setText("Dismiss");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CtrlServersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.middlePanel.setLayout(new BorderLayout());
        this.servInfoArea = new JTextArea("Servers Info");
        this.servInfoArea.setBackground(Color.lightGray);
        this.servInfoArea.setEditable(false);
        this.servInfoArea.setFont(new Font("Dialog", 1, 14));
        this.getContentPane().add((Component)this.servInfoArea, "North");
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.dbInfoArea = new JTextArea("DB info.");
        this.dbInfoArea.setBackground(Color.lightGray);
        this.dbInfoArea.setEditable(false);
        this.dbInfoArea.setFont(new Font("Dialog", 1, 10));
        this.middlePanel.add((Component)this.dbInfoArea, "North");
        this.cancelButton.setBackground(Color.lightGray);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.setBackground(Color.lightGray);
        this.middlePanel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.middlePanel, "South");
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public void show(String title, Vector servnames, Vector servers_info) {
        ServersTree tree = new ServersTree(this.parent, "Controlled Servers", servnames, servers_info);
        this.jScrollPane1.setViewportView(tree);
        this.servInfoArea.setText(title);
        this.pack();
        AstorUtil.rightShiftDialog(this, this.parent);
        this.setVisible(true);
    }

    class DisplayThread
    extends Thread {
        private Monitor monitor = null;

        private void updateProgressMonitor(String hostname, int hostnum) {
            if (this.monitor == null) {
                this.monitor = new Monitor(CtrlServersDialog.this.parent, "Browsing TANGO database", "Reading host");
            }
            double ratio = (double)(hostnum + 1) / (double)CtrlServersDialog.this.hosts.length;
            this.monitor.setProgressValue(ratio, "Query servers for " + hostname);
        }

        public DbServInfo[] getControledServers(String hostname) throws DevFailed {
            Database db = ApiUtil.get_db_obj();
            DeviceData argin = new DeviceData();
            argin.insert(hostname);
            DeviceData argout = db.command_inout("DbGetHostServerList", argin);
            String[] servnames = argout.extractStringArray();
            Vector<DbServInfo> servers = new Vector<DbServInfo>();
            for (int i = 0; i < servnames.length; ++i) {
                DbServInfo s = db.get_server_info(servnames[i]);
                if (!s.controlled) continue;
                servers.add(s);
            }
            DbServInfo[] servinfo = new DbServInfo[servers.size()];
            for (int i = 0; i < servers.size(); ++i) {
                servinfo[i] = (DbServInfo)servers.elementAt(i);
            }
            return servinfo;
        }

        private synchronized void wait_next_loop(long ms) {
            try {
                this.wait(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void run() {
            int nb_programs = 0;
            int nb_servers = 0;
            StringBuffer sb = new StringBuffer();
            Vector<String> servnames = new Vector<String>();
            Vector<DbServInfo[]> servers_info = new Vector<DbServInfo[]>();
            try {
                int[] line_displayed = new int[]{4, 5, 6, 7, 9, 10};
                DeviceData argout = ApiUtil.get_db_obj().command_inout("DbInfo");
                String[] res = argout.extractStringArray();
                String str = "Database Information:\n\n";
                for (int i = 0; i < line_displayed.length; ++i) {
                    str = str + res[line_displayed[i]];
                    if (i >= line_displayed.length - 1) continue;
                    str = str + "\n";
                }
                CtrlServersDialog.this.dbInfoArea.setText(str);
            }
            catch (DevFailed e) {
                PopupError.show((Component)CtrlServersDialog.this.parent, e);
            }
            int nb_on_events = 0;
            int nb_classes = 0;
            int nb_devices = 0;
            for (int i = 0; i < CtrlServersDialog.this.hosts.length; ++i) {
                int s;
                this.updateProgressMonitor(CtrlServersDialog.this.hosts[i].getName(), i);
                if (((CtrlServersDialog)CtrlServersDialog.this).hosts[i].use_events) {
                    ++nb_on_events;
                }
                DbServInfo[] servinfo = new DbServInfo[]{};
                try {
                    servinfo = this.getControledServers(CtrlServersDialog.this.hosts[i].getName());
                    for (s = 0; s < servinfo.length; ++s) {
                        DbServer dbs = new DbServer(servinfo[s].name);
                        String[] classes = dbs.get_class_list();
                        nb_classes += classes.length;
                        for (int c = 0; c < classes.length; ++c) {
                            String[] dn = dbs.get_device_name(classes[c]);
                            nb_devices += dn.length;
                        }
                    }
                }
                catch (DevFailed e) {
                    Except.print_exception((Exception)((Object)e));
                }
                sb.append(CtrlServersDialog.this.hosts[i].getName() + " (" + servinfo.length + " server");
                if (servinfo.length > 1) {
                    sb.append("s");
                }
                sb.append("):\n");
                servers_info.add(servinfo);
                for (s = 0; s < servinfo.length; ++s) {
                    ++nb_servers;
                    sb.append("\t" + servinfo[s].name + "\tStartup level: " + servinfo[s].startup_level + "\n");
                    int start_instance = servinfo[s].name.indexOf("/");
                    if (start_instance < 0) break;
                    String sname = servinfo[s].name.substring(0, start_instance);
                    boolean found = false;
                    for (int j = 0; j < servnames.size() && !found; ++j) {
                        String str = (String)servnames.elementAt(j);
                        found = str.equals(sname);
                    }
                    if (found) continue;
                    ++nb_programs;
                    servnames.add(sname);
                }
                sb.append("___________________________________________________\n\n");
                this.wait_next_loop(50L);
            }
            this.monitor.setProgressValue(100.0);
            Collections.sort(servnames, AstorUtil.getInstance().compare);
            String title = new String(CtrlServersDialog.this.hosts.length + " hosts in control system");
            if (nb_on_events > 0) {
                title = title + " (" + nb_on_events + " controlled on events)";
            }
            title = title + "\n" + nb_programs + " different servers \n" + nb_servers + " controlled instances\n" + nb_classes + " classes  -  " + nb_devices + " devices.";
            CtrlServersDialog.this.show(title, servnames, servers_info);
        }
    }
}

