/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.DevBrowserTree;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class TreePopupMenu
extends JPopupMenu {
    private DevBrowserTree parent;
    private static final int CHANGE = 0;
    private static final int PERIODIC = 1;
    private static final int ARCHIVE = 2;
    public static final int MODE_DEVICE = 0;
    public static final int MODE_ATTR = 1;
    public static final int MODE_SERVER = 2;
    private static String[] attLabels = new String[]{"Manage Polling", null, "Subscribe on Change  Event", "Subscribe on Periodic Event", "Subscribe on Archive  Event", null, null, "Edit Change  Event Properties", "Edit Periodic Event Properties", "Edit Archive  Event Properties"};
    private static String[] devLabels = new String[]{"Test Device", "MonitorDevice", "Host Panel", "Manage Polling", "Polling Profiler", "Go To Server Node"};
    private static String[] servLabels = new String[]{"Test Admin Device", "Host Panel", "Server Architecture", "Polling Profiler"};
    private static final int OFFSET = 2;
    private static final int ATT_POLLING = 0;
    private static final int ATT_ADD_CHANGE = 2;
    private static final int ATT_ADD_PERIODIC = 3;
    private static final int ATT_ADD_ARCHIVE = 4;
    private static final int ATT_ED_CHANGE = 7;
    private static final int ATT_ED_PERIODIC = 8;
    private static final int ATT_ED_ARCHIVE = 9;
    private static final int DEV_TEST = 0;
    private static final int DEV_MONITOR = 1;
    private static final int DEV_HOST_PANEL = 2;
    private static final int DEV_POLLING = 3;
    private static final int DEV_PROFILER = 4;
    private static final int DEV_GOTO_SERVER = 5;
    private static final int SERV_TEST = 0;
    private static final int SERV_HOST_PANEL = 1;
    private static final int SERV_ARCHI = 2;
    private static final int SERV_PROFILER = 3;
    private int mode;
    private JLabel title;

    public TreePopupMenu(DevBrowserTree parent, int mode) {
        this.parent = parent;
        this.mode = mode;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        this.title = new JLabel("Attribute :");
        this.title.setFont(new Font("Dialog", 1, 16));
        this.add(this.title);
        this.add(new JPopupMenu.Separator());
        String[] menuLabels = this.mode == 1 ? attLabels : (this.mode == 0 ? devLabels : servLabels);
        for (int i = 0; i < menuLabels.length; ++i) {
            if (menuLabels[i] == null) {
                this.add(new JPopupMenu.Separator());
                continue;
            }
            JMenuItem btn = new JMenuItem(menuLabels[i]);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TreePopupMenu.this.hostActionPerformed(evt);
                }
            });
            this.add(btn);
        }
    }

    public void showMenu(MouseEvent evt) {
        this.showMenu(evt, false);
    }

    public void showMenu(MouseEvent evt, boolean obj_has_polling) {
        TreePath selectedPath = this.parent.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        this.parent.setSelectionPath(selectedPath);
        if (this.mode == 1) {
            this.title.setText("Attribute: " + this.parent.getSelectedName());
        } else if (this.mode == 0) {
            this.title.setText("Device: " + this.parent.getSelectedName());
            String collec = this.parent.getCollection();
            this.getComponent(6).setEnabled(obj_has_polling);
            this.getComponent(7).setVisible(collec.equals("Devices") || collec.equals("Aliases"));
        } else if (this.mode == 2) {
            this.title.setText("Server: " + this.parent.getSelectedName());
            this.getComponent(5).setEnabled(obj_has_polling);
        }
        this.show(this.parent, evt.getX(), evt.getY());
    }

    private void hostActionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (this.mode == 1) {
            if (cmd.equals(attLabels[0])) {
                this.parent.managePolling();
            } else if (cmd.equals(attLabels[2])) {
                this.parent.add(0);
            } else if (cmd.equals(attLabels[3])) {
                this.parent.add(1);
            } else if (cmd.equals(attLabels[4])) {
                this.parent.add(2);
            } else if (cmd.equals(attLabels[7])) {
                this.parent.editProperties(0);
            } else if (cmd.equals(attLabels[8])) {
                this.parent.editProperties(1);
            } else if (cmd.equals(attLabels[9])) {
                this.parent.editProperties(2);
            }
        } else if (this.mode == 0) {
            if (cmd.equals(devLabels[0])) {
                this.parent.deviceTest();
            } else if (cmd.equals(devLabels[1])) {
                this.parent.deviceMonitor();
            } else if (cmd.equals(devLabels[2])) {
                this.parent.displayHostPanel();
            } else if (cmd.equals(devLabels[3])) {
                this.parent.managePolling();
            } else if (cmd.startsWith(devLabels[4])) {
                this.parent.showProfiler();
            } else if (cmd.startsWith(devLabels[5])) {
                this.parent.gotoServer();
            }
        } else if (this.mode == 2) {
            if (cmd.equals(servLabels[0])) {
                this.parent.deviceTest();
            } else if (cmd.equals(servLabels[1])) {
                this.parent.displayHostPanel();
            } else if (cmd.equals(servLabels[2])) {
                this.parent.serverArchitecture();
            } else if (cmd.equals(servLabels[3])) {
                this.parent.showProfiler();
            }
        }
    }
}

