/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.EventsTable;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoDs.TangoConst;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PropertyDialog
extends JDialog
implements TangoConst {
    private JFrame parent;
    private String signame;
    static int ADD_OPTION = 0;
    static int UPDATE_OPTION = 1;
    static int CANCEL_OPTION = 2;
    private int mode;
    private AttributeProxy att = null;
    private AttributeInfoEx info;
    private String abs_change;
    private String rel_change;
    private String period;
    private JLabel absLbl;
    private JTextField absTxt;
    private JButton cancelBtn;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel periodLbl;
    private JTextField periodTxt;
    private JLabel relLbl;
    private JTextField relTxt;
    private JLabel titleLabel;
    private JButton updateBtn;

    public PropertyDialog(JFrame parent, String signame, int mode) {
        super((Frame)parent, true);
        this.parent = parent;
        this.signame = signame;
        this.mode = mode;
        this.initComponents();
        this.titleLabel.setText(EventsTable.strMode[mode] + " Event for " + signame);
        switch (mode) {
            case 0: {
                this.periodLbl.setVisible(false);
                this.periodTxt.setVisible(false);
                break;
            }
            case 1: {
                this.absLbl.setVisible(false);
                this.absTxt.setVisible(false);
                this.relLbl.setVisible(false);
                this.relTxt.setVisible(false);
            }
        }
        this.pack();
        Point p = parent.getLocationOnScreen();
        p.x += 50;
        p.y += 50;
        this.setLocation(p);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.updateBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.absLbl = new JLabel();
        this.relLbl = new JLabel();
        this.periodLbl = new JLabel();
        this.absTxt = new JTextField();
        this.relTxt = new JTextField();
        this.periodTxt = new JTextField();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PropertyDialog.this.closeDialog(evt);
            }
        });
        this.updateBtn.setText("Update");
        this.updateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.updateBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.updateBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jPanel3.setLayout(new GridBagLayout());
        this.absLbl.setText("abs_change");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel3.add((Component)this.absLbl, gridBagConstraints);
        this.relLbl.setText("rel_change");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel3.add((Component)this.relLbl, gridBagConstraints);
        this.periodLbl.setText("period");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel3.add((Component)this.periodLbl, gridBagConstraints);
        this.absTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel3.add((Component)this.absTxt, gridBagConstraints);
        this.relTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel3.add((Component)this.relTxt, gridBagConstraints);
        this.periodTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel3.add((Component)this.periodTxt, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.pack();
    }

    private boolean checkValues() {
        try {
            double d;
            boolean one_set = false;
            String s = this.getAbs();
            if (!s.equals("Not specified")) {
                d = Double.parseDouble(s);
                one_set = true;
            }
            if (!(s = this.getRel()).equals("Not specified")) {
                d = Double.parseDouble(s);
                one_set = true;
            }
            if (!(s = this.getPeriod()).equals("Not specified")) {
                int i = Integer.parseInt(s);
                one_set = true;
            }
            if (!one_set) {
                PopupError.show((Component)this, "At least, one field must be filled !");
                return false;
            }
        }
        catch (Exception e) {
            PopupError.show((Component)this, e);
            return false;
        }
        return true;
    }

    private boolean writeValues() {
        try {
            boolean changed = false;
            if (!this.abs_change.equals(this.getAbs())) {
                changed = true;
                if (this.mode == 0) {
                    this.info.events.ch_event.abs_change = this.getAbs();
                } else if (this.mode == 2) {
                    this.info.events.arch_event.abs_change = this.getAbs();
                }
            }
            if (!this.rel_change.equals(this.getRel())) {
                changed = true;
                if (this.mode == 0) {
                    this.info.events.ch_event.rel_change = this.getRel();
                } else if (this.mode == 2) {
                    this.info.events.arch_event.rel_change = this.getRel();
                }
            }
            if (!this.period.equals(this.getPeriod())) {
                changed = true;
                if (this.mode == 1) {
                    this.info.events.per_event.period = this.getPeriod();
                } else if (this.mode == 2) {
                    this.info.events.arch_event.period = this.getPeriod();
                }
            }
            if (changed) {
                AttributeInfoEx[] aie = new AttributeInfoEx[]{this.info};
                this.att.set_info(aie);
            }
            return true;
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.parent, e);
            return false;
        }
    }

    private void updateBtnActionPerformed(ActionEvent evt) {
        if (this.checkValues() && this.writeValues()) {
            this.doClose();
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    String getAbs() {
        return this.absTxt.getText().trim();
    }

    String getRel() {
        return this.relTxt.getText().trim();
    }

    String getPeriod() {
        return this.periodTxt.getText().trim();
    }

    private void displayProperty() throws DevFailed {
        if (this.att == null) {
            this.att = new AttributeProxy(this.signame);
        }
        this.info = this.att.get_info_ex();
        switch (this.mode) {
            case 0: {
                if (this.info.events != null && this.info.events.ch_event != null) {
                    this.abs_change = this.info.events.ch_event.abs_change;
                    this.rel_change = this.info.events.ch_event.rel_change;
                    this.period = "Not specified";
                    break;
                }
                this.abs_change = "Not specified";
                this.rel_change = "Not specified";
                this.period = "Not specified";
                break;
            }
            case 2: {
                if (this.info.events != null && this.info.events.arch_event != null) {
                    this.abs_change = this.info.events.arch_event.abs_change;
                    this.rel_change = this.info.events.arch_event.rel_change;
                    this.period = this.info.events.arch_event.period;
                    break;
                }
                this.abs_change = "Not specified";
                this.rel_change = "Not specified";
                this.period = "Not specified";
                break;
            }
            case 1: {
                if (this.info.events != null && this.info.events.per_event != null) {
                    this.abs_change = "Not specified";
                    this.rel_change = "Not specified";
                    this.period = this.info.events.per_event.period;
                    break;
                }
                this.abs_change = "Not specified";
                this.rel_change = "Not specified";
                this.period = "Not specified";
            }
        }
        this.absTxt.setText(this.abs_change);
        this.relTxt.setText(this.rel_change);
        this.periodTxt.setText(this.period);
    }

    public void showDialog() {
        try {
            this.displayProperty();
            this.setVisible(true);
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.parent, e);
        }
    }
}

