/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.tools.DevPollStatus;
import admin.astor.tools.PolledElement;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.Timer;

public class PollingProfiler
extends JDialog
implements IJLChartListener {
    private JLChart chart = new JLChart();
    private JLAxis y_axis;
    private JLAxis x_axis;
    private String[] devnames;
    private DevPollStatus poll_status;
    private Component parent = null;
    private Timer timer = null;
    private int timer_period = 2;
    private boolean update_chart = true;
    private JLDataView[] data = null;
    private long now;
    private JRadioButton autoBtn;
    private JButton cancelBtn;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel titleLabel;
    private JButton updateBtn;

    public PollingProfiler(JDialog parent, String devname) throws DevFailed {
        super((Dialog)parent, false);
        this.parent = parent;
        this.realConstructor(new String[]{devname});
    }

    public PollingProfiler(Frame parent, String devname) throws DevFailed {
        super(parent, false);
        this.parent = parent;
        this.realConstructor(new String[]{devname});
    }

    public PollingProfiler(JDialog parent, String[] devnames) throws DevFailed {
        super((Dialog)parent, false);
        this.parent = parent;
        this.realConstructor(devnames);
    }

    public PollingProfiler(Frame parent, String[] devnames) throws DevFailed {
        super(parent, false);
        this.parent = parent;
        this.realConstructor(devnames);
    }

    private void realConstructor(String[] devnames) throws DevFailed {
        this.devnames = devnames;
        this.initComponents();
        this.initOwnComponents();
        this.updateData();
        this.titleLabel.setVisible(false);
        this.pack();
        if (this.parent != null && this.parent.isVisible()) {
            Point p = this.parent.getLocationOnScreen();
            p.x += 10;
            p.y += 10;
            this.setLocation(p);
        }
    }

    private void initOwnComponents() {
        this.y_axis = this.chart.getY2Axis();
        this.x_axis = this.chart.getXAxis();
        this.chart.setBackground(Color.white);
        this.chart.setChartBackground(Color.lightGray);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.setLabelVisible(true);
        this.chart.setLabelFont(new Font("Dialog", 1, 12));
        this.y_axis.setName("T0");
        this.y_axis.setAutoScale(false);
        this.x_axis.setAutoScale(false);
        this.x_axis.setName("Time");
        this.x_axis.setGridVisible(true);
        this.chart.setPreferredSize(new Dimension(850, 400));
        this.chart.setJLChartListener((IJLChartListener)this);
        this.chart.setLabelPlacement(2);
        this.getContentPane().add((Component)this.chart, "Center");
        this.chart.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                PollingProfiler.this.myMouseReleased(evt);
            }
        });
        String title = "Polling on:  ";
        if (this.devnames.length == 1) {
            title = title + this.devnames[0];
        } else {
            try {
                String adm = new DeviceProxy(this.devnames[0]).adm_name();
                title = title + adm.substring(adm.indexOf(47) + 1);
            }
            catch (DevFailed e) {
                title = title + this.devnames[0];
                PopupError.show((Component)this, e);
            }
        }
        this.chart.setHeader(title);
    }

    private void myMouseReleased(MouseEvent evt) {
        if ((evt.getModifiers() & 0x10) != 0) {
            this.update_chart = true;
            this.doRepaint();
        }
    }

    private void updateData() throws DevFailed {
        int i;
        this.now = System.currentTimeMillis();
        try {
            this.poll_status = new DevPollStatus(this.devnames);
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
            return;
        }
        int nb = this.poll_status.size();
        if (nb == 0) {
            Except.throw_exception((String)"NoAttributePolled", (String)"There is not any attribute polled !", (String)"PollingProfiler.updateData()");
            return;
        }
        if (this.data != null && nb != this.data.length) {
            for (i = 0; i < this.data.length; ++i) {
                this.data[i].reset();
                this.y_axis.removeDataView(this.data[i]);
            }
            this.data = null;
            this.initOwnComponents();
        }
        if (this.data != null) {
            for (i = 0; i < this.data.length; ++i) {
                this.data[i].reset();
            }
        } else {
            this.data = new JLDataView[nb];
            AstorUtil util = AstorUtil.getInstance();
            util.initColors(nb);
            for (int i2 = 0; i2 < nb; ++i2) {
                this.data[i2] = new JLDataView();
                this.data[i2].setColor(util.getNewColor());
                this.data[i2].setName(this.poll_status.polledElementAt((int)i2).name);
                this.data[i2].setFill(false);
                this.data[i2].setLabelVisible(true);
                this.y_axis.addDataView(this.data[i2]);
            }
        }
        double xmin = this.now;
        for (int i3 = 0; i3 < nb; ++i3) {
            PolledElement pe = this.poll_status.polledElementAt(i3);
            double x = this.now - (long)pe.last_update;
            double y = 1.0 + 0.1 * (double)i3;
            this.data[i3].add(x, 0.0);
            this.data[i3].add(x, y);
            this.data[i3].add(x - pe.reading_time, y);
            this.data[i3].add(x - pe.reading_time, 0.0);
            if (x < xmin) {
                xmin = x;
            }
            for (int t = 0; t < pe.real_periods.length; ++t) {
                this.data[i3].add(x -= (double)pe.real_periods[t], 0.0);
                this.data[i3].add(x, y);
                this.data[i3].add(x - pe.reading_time, y);
                this.data[i3].add(x - pe.reading_time, 0.0);
                if (!(x < xmin)) continue;
                xmin = x;
            }
        }
        this.x_axis.setMinimum(xmin -= 1000.0);
        this.x_axis.setMaximum((double)this.now);
        this.y_axis.setMinimum(0.0);
        this.y_axis.setMaximum(0.1 * (double)nb + 1.5);
        this.doRepaint();
    }

    private void doRepaint() {
        if (this.update_chart) {
            this.chart.repaint();
        }
    }

    public String[] clickOnChart(JLChartEvent event) {
        this.update_chart = false;
        JLDataView dv = event.getDataView();
        PolledElement pe = null;
        for (int i = 0; pe == null && i < this.poll_status.size(); ++i) {
            if (!dv.getName().equals(this.poll_status.polledElementAt((int)i).name)) continue;
            pe = this.poll_status.polledElementAt(i);
        }
        int idx = event.getDataViewIndex();
        DataList dl = dv.getData();
        for (int i = 0; i < idx; ++i) {
            dl = dl.next;
        }
        if (pe == null) {
            return new String[0];
        }
        String[] s1 = pe.getInfo();
        int nblines = s1.length;
        String[] retVal = new String[nblines + 2];
        System.arraycopy(s1, 0, retVal, 0, nblines);
        retVal[nblines] = "";
        retVal[nblines + 1] = "T0 - " + (int)((double)this.now - dl.x) + " ms";
        return retVal;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.autoBtn = new JRadioButton();
        this.updateBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PollingProfiler.this.closeDialog(evt);
            }
        });
        this.autoBtn.setText("Auto Update");
        this.autoBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.autoBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.autoBtn);
        this.updateBtn.setText("Update");
        this.updateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.updateBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.updateBtn);
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void autoBtnActionPerformed(ActionEvent evt) {
        if (this.autoBtn.getSelectedObjects() != null) {
            String strval = "" + this.timer_period;
            if ((strval = (String)JOptionPane.showInputDialog(this, "Reading period (seconds)  ?", "Reading period", 1, null, null, strval)) == null) {
                this.autoBtn.setSelected(false);
                return;
            }
            try {
                this.timer_period = Integer.parseInt(strval);
            }
            catch (NumberFormatException e) {
                PopupError.show((Component)this, e.toString());
                this.autoBtn.setSelected(false);
                return;
            }
            try {
                this.updateData();
            }
            catch (DevFailed e) {
                // empty catch block
            }
            if (this.timer == null) {
                ActionListener taskPerformer = new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        try {
                            PollingProfiler.this.updateData();
                        }
                        catch (DevFailed devFailed) {
                            // empty catch block
                        }
                    }
                };
                this.timer = new Timer(1000 * this.timer_period, taskPerformer);
            } else {
                this.timer.setDelay(1000 * this.timer_period);
            }
            this.timer.start();
            this.updateBtn.setEnabled(false);
        } else if (this.timer != null) {
            this.timer.stop();
            this.updateBtn.setEnabled(true);
        }
    }

    private void updateBtnActionPerformed(ActionEvent evt) {
        try {
            this.updateData();
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.parent != null && this.parent.isVisible()) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        String devname = "pv/ps/1";
        if (args.length > 0) {
            devname = args[0];
        }
        try {
            new PollingProfiler(new JDialog(), devname).setVisible(true);
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
    }
}

