/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.ListDialog;
import admin.astor.ServerCmdThread;
import admin.astor.ServerPopupMenu;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.Timer;

public class HostInfoDialog
extends JDialog
implements AstorDefs {
    String name;
    private Astor astor;
    TangoHost host;
    private static String servname;
    private JLabel notifydBtn;
    private JLabel[] btn;
    private short nbStartupLevels = 0;
    private JPanel[] levelPanel;
    private Vector[] serverLevel;
    private boolean updating = true;
    private ServerThread thread = null;
    private ServerPopupMenu pMenu;
    private JButton dismissBtn;
    private JRadioButton displayAllBtn;
    private JPanel hostPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSeparator jSeparator1;
    private JButton startAllBtn;
    private JButton startNewBtn;
    private JButton stopAllBtn;
    private JLabel title;

    public HostInfoDialog(Astor astor, TangoHost host) {
        super((Frame)astor, false);
        this.initComponents();
        this.nbStartupLevels = AstorUtil.getStarterNbStartupLevels();
        this.astor = astor;
        this.host = host;
        this.name = host.getName();
        this.myInitComponents();
    }

    private void myInitComponents() {
        this.createStartupLevelPanels();
        this.buildPanel();
        this.pMenu = new ServerPopupMenu(this.astor, this, this.host);
        this.thread = new ServerThread();
        this.thread.start();
        this.setTitle((Object)((Object)this.host) + "  Control");
        this.pack();
    }

    private void initComponents() {
        this.hostPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.dismissBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.title = new JLabel();
        this.jPanel3 = new JPanel();
        this.startNewBtn = new JButton();
        this.startAllBtn = new JButton();
        this.stopAllBtn = new JButton();
        this.displayAllBtn = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.setTitle("Host Info Window");
        this.setBackground(new Color(198, 178, 168));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                HostInfoDialog.this.closeDialog(evt);
            }
        });
        this.hostPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.hostPanel, "Center");
        this.dismissBtn.setText("Dismiss");
        this.dismissBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.dismissBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.dismissBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new BorderLayout());
        this.title.setFont(new Font("Dialog", 1, 18));
        this.title.setHorizontalAlignment(0);
        this.title.setText("jLabel2");
        this.jPanel2.add((Component)this.title, "South");
        this.startNewBtn.setFont(new Font("Dialog", 1, 10));
        this.startNewBtn.setText("Start New");
        this.startNewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.startNewBtnActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.startNewBtn);
        this.startAllBtn.setFont(new Font("Dialog", 1, 10));
        this.startAllBtn.setText("Start All");
        this.startAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.startAllBtnActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.startAllBtn);
        this.stopAllBtn.setFont(new Font("Dialog", 1, 10));
        this.stopAllBtn.setText("Stop All");
        this.stopAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.stopAllBtnActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.stopAllBtn);
        this.displayAllBtn.setFont(new Font("Dialog", 1, 10));
        this.displayAllBtn.setText("Display All");
        this.displayAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.displayAllBtnActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.displayAllBtn);
        this.jPanel2.add((Component)this.jPanel3, "North");
        this.jPanel2.add((Component)this.jSeparator1, "Center");
        this.getContentPane().add((Component)this.jPanel2, "North");
    }

    private void displayAllBtnActionPerformed(ActionEvent evt) {
        boolean bl = this.host.all_servers = this.displayAllBtn.getSelectedObjects() != null;
        if (this.host.use_events) {
            this.checkUpdatePanel(true);
            this.thread.updateData(true);
        } else {
            this.host.updateData();
        }
    }

    private void stopAllBtnActionPerformed(ActionEvent evt) {
        boolean[] levelUsed = new boolean[this.nbStartupLevels];
        for (int level = 0; level < this.nbStartupLevels; ++level) {
            levelUsed[level] = this.serverLevel[level].size() != 0;
        }
        new ServerCmdThread(this, this.host, 1, levelUsed).start();
    }

    private void startAllBtnActionPerformed(ActionEvent evt) {
        boolean[] levelUsed = new boolean[this.nbStartupLevels];
        for (int level = 0; level < this.nbStartupLevels; ++level) {
            levelUsed[level] = this.serverLevel[level].size() != 0;
        }
        new ServerCmdThread(this, this.host, 0, levelUsed).start();
    }

    private void startNewBtnActionPerformed(ActionEvent evt) {
        ListDialog jlist = new ListDialog(this);
        Point p = this.getLocationOnScreen();
        p.translate(50, 50);
        jlist.setLocation(p);
        jlist.showDialog();
        servname = jlist.getSelectedItem();
        if (servname != null) {
            try {
                this.host.registerServer(servname);
                this.host.startOneServer(servname);
                if (new TangoServer(servname, false).startupLevel(this, this.host.getName(), p)) {
                    this.updateData();
                }
            }
            catch (DevFailed e) {
                PopupError.show((Component)this.astor, e);
            }
        }
    }

    private void dismissBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private synchronized Vector[] buildVectorOfStartupLevel() {
        int nb = this.nbStartupLevels;
        ++nb;
        ++nb;
        try {
            for (int i = 0; i < this.host.nbServers(); ++i) {
                TangoServer server = this.host.getServer(i);
                server.updateStartupInfo();
            }
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.astor, e);
        }
        Vector[] serverLevel = new Vector[nb];
        int idx = 0;
        int level = 1;
        while (level <= this.nbStartupLevels) {
            serverLevel[idx] = new Vector();
            for (int i = 0; i < this.host.nbServers(); ++i) {
                TangoServer server = this.host.getServer(i);
                if (server == null || server.info == null || server.info.startup_level != level) continue;
                serverLevel[idx].add(server);
            }
            ++level;
            ++idx;
        }
        serverLevel[nb - 2] = new Vector();
        serverLevel[nb - 1] = new Vector();
        for (int i = 0; i < this.host.nbServers(); ++i) {
            TangoServer server = this.host.getServer(i);
            if (server.info.controlled) {
                if (server.info.startup_level != 0) continue;
                serverLevel[nb - 2].add(server);
                continue;
            }
            serverLevel[nb - 1].add(server);
        }
        AstorUtil.getInstance().sort(serverLevel);
        return serverLevel;
    }

    private void addLevelPanelTitles() {
        GridBagConstraints gbc = new GridBagConstraints();
        int idx = 0;
        gbc.gridx = 1;
        gbc.anchor = 17;
        int level = 1;
        while (level <= this.nbStartupLevels) {
            gbc.gridy = 0;
            String text = "Level " + level + " : ";
            JLabel lbl = new JLabel(text);
            lbl.setFont(new Font("Dialog", 1, 14));
            this.levelPanel[idx].add((Component)lbl, gbc);
            gbc.gridy = 500;
            this.levelPanel[idx].add((Component)new JLabel(" "), gbc);
            ++level;
            ++idx;
        }
        gbc.gridy = 0;
        this.levelPanel[idx].add((Component)new JLabel("Not Automaticly Started:"), gbc);
        gbc.gridy = 500;
        this.levelPanel[idx].add((Component)new JLabel(" "), gbc);
        gbc.gridy = 0;
        this.levelPanel[++idx].add((Component)new JLabel("Not Controlled:"), gbc);
    }

    private void createStartupLevelPanels() {
        int nb = this.nbStartupLevels;
        ++nb;
        this.levelPanel = new JPanel[++nb];
        GridBagConstraints gbc = new GridBagConstraints();
        int y = 0;
        gbc.gridx = 1;
        gbc.gridy = y++;
        this.notifydBtn = new JLabel("Events Notify Daemon");
        this.notifydBtn.setVisible(this.host.check_notifd);
        this.hostPanel.add((Component)this.notifydBtn, gbc);
        this.notifydBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HostInfoDialog.this.serverBtnMouseClicked(evt);
            }
        });
        gbc.gridy = y++;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.fill = 2;
        this.hostPanel.add((Component)new JLabel("   "), gbc);
        int idx = 0;
        int level = 1;
        while (level <= this.nbStartupLevels) {
            gbc.gridy = y++;
            this.levelPanel[idx] = new JPanel(new GridBagLayout());
            this.hostPanel.add((Component)this.levelPanel[idx], gbc);
            ++level;
            ++idx;
        }
        gbc.gridy = y++;
        this.levelPanel[idx] = new JPanel(new GridBagLayout());
        this.hostPanel.add((Component)this.levelPanel[idx], gbc);
        gbc.gridy = y;
        this.levelPanel[++idx] = new JPanel(new GridBagLayout());
        this.hostPanel.add((Component)this.levelPanel[idx], gbc);
    }

    public void buildPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.host.all_servers) {
            this.title.setText(" All Servers Registred on " + this.name + " ");
        } else {
            this.title.setText(" Servers Controlled on " + this.name + " ");
        }
        this.btn = new JLabel[this.host.nbServers()];
        this.serverLevel = this.buildVectorOfStartupLevel();
        int nbmax = 0;
        for (int level = 0; level < this.nbStartupLevels + 2 && (level != this.nbStartupLevels + 1 || this.displayAllBtn.getSelectedObjects() != null); ++level) {
            if (this.serverLevel[level].size() <= nbmax) continue;
            nbmax = this.serverLevel[level].size();
        }
        int x_servers = (int)Math.sqrt(nbmax);
        if (x_servers > 2) {
            --x_servers;
        }
        if (x_servers > 4) {
            x_servers = 4;
        }
        Vector<JLabel> dummyLbl = new Vector<JLabel>();
        int btnIdx = 0;
        for (int level = 0; level < this.nbStartupLevels + 2; ++level) {
            int i;
            if (level == this.nbStartupLevels + 1 && this.displayAllBtn.getSelectedObjects() == null) {
                this.levelPanel[level].setVisible(false);
                break;
            }
            if (this.serverLevel[level].size() == 0) {
                this.levelPanel[level].setVisible(false);
                continue;
            }
            this.levelPanel[level].setVisible(true);
            int x = 1;
            int y = 1;
            for (i = 0; i < this.serverLevel[level].size() && btnIdx < this.btn.length; ++btnIdx, ++i) {
                TangoServer server = (TangoServer)this.serverLevel[level].elementAt(i);
                gbc.gridx = x++;
                gbc.gridy = y++;
                gbc.fill = 2;
                gbc.anchor = 17;
                this.btn[btnIdx] = new JLabel(server.toString());
                this.btn[btnIdx].setHorizontalAlignment(2);
                this.btn[btnIdx].setIcon(Astor.state_icons[0]);
                this.btn[btnIdx].setFont(new Font("Dialog", 1, 12));
                this.levelPanel[level].add((Component)this.btn[btnIdx], gbc);
                this.btn[btnIdx].addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent evt) {
                        HostInfoDialog.this.serverBtnMouseClicked(evt);
                    }
                });
                if (x <= x_servers) continue;
                x = 1;
            }
            if (this.serverLevel[level].size() >= x_servers + 1) continue;
            for (i = this.serverLevel[level].size(); i < x_servers; ++i) {
                gbc.gridx = x++;
                JLabel lbl = new JLabel(" ");
                dummyLbl.add(lbl);
                this.levelPanel[level].add((Component)lbl, gbc);
            }
        }
        this.addLevelPanelTitles();
        this.pack();
        if (this.btn.length > 0) {
            int i;
            int height = 10;
            int width = 0;
            for (i = 0; i < this.btn.length; ++i) {
                if (this.btn[i] == null || !this.btn[i].isVisible() || width >= this.btn[i].getWidth()) continue;
                width = this.btn[i].getWidth();
                height = this.btn[i].getHeight();
            }
            for (i = 0; i < this.btn.length; ++i) {
                if (this.btn[i] == null || !this.btn[i].isVisible()) continue;
                this.btn[i].setPreferredSize(new Dimension(width, height));
            }
            for (i = 0; i < dummyLbl.size(); ++i) {
                ((JLabel)dummyLbl.get(i)).setPreferredSize(new Dimension(width, height));
            }
            this.pack();
        }
    }

    private void serverBtnMouseClicked(MouseEvent evt) {
        this.pMenu.showMenu(evt);
    }

    public void updatePanel() {
        for (int level = 0; level < this.levelPanel.length; ++level) {
            this.levelPanel[level].removeAll();
        }
        this.buildPanel();
        this.thread.updateData(true);
    }

    void checkUpdatePanel(boolean forced) {
        if (forced) {
            for (int level = 0; level < this.levelPanel.length; ++level) {
                this.levelPanel[level].removeAll();
            }
            this.buildPanel();
        }
    }

    public String getServerName() {
        return servname;
    }

    void doClose() {
        this.host.poll_serv_lists = false;
        this.setVisible(false);
        this.thread.updateData(false);
        this.dispose();
    }

    void updateData() {
        this.thread.updateData(true);
    }

    void setSelection(String servname) {
        while (this.updating) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
        Blink blink = null;
        for (int i = 0; blink == null && i < this.btn.length; ++i) {
            if (this.btn[i] == null || !this.btn[i].getText().equals(servname)) continue;
            blink = new Blink(this.btn[i], 5);
        }
        if (blink != null) {
            blink.start();
        }
    }

    class ServerThread
    extends Thread {
        private boolean update_data = true;

        public synchronized void wait_next_update() {
            try {
                this.wait(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void updateData(boolean b) {
            this.update_data = b;
            this.notify();
        }

        private synchronized void updateParent() {
            int state;
            HostInfoDialog.this.updating = true;
            HostInfoDialog.this.checkUpdatePanel(true);
            for (int i = 0; i < HostInfoDialog.this.btn.length; ++i) {
                if (HostInfoDialog.this.btn[i] == null) continue;
                TangoServer server = HostInfoDialog.this.host.getServer(HostInfoDialog.this.btn[i].getText());
                state = server == null ? 0 : (server.isRunning() ? 3 : 1);
                HostInfoDialog.this.btn[i].setIcon(Astor.state_icons[state]);
            }
            state = HostInfoDialog.this.host.notifyd_state;
            if (HostInfoDialog.this.notifydBtn.isVisible()) {
                HostInfoDialog.this.notifydBtn.setIcon(Astor.state_icons[state]);
            }
            HostInfoDialog.this.updating = false;
        }

        public void run() {
            while (true) {
                if (this.update_data) {
                    this.updateParent();
                }
                this.wait_next_update();
            }
        }
    }

    class Blink {
        private JComponent obj;
        private int cnt;
        private Timer timer;
        private Color color;
        private long t0 = 0L;
        private int duration;
        private String text = null;

        Blink(JComponent obj) {
            this.obj = obj;
            this.cnt = 0;
            this.color = obj.getBackground();
        }

        Blink(JComponent obj, int duration) {
            this(obj);
            this.duration = duration;
            if (obj instanceof JLabel) {
                this.text = ((JLabel)obj).getText();
            } else {
                this.color = obj.getBackground();
            }
            this.t0 = System.currentTimeMillis();
        }

        void blinkPerformer(ActionEvent evt) {
            long t1;
            ++this.cnt;
            if (this.cnt % 2 == 0) {
                if (this.obj instanceof JLabel) {
                    ((JLabel)this.obj).setText("-> " + this.text);
                } else {
                    this.obj.setBackground(this.color);
                }
            } else if (this.obj instanceof JLabel) {
                ((JLabel)this.obj).setText(this.text);
            } else {
                this.obj.setBackground(Color.lightGray);
            }
            if (this.duration != 0 && (t1 = System.currentTimeMillis()) - this.t0 >= (long)(this.duration * 1000)) {
                this.timer.stop();
                if (this.obj instanceof JLabel) {
                    ((JLabel)this.obj).setText(this.text);
                } else {
                    this.obj.setBackground(this.color);
                }
            }
        }

        private void start() {
            ActionListener taskPerformer = new ActionListener(this){
                private final /* synthetic */ Blink this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent evt) {
                    this.this$1.blinkPerformer(evt);
                }
            };
            this.timer = new Timer(200, taskPerformer);
            this.timer.start();
        }
    }
}

