/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import java.util.Vector;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;

public class TaskPollingNode
extends TangoNode {
    private Database db;
    private String devName;
    private Vector attPollingInfo;
    private Vector cmdPollingInfo;

    TaskPollingNode(Database database, String string) {
        this.db = database;
        this.devName = string;
    }

    void populateNode() throws DevFailed {
    }

    ImageIcon getIcon() {
        return TangoNodeRenderer.leafcfgicon;
    }

    public String toString() {
        return "Polling";
    }

    String getTitle() {
        return "Device polling";
    }

    String getName() {
        return this.devName;
    }

    public boolean isLeaf() {
        return true;
    }

    int getCommandNumber() {
        return this.cmdPollingInfo.size();
    }

    String getCommandName(int n) {
        return ((PInfo)this.cmdPollingInfo.get((int)n)).name;
    }

    boolean isCommandPolled(int n) {
        return ((PInfo)this.cmdPollingInfo.get((int)n)).period != "";
    }

    String getCommandPollingPeriod(int n) {
        return ((PInfo)this.cmdPollingInfo.get((int)n)).period;
    }

    void updateCommandPolling(String string, boolean bl, String string2) {
        int n = 3000;
        if (bl) {
            if (string2 != "") {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    JiveUtils.showJiveError("Invalid period value for command " + string + "\n" + numberFormatException.getMessage());
                }
            }
            try {
                DeviceProxy deviceProxy = new DeviceProxy(this.devName);
                deviceProxy.poll_command(string, n);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        } else {
            try {
                DeviceProxy deviceProxy = new DeviceProxy(this.devName);
                deviceProxy.stop_poll_command(string);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }
    }

    int getAttributeNumber() {
        return this.attPollingInfo.size();
    }

    String getAttributeName(int n) {
        return ((PInfo)this.attPollingInfo.get((int)n)).name;
    }

    boolean isAttributePolled(int n) {
        return ((PInfo)this.attPollingInfo.get((int)n)).period != "";
    }

    String getAttributePollingPeriod(int n) {
        return ((PInfo)this.attPollingInfo.get((int)n)).period;
    }

    void updateAttributePolling(String string, boolean bl, String string2) {
        int n = 3000;
        if (bl) {
            if (string2 != "") {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    JiveUtils.showJiveError("Invalid period value for attribute " + string + "\n" + numberFormatException.getMessage());
                }
            }
            try {
                DeviceProxy deviceProxy = new DeviceProxy(this.devName);
                deviceProxy.poll_attribute(string, n);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        } else {
            try {
                DeviceProxy deviceProxy = new DeviceProxy(this.devName);
                deviceProxy.stop_poll_attribute(string);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }
    }

    String getPollOldFactor() {
        String string = "4";
        try {
            DbDatum dbDatum = this.db.get_device_property(this.devName, "poll_old_factor");
            if (!dbDatum.is_empty()) {
                string = dbDatum.extractString();
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        return string;
    }

    void setPollOldFactor(String string) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum("poll_old_factor", string));
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    String getPollRingDepth() {
        String string = "10";
        try {
            DbDatum dbDatum = this.db.get_device_property(this.devName, "poll_ring_depth");
            if (!dbDatum.is_empty()) {
                string = dbDatum.extractString();
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        return string;
    }

    void setPollRingDepth(String string) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum("poll_ring_depth", string));
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetConfig() {
        try {
            this.db.delete_device_property(this.devName, "polled_attr");
            this.db.delete_device_property(this.devName, "polled_cmd");
            this.db.delete_device_property(this.devName, "non_auto_polled_cmd");
            this.db.delete_device_property(this.devName, "non_auto_polled_attr");
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    private String[] getCommandList(DeviceProxy deviceProxy) throws DevFailed {
        int n;
        Vector<String> vector = new Vector<String>();
        CommandInfo[] commandInfoArray = deviceProxy.command_list_query();
        for (n = 0; n < commandInfoArray.length; ++n) {
            if (commandInfoArray[n].in_type != 0) continue;
            vector.add(commandInfoArray[n].cmd_name);
        }
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.get(n);
        }
        return stringArray;
    }

    private void update(String[] stringArray, PInfo pInfo) {
        boolean bl = false;
        String[] stringArray2 = null;
        int n = 0;
        while (n < stringArray.length && !bl) {
            stringArray2 = JiveUtils.extractPollingInfo(stringArray[n]);
            bl = stringArray2[0].equalsIgnoreCase(pInfo.type) && stringArray2[1].equalsIgnoreCase(pInfo.name);
            if (bl) continue;
            ++n;
        }
        pInfo.period = bl ? stringArray2[2] : "";
    }

    void browsePollingStatus() {
        this.cmdPollingInfo = new Vector();
        this.attPollingInfo = new Vector();
        try {
            Object object;
            int n;
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            String[] stringArray = deviceProxy.polling_status();
            String[] stringArray2 = this.getCommandList(deviceProxy);
            for (n = 0; n < stringArray2.length; ++n) {
                object = new PInfo();
                object.name = stringArray2[n];
                object.type = "command";
                this.update(stringArray, (PInfo)object);
                this.cmdPollingInfo.add(object);
            }
            object = deviceProxy.get_attribute_list();
            for (n = 0; n < ((String[])object).length; ++n) {
                PInfo pInfo = new PInfo();
                pInfo.name = object[n];
                pInfo.type = "attribute";
                this.update(stringArray, pInfo);
                this.attPollingInfo.add(pInfo);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    class PInfo {
        String name;
        String type;
        String period;

        PInfo() {
        }
    }
}

