/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import java.util.Vector;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.PropertyNode;
import jive3.TangoNodeRenderer;
import jive3.TreePanel;

class TaskDevicePropertyNode
extends PropertyNode {
    private Database db;
    private String devName;

    TaskDevicePropertyNode(TreePanel treePanel, Database database, String string) {
        this.db = database;
        this.devName = string;
        this.parentPanel = treePanel;
    }

    void populateNode() throws DevFailed {
    }

    ImageIcon getIcon() {
        return TangoNodeRenderer.leaficon;
    }

    public String toString() {
        return "Properties";
    }

    String getTitle() {
        return "Device properties";
    }

    String getName() {
        return this.devName;
    }

    public boolean isLeaf() {
        return true;
    }

    String[][] getProperties() {
        String[][] stringArray = new String[0][0];
        try {
            int n;
            String[] stringArray2 = this.db.get_device_property_list(this.devName, "*");
            Vector<String> vector = new Vector<String>();
            for (n = 0; n < stringArray2.length; ++n) {
                if (JiveUtils.IsPollCfgItem(stringArray2[n]) || JiveUtils.IsLogCfgItem(stringArray2[n]) || JiveUtils.IsHdbCfgItem(stringArray2[n]) || JiveUtils.IsSystemItem(stringArray2[n])) continue;
                vector.add(stringArray2[n]);
                String[] stringArray3 = this.db.get_device_property(this.devName, stringArray2[n]).extractStringArray();
                vector.add(JiveUtils.stringArrayToString(stringArray3));
            }
            stringArray = new String[vector.size() / 2][2];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n][0] = (String)vector.get(2 * n);
                stringArray[n][1] = (String)vector.get(2 * n + 1);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        return stringArray;
    }

    void setProperty(String string, String string2) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum(string, string2));
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void deleteProperty(String string) {
        try {
            this.db.delete_device_property(this.devName, JiveUtils.makeDbDatum(string, ""));
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }
}

