/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import jive.JiveUtils;
import jive.MultiLineCellEditor;
import jive3.ProgressFrame;
import jive3.PropertyNode;

public class PropertyPanel
extends JPanel
implements ActionListener,
MouseListener {
    private JScrollPane textView;
    private JTable theTable;
    private JButton refreshButton;
    private JButton applyButton;
    private JButton deleteButton;
    private JButton copyButton;
    private JButton newButton;
    private PropertyNode[] source = null;
    private DefaultTableModel dm;
    private MultiLineCellEditor editor;
    private boolean[] updatedProp;
    private JPopupMenu tableMenu;
    private JMenuItem renameMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem copyMenuItem;
    static /* synthetic */ Class class$java$lang$String;

    PropertyPanel() {
        this.setLayout(new BorderLayout());
        this.dm = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return class$java$lang$String == null ? (class$java$lang$String = PropertyPanel.class$("java.lang.String")) : class$java$lang$String;
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 == 1 && !JiveUtils.readOnly;
            }

            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    PropertyPanel.this.applyButton.setEnabled(true);
                    ((PropertyPanel)PropertyPanel.this).updatedProp[n] = true;
                }
            }
        };
        this.theTable = new JTable(this.dm);
        this.theTable.addMouseListener(this);
        this.editor = new MultiLineCellEditor(this.theTable);
        this.theTable.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = PropertyPanel.class$("java.lang.String")) : class$java$lang$String, this.editor);
        MultiLineCellRenderer multiLineCellRenderer = new MultiLineCellRenderer();
        this.theTable.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = PropertyPanel.class$("java.lang.String")) : class$java$lang$String, multiLineCellRenderer);
        this.textView = new JScrollPane(this.theTable);
        this.add((Component)this.textView, "Center");
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.textView.setBorder(titledBorder);
        this.add((Component)this.textView, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setEnabled(!JiveUtils.readOnly);
        this.deleteButton.addActionListener(this);
        this.copyButton = new JButton("Copy");
        this.copyButton.setEnabled(!JiveUtils.readOnly);
        this.copyButton.addActionListener(this);
        this.newButton = new JButton("New property");
        this.newButton.setEnabled(!JiveUtils.readOnly);
        this.newButton.addActionListener(this);
        jPanel.add(this.refreshButton);
        jPanel.add(this.applyButton);
        jPanel.add(this.newButton);
        jPanel.add(this.copyButton);
        jPanel.add(this.deleteButton);
        this.add((Component)jPanel, "South");
        this.tableMenu = new JPopupMenu();
        this.copyMenuItem = new JMenuItem("Copy");
        this.copyMenuItem.addActionListener(this);
        this.renameMenuItem = new JMenuItem("Rename");
        this.renameMenuItem.addActionListener(this);
        this.deleteMenuItem = new JMenuItem("Delete");
        this.deleteMenuItem.addActionListener(this);
        this.tableMenu.add(this.copyMenuItem);
        this.tableMenu.add(this.deleteMenuItem);
        this.tableMenu.add(this.renameMenuItem);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1 && !JiveUtils.readOnly && (n = this.getRowForLocation(mouseEvent.getY())) != -1) {
            this.theTable.addRowSelectionInterval(n, n);
            this.theTable.setColumnSelectionInterval(0, 1);
            int[] nArray = this.theTable.getSelectedRows();
            this.renameMenuItem.setEnabled(nArray.length == 1);
            this.tableMenu.show(this.theTable, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.refreshValue();
        } else if (object == this.applyButton) {
            int n = this.getNbUpdated() * this.source.length;
            int n2 = 0;
            if (n > 1) {
                ProgressFrame.displayProgress("Updating properties");
            }
            for (int i = 0; i < this.updatedProp.length; ++i) {
                if (!this.updatedProp[i]) continue;
                for (int j = 0; j < this.source.length; ++j) {
                    ProgressFrame.setProgress("Applying " + this.source[j].getName() + "/" + this.dm.getValueAt(i, 0), ++n2 * 100 / n);
                    this.source[j].setProperty((String)this.dm.getValueAt(i, 0), (String)this.dm.getValueAt(i, 1));
                }
                this.updatedProp[i] = false;
            }
            this.applyButton.setEnabled(false);
            ProgressFrame.hideProgress();
        } else if (object == this.deleteMenuItem || object == this.deleteButton) {
            int[] nArray = this.theTable.getSelectedRows();
            if (nArray.length == 0) {
                JiveUtils.showJiveError("Selection is empty.");
                return;
            }
            int n = JOptionPane.showConfirmDialog(this, "Delete selection ?", "Confirm delete", 0);
            if (n == 0) {
                int n3 = nArray.length * this.source.length;
                int n4 = 0;
                if (n3 > 1) {
                    ProgressFrame.displayProgress("Deleting properties");
                }
                for (int i = 0; i < nArray.length; ++i) {
                    for (int j = 0; j < this.source.length; ++j) {
                        ProgressFrame.setProgress("Deleting " + this.source[j].getName() + "/" + this.dm.getValueAt(nArray[i], 0), ++n4 * 100 / n3);
                        this.source[j].deleteProperty((String)this.dm.getValueAt(nArray[i], 0));
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (object == this.renameMenuItem) {
            int n = this.theTable.getSelectedRow();
            String string = (String)this.dm.getValueAt(n, 0);
            String string2 = (String)this.dm.getValueAt(n, 1);
            String string3 = JOptionPane.showInputDialog(null, "Rename property", string);
            if (string3 == null) {
                return;
            }
            if (this.propertyExists(string3)) {
                JiveUtils.showJiveError("Name already exists.");
                return;
            }
            int n5 = 0;
            int n6 = this.source.length;
            if (n6 > 1) {
                ProgressFrame.displayProgress("Renaming properties");
            }
            for (int i = 0; i < this.source.length; ++i) {
                ProgressFrame.setProgress("Renaming " + this.source[i].getName() + "/" + string, ++n5 * 100 / n6);
                this.source[i].rename(string, string2, string3);
            }
            this.refreshValue();
            ProgressFrame.hideProgress();
        } else if (object == this.newButton) {
            String string = JOptionPane.showInputDialog(null, "Add property", "");
            if (string == null) {
                return;
            }
            if (this.propertyExists(string)) {
                JiveUtils.showJiveError("Name already exists.");
                return;
            }
            int n = 0;
            int n7 = this.source.length;
            if (n7 > 1) {
                ProgressFrame.displayProgress("Creating properties");
            }
            for (int i = 0; i < this.source.length; ++i) {
                ProgressFrame.setProgress("Creating " + this.source[i].getName() + "/" + string, ++n * 100 / n7);
                this.source[i].setProperty(string, "");
            }
            this.refreshValue();
            ProgressFrame.hideProgress();
        } else if (object == this.copyMenuItem || object == this.copyButton) {
            int[] nArray = this.theTable.getSelectedRows();
            if (nArray.length == 0) {
                JiveUtils.showJiveError("Nothing to copy.");
                return;
            }
            JiveUtils.the_clipboard.clear();
            for (int i = 0; i < nArray.length; ++i) {
                JiveUtils.the_clipboard.add((String)this.dm.getValueAt(nArray[i], 0), (String)this.dm.getValueAt(nArray[i], 1));
            }
        }
    }

    void setSource(PropertyNode[] propertyNodeArray) {
        this.source = propertyNodeArray;
        this.refreshValue();
    }

    private void refreshValue() {
        this.applyButton.setEnabled(false);
        if (this.source != null) {
            Object[] objectArray = new String[]{"Property name", "Value"};
            Object[][] objectArray2 = this.source[0].getProperties();
            this.dm.setDataVector(objectArray2, objectArray);
            this.updatedProp = new boolean[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                this.updatedProp[i] = false;
            }
            this.editor.updateRows();
            this.theTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            this.theTable.validate();
            String string = this.source[0].getTitle();
            string = this.source.length == 1 ? string + " [" + this.source[0].getName() + "]" : string + " [" + this.source.length + " items selected]";
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string);
            this.textView.setBorder(titledBorder);
        }
    }

    private boolean propertyExists(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.dm.getRowCount() && !bl) {
            bl = ((String)this.dm.getValueAt(n, 0)).equalsIgnoreCase(string);
            if (bl) continue;
            ++n;
        }
        return bl;
    }

    private int getNbUpdated() {
        int n = 0;
        for (int i = 0; i < this.updatedProp.length; ++i) {
            if (!this.updatedProp[i]) continue;
            ++n;
        }
        return n;
    }

    private int getRowForLocation(int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.dm.getRowCount() && !bl) {
            bl = n >= n3 && n <= n3 + this.theTable.getRowHeight(n2);
            if (bl) continue;
            n3 += this.theTable.getRowHeight(n2);
            ++n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MultiLineCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        Color selColor = new Color(200, 200, 255);
        Border selBorder = BorderFactory.createLineBorder(this.selColor);

        public MultiLineCellRenderer() {
            this.setEditable(false);
            this.setLineWrap(false);
            this.setWrapStyleWord(false);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof String) {
                this.setText((String)object);
            } else {
                this.setText("");
            }
            int[] nArray = jTable.getSelectedRows();
            if (JiveUtils.contains(nArray, n) && n2 == 0) {
                this.setBackground(this.selColor);
            } else {
                this.setBackground(Color.WHITE);
            }
            if (bl && n2 == 1) {
                this.setBorder(this.selBorder);
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }
}

