/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.Tango.DispLevel;
import fr.esrf.TangoDs.TangoConst;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.DevState;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.Property;
import pogo.gene.TangoTypes;

public class PogoGeneDoc
extends PogoGene
implements PogoDefs,
TangoConst {
    private PogoClass server;
    private String outDoc;
    private String footer = null;
    private Cmd init_cmd;
    private final String end_html = "\n\n</BODY>\n</HTML>\n";
    private boolean display_trace = false;
    private static final String Cr = "<Br>&nbsp;<Br>";

    public PogoGeneDoc(PogoClass server) {
        super(server);
        this.server = server;
        this.outDoc = server.projectFiles.getDocHtml();
        this.init_cmd = new Cmd("Init", "", "Tango::DEV_VOID", "Tango::DEV_VOID", "none.", "none.", "This commands re-initialise a device keeping the same network connection.<Br>\nAfter an Init command executed on a device, it is not necessary for client to re-connect to the device.<Br>\nThis command first calls the device <i> delete_device() </i>method and then execute its <i> init_device()</i> method.<Br>\nFor C++ device server, all the memory allocated in the <i> nit_device() </i> method must be freed in the <i> delete_device() </i> method.<Br>\nThe language device desctructor automatically calls the <i> delete_device() </i> method.");
    }

    private static String buildTableHeader(String title, int nb_col) {
        String sb = "<Table Border=2 Cellpadding=3 CELLSPACING=0 WIDTH=\"100%\">\n";
        sb = sb + "<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n";
        sb = sb + "<Td COLSPAN=" + nb_col + "> <Font Size=+2>";
        sb = sb + "<Center>";
        sb = sb + "<b>" + title + "</b></td></Font></Center>\n";
        return sb;
    }

    public static String buildTableHeader(String title, String[] col_titles) {
        String str = PogoGeneDoc.buildTableHeader(title, col_titles.length);
        str = str + "<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n";
        for (int i = 0; i < col_titles.length; ++i) {
            str = str + "<Td>";
            str = str + "<Center>";
            str = str + "<b>" + col_titles[i] + "</b></td></Center>\n";
        }
        return str;
    }

    private void makeDocDir() throws SecurityException {
        int end = 1;
        while ((end = this.outDoc.indexOf("/", end)) > 0) {
            String path = this.outDoc.substring(0, end);
            File f = new File(path);
            if (!f.exists()) {
                f.mkdir();
                System.out.println(path + "  created");
            }
            ++end;
        }
        File f = new File(this.outDoc);
        if (!f.exists()) {
            f.mkdir();
            System.out.println(this.outDoc + "  created");
        }
    }

    protected void generateIndexFile() throws IOException, PogoException {
        PogoString pgs = this.readTemplate("index.html", "");
        String inheritance = this.buildInheritanceDiagram();
        int idx = pgs.str.indexOf("Revision:");
        idx = pgs.str.lastIndexOf("<b>", idx);
        pgs.insert(idx, inheritance);
        String f_out = this.outDoc + "/index.html";
        this.writeDocFile(f_out, pgs.str, true);
    }

    private String buildInheritanceDiagram() {
        String code = "";
        try {
            String inheritance = PogoUtil.readFile(this.server.templates_dir + "/html/Inheritance.html");
            int idx = inheritance.indexOf("<img ");
            String arrow = inheritance.substring(idx);
            inheritance = inheritance.substring(0, idx);
            PogoString pg_str = new PogoString(inheritance);
            String base = "Device_" + this.pogo.deviceImpl + "Impl";
            pg_str.replace("ClassName", base);
            code = "<Center>\n" + pg_str.str + arrow;
            if (!this.pogo.inheritedClassName().equals("Device_3Impl")) {
                pg_str = new PogoString(inheritance);
                pg_str.replace("ClassName", this.pogo.inheritedClassName());
                code = code + pg_str.str + arrow;
            }
            pg_str = new PogoString(inheritance);
            pg_str.replace("ClassName", this.pogo.class_name);
            code = code + pg_str.str + "</Center>\n<Br>\n";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    protected void generateDescriptionFile() throws IOException, PogoException {
        String f_out = this.outDoc + "/Description.html";
        if (new File(f_out).exists()) {
            String old_mess;
            int start;
            boolean modified = false;
            PogoString code = new PogoString(PogoUtil.readFile(f_out));
            int end = code.str.indexOf("<HR WIDTH=\"100%\"></H5>");
            if (end > 0) {
                String templname = this.server.templates_dir + "/html/header.html";
                String old_header = code.str.substring(0, end);
                String new_header = PogoUtil.readFile(templname);
                int p = new_header.indexOf("</Body>");
                if (p > 0) {
                    new_header = new_header.substring(0, p);
                }
                code.replace(old_header, new_header);
                modified = true;
            }
            if ((start = code.str.indexOf(old_mess = "This Page Must Be Filled by <Br>\nThe Programmer")) > 0) {
                code.replace(old_mess, this.server.class_desc);
                modified = true;
            }
            if (modified) {
                PogoUtil.writeFile(f_out, code.str);
            }
        } else {
            PogoString pgs = this.readTemplate("page.html", "Device Description");
            pgs.append("<Center>\n");
            pgs.append(this.server.class_desc);
            pgs.append("\n<Br>\n<Br>\n");
            pgs.append("</Center>\n");
            this.writeDocFile(f_out, pgs.str, true);
        }
        PogoGeneDoc.checkDocFile(this.outDoc);
    }

    protected void generateStateDescriptionFile() throws IOException, PogoException {
        PogoString pgs = this.readTemplate("page.html", "Device States Description");
        pgs.append("<Center>\n");
        pgs.append("<Br> <Br> <Br> \n");
        String[] titles = new String[]{"Names", "Descriptions"};
        pgs.append(PogoGeneDoc.buildTableHeader("States", titles));
        for (int i = 0; i < this.server.states.size(); ++i) {
            DevState state = (DevState)this.server.states.elementAt(i);
            pgs.append("<Tr><Td><b>" + this.removeTangoNamespace(state.name) + "</b></Td>\n");
            pgs.append("<Td><Font Size=-1>" + state.description + "</Font></Td></Tr>\n\n");
        }
        pgs.append("\n");
        pgs.append("\n");
        pgs.append("\n");
        pgs.append("</Table>\n");
        pgs.append("</Center>\n");
        String f_out = this.outDoc + "/TangoDevStates.html";
        this.writeDocFile(f_out, pgs.str, true);
    }

    protected void generatePropertyDescriptionFile() throws IOException, PogoException {
        Property property;
        int i;
        boolean class_prop = false;
        boolean device_prop = false;
        PogoString pgs = this.readTemplate("page.html", "Properties Description");
        pgs.append("<Br> <Br> <Br> \n");
        pgs.append("<Center>\n");
        String[] titles = new String[]{"Property name", "Property type", "Description"};
        if (this.server.class_properties.size() > 0) {
            class_prop = true;
            pgs.append(PogoGeneDoc.buildTableHeader("Class Properties", titles));
            pgs.append("\n");
            for (i = 0; i < this.server.class_properties.size(); ++i) {
                property = this.server.class_properties.propertyAt(i);
                pgs.append("<Tr><Td><b>" + property.name + "</b></Td>\n");
                pgs.append("<Td><Font Size=-1>" + property.type.cpp_code_str + "</Font></Td>\n");
                pgs.append("<Td><Font Size=-1>" + property.description + "</Font></Td></Tr>\n\n");
            }
            pgs.append("</Table>\n");
            pgs.append("\n");
        }
        if (this.server.dev_properties.size() > 0) {
            device_prop = true;
            pgs.append("<Br> <Br> <Br> \n");
            pgs.append(PogoGeneDoc.buildTableHeader("Device Properties", titles));
            for (i = 0; i < this.server.dev_properties.size(); ++i) {
                property = this.server.dev_properties.propertyAt(i);
                pgs.append("<Tr><Td><b>" + property.name + "</b></Td>\n");
                pgs.append("<Td><Font Size=-1>" + property.type.cpp_code_str + "</Font></Td>\n");
                pgs.append("<Td><Font Size=-1>" + property.description + "</Font></Td></Tr>\n\n");
            }
            pgs.append("</Table>\n");
            pgs.append("\n");
        }
        if (!device_prop || !class_prop) {
            pgs.append("<Br><Br><Br>\n");
            pgs.append("<Center><b>\n");
            if (!class_prop) {
                pgs.append("There is no Class properties.<Br><Br>\n");
            }
            if (!device_prop) {
                pgs.append("There is no Device Properties.<Br><Br>\n");
            }
            pgs.append("</Center></b>\n");
        }
        String f_out = this.outDoc + "/Properties.html";
        this.writeDocFile(f_out, pgs.str, true);
    }

    protected void generateAttributesFile() throws IOException, PogoException {
        String level;
        String str_type;
        String desc;
        PogoString pgs = this.readTemplate("page.html", "Device Attributes Description");
        pgs.append("<Br>\n");
        boolean assAttr = false;
        boolean scalar = false;
        boolean spectrum = false;
        boolean image = false;
        for (int i = 0; i < this.server.attributes.size(); ++i) {
            Attrib attr = this.server.attributes.attributeAt(i);
            if (attr.attrType == 0) {
                scalar = true;
                if (attr.rwType != 3) continue;
                assAttr = true;
                continue;
            }
            if (attr.attrType == 1) {
                spectrum = true;
                continue;
            }
            if (attr.attrType != 2) continue;
            image = true;
        }
        if (scalar) {
            String[] titles = new String[4 + (assAttr ? 1 : 0)];
            int n = 0;
            titles[n++] = "Attribute name";
            titles[n++] = "Data Type";
            titles[n++] = "R/W Type";
            if (assAttr) {
                titles[n++] = "Ass. Attr.";
            }
            titles[n] = "Expert";
            pgs.append(PogoGeneDoc.buildTableHeader("Scalar Attributes", titles));
            for (int i = 0; i < this.server.attributes.size(); ++i) {
                Attrib attr = this.server.attributes.attributeAt(i);
                if (attr.attrType != 0) continue;
                pgs.append("<Font Size=-1>\n");
                pgs.append("<Tr><Td><b>" + attr.name + "</b>");
                String desc2 = attr.getDescriptionLine();
                if (desc2 != null && desc2.length() > 0) {
                    pgs.append(": <Font Size=-1>" + desc2 + "</Font>");
                }
                pgs.append("</Td>\n");
                String str_type2 = this.simpleType(attr.dataType);
                String str_rw = PogoDefs.AttrRWtypeArray[attr.rwType];
                String level2 = attr.disp_level == DispLevel.OPERATOR ? "No" : "Yes";
                pgs.append("<Td><Center><Font Size=-1>" + str_type2 + "</Font></Center></Td>");
                pgs.append("<Td><Center><Font Size=-1>" + str_rw + "</Font></Center></Td>");
                if (attr.rwType == 3) {
                    pgs.append("<Td><Center><Font Size=-1>" + attr.assAttr + "</Font></Center></Td>");
                } else if (assAttr) {
                    pgs.append("<Td><Center> - </Center></Td>");
                }
                pgs.append("<Td><Center><Font Size=-1>" + level2 + "</Font></Center></Td>");
                pgs.append("</Tr>\n\n");
            }
            pgs.append("</Table>\n");
            pgs.append("</Center>\n");
            pgs.append("<Br><Br><Br><Br><Br>\n");
        }
        if (spectrum) {
            String[] titles = new String[]{"Attribute name", "Data Type", "X Data Length", "Expert"};
            pgs.append(PogoGeneDoc.buildTableHeader("Spectrum Attributes", titles));
            for (int i = 0; i < this.server.attributes.size(); ++i) {
                Attrib attr = this.server.attributes.attributeAt(i);
                if (attr.attrType != 1) continue;
                pgs.append("<Tr><Td><b>" + attr.name + "</b>");
                desc = attr.getDescriptionLine();
                if (desc != null && desc.length() > 0) {
                    pgs.append(": <Font Size=-1>" + desc + "</Font>");
                }
                pgs.append("</Td>\n");
                str_type = this.simpleType(attr.dataType);
                level = attr.disp_level == DispLevel.OPERATOR ? "No" : "Yes";
                pgs.append("<Td><Center><Font Size=-1>" + str_type + "</Font></Center></Td>");
                pgs.append("<Td><Center><Font Size=-1>" + attr.xSize + "</Font></Center></Td>");
                pgs.append("<Td><Center><Font Size=-1>" + level + "</Font></Center></Td>");
                pgs.append("</Tr>\n\n");
            }
            pgs.append("</Table>\n");
            pgs.append("</Center>\n");
            pgs.append("<Br><Br><Br><Br><Br>\n");
        }
        if (image) {
            String[] titles = new String[]{"Attribute name", "Data Type", "X Data Length", "Y Data Length", "Expert"};
            pgs.append(PogoGeneDoc.buildTableHeader("Image Attributes", titles));
            for (int i = 0; i < this.server.attributes.size(); ++i) {
                Attrib attr = this.server.attributes.attributeAt(i);
                if (attr.attrType != 2) continue;
                pgs.append("<Tr><Td><b>" + attr.name + "</b>");
                desc = attr.getDescriptionLine();
                if (desc != null && desc.length() > 0) {
                    pgs.append(": <Font Size=-1>" + desc + "</Font>");
                }
                pgs.append("</Td>\n");
                str_type = this.simpleType(attr.dataType);
                level = attr.disp_level == DispLevel.OPERATOR ? "No" : "Yes";
                pgs.append("<Td><Center><Font Size=-1>" + str_type + "</Font></Center></Td>");
                pgs.append("<Td><Center><Font Size=-1>" + attr.xSize + "</Font></Center></Td>");
                pgs.append("<Td><Center><Font Size=-1>" + attr.ySize + "</Font></Center></Td>");
                pgs.append("<Td><Center><Font Size=-1>" + level + "</Font></Center></Td>");
                pgs.append("</Tr>\n\n");
            }
            pgs.append("</Table>\n");
            pgs.append("</Center>\n");
        }
        String f_out = this.outDoc + "/Attributes.html";
        this.writeDocFile(f_out, pgs.str, true);
    }

    protected void generateCmdListFile() throws IOException, PogoException {
        String str = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">\n";
        str = str + "<HTML><HEAD>\n";
        str = str + "<TITLE>Commands\n</TITLE></HEAD>\n";
        str = str + "<BODY BGCOLOR=\"white\">\n";
        str = str + "<FONT size=\"+1\" ID=\"FrameHeadingFont\">\n";
        str = str + "<B>Commands:</B></FONT>\n";
        str = str + "<Br>\n<Br>\n<Br>\n";
        str = str + "<A Href=\"DevCommands.html#Init";
        str = str + "\" TARGET=\"DevCommands\"> ";
        str = str + "Init</a><Br>\n";
        for (int i = 0; i < this.server.commands.size(); ++i) {
            Cmd cmd = this.server.commands.cmdAt(i);
            str = str + "<A Href=\"DevCommands.html#" + cmd.name;
            str = str + "\" TARGET=\"DevCommands\"> ";
            str = str + cmd.name + "</a><Br>\n";
        }
        str = str + "\n\n</BODY>\n</HTML>\n";
        String f_out = this.outDoc + "/DevCommandsList.html";
        this.writeDocFile(f_out, str, false);
        PogoGeneDoc.copyFile(this.server.templates_dir + "/html/frame.html", this.outDoc + "/DevCommandsFrame.html");
    }

    private String buildCmdDesc(Cmd cmd, int cmd_idx) {
        PogoString desc;
        PogoString pgs = new PogoString("<A NAME=\"" + cmd.name + "\"><!-- --></A>\n");
        pgs.append("<A NAME=\"" + cmd.name + "\"><!-- --></A>\n");
        pgs.append("<h2>" + cmd_idx + " - " + cmd.name);
        if (cmd.level == DispLevel.EXPERT) {
            pgs.append(" (for expert only)");
        }
        pgs.append("</h2>\n<ul>\n");
        pgs.append("<Li><Strong>Description: </Strong> ");
        if (cmd.description != null) {
            pgs.append(cmd.description);
        }
        pgs.append("<Br>&nbsp\n");
        pgs.append("<Li><Strong>Argin:<Br>" + this.simpleType(cmd.argin) + "</Strong>\n");
        if (cmd.argin.description != null) {
            desc = new PogoString(cmd.argin.description);
            while (desc.indexOf("\\n") >= 0) {
                desc.replace("\\n", "<Br>\n");
            }
            pgs.append(" : " + desc);
        }
        pgs.append("<Br>&nbsp\n");
        pgs.append("<Li><Strong>Argout:<Br>" + this.simpleType(cmd.argout) + "</Strong>\n");
        if (cmd.argout.description != null) {
            desc = new PogoString(cmd.argout.description);
            while (desc.indexOf("\\n") >= 0) {
                desc.replace("\\n", "<Br>\n");
            }
            pgs.append(" : " + desc);
        }
        if (cmd.notAllowedFor != null) {
            pgs.append("<Br>&nbsp\n");
            pgs.append("<Li><Strong>Command allowed for: </Strong><Ul>\n");
            for (int idx = 0; idx < this.server.states.size(); ++idx) {
                DevState st = this.server.states.stateAt(idx);
                boolean found = false;
                for (int alIdx = 0; alIdx < cmd.notAllowedFor.size(); ++alIdx) {
                    DevState st1 = cmd.notAllowedFor.stateAt(alIdx);
                    if (!st1.name.equals(st.name)) continue;
                    found = true;
                }
                if (found) continue;
                pgs.append("<Li>" + st.name);
            }
            pgs.append("</Ul>\n");
        } else {
            pgs.append("<Li><Strong>Command allowed for all device states.</Strong><Br>\n");
        }
        pgs.append("<Br>&nbsp\n");
        if (cmd.polled_period > 0) {
            pgs.append("<Li><Strong>Polled every " + cmd.polled_period + " ms</Strong><Br>\n");
        }
        pgs.append("</ul><Br>\n<Br>\n");
        return pgs.str;
    }

    protected void generateCmdListDescriptionFile() throws IOException, PogoException {
        PogoString pgs = this.readTemplate("page.html", "Device Commands Description");
        pgs.append("<Br>\n<Br>\n<Br>\n");
        int cmd_idx = 1;
        pgs.append(this.buildCmdDesc(this.init_cmd, cmd_idx++));
        for (int i = 0; i < this.server.commands.size(); ++i) {
            Cmd cmd = this.server.commands.cmdAt(i);
            pgs.append(this.buildCmdDesc(cmd, cmd_idx++));
        }
        String f_out = this.outDoc + "/DevCommands.html";
        this.writeDocFile(f_out, pgs.str, true);
    }

    protected void generateCmdTableFile() throws IOException, PogoException {
        Cmd cmd;
        int i;
        PogoString pgs = this.readTemplate("page.html", "Device Commands Description");
        String[] titles = new String[]{"Command name", "Argument In", "Argument Out"};
        pgs.append("<Center>\n");
        pgs.append("<Br><Br>\n<A Href=\"DevCommandsFrame.html\"> More Details on commands.... </a><Br>\n");
        pgs.append("<Br> <Br>\n");
        pgs.append(PogoGeneDoc.buildTableHeader("Device Commands for Operator Level", titles));
        pgs.append("<Tr><Td><b>" + this.init_cmd.name + "</b></Td>\n");
        pgs.append("<Td><Font Size=-1>" + this.simpleType(this.init_cmd.argin) + "</Font></Td>\n");
        pgs.append("<Td><Font Size=-1>" + this.simpleType(this.init_cmd.argout) + "</Font></Td>\n");
        int nb_expert = 0;
        for (i = 0; i < this.server.commands.size(); ++i) {
            cmd = this.server.commands.cmdAt(i);
            if (cmd.level == DispLevel.OPERATOR) {
                pgs.append("<Tr><Td><b>" + cmd.name + "</b></Td>\n");
                pgs.append("<Td><Font Size=-1>" + this.simpleType(cmd.argin) + "</Font></Td>\n");
                pgs.append("<Td><Font Size=-1>" + this.simpleType(cmd.argout) + "</Font></Td>\n");
                continue;
            }
            ++nb_expert;
        }
        pgs.append("\n\n\n</Table></Center>\n");
        if (nb_expert > 0) {
            pgs.append("<Br> <Br> <Br> \n");
            pgs.append("<Center>\n");
            pgs.append(PogoGeneDoc.buildTableHeader("Device Commands for Expert Level Only", titles));
            for (i = 0; i < this.server.commands.size(); ++i) {
                cmd = this.server.commands.cmdAt(i);
                if (cmd.level != DispLevel.EXPERT) continue;
                pgs.append("<Tr><Td><b>" + cmd.name + "</b></Td>\n");
                pgs.append("<Td><Font Size=-1>" + this.simpleType(cmd.argin) + "</Font></Td>\n");
                pgs.append("<Td><Font Size=-1>" + this.simpleType(cmd.argout) + "</Font></Td>\n");
            }
            pgs.append("\n\n\n</Table></Center>\n");
        }
        String f_out = this.outDoc + "/DevCommandsTable.html";
        this.writeDocFile(f_out, pgs.str, true);
    }

    private void writeDocFile(String filename, String str, boolean write_footer) throws IOException {
        if (write_footer) {
            if (this.footer == null) {
                String footname = this.server.templates_dir + "/html/footer.html";
                FileInputStream fidin = new FileInputStream(footname);
                int nb = fidin.available();
                byte[] inStr = new byte[nb];
                this.footer = (nb = fidin.read(inStr)) > 0 ? new String(inStr) : "";
                fidin.close();
            }
            str = str + this.footer;
        }
        FileOutputStream fidout = new FileOutputStream(filename);
        fidout.write(str.getBytes());
        fidout.close();
    }

    protected void removePgGuideLink() throws FileNotFoundException, IOException {
        String[] pgGuideLink = new String[]{"<h2>Programmer's guide:</h2>", "<ul>", "<li> <a href=\"html/index.html\">\t\tSoftware description.</a>", "</ul>"};
        String filename = this.server.projectFiles.getDocHtml() + "/index.html";
        PogoString pgs = new PogoString(PogoUtil.readFile(filename));
        for (int i = 0; i < pgGuideLink.length; ++i) {
            pgs.replace(pgGuideLink[i], "");
        }
        FileOutputStream fidout = new FileOutputStream(filename);
        fidout.write(pgs.str.getBytes());
        fidout.close();
    }

    private PogoString readTemplate(String filename, String page_title) throws IOException {
        int pos;
        String templname = this.server.templates_dir + "/html/" + filename;
        PogoString pgs = new PogoString(PogoUtil.readFile(templname));
        pgs.replace("project :", this.server.title);
        pgs.replace("Page Title", page_title);
        pgs.replace("ClassName", this.server.class_name);
        pgs.replace("1.0", this.server.revision);
        pgs.replace("Verdier", this.server.author);
        pgs.replace("Class Description:", this.server.class_desc);
        if (this.server.cvs_repository != null && (pos = pgs.indexOf(this.server.author)) > 0) {
            pgs.insert(pos += this.server.author.length(), " -  CVS repository: " + this.server.cvs_repository);
        }
        return pgs;
    }

    private String simpleType(TangoTypes type) {
        return this.removeTangoNamespace(type.cpp_code_str);
    }

    private String removeTangoNamespace(String s) {
        if (s.indexOf("Tango::") != 0) {
            return s;
        }
        return s.substring("Tango::".length());
    }

    public static void checkDocFile(String targetdir) {
        File f = new File(targetdir);
        if (!f.exists()) {
            return;
        }
        String[] src_files = f.list();
        for (int i = 0; i < src_files.length; ++i) {
            int idx;
            String src_file = targetdir + "/" + src_files[i];
            File sf = new File(src_file);
            if (sf.isDirectory() || (idx = src_file.lastIndexOf(".")) < 0 || !src_file.substring(idx).equals(".doc") && !src_file.substring(idx).equals(".pdf")) continue;
            idx = src_file.lastIndexOf("/");
            idx = idx < 0 ? 0 : ++idx;
            String filename = PogoUtil.checkFileName(src_file.substring(idx));
            System.out.println("---------> " + filename);
            sf.renameTo(new File(targetdir + "/" + filename));
            PogoGeneDoc.addLinkOnDoc(targetdir, filename);
        }
    }

    public static void addLinkOnDoc(String targetdir, String filename) {
        try {
            PogoString code = new PogoString(PogoUtil.readFile(targetdir + "/Description.html"));
            if (code.str.indexOf(filename) > 0) {
                return;
            }
            int idx = code.str.indexOf("Revision");
            if (idx < 0) {
                return;
            }
            idx = code.str.toLowerCase().indexOf("</center>", idx);
            if (idx < 0) {
                return;
            }
            String link = "<Br><Br><Br>\nDownload <A href=" + filename + "> " + filename + " </a>\n";
            code.insert(idx, link);
            PogoUtil.writeFile(targetdir + "/Description.html", code.str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String generate() throws FileNotFoundException, SecurityException, IOException, InterruptedException, PogoException {
        System.out.println("Generating HTML Doc files...");
        this.makeDocDir();
        this.generateIndexFile();
        this.generateDescriptionFile();
        this.generateStateDescriptionFile();
        this.generatePropertyDescriptionFile();
        this.generateCmdListDescriptionFile();
        this.generateCmdListFile();
        this.generateCmdTableFile();
        this.generateAttributesFile();
        this.generateFull();
        return "";
    }

    private String takeOffHeaderAndFooter(String code, boolean is_desc) {
        String separator = "<HR WIDTH=\"100%\"></H5>";
        int pos = code.indexOf(separator);
        if (pos > 0) {
            code = code.substring(pos);
            if (is_desc) {
                pos = code.indexOf("Revision:");
                if (pos < 0) {
                    pos = 0;
                }
                pos = code.indexOf("\n", pos);
            } else {
                pos = code.indexOf("</center>\n");
                pos += "</center>\n".length();
            }
        }
        if (pos > 0) {
            code = code.substring(pos);
            if (pos > 0) {
                pos = code.indexOf(separator);
                if ((pos = code.lastIndexOf("<Center>", pos)) < 0) {
                    pos = code.toLowerCase().indexOf("</body>");
                }
                if (pos > 0) {
                    return code.substring(0, pos);
                }
                return code;
            }
        }
        return "";
    }

    protected String getDescriptionPart() throws IOException, PogoException {
        String f_in = this.outDoc + "/Description.html";
        String code = PogoUtil.readFile(f_in);
        return this.takeOffHeaderAndFooter(code, true) + "\n</center>\n";
    }

    protected String getPropertiesPart() throws IOException, PogoException {
        String f_in = this.outDoc + "/Properties.html";
        String code = PogoUtil.readFile(f_in);
        return "<Br>&nbsp;<Br><Br>&nbsp;<Br><h2>Properties:</h2>\n" + this.takeOffHeaderAndFooter(code, false) + "\n</center>\n";
    }

    protected String getStatesPart() throws IOException, PogoException {
        String f_in = this.outDoc + "/TangoDevStates.html";
        String code = PogoUtil.readFile(f_in);
        return "<Br>&nbsp;<Br><Br>&nbsp;<Br><h2>States:</h2>\n" + this.takeOffHeaderAndFooter(code, false) + "\n</center>\n";
    }

    protected String getAttributesPart() throws IOException, PogoException {
        String f_in = this.outDoc + "/Attributes.html";
        String code = PogoUtil.readFile(f_in);
        return "<Br>&nbsp;<Br><Br>&nbsp;<Br><h2>Attributes:</h2>\n" + this.takeOffHeaderAndFooter(code, false) + "\n</center>\n";
    }

    protected String getCommandsPart() throws IOException, PogoException {
        String f_in = this.outDoc + "/DevCommandsTable.html";
        String code = PogoUtil.readFile(f_in);
        String result = "<h2>Commands:</h2>\n" + this.takeOffHeaderAndFooter(code, false) + "</center>\n";
        f_in = this.outDoc + "/DevCommands.html";
        code = PogoUtil.readFile(f_in);
        result = result + Cr + this.takeOffHeaderAndFooter(code, false) + "</center>\n";
        return "<Br>&nbsp;<Br><Br>&nbsp;<Br>" + result;
    }

    protected boolean buildPdf(String f_in) {
        try {
            String filename = f_in.substring(0, f_in.lastIndexOf("."));
            String cmd = "html2pdf " + filename + ".html  " + filename + ".pdf";
            String trace = PogoUtil.executeShellCmd(cmd);
            if (this.display_trace) {
                System.out.println(trace);
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Cannot buid pdf file");
            e.printStackTrace();
            return false;
        }
    }

    private String buildTitle(String code) {
        int start_title = code.indexOf("<h1>");
        if ((start_title = code.lastIndexOf("<center>", start_title)) < 0) {
            return code;
        }
        int end_title = code.indexOf("</center>");
        String title = code.substring(start_title, end_title);
        String new_title = "<Br>&nbsp;<Br><Br>&nbsp;<Br><Br>&nbsp;<Br><center><Table Border=2 Cellpadding=3 CELLSPACING=0 WIDTH=\"100%\">\n<Tr><Td><Br>&nbsp;<Br>\n";
        int pos = title.indexOf("User's Guide") + "User's Guide".length();
        new_title = new_title + title.substring(0, pos) + Cr;
        int pos2 = title.indexOf("Class", pos) + "Class".length();
        new_title = new_title + title.substring(pos, pos2) + Cr;
        new_title = new_title + "</Td></Tr>\n</h1>\n<Tr><Td>\n";
        pos = title.indexOf("Revision:", pos2);
        pos2 = title.indexOf("\n", pos);
        new_title = new_title + "<b>" + title.substring(pos, pos2 + 1);
        new_title = new_title + "</b>\n</Td></Tr>\n</center>\n</Table>\n";
        String inheritance = this.buildInheritanceDiagram();
        new_title = new_title + "<Br>\n<Br>\n<Br>\n" + inheritance;
        return code.substring(0, start_title) + new_title + code.substring(end_title);
    }

    protected void generateFull() throws IOException, PogoException {
        if (!PogoUtil.osName().equals("Linux")) {
            return;
        }
        String code = this.readTemplate((String)"index.html", (String)"").str;
        code = this.buildTitle(code);
        String intro = "<h2>Introduction:</h2>\n";
        String desc = "<h2>Description:</h2>";
        int pos = code.indexOf(intro);
        code = code.substring(0, pos) + Cr + Cr + "\n" + code.substring(pos);
        pos = code.indexOf(desc);
        code = code.substring(0, pos) + Cr + Cr + "\n" + code.substring(pos);
        if (this.server.inherited_from != null && !this.server.inheritedClassName().equals("Device_3Impl")) {
            String inheritance_message = "<b>This class inherits from " + this.server.inheritedClassName() + " class.</b><Br>\n";
            pos = code.indexOf(intro);
            code = code.substring(0, pos) + inheritance_message + code.substring(pos);
        }
        pos = code.indexOf(desc);
        code = code.substring(0, pos + desc.length()) + "\n";
        code = code + this.getDescriptionPart();
        code = code + this.getPropertiesPart();
        if (this.server.states.size() > 0) {
            code = code + this.getStatesPart();
        }
        if (this.server.attributes.size() > 0) {
            code = code + this.getAttributesPart();
        }
        if (this.server.commands.size() > 0) {
            code = code + this.getCommandsPart();
        }
        code = code + "<Br>&nbsp;<Br><Br>&nbsp;<Br>\n";
        String f_out = this.outDoc + "/user_guide.html";
        this.writeDocFile(f_out, code, true);
        if (this.buildPdf(f_out)) {
            try {
                String indexfile = this.outDoc + "/index.html";
                PogoString pgs = new PogoString(PogoUtil.readFile(indexfile));
                pos = pgs.str.indexOf("Revision:");
                pos = pgs.str.indexOf("<Br>", pos + 1);
                pos = pgs.str.indexOf("<Br>", pos + 1);
                pos = pgs.str.indexOf("<Br>", pos + 1);
                pgs.insert(pos, "<center>\n<a href=user_guide.pdf target=new> Download PDF format</a>\n</center>\n");
                PogoUtil.writeFile(indexfile, pgs.str);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

