/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.Tango.DispLevel;
import fr.esrf.TangoDs.TangoConst;
import java.util.StringTokenizer;
import pogo.gene.DevState;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.TangoTypes;

public class Cmd
implements TangoConst,
PogoDefs {
    public String name;
    public String description;
    public String exec_method;
    public String cmd_class;
    public TangoTypes argin;
    public TangoTypes argout;
    public DispLevel level = DispLevel.OPERATOR;
    public DevStateTable notAllowedFor;
    public boolean virtual_method;
    public int override_method;
    public int polled_period;
    private String[] poll_template = new String[]{"\t\t\tif (cmd.get_name().equals(\"CMD_NAME\"))\n\t\t\t\tcmd.set_polling_period(", "\t\tif (command_list[i]->get_name()==\"CMD_NAME\")\n\t\t\tcommand_list[i]->set_polling_period("};

    private void cmdFactory(String name, String cc, String in_type, String out_type, String in_desc, String out_desc, String desc) {
        this.name = name;
        this.cmd_class = cc;
        this.exec_method = this.buildExecCmdMethodName();
        this.argin = new TangoTypes(in_type, in_desc);
        this.argout = new TangoTypes(out_type, out_desc);
        this.notAllowedFor = new DevStateTable();
        if (desc != null) {
            this.description = desc;
        }
        this.virtual_method = false;
        this.override_method = 0;
    }

    public Cmd(Cmd cmd) {
        this.cmdFactory(cmd.name, cmd.cmd_class, cmd.argin.cpp_code_str, cmd.argin.cpp_code_str, cmd.argout.description, cmd.argout.description, cmd.description);
        this.polled_period = cmd.polled_period;
        this.level = cmd.level;
    }

    public Cmd(String name, String cc, String in_type, String out_type, String in_desc, String out_desc, String desc) {
        this.cmdFactory(name, cc, in_type, out_type, in_desc, out_desc, desc);
    }

    public Cmd(String name, String cc, String in_type, String out_type, String in_desc, String out_desc, String desc, DispLevel level) {
        this.cmdFactory(name, cc, in_type, out_type, in_desc, out_desc, desc);
        this.level = level;
    }

    public Cmd(String cmdLine) {
        String[] fields = new PogoString(cmdLine).getFields();
        this.cmdFactory(fields[1], fields[0], fields[2], fields[3], fields[4], fields[5], "");
        if (fields.length >= 7 && fields[6].indexOf("EXPERT") > 0) {
            this.level = DispLevel.EXPERT;
        }
    }

    public void setDescription(String str) {
        this.description = str;
    }

    private String buildExecCmdMethodName() {
        if (this.name.equals("State")) {
            return "dev_state";
        }
        if (this.name.equals("Status")) {
            return "dev_status";
        }
        String str = "";
        for (int i = 0; i < this.name.length(); ++i) {
            if (this.name.charAt(i) >= 'A' && this.name.charAt(i) <= 'Z') {
                if (i > 0 && (this.name.charAt(i - 1) < 'A' || this.name.charAt(i - 1) > 'Z')) {
                    str = str + '_';
                }
                str = str + (char)(this.name.charAt(i) + 32);
                continue;
            }
            str = str + this.name.charAt(i);
        }
        return str;
    }

    public void setPolledPerriod(String cmd_factory, int lang) {
        PogoString pgs = new PogoString(this.poll_template[lang]);
        pgs.replace("CMD_NAME", this.name);
        int start = cmd_factory.indexOf(pgs.str);
        if (start > 0) {
            int end = cmd_factory.indexOf(")", start += pgs.str.length());
            try {
                this.polled_period = Integer.parseInt(cmd_factory.substring(start, end));
            }
            catch (NumberFormatException e) {
                this.polled_period = 0;
            }
        }
    }

    public boolean isExecMethod(String line) {
        if (line.indexOf(59) >= 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(line);
        while (st.countTokens() > 0) {
            int end;
            String s = st.nextToken();
            int start = s.indexOf("::");
            if (start > 0) {
                s = s.substring(start + "::".length());
            }
            if ((end = s.indexOf("(")) > 0) {
                s = s.substring(0, end);
            }
            if (!s.equals(this.exec_method)) continue;
            return true;
        }
        return false;
    }

    public String constructorSignature(String code) {
        PogoString pgs = new PogoString(code);
        String defaultname = "DevTemplateCmd::DevTemplateCmd";
        String name = this.cmd_class + "::" + this.cmd_class;
        while (pgs.str.indexOf(defaultname) >= 0) {
            pgs.replace(defaultname, name);
        }
        int start = pgs.str.indexOf(name);
        start = pgs.str.indexOf(name, start + 1);
        int end = pgs.str.indexOf("{", start);
        code = pgs.str.substring(start, end);
        return code;
    }

    public String AddCmdPollingLine(int lang) {
        PogoString pgs = new PogoString(this.poll_template[lang]);
        pgs.replace("CMD_NAME", this.name);
        if (this.polled_period > 0) {
            pgs.str = pgs.str + this.polled_period + ");\n";
            return pgs.str;
        }
        return "";
    }

    public String AddCmdFactoryLine(int lang) {
        String add_list_str = lang == 0 ? "command_list.addElement" : "command_list.push_back";
        String tab0 = lang == 0 ? "\t\t" : "\t";
        String tab = lang == 0 ? "\t\t\t" : "\t\t";
        String str = tab0 + add_list_str + "(new " + this.cmd_class + "(\"" + this.name + "\",\n" + tab;
        str = lang == 0 ? str + this.argin.java_code_str : str + this.argin.cpp_code_str;
        str = str + ", ";
        str = lang == 0 ? str + this.argout.java_code_str : str + this.argout.cpp_code_str;
        str = str + ",\n" + tab;
        str = this.argin.description == null ? str + "\"\",\n" + tab : str + "\"" + this.argin.description + "\",\n" + tab;
        str = this.argout.description == null ? str + "\"\"));\n" : str + "\"" + this.argout.description + "\"";
        String namespace = lang == 0 ? "DispLevel." : "Tango::";
        str = str + ",\n" + tab + namespace;
        str = this.level == DispLevel.EXPERT ? str + "EXPERT));\n" : str + "OPERATOR));\n";
        return str;
    }

    public boolean execMethodArgsChanged(String line, int lang) {
        String argin;
        String s1;
        StringTokenizer st1;
        StringTokenizer st = new StringTokenizer(line);
        String s = st.nextToken();
        String argout = lang == 0 ? st.nextToken() : s;
        int start = line.indexOf("(") + 1;
        int end = line.indexOf(")");
        if (end < 0) {
            end = line.length();
        }
        if ((st1 = new StringTokenizer(s1 = line.substring(start, end))).countTokens() > 0) {
            argin = st1.nextToken();
            if (argin.equals("const")) {
                argin = st1.nextToken();
            }
        } else {
            argin = "void";
        }
        switch (lang) {
            case 0: {
                return !this.argin.java.equals(argin) || !this.argout.java.equals(argout);
            }
            case 1: {
                if (!this.argin.cpp.equals(argin)) {
                    System.out.println("ARGIN CHANGED " + argin + " - " + this.argin.cpp);
                }
                if (!this.argout.cpp.equals(argout)) {
                    System.out.println("ARGOUT CHANGED " + argout + " - " + this.argout.cpp);
                }
                return !this.argin.cpp.equals(argin) || !this.argout.cpp.equals(argout);
            }
        }
        return false;
    }

    public String buildJavaExecuteMethodBlock(String class_name) {
        String str = "";
        String indent = "\t\t";
        if (this.argin.code != 0) {
            str = str + indent + this.argin.java + " argin = " + this.argin.javaExtract() + "(in_any);\n";
        }
        str = !this.argout.java.equals("void") ? str + indent + "return insert(" : str + indent;
        str = str + "((" + class_name + ")(device))." + this.exec_method + "(";
        if (!this.argin.java.equals("void")) {
            str = str + "argin";
        }
        str = !this.argout.java.equals("void") ? str + "));\n" : str + ");\n" + indent + "return insert();\n";
        str = str + "\t}\n";
        return str;
    }

    public String buildJavaExecCmdMethodComments() {
        String str = "\n\n//=========================================================\n/**\n *\tExecute command \"" + this.name + "\" on device.\n";
        if (this.description != null && this.description.length() > 0) {
            str = str + " *\t" + new PogoString(this.description).setComments() + "\n";
        }
        str = str + " *\n";
        if (!this.argin.java.equals("void")) {
            str = str + " * @param\targin\t" + this.argin.description + "\n";
        }
        if (!this.argout.java.equals("void")) {
            str = str + " * @return\t" + this.argout.description + "\n";
        }
        return str + " */\n" + "//=========================================================\n";
    }

    public String buildJavaExecCmdMethodSignature(int out) {
        String str = "public " + this.argout.java + " ";
        str = out == 0 ? str + this.exec_method : str + this.name;
        str = str + "(";
        if (this.argin.code != 0) {
            str = str + this.argin.java + " argin";
        }
        str = str + ") throws DevFailed";
        return str;
    }

    public String buildJavaExecCmdMethod() {
        String str = this.buildJavaExecCmdMethodSignature(0) + "\n\t{\n";
        if (this.argout.code != 0) {
            str = str + "\t\t" + this.argout.java + "\targout = ";
            if (this.name.equals("State")) {
                str = str + " super.dev_state();\n\n";
            } else if (this.name.equals("Status")) {
                str = str + " super.dev_status();\n\n";
            } else if (this.argout.is_array && !this.argout.need_2constr) {
                str = str + "new " + this.argout.java;
                int pos = str.length() - 1;
                str = str.substring(0, pos) + "5" + str.substring(pos);
                str = str + ";\n\n";
            } else {
                str = this.argout.need_constr ? str + "new " + this.argout.java + "();\n\n" : str + " (" + this.argout.java + ")0;\n\n";
            }
        }
        str = str + "\t\tget_logger().info(\"Entering " + this.exec_method + "()\");\n";
        str = str + "\n\t\t// ---Add your Own code to control device here ---\n\n";
        str = str + "\t\tget_logger().info(\"Exiting " + this.exec_method + "()\");\n";
        if (this.argout.code != 0) {
            str = str + "\t\treturn argout;\n";
        }
        str = str + "\t}\n";
        return str;
    }

    public String buildJavaProxyMethod() {
        String str = "";
        str = str + "\n\t{\n";
        if (this.name.equals("State")) {
            str = str + "\t\treturn state();\n";
        } else if (this.name.equals("Status")) {
            str = str + "\t\treturn status();\n";
        } else {
            if (this.argin.code != 0) {
                str = str + "\t\tdata_in.insert(argin);\n";
                str = str + "\t\tdata_out = command_inout(\"" + this.name + "\", data_in);\n";
            } else {
                str = str + "\t\tdata_out = command_inout(\"" + this.name + "\");\n";
            }
            if (this.argout.code != 0) {
                str = str + "\t\treturn data_out." + this.argout.extract_method() + "();\n";
            }
        }
        str = str + "\t}\n";
        return str;
    }

    public String buildCppCmdProtypesLineNoTab() {
        PogoString pgs = new PogoString(this.buildCppCmdProtypesLine());
        while (pgs.str.indexOf(9) >= 0) {
            pgs.replace("\t", " ");
        }
        return pgs.str;
    }

    public String buildCppCmdProtypesLine() {
        String str = "";
        if (this.virtual_method) {
            str = str + "virtual ";
        }
        str = str + this.argout.cpp + "\t";
        if (this.argout.code != 8 && (this.argout.need_constr || this.argout.is_array)) {
            str = str + "*";
        }
        str = str + this.exec_method + "(";
        if (this.argin.code != 0) {
            if (this.argin.is_array) {
                str = str + "const ";
            }
            str = str + this.argin.cpp;
            if ((this.argin.need_constr || this.argin.is_array) && this.argin.code != 8) {
                str = str + " *";
            }
        }
        str = str + ");\n";
        return str;
    }

    public String buildCppCmdProtypes() {
        String str = "/**\n * ";
        if (this.description != null) {
            str = str + new PogoString(this.description).setComments();
        }
        if (this.argin.code != 0) {
            str = str + "\n *\t@param\targin\t";
            if (this.argin.description != null) {
                str = str + new PogoString(this.argin.description).setComments();
            }
        }
        if (this.argout.code != 0) {
            str = str + "\n *\t@return\t";
            if (this.argout.description != null) {
                str = str + new PogoString(this.argout.description).setComments();
            }
        }
        str = str + "\n *\t@exception DevFailed\n */\n";
        str = str + "\t";
        str = str + this.buildCppCmdProtypesLine();
        return str;
    }

    public String buildCppClassesDefs(String str, String class_name) {
        PogoString pgs = new PogoString(str);
        while (pgs.str.indexOf("DevTemplateCmd") >= 0) {
            pgs.replace("DevTemplateCmd", this.cmd_class);
        }
        while (pgs.str.indexOf("CLASS") >= 0) {
            pgs.replace("CLASS", class_name);
        }
        while (pgs.str.indexOf("COMMAND") >= 0) {
            pgs.replace("COMMAND", this.name);
        }
        pgs.append("\n\n");
        return pgs.str;
    }

    public String setCmdClass(String str) {
        PogoString pgs = new PogoString(str);
        while (pgs.str.indexOf("DevTemplateCmd") >= 0) {
            pgs.replace("DevTemplateCmd", this.cmd_class);
        }
        pgs.append("\n\n");
        return pgs.str;
    }

    public String buildCppCmdClassBlock(String str, String class_name) throws PogoException {
        int end = str.indexOf("extract");
        if (end < 0) {
            throw new PogoException("Input File Syntax error 1!");
        }
        PogoString pgs = new PogoString(str);
        while (pgs.str.indexOf("DevTemplateCmd") >= 0) {
            pgs.replace("DevTemplateCmd", this.cmd_class);
        }
        while (str.charAt(end) != '\n') {
            --end;
        }
        str = str.substring(0, ++end);
        if (this.argin.code != 0) {
            str = str + "\t";
            if (this.argin.is_array) {
                str = str + "const ";
            }
            str = str + this.argin.cpp + "\t";
            if ((this.argin.need_constr || this.argin.is_array) && this.argin.code != 8) {
                str = str + "*";
            }
            str = str + "argin;\n";
            str = str + "\textract(in_any, argin);\n\n";
        }
        str = str + "\t";
        if (this.argout.code != 0) {
            str = str + "return insert";
        }
        str = str + "((static_cast<" + class_name + " *>(device))->" + this.exec_method + "(";
        if (this.argin.code != 0) {
            str = str + "argin";
        }
        str = str + "));\n";
        if (this.argout.code == 0) {
            str = str + "\treturn new CORBA::Any();\n";
        }
        str = str + "}\n";
        return str;
    }

    public String buildCppExecCmdMethodComments(String class_name) {
        String str = "//+------------------------------------------------------------------\n/**\n *\tmethod:\t" + class_name + "::" + this.exec_method + "\n" + " *\n" + " *\tdescription:\tmethod to execute \"" + this.name + "\"\n";
        if (this.description != null && this.description.length() > 0) {
            str = str + " *\t" + new PogoString(this.description).setComments() + "\n";
        }
        str = str + " *\n";
        if (this.argin.code != 0) {
            str = str + " * @param\targin\t" + this.argin.description + "\n";
        }
        if (this.argout.code != 0) {
            str = str + " * @return\t" + this.argout.description + "\n";
        }
        str = str + " *\n */\n//+------------------------------------------------------------------\n";
        return str;
    }

    public void updateCppExecCmdMethodComments(PogoString codeStr, String class_name) throws PogoException {
        int startMethod;
        boolean methodExists = false;
        int endLine = 0;
        String line = this.buildCppExecCmdMethodSignature(class_name);
        System.out.println(line);
        int sl = line.indexOf("(");
        int el = line.indexOf(" ", sl);
        if (el < 0) {
            el = sl + 1;
        }
        line = line.substring(0, el);
        while ((startMethod = codeStr.str.indexOf(line, endLine)) >= 0) {
            String s;
            if ((startMethod = codeStr.previousCr(startMethod)) > (endLine = codeStr.nextCr(startMethod))) {
                System.out.println("\n1:\n" + startMethod + " - " + endLine);
                System.out.println(line + "\n\n");
            }
            if ((s = codeStr.str.substring(startMethod, endLine)).indexOf("//") >= 0 || s.indexOf("\"") >= 0 || s.indexOf("<<") >= 0) continue;
            methodExists = true;
            break;
        }
        String newHeader = this.buildCppExecCmdMethodComments(class_name);
        if (methodExists) {
            int startHeader;
            for (startHeader = startMethod; startHeader > 0 && codeStr.str.charAt(startHeader) != '}'; --startHeader) {
            }
            if ((startHeader = codeStr.str.indexOf("//", startHeader)) < 0) {
                startHeader = startMethod;
            }
            String oldHeader = codeStr.str.substring(startHeader, startMethod);
            codeStr.replace(startHeader, oldHeader, newHeader);
        } else {
            codeStr.append(newHeader);
        }
    }

    public String buildCppExecCmdMethodSignature(String class_name) {
        String str = this.argout.cpp + " ";
        if (this.argout.code != 8 && this.argout.is_array) {
            str = str + "*";
        }
        str = str + class_name + "::" + this.exec_method + "(";
        if (this.argin.code != 0) {
            if (this.argin.is_array) {
                str = str + "const ";
            }
            str = str + this.argin.cpp + " ";
            if ((this.argin.need_constr || this.argin.is_array) && this.argin.code != 8) {
                str = str + "*";
            }
            str = str + "argin";
        }
        str = str + ")";
        return str;
    }

    public String buildCppExecCmdMethod(String class_name) {
        String str = this.buildCppExecCmdMethodSignature(class_name) + "\n{\n";
        if (this.argout.code != 0) {
            if (this.argout.need_constr || this.argout.is_array) {
                str = str + "\t//\tPOGO has generated a method core with argout allocation.\n\t//\tIf you would like to use a static reference without copying,\n\t//\tSee \"TANGO Device Server Programmer's Manual\"\n\t//\t\t(chapter : Writing a TANGO DS / Exchanging data)\n\t//------------------------------------------------------------\n";
            }
            str = str + "\t" + this.argout.cpp + "\t";
            if (this.argout.code != 8 && this.argout.need_constr || this.argout.is_array) {
                str = str + "*";
            }
            str = str + "argout ";
            if (this.name.equals("State")) {
                str = str + "= DeviceImpl::dev_state()";
            } else if (this.name.equals("Status")) {
                str = str + "= DeviceImpl::dev_status()";
            } else if (this.argout.need_constr) {
                str = str + " = new ";
                str = this.argout.code == 8 ? str + "char[6];\n\tstrcpy(argout, \"dummy\")" : str + this.argout.cpp + "()";
            }
            str = str + ";\n";
            if (this.argout.code == -2 && !this.name.equals("Status")) {
                str = str + "\targout = \"Hello World\";\n";
            }
            if (!this.argout.need_2constr) {
                if (this.argout.is_array) {
                    if (this.argout.code == 16) {
                        str = str + "\targout->length(1);\n\t(*argout)[0] = CORBA::string_dup(\"dummy\");\n";
                    } else {
                        str = str + "\targout->length(1);\n";
                        str = str + "\t(*argout)[0] = 0";
                        if (this.argout.code == 12 || this.argout.code == 13) {
                            str = str + ".0";
                        }
                        str = str + ";\n";
                    }
                }
            } else {
                str = this.argout.code == 18 ? str + "\targout->dvalue.length(1);\n\targout->dvalue[0] = 0.0;\n" : str + "\targout->lvalue.length(1);\n\targout->lvalue[0] = 0;\n";
                str = str + "\targout->svalue.length(1);\n\targout->svalue[0] = CORBA::string_dup(\"dummy\");\n";
            }
        }
        str = str + "\tDEBUG_STREAM << \"" + class_name + "::" + this.exec_method + "(): entering... !\" << endl;\n" + "\n\t//\tAdd your own code to control device here\n\n";
        if (this.argout.code != 0) {
            str = str + "\treturn argout;\n";
        }
        str = str + "}\n";
        return str;
    }

    public void getExecMethodDescription(String str, int lang) {
        int start;
        int end;
        boolean isComments = true;
        PogoString pgs = new PogoString(str);
        for (end = 0; end >= 0 && isComments; ++end) {
            String target = lang == 0 ? this.buildJavaExecCmdMethodSignature(0) : this.buildCppCmdProtypesLine();
            int idx = target.indexOf(59);
            if (idx > 0) {
                target = target.substring(0, idx);
            }
            if ((end = pgs.str.indexOf(target, end)) < 0 && (end = pgs.str.indexOf(target = this.argout.cpp + "\t" + this.exec_method + "(", end)) < 0) {
                System.out.println(this.exec_method + " method Not found !");
                return;
            }
            start = pgs.previousCr(end);
            if (pgs.str.substring(start, end).indexOf("//") >= 0) continue;
            isComments = false;
        }
        if (end < 0) {
            System.out.println(this.exec_method + " Not found !");
            return;
        }
        switch (lang) {
            case 1: {
                for (start = end = pgs.previousCr(end); start > 0 && pgs.str.charAt(start) != ';' && pgs.str.charAt(start) != '{'; --start) {
                }
                ++start;
                break;
            }
            case 0: {
                int start1;
                while (start > 0 && pgs.str.charAt(start) != '}') {
                    --start;
                }
                if ((start1 = pgs.str.indexOf("Execute command", ++start)) >= 0) {
                    start = pgs.nextCr(start1);
                }
                end = pgs.str.indexOf("*/", start);
            }
        }
        PogoString comments = new PogoString(pgs.str.substring(start, end));
        this.description = comments.getDescription();
    }

    public void setNotAllowedFor(String str, int lang) {
        if (this.notAllowedFor == null) {
            this.notAllowedFor = new DevStateTable();
        } else {
            this.notAllowedFor.clear();
        }
        PogoString pgs = new PogoString(str);
        String pattern = lang == 0 ? "public boolean is_allowed(DeviceImpl device, Any data_in)" : this.cmd_class + "::is_allowed";
        int start = pgs.str.indexOf(pattern);
        if (start < 0) {
            System.out.println("WARNING: " + pattern + " Not Found !" + "\nLang = " + lang);
            return;
        }
        start = pgs.inMethod(start);
        int end = pgs.outMethod(start + 1);
        PogoString method = new PogoString(pgs.str.substring(start, end));
        if ((start = method.inTest(0)) < 0) {
            return;
        }
        end = method.outTest(start);
        if (end < 0) {
            return;
        }
        StringTokenizer stk = new StringTokenizer(method.str.substring(start + 1, end - 1));
        while (stk.hasMoreTokens()) {
            String s = stk.nextToken();
            switch (lang) {
                case 1: {
                    if (s.indexOf("Tango::") != 0) break;
                    this.notAllowedFor.addElement(new DevState(s, ""));
                    break;
                }
                case 0: {
                    if (s.indexOf("DevState.") != 0) break;
                    this.notAllowedFor.addElement(new DevState(s, ""));
                }
            }
        }
    }

    public void setNotAllowedFor(DevStateTable stTable) {
        if (this.notAllowedFor == null) {
            this.notAllowedFor = new DevStateTable();
        } else {
            this.notAllowedFor.clear();
        }
        for (int i = 0; i < stTable.size(); ++i) {
            this.notAllowedFor.addElement(stTable.elementAt(i));
        }
    }

    public void addNotAllowedFor(DevState state) {
        this.notAllowedFor.addElement(state);
    }

    public void removeNotAllowedFor(DevState state) {
        this.notAllowedFor.remove(state);
    }

    public String buildIsAllowedMethod(PogoString method, int lang) throws PogoException {
        int start = method.str.indexOf("End of Generated Code");
        if (start < 0) {
            throw new PogoException("\"End of Generated Code\" Not Found !");
        }
        int end = method.str.indexOf("Re-Start of Generated Code");
        if (end < 0) {
            throw new PogoException("\"Re-Start of Generated Code\" Not Found !");
        }
        start = method.previousCr(start);
        end = method.nextCr(end) + 1;
        String nonAuto = method.str.substring(start, end);
        if (this.notAllowedFor == null || this.notAllowedFor.size() == 0) {
            String str = "{\n" + nonAuto + "\t\treturn true;\n";
            if (lang == 0) {
                str = str + "\t";
            }
            str = str + "}\n";
            return str;
        }
        String head = "{\n\t";
        if (lang == 0) {
            head = head + "\t";
        }
        head = head + "if (";
        for (int i = 0; i < this.notAllowedFor.size(); ++i) {
            DevState state = (DevState)this.notAllowedFor.elementAt(i);
            head = lang == 0 ? head + "device.get_state() == " + state.javaName() : head + "device->get_state() == " + state.name;
            if (i >= this.notAllowedFor.size() - 1) continue;
            head = head + "  ||\n\t\t";
            if (lang != 0) continue;
            head = head + "\t";
        }
        head = lang == 0 ? head + ")\n\t\t{\n" : head + ")\n\t{\n";
        StringBuffer foot = new StringBuffer("");
        if (lang == 0) {
            foot.append("\t");
        }
        foot.append("\t\treturn false;\n");
        if (lang == 0) {
            foot.append("\t");
        }
        foot.append("\t}\n");
        if (lang == 0) {
            foot.append("\t");
        }
        foot.append("\treturn true;\n");
        if (lang == 0) {
            foot.append("\t");
        }
        foot.append("}\n");
        return head + nonAuto + foot.toString();
    }

    String allowedSignatureMethod(String class_name) {
        return this.signature("/**\n *\tExecution allowed for COMMAND command.\n */\n\tvirtual bool CLASS::METHOD(const CORBA::Any &any)", class_name, "is_" + this.name + "_allowed", false);
    }

    String allowedFullSignatureMethod(String class_name) {
        return this.signature("/**\n *\tExecution allowed for COMMAND command.\n */\n\tvirtual bool CLASS::METHOD(const CORBA::Any &any)", class_name, "is_" + this.name + "_allowed", true);
    }

    private String signature(String template, String cl_name, String method, boolean full) {
        int start;
        String target;
        PogoString pgs = new PogoString(template);
        pgs.replace("COMMAND", this.name);
        pgs.replace("METHOD", method);
        if (cl_name == null) {
            pgs.replace("CLASS::", "");
        } else {
            pgs.replace("CLASS", cl_name);
            if (full) {
                target = " *\t";
                start = pgs.indexOf(target, "/**".length());
                int end = pgs.nextCr(start += target.length());
                String desc = pgs.substring(start, end);
                PogoString separator = new PogoString("//+----------------------------------------------------------------------------\n//\n// method : \t\tCLASS::METHOD\n// \n// description : \tDESCRIPTION\n//\n//-----------------------------------------------------------------------------\n");
                separator.replace("CLASS", cl_name);
                separator.replace("METHOD", method);
                separator.replace("DESCRIPTION", desc);
                target = " */\n\tvirtual ";
                end = pgs.indexOf(target);
                String comments = pgs.substring(0, end + target.length());
                pgs.replace(comments, separator.str);
            }
        }
        if (!full) {
            target = " */\n\tvirtual ";
            start = pgs.indexOf(target);
            return pgs.substring(start += target.length());
        }
        return pgs.str;
    }

    String allowedCore() {
        return this.notAllowedFor.allowedCore();
    }

    public String toString() {
        return this.name;
    }
}

