/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.Tango.DispLevel;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.TangoTypes;

public class Attrib
implements PogoDefs {
    public String name;
    public int attrType;
    public TangoTypes dataType;
    public int rwType;
    public String assAttr;
    public int xSize;
    public int ySize;
    public DevStateTable notAllowedFor;
    public DispLevel disp_level = DispLevel.OPERATOR;
    public int polled_period = 0;
    public boolean memorized = false;
    public boolean memorized_init = true;
    public String[] properties;
    private static final String[] def_prop_method = new String[]{"set_label", "set_unit", "set_standard_unit", "set_display_unit", "set_format", "set_max_value", "set_min_value", "set_max_alarm", "set_min_alarm", "set_description"};
    private static final String set_def_prop_method = "set_default_properties";
    private FireEvent change_evt;
    private FireEvent archive_evt;
    public static final int CHANGE = 0;
    public static final int ARCHIVE = 1;

    public boolean[] getFireEvent(int type) {
        FireEvent evt = type == 0 ? this.change_evt : this.archive_evt;
        return new boolean[]{evt.by_code, evt.whith_check};
    }

    public void setFireEvent(int type, boolean code, boolean checked) {
        FireEvent evt;
        FireEvent fireEvent = evt = type == 0 ? this.change_evt : this.archive_evt;
        if (evt == null) {
            evt = new FireEvent();
        }
        evt.by_code = code;
        evt.whith_check = code ? checked : false;
    }

    public Attrib(String name, String readcode) throws PogoException {
        this.name = name;
        this.change_evt = new FireEvent();
        this.archive_evt = new FireEvent();
        PogoString code = new PogoString(readcode);
        int start = code.indexOf("class " + name + "Attr:");
        if (start < 0 && (start = code.indexOf("class " + name + "Attrib:")) < 0) {
            throw new PogoException("Attribute class not defined in header file !");
        }
        start = code.inMethod(start);
        int end = code.outMethod(start);
        PogoString class_def = new PogoString(code.substring(start, end));
        end = class_def.indexOf(") {}");
        start = class_def.lastIndexOf("(", end) + 1;
        PogoString constructor = new PogoString(class_def.substring(start, end));
        String[] params = constructor.getFields();
        end = start;
        String constr_signature = class_def.substring(start = class_def.lastIndexOf("public:", end) + "public:".length(), end).trim();
        this.attrType = constr_signature.indexOf(":ImageAttr") > 0 ? 2 : (constr_signature.indexOf(":SpectrumAttr") > 0 ? 1 : 0);
        int idx = 1;
        this.dataType = new TangoTypes(params[idx++]);
        this.rwType = 0;
        for (int i = 0; i < PogoDefs.AttrRWtypeArray.length; ++i) {
            String target = "Tango::" + PogoDefs.AttrRWtypeArray[i];
            if (!params[idx].equals(target)) continue;
            this.rwType = i;
        }
        ++idx;
        switch (this.attrType) {
            case 0: {
                if (this.rwType != 3) break;
                this.assAttr = params[idx];
                break;
            }
            case 1: {
                this.xSize = new Integer(params[idx]);
                break;
            }
            case 2: {
                this.xSize = new Integer(params[idx]);
                this.ySize = new Integer(params[++idx]);
            }
        }
        this.properties = new String[10];
        this.notAllowedFor = new DevStateTable();
    }

    public Attrib(String name, int attrType, String dataType, int rwType, String assAttr) {
        this(name, attrType, dataType, 1, 1);
        this.rwType = rwType;
        this.assAttr = assAttr;
        this.change_evt = new FireEvent();
        this.archive_evt = new FireEvent();
    }

    public Attrib(String name, int attrType, String dataType, int rwType, int xSize) {
        this(name, attrType, dataType, rwType, xSize, 1);
        this.change_evt = new FireEvent();
        this.archive_evt = new FireEvent();
    }

    public Attrib(String name, int attrType, String dataType, int rwType, int xSize, int ySize) {
        this.name = name;
        this.attrType = attrType;
        this.dataType = new TangoTypes(dataType, "");
        this.rwType = rwType;
        this.xSize = xSize;
        this.ySize = ySize;
        this.assAttr = "";
        this.properties = new String[10];
        this.notAllowedFor = new DevStateTable();
        this.change_evt = new FireEvent();
        this.archive_evt = new FireEvent();
    }

    public void setDataType(String dataType) {
        this.dataType = new TangoTypes(dataType, "");
    }

    public void setDataType(String dataType, int lang) {
        this.dataType = new TangoTypes(dataType);
    }

    public boolean getWritable() {
        return this.rwType != 0 && this.rwType != 3;
    }

    public String cppMemberData() {
        String str = "";
        if (this.rwType != 1) {
            str = str + "\t\t" + this.dataType.cpp + "\t*attr_" + this.name + "_read;\n";
        }
        if (this.getWritable()) {
            str = str + "\t\t" + this.dataType.cpp + "\tattr_" + this.name + "_write;\n";
        }
        return str;
    }

    public String javaMemberData() {
        String str = "";
        if (this.rwType != 1) {
            str = str + "\tprotected " + this.dataType.java + "[]\tattr_" + this.name + "_read " + "= new " + this.dataType.java;
            switch (this.attrType) {
                case 0: {
                    str = str + "[1];\n";
                    break;
                }
                case 1: {
                    str = str + "[" + this.xSize + "];\n";
                    break;
                }
                case 2: {
                    str = str + "[" + this.xSize * this.ySize + "];\n";
                }
            }
        }
        if (this.attrType == 0 && this.rwType != 0 && this.rwType != 3) {
            str = str + "\tprotected " + this.dataType.java + "\tattr_" + this.name + "_write;\n";
        }
        return str;
    }

    public String buildCodeForAttributeConstructor(int lang) {
        if (lang == 1) {
            return "\t" + this.name + "Attrib\t*" + this.getLowerName() + " = new " + this.name + "Attrib();\n";
        }
        String[] att_type = new String[]{"Attr", "SpectrumAttr", "ImageAttr"};
        String namespace = lang == 0 ? "" : "Tango::";
        String tab = lang == 0 ? "\t" : "";
        String pointer = lang == 0 ? "" : "*";
        String argtype = lang == 0 ? this.dataType.java_code_str : this.dataType.cpp_code_str;
        String str = "\t" + tab + namespace + att_type[this.attrType] + "\t" + pointer + this.getLowerName() + " = \n" + tab + "\t\t" + "new " + namespace + att_type[this.attrType] + "(" + "\"" + this.name + "\", " + argtype + ", ";
        switch (this.attrType) {
            case 0: {
                if (lang == 0) {
                    namespace = "AttrWriteType.";
                }
                str = str + namespace + PogoDefs.AttrRWtypeArray[this.rwType];
                if (this.rwType != 3) break;
                str = str + ", \"" + this.assAttr + "\"";
                break;
            }
            case 1: {
                str = str + this.xSize;
                break;
            }
            case 2: {
                str = str + this.xSize + ", " + this.ySize;
            }
        }
        str = str + ");\n";
        return str;
    }

    public String buitCodeForDefaultProperties(int lang) {
        String namespace;
        String pointer;
        String tab = lang == 0 ? "\t" : "";
        boolean has_been_set = false;
        for (int i = 0; i < this.properties.length; ++i) {
            if (this.properties[i] == null || this.properties[i].length() <= 0) continue;
            has_been_set = true;
        }
        String str = "";
        String string = pointer = lang == 0 ? "." : "->";
        if (has_been_set) {
            namespace = lang == 0 ? "" : "Tango::";
            str = str + tab + "\t" + namespace + "UserDefaultAttrProp\t" + this.getLowerName() + "_prop";
            if (lang == 0) {
                str = str + " = new UserDefaultAttrProp()";
            }
            str = str + ";\n";
            for (int i = 0; i < def_prop_method.length; ++i) {
                if (this.properties[i] == null || this.properties[i].length() <= 0) continue;
                str = str + tab + "\t" + this.getLowerName() + "_prop." + def_prop_method[i] + "(\"" + this.properties[i] + "\");\n";
            }
            str = str + tab + "\t" + this.getLowerName() + pointer + set_def_prop_method + "(" + this.getLowerName() + "_prop);\n";
        }
        if (this.polled_period > 0) {
            str = str + tab + "\t" + this.getLowerName() + pointer + "set_polling_period(" + this.polled_period + ");\n";
        }
        if (this.disp_level == DispLevel.EXPERT) {
            namespace = lang == 0 ? "DispLevel." : "Tango::";
            str = str + tab + "\t" + this.getLowerName() + pointer + "set_disp_level(" + namespace + "EXPERT);\n";
        }
        if (lang == 1) {
            if (this.memorized) {
                str = str + tab + "\t" + this.getLowerName() + pointer + "set_memorized();\n" + tab + "\t" + this.getLowerName() + pointer + "set_memorized_init(" + this.memorized_init + ");\n";
            }
            if (this.change_evt.by_code) {
                str = str + tab + "\t" + this.getLowerName() + pointer + "set_change_event(" + this.change_evt.by_code + ", " + this.change_evt.whith_check + ");\n";
            }
            if (this.archive_evt.by_code) {
                str = str + tab + "\t" + this.getLowerName() + pointer + "set_archive_event(" + this.archive_evt.by_code + ", " + this.archive_evt.whith_check + ");\n";
            }
        }
        return str;
    }

    public void getDefaultProperties(PogoString pgs, int lang) {
        String[] params;
        String method;
        String prop_def = this.getLowerName() + "_prop.";
        String pattern = "//\tAttribute : ";
        int start = pgs.str.indexOf(pattern + this.name);
        if (start < 0) {
            return;
        }
        int end = pgs.str.indexOf(pattern, start + 1);
        PogoString block = end > 0 ? new PogoString(pgs.str.substring(start, end)) : new PogoString(pgs.str.substring(start));
        end = 0;
        while ((start = block.str.indexOf(prop_def, end)) > 0) {
            end = block.nextCr(start);
            int start1 = start + prop_def.length();
            int end1 = block.str.indexOf("(", start1);
            method = block.str.substring(start1, end1);
            start1 = block.str.indexOf("\"", end1) + 1;
            end1 = block.str.indexOf("\"", start1);
            String value = block.str.substring(start1, end1);
            for (int i = 0; i < def_prop_method.length; ++i) {
                if (!method.equals(def_prop_method[i])) continue;
                this.properties[i] = value;
            }
        }
        String code = block.str;
        String pointer = lang == 0 ? "." : "->";
        method = this.getLowerName() + pointer + "set_polling_period(";
        start = code.indexOf(method);
        if (start > 0) {
            this.polled_period = Integer.parseInt(code.substring(start += method.length(), code.indexOf(")", start)));
        }
        if ((start = code.indexOf(method = this.getLowerName() + pointer + "set_disp_level(")) > 0) {
            String strlevel;
            this.disp_level = (strlevel = code.substring(start += method.length(), code.indexOf(")", start))).indexOf("EXPERT") > 0 ? DispLevel.EXPERT : DispLevel.OPERATOR;
        }
        if (code.indexOf(method = this.getLowerName() + pointer + "set_memorized();") > 0) {
            this.memorized = true;
            method = this.getLowerName() + pointer + "set_memorized_init(";
            start = code.indexOf(method);
            if (start > 0) {
                String param = code.substring(start + method.length());
                this.memorized_init = param.startsWith("true");
            } else {
                this.memorized_init = true;
            }
        }
        if ((start = code.indexOf(method = this.getLowerName() + pointer + "set_change_event(")) > 0) {
            params = new String[2];
            end = code.indexOf(",", start += method.length());
            params[0] = code.substring(start, end).trim().toLowerCase();
            start = end + 1;
            end = code.indexOf(");", start);
            params[1] = code.substring(start, end).trim().toLowerCase();
            this.setFireEvent(0, params[0].equals("true"), params[1].equals("true"));
        }
        if ((start = code.indexOf(method = this.getLowerName() + pointer + "set_archive_event(")) > 0) {
            params = new String[2];
            end = code.indexOf(",", start += method.length());
            params[0] = code.substring(start, end).trim().toLowerCase();
            start = end + 1;
            end = code.indexOf(");", start);
            params[1] = code.substring(start, end).trim().toLowerCase();
            this.setFireEvent(1, params[0].equals("true"), params[1].equals("true"));
        }
    }

    String getDescription() {
        return this.properties[def_prop_method.length - 1];
    }

    String getDescriptionLine() {
        String desc = this.properties[def_prop_method.length - 1];
        if (desc == null) {
            return desc;
        }
        if (desc.length() == 0) {
            return desc;
        }
        PogoString line = new PogoString(desc);
        while (line.str.indexOf("\\n") >= 0) {
            line.replace("\\n", " ");
        }
        return line.str;
    }

    String buildCppClassesDefs(String template, String class_name) {
        String add_param;
        int start;
        String src;
        PogoString pgs = new PogoString(template);
        while (pgs.indexOf("ATTRIBUTE") > 0) {
            pgs.replace("ATTRIBUTE", this.name);
        }
        while (pgs.indexOf("CLASS") > 0) {
            pgs.replace("CLASS", class_name);
        }
        String inherite_class = src = ":Attr";
        if (this.attrType == 1) {
            inherite_class = ":SpectrumAttr";
        } else if (this.attrType == 2) {
            inherite_class = ":ImageAttr";
        }
        pgs.replace(src, inherite_class);
        pgs.replace(src, inherite_class);
        pgs.replace("DATA_TYPE", this.dataType.cpp_code_str);
        pgs.replace("RW_TYPE", "Tango::" + PogoDefs.AttrRWtypeArray[this.rwType]);
        if (this.attrType == 0 && this.rwType == 3) {
            start = pgs.indexOf(") {}");
            add_param = ", \"" + this.assAttr + "\"";
            pgs.insert(start, add_param);
        }
        if (this.attrType == 1 || this.attrType == 2) {
            start = pgs.indexOf(") {}");
            add_param = ", " + this.xSize;
            pgs.insert(start, add_param);
        }
        if (this.attrType == 2) {
            start = pgs.indexOf(") {}");
            add_param = ", " + this.ySize;
            pgs.insert(start, add_param);
        }
        if (!this.getWritable()) {
            start = pgs.indexOf("\tvirtual void write");
            int end = pgs.indexOf("\tvirtual bool is_allowed");
            pgs.remove(pgs.substring(start, end));
        }
        return pgs.str;
    }

    String readSignatureMethod(String class_name) {
        return this.signature("/**\n *\tExtract real attribute values for ATTRIBUTE acquisition result.\n */\n\tvirtual void CLASS::METHOD(Tango::Attribute &attr)", class_name, "read_" + this.name, false);
    }

    String writeSignatureMethod(String class_name) {
        return this.signature("/**\n *\tWrite ATTRIBUTE attribute values to hardware.\n */\n\tvirtual void CLASS::METHOD(Tango::WAttribute &attr)", class_name, "write_" + this.name, false);
    }

    String allowedSignatureMethod(String class_name) {
        return this.signature("/**\n *\tRead/Write allowed for ATTRIBUTE attribute.\n */\n\tvirtual bool CLASS::METHOD(Tango::AttReqType type)", class_name, "is_" + this.name + "_allowed", false);
    }

    String readFullSignatureMethod(String class_name) {
        return this.signature("/**\n *\tExtract real attribute values for ATTRIBUTE acquisition result.\n */\n\tvirtual void CLASS::METHOD(Tango::Attribute &attr)", class_name, "read_" + this.name, true);
    }

    String writeFullSignatureMethod(String class_name) {
        return this.signature("/**\n *\tWrite ATTRIBUTE attribute values to hardware.\n */\n\tvirtual void CLASS::METHOD(Tango::WAttribute &attr)", class_name, "write_" + this.name, true);
    }

    String allowedFullSignatureMethod(String class_name) {
        return this.signature("/**\n *\tRead/Write allowed for ATTRIBUTE attribute.\n */\n\tvirtual bool CLASS::METHOD(Tango::AttReqType type)", class_name, "is_" + this.name + "_allowed", true);
    }

    private String signature(String template, String cl_name, String method, boolean full) {
        int start;
        String target;
        PogoString pgs = new PogoString(template);
        pgs.replace("ATTRIBUTE", this.name);
        pgs.replace("METHOD", method);
        if (cl_name == null) {
            pgs.replace("CLASS::", "");
        } else {
            pgs.replace("CLASS", cl_name);
            if (full) {
                target = " *\t";
                start = pgs.indexOf(target, "/**".length());
                int end = pgs.nextCr(start += target.length());
                String desc = pgs.substring(start, end);
                PogoString separator = new PogoString("//+----------------------------------------------------------------------------\n//\n// method : \t\tCLASS::METHOD\n// \n// description : \tDESCRIPTION\n//\n//-----------------------------------------------------------------------------\n");
                separator.replace("CLASS", cl_name);
                separator.replace("METHOD", method);
                separator.replace("DESCRIPTION", desc);
                target = " */\n\tvirtual ";
                end = pgs.indexOf(target);
                String comments = pgs.substring(0, end + target.length());
                pgs.replace(comments, separator.str);
            }
        }
        if (!full) {
            target = " */\n\tvirtual ";
            start = pgs.indexOf(target);
            return pgs.substring(start += target.length());
        }
        return pgs.str;
    }

    String getDevImpl2ReadAttr(PogoString code, String classname) {
        String pattern = "void " + classname + "::read_attr(Tango::Attribute &attr)";
        int start = code.str.indexOf(pattern);
        if (start < 0) {
            return "";
        }
        start = code.inMethod(start);
        int end = code.outMethod(start);
        PogoString method = new PogoString(code.str.substring(start, end));
        pattern = "if (attr_name == \"" + this.name + "\")";
        start = method.str.indexOf(pattern);
        if (start < 0) {
            return "";
        }
        start = method.inMethod(start);
        end = method.outMethod(start);
        start = method.nextCr(start);
        end = method.previousCr(end - 2);
        PogoString block = new PogoString(method.str.substring(start, end));
        block.indent(-1);
        return block.str;
    }

    String getDevImpl2WriteAttr(PogoString code, String classname) {
        String pattern = "void " + classname + "::write_attr_hardware(vector<long> &attr_list)";
        int start = code.str.indexOf(pattern);
        if (start < 0) {
            System.out.println(pattern + " Not found !");
            return "";
        }
        start = code.inMethod(start);
        int end = code.outMethod(start);
        PogoString method = new PogoString(code.str.substring(start, end));
        pattern = "if (attr_name == \"" + this.name + "\")";
        start = method.str.indexOf(pattern);
        if (start < 0) {
            System.out.println(pattern + " Not found !");
            return "";
        }
        start = method.inMethod(start);
        end = method.outMethod(start);
        start = method.nextCr(start);
        end = method.previousCr(end - 2);
        PogoString block = new PogoString(method.str.substring(start, end));
        block.indent(-2);
        while (block.str.indexOf("att.") > 0) {
            block.replace("att.", "attr.");
        }
        return block.str;
    }

    String allowedCore() {
        return this.notAllowedFor.allowedCore();
    }

    public void setMemorized(boolean val) {
        this.memorized = val;
    }

    public boolean getMemorized() {
        return this.memorized;
    }

    public void setMemorizedInit(boolean val) {
        this.memorized_init = val;
    }

    public boolean getMemorizedInit() {
        return this.memorized_init;
    }

    public String getLowerName() {
        PogoString pgs = new PogoString(this.name);
        return pgs.toLowerString();
    }

    public String toString() {
        return this.name;
    }

    class FireEvent {
        boolean by_code = false;
        boolean whith_check = false;

        FireEvent() {
        }
    }
}

