/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import app_util.PopupError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pogo.appli.AttributeDialog;
import pogo.appli.ClassDialog;
import pogo.appli.CommandDialog;
import pogo.appli.CommentsDialog;
import pogo.appli.EditPogoCode;
import pogo.appli.PogoAppli;
import pogo.appli.PogoAppliDefs;
import pogo.appli.PropertyDialog;
import pogo.appli.StateDialog;
import pogo.appli.StateMachineDialog;
import pogo.appli.TreePopupMenu;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.DevState;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.Property;
import pogo.gene.ServerDefinitions;

public class PogoTree
extends JTree
implements PogoAppliDefs,
PogoDefs {
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode[] collection;
    private PogoAppli parent;
    private DefaultTreeModel treeModel;
    PogoClass server;
    private boolean modified;
    private TreePopupMenu pMenu;
    private static final String remove_message = "The ITEM NAME has been taken off the ITEM factory.\n\nBut, for safety reason, if code for this ITEM has been already generated,\nthe 'METHOD' method will not be automaticaly removed !!!\nPlease do it by yourself.";

    public PogoTree(PogoAppli parent) {
        this.parent = parent;
        Color background = new Color(255, 255, 204);
        this.setBackground(background);
        this.root = new DefaultMutableTreeNode("Tango Device Server");
        this.collection = new DefaultMutableTreeNode[PogoAppliDefs.collec_names.length];
        for (int i = 0; i < PogoAppliDefs.collec_names.length; ++i) {
            this.collection[i] = new DefaultMutableTreeNode(PogoAppliDefs.collec_names[i]);
            this.root.add(this.collection[i]);
        }
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new PogoRenderer(background));
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
                PogoTree.this.collapsedPerfomed(e);
            }

            public void treeExpanded(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PogoTree.this.treeMouseClicked(evt);
            }
        });
        this.pMenu = new TreePopupMenu(parent, this);
    }

    int getCollectionIdx(String name) {
        for (int i = 0; i < PogoAppliDefs.collec_names.length; ++i) {
            if (!PogoAppliDefs.collec_names[i].equals(name)) continue;
            return i;
        }
        return 0;
    }

    private void createLeaf(DefaultMutableTreeNode parent_node, Object obj) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(obj);
        this.treeModel.insertNodeInto(node, parent_node, parent_node.getChildCount());
    }

    void cloneLeaf(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
        DefaultMutableTreeNode new_node = null;
        if (parent_node == this.collection[0]) {
            new_node = new DefaultMutableTreeNode(node.getUserObject());
            parent_node = this.collection[1];
        } else if (parent_node == this.collection[1]) {
            new_node = new DefaultMutableTreeNode(node.getUserObject());
            parent_node = this.collection[0];
        } else {
            this.createItem(node);
        }
        if (new_node != null) {
            Property prop = (Property)node.getUserObject();
            for (int i = 0; i < parent_node.getChildCount(); ++i) {
                if (!parent_node.getChildAt(i).toString().equals(prop.name)) continue;
                PopupError.show((Component)this.parent, prop.name + " Already Exists !");
                return;
            }
            this.treeModel.insertNodeInto(new_node, parent_node, parent_node.getChildCount());
            Object[] path = new_node.getPath();
            this.setSelectionPath(new TreePath(path));
            this.modified = true;
        }
    }

    private void changeLeaf(DefaultMutableTreeNode node, Object obj) {
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
        int pos = 0;
        for (int i = 0; i < parent_node.getChildCount(); ++i) {
            if (!parent_node.getChildAt(i).equals(node)) continue;
            pos = i;
        }
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(obj);
        this.treeModel.insertNodeInto(new_node, parent_node, pos);
        this.treeModel.removeNodeFromParent(node);
        this.modified = true;
        this.setSelectionNode(new_node);
    }

    void setSelectionNode(DefaultMutableTreeNode node) {
        Object[] path = node.getPath();
        this.setSelectionPath(new TreePath(path));
    }

    DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    boolean isLeafSelected() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node != null) {
            TreeNode[] path = node.getPath();
            return path.length == 3;
        }
        return this.getSelectedNode() != null;
    }

    void moveSelection(String direction) {
        DefaultMutableTreeNode node = this.getSelectedNode();
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
        int pos = 0;
        for (int i = 0; i < parent_node.getChildCount(); ++i) {
            if (!parent_node.getChildAt(i).equals(node)) continue;
            pos = i;
        }
        int pos_min = 0;
        int pos_max = parent_node.getChildCount() - 1;
        if (parent_node.equals(this.collection[2])) {
            pos_min = 2;
        }
        if (direction.equals("Up")) {
            if (pos > pos_min) {
                this.treeModel.removeNodeFromParent(node);
                this.treeModel.insertNodeInto(node, parent_node, pos - 1);
            }
        } else if (pos < pos_max) {
            this.treeModel.removeNodeFromParent(node);
            this.treeModel.insertNodeInto(node, parent_node, pos + 1);
        }
        this.setSelectionNode(node);
        this.modified = true;
    }

    void removeLeaf(DefaultMutableTreeNode node) {
        this.treeModel.removeNodeFromParent(node);
        this.modified = true;
    }

    void removeSelectedLeaf() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object[] options = new Object[]{"OK", "CANCEL"};
        if (JOptionPane.showOptionDialog(this.parent, "Click OK to confirm delete " + node + " !", "Warning", -1, 2, null, options, options[0]) != 0) {
            return;
        }
        this.removeLeaf(node);
        PogoString pgs = null;
        switch (this.instanceOf(node.getUserObject())) {
            case 2: {
                Cmd cmd = (Cmd)node.getUserObject();
                pgs = new PogoString(remove_message);
                pgs.replace("ITEM", "command");
                pgs.replace("ITEM", "command");
                pgs.replace("ITEM", "command");
                pgs.replace("NAME", cmd.name);
                pgs.replace("METHOD", cmd.exec_method);
                break;
            }
            case 3: {
                Attrib attr = (Attrib)node.getUserObject();
                pgs = new PogoString(remove_message);
                pgs.replace("ITEM", "attribute");
                pgs.replace("ITEM", "attribute");
                pgs.replace("ITEM", "attribute");
                pgs.replace("NAME", attr.name);
                pgs.replace("METHOD", "read_" + attr.name);
            }
        }
        if (pgs != null) {
            JOptionPane.showMessageDialog(this, pgs.str, "Info Window", 1);
        }
    }

    public void clear() {
        for (int i = 0; i < this.collection.length; ++i) {
            int nb = this.collection[i].getChildCount();
            for (int j = 0; j < nb; ++j) {
                this.removeLeaf((DefaultMutableTreeNode)this.collection[i].getChildAt(0));
            }
            this.collection[i].removeAllChildren();
        }
        this.root.setUserObject("");
        this.modified = false;
    }

    public void setPogoTree(PogoClass server) {
        Property prop;
        int i;
        this.server = server;
        this.clear();
        this.root.setUserObject(new ServerDefinitions(server.class_name, server.inherited_from, server.class_desc, server.title));
        int nb_rows = PogoAppliDefs.collec_names.length;
        if (server.class_properties != null) {
            i = 0;
            while (i < server.class_properties.size()) {
                prop = server.class_properties.propertyAt(i);
                this.createLeaf(this.collection[0], prop);
                ++i;
                ++nb_rows;
            }
        }
        if (server.dev_properties != null) {
            i = 0;
            while (i < server.dev_properties.size()) {
                prop = server.dev_properties.propertyAt(i);
                this.createLeaf(this.collection[1], prop);
                ++i;
                ++nb_rows;
            }
        }
        if (server.commands != null) {
            i = 0;
            while (i < server.commands.size()) {
                Cmd cmd = server.commands.cmdAt(i);
                this.createLeaf(this.collection[2], cmd);
                ++i;
                ++nb_rows;
            }
        }
        if (server.attributes != null) {
            i = 0;
            while (i < server.attributes.size()) {
                Attrib attr = server.attributes.attributeAt(i);
                this.createLeaf(this.collection[3], attr);
                ++i;
                ++nb_rows;
            }
        }
        if (server.states != null) {
            i = 0;
            while (i < server.states.size()) {
                DevState state = server.states.stateAt(i);
                this.createLeaf(this.collection[4], state);
                ++i;
                ++nb_rows;
            }
        }
        for (i = 0; i < nb_rows; ++i) {
            this.expandRow(i);
        }
        this.modified = false;
    }

    public boolean hasBeenModified() {
        return this.modified;
    }

    public void setModified(boolean state) {
        this.modified = state;
    }

    public PogoClass getPogoClass() {
        PogoClass server = null;
        try {
            ServerDefinitions sd = (ServerDefinitions)this.root.getUserObject();
            server = new PogoClass(sd, this.parent.getLanguage(), this.server.projectFiles.getPath());
            server.commands.clear();
            for (int i = 0; i < this.collection.length; ++i) {
                int nb = this.collection[i].getChildCount();
                block9: for (int j = 0; j < nb; ++j) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.collection[i].getChildAt(j);
                    Object obj = node.getUserObject();
                    switch (this.instanceOf(obj)) {
                        case 2: {
                            server.addCommand((Cmd)obj);
                            continue block9;
                        }
                        case 3: {
                            server.addAttribute((Attrib)obj);
                            continue block9;
                        }
                        case 4: {
                            server.addState((DevState)obj);
                            continue block9;
                        }
                        case 0: {
                            if (i == 0) {
                                server.addClassProperty((Property)obj);
                                continue block9;
                            }
                            server.addDevProperty((Property)obj);
                            continue block9;
                        }
                        default: {
                            System.out.println(obj.toString() + "\n Object unknown !");
                            throw new PogoException(obj.toString() + "\n Object unknown !");
                        }
                    }
                }
            }
            server.is_abstractclass = this.server.is_abstractclass;
            server.revision = this.server.revision;
            server.author = this.server.author;
            server.cvs_repository = this.server.cvs_repository;
            server.projectFiles = this.server.projectFiles;
            this.server = server;
        }
        catch (PogoException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Error Window", 0);
        }
        return server;
    }

    int instanceOf(Object obj) {
        if (obj instanceof ServerDefinitions) {
            return -1;
        }
        if (obj instanceof Property) {
            return 0;
        }
        if (obj instanceof Cmd) {
            return 2;
        }
        if (obj instanceof Attrib) {
            return 3;
        }
        if (obj instanceof DevState) {
            return 4;
        }
        if (obj instanceof String) {
            return 5;
        }
        return -1;
    }

    private void treeMouseClicked(MouseEvent evt) {
        int mask = evt.getModifiers();
        if ((mask & 8) != 0) {
            System.out.println(" BTN 2");
            return;
        }
        int selRow = this.getRowForLocation(evt.getX(), evt.getY());
        TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
        if (path == null) {
            return;
        }
        this.setSelectionPath(path);
        if (evt.getClickCount() != 2) {
            if ((mask & 4) != 0) {
                switch (path.getPathCount() - 1) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.pMenu.showMenu(evt);
                    }
                }
            }
            return;
        }
        if (selRow == -1) {
            return;
        }
        if ((mask & 4) != 0) {
            switch (path.getPathCount() - 1) {
                case 0: {
                    this.editClassObject();
                    break;
                }
                case 1: {
                    this.createItem();
                    break;
                }
            }
        } else {
            evt.consume();
            switch (path.getPathCount()) {
                case 1: {
                    this.editClassObject();
                    break;
                }
                case 2: {
                    this.createItem();
                    break;
                }
                case 3: {
                    this.editItem();
                }
            }
        }
    }

    public void collapsedPerfomed(TreeExpansionEvent e) {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        TreePath path = e.getPath();
        DefaultMutableTreeNode c = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
        if (!c.equals(node)) {
            return;
        }
        if (node.getChildCount() > 0) {
            DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)node.getChildAt(0);
            Object[] leaf_path = leaf.getPath();
            this.setExpandedState(new TreePath(leaf_path), true);
        }
    }

    void editStateMachine(DefaultMutableTreeNode node) {
        if (this.server.states.size() < 2) {
            JOptionPane.showMessageDialog(this, "Create more than one states before !", "Error Window", 0);
            return;
        }
        if (this.server.commands.size() == 0 && this.server.attributes.size() == 0) {
            JOptionPane.showMessageDialog(this, "Create commands or attributes before !", "Error Window", 0);
            return;
        }
        new StateMachineDialog(this.parent, this.server).showDialog();
    }

    void editDescriptions(DefaultMutableTreeNode node) {
        CommentsDialog dlg = null;
        if (node.equals(this.collection[0])) {
            dlg = new CommentsDialog(this.parent, this.server.class_properties, 0);
        } else if (node.equals(this.collection[1])) {
            dlg = new CommentsDialog(this.parent, this.server.dev_properties, 1);
        } else if (node.equals(this.collection[2])) {
            dlg = new CommentsDialog((JFrame)this.parent, this.server.commands);
        } else if (node.equals(this.collection[3])) {
            dlg = new CommentsDialog((JFrame)this.parent, this.server.attributes);
        } else if (node.equals(this.collection[4])) {
            dlg = new CommentsDialog((JFrame)this.parent, this.server.states);
        }
        if (dlg != null) {
            dlg.setVisible(true);
            this.modified = dlg.getModified();
        }
    }

    void sortItems(DefaultMutableTreeNode node) {
        this.server = this.getPogoClass();
        int start_idx = 0;
        if (node.equals(this.collection[2])) {
            start_idx = 2;
        }
        Vector<TreeNode> vector = new Vector<TreeNode>();
        for (int i = start_idx; i < node.getChildCount(); ++i) {
            vector.add(node.getChildAt(i));
        }
        while (node.getChildCount() > start_idx) {
            this.removeLeaf((DefaultMutableTreeNode)node.getChildAt(start_idx));
        }
        MyCompare comp = new MyCompare();
        Collections.sort(vector, comp);
        DefaultMutableTreeNode leaf = null;
        for (int i = 0; i < vector.size(); ++i) {
            leaf = (DefaultMutableTreeNode)vector.elementAt(i);
            this.treeModel.insertNodeInto(leaf, node, node.getChildCount());
        }
        Object[] path = leaf.getPath();
        this.setExpandedState(new TreePath(path), true);
        this.modified = true;
    }

    private void editCommand(DefaultMutableTreeNode node) {
        Cmd cmd = (Cmd)node.getUserObject();
        if (cmd.virtual_method) {
            if (cmd.override_method == 2 || cmd.override_method == 1) {
                JOptionPane.showMessageDialog(this, "This command's method override a method from DeviceImpl class !\nYou cannot change it's signature !", "Info Window", 1);
            } else {
                cmd.override_method = JOptionPane.showConfirmDialog(this, "This command's method is already defined in the DeviceImpl class !\n\nAre you sure to want to override it ?", "Info Window", 0) == 0 ? 1 : 0;
            }
        } else {
            CommandDialog dialog = new CommandDialog(this.parent, this.server, cmd, 1);
            if (dialog.showDialog() == 1) {
                System.out.println(dialog.getInput());
                Cmd newCmd = dialog.getInput();
                if (!cmd.equals(newCmd)) {
                    this.changeLeaf(node, newCmd);
                    this.modified = true;
                }
            }
        }
    }

    void editItem() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object obj = node.getUserObject();
        this.server = this.getPogoClass();
        switch (this.instanceOf(obj)) {
            case 2: {
                this.editCommand(node);
                break;
            }
            case 3: {
                Attrib newAttr;
                Attrib attr = (Attrib)obj;
                AttributeDialog att_dialog = new AttributeDialog(this.parent, this.server, attr, 1);
                if (att_dialog.showDialog() != 1 || attr.equals(newAttr = att_dialog.getInput())) break;
                this.changeLeaf(node, newAttr);
                this.modified = true;
                break;
            }
            case 4: {
                DevState newState;
                DevState state = (DevState)obj;
                StateDialog st_dialog = new StateDialog(this.parent, this.server, state, 1);
                if (st_dialog.showDialog() != 1 || state.equals(newState = st_dialog.getInput())) break;
                this.changeLeaf(node, newState);
                this.modified = true;
                break;
            }
            case 0: {
                Property newProp;
                Property property = (Property)obj;
                PropertyDialog prop_dialog = new PropertyDialog(this.parent, property, node.getParent().toString());
                if (prop_dialog.showDialog() != 1 || property.equals(newProp = prop_dialog.getInput())) break;
                this.changeLeaf(node, newProp);
                this.modified = true;
            }
        }
    }

    void createItem(DefaultMutableTreeNode node) {
        Object obj = node.getUserObject();
        if (obj instanceof Cmd) {
            CommandDialog dialog = new CommandDialog(this.parent, this.server, (Cmd)obj, 0);
            if (dialog.showDialog() == 1) {
                Cmd newCmd = dialog.getInput();
                this.server.commands.add(newCmd);
                newCmd.cmd_class = newCmd.name + "Class";
                this.createLeaf((DefaultMutableTreeNode)node.getParent(), newCmd);
                this.modified = true;
            }
        } else if (obj instanceof Attrib) {
            AttributeDialog att_dialog = new AttributeDialog(this.parent, this.server, (Attrib)obj, 0);
            if (att_dialog.showDialog() == 1) {
                Attrib new_attr = att_dialog.getInput();
                this.server.attributes.add(new_attr);
                this.createLeaf((DefaultMutableTreeNode)node.getParent(), new_attr);
                this.modified = true;
            }
        } else if (obj instanceof DevState) {
            StateDialog dialog = new StateDialog(this.parent, this.server, (DevState)obj, 0);
            if (dialog.showDialog() == 1) {
                DevState state = dialog.getInput();
                this.server.states.add(state);
                this.createLeaf((DefaultMutableTreeNode)node.getParent(), state);
                this.modified = true;
            }
        } else {
            System.out.println("Unknown: " + obj);
        }
    }

    void createItem() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        int item = 0;
        for (int i = 0; i < this.collection.length; ++i) {
            if (!this.collection[i].equals(node)) continue;
            item = i;
        }
        this.server = this.getPogoClass();
        switch (item) {
            case 2: {
                CommandDialog dialog = new CommandDialog(this.parent, this.server, null, 0);
                if (dialog.showDialog() != 1) break;
                Cmd newCmd = dialog.getInput();
                newCmd.cmd_class = newCmd.name + "Class";
                this.server.commands.add(newCmd);
                this.createLeaf(node, newCmd);
                this.modified = true;
                break;
            }
            case 3: {
                AttributeDialog att_dialog = new AttributeDialog(this.parent, this.server, null, 0);
                if (att_dialog.showDialog() != 1) break;
                Attrib newAtt = att_dialog.getInput();
                this.server.attributes.add(newAtt);
                this.createLeaf(node, newAtt);
                this.modified = true;
                break;
            }
            case 4: {
                StateDialog st_dialog = new StateDialog(this.parent, this.server, null, 0);
                if (st_dialog.showDialog() != 1) break;
                DevState state = st_dialog.getInput();
                this.server.states.add(state);
                this.createLeaf(node, state);
                this.modified = true;
                break;
            }
            case 0: 
            case 1: {
                PropertyDialog prop_dialog = new PropertyDialog(this.parent, null, this.collection[item].toString());
                if (prop_dialog.showDialog() != 1) break;
                this.createLeaf(node, prop_dialog.getInput());
                this.modified = true;
            }
        }
    }

    void editCode() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object obj = node.getUserObject();
        String mess = null;
        EditPogoCode ed = new EditPogoCode(this.getPogoClass());
        try {
            switch (this.instanceOf(obj)) {
                case 2: {
                    Cmd cmd = (Cmd)obj;
                    ed.setCommandTarget(cmd.name);
                    break;
                }
                case 3: {
                    Attrib attr = (Attrib)obj;
                    ed.setAttributeTarget(attr.name);
                    break;
                }
                case 0: {
                    TreeNode[] path = node.getPath();
                    if (path[1].toString().equals(PogoAppliDefs.collec_names[0])) {
                        ed.setPropertiesTarget(0);
                        break;
                    }
                    ed.setPropertiesTarget(1);
                    break;
                }
                case 4: {
                    ed.setStateTarget();
                }
            }
            ed.start();
        }
        catch (FileNotFoundException e) {
            mess = ed.getSrcFilename() + "\nSource File Not Found !";
        }
        catch (IOException e) {
            mess = e.toString();
        }
        catch (PogoException e) {
            mess = e.toString();
        }
        if (mess != null) {
            JOptionPane.showMessageDialog(this, mess, "Error Window", 0);
        }
    }

    void editAbstractClass() {
        new PogoAppli(this.server.inherited_from + ".h").setVisible(true);
    }

    public void editClassObject() {
        ServerDefinitions sd = (ServerDefinitions)this.root.getUserObject();
        ClassDialog dialog = new ClassDialog(this.parent, sd);
        if (dialog.showDialog() == 1) {
            sd = dialog.getInput();
            this.root.setUserObject(sd);
            this.modified = true;
        }
    }

    void setLanguage(int language) {
        this.server.language = language;
    }

    void setHomeDir(String path) {
        this.server.setProjectPath(path);
    }

    void setOutputModel(boolean is_abstractclass) {
        this.server.is_abstractclass = is_abstractclass;
    }

    class MyCompare
    implements Comparator {
        MyCompare() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1.toString().toLowerCase();
            String s2 = o2.toString().toLowerCase();
            return s1.compareTo(s2);
        }
    }

    class PogoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private ImageIcon[] icons;

        public PogoRenderer(Color background) {
            this.setTextSelectionColor(Color.black);
            this.setBorderSelectionColor(Color.red);
            this.setBackgroundSelectionColor(Color.lightGray);
            this.setTextNonSelectionColor(Color.blue);
            this.setBackgroundNonSelectionColor(background);
            this.icons = new ImageIcon[3];
            this.icons[0] = new ImageIcon(this.getClass().getResource("/pogo/img/tg_class.jpg"));
            this.icons[1] = new ImageIcon(this.getClass().getResource("/pogo/img/arrow.gif"));
            this.icons[2] = new ImageIcon(this.getClass().getResource("/pogo/img/or_diam.gif"));
            this.fonts = new Font[3];
            this.fonts[0] = new Font("helvetica", 1, 22);
            this.fonts[1] = new Font("helvetica", 1, 18);
            this.fonts[2] = new Font("helvetica", 1, 12);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color color;
            Font font;
            ImageIcon icon;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            TreePath tp = tree.getPathForRow(row);
            if (tp == null) {
                return this;
            }
            String tip = "";
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (row == 0) {
                if (PogoTree.this.server == null) {
                    tip = "double double click to edit class (name, description...)";
                } else {
                    tip = "Inherited from :  " + PogoTree.this.server.inheritedClassName() + "\n" + "Revision       :  " + PogoTree.this.server.revision + "\n" + "Author         :  " + PogoTree.this.server.author;
                    if (PogoTree.this.server.cvs_repository != null) {
                        tip = tip + "\nCvs Repository :  " + PogoTree.this.server.cvs_repository;
                    }
                }
                icon = this.icons[0];
                font = this.fonts[0];
                color = Color.blue;
            } else if (obj instanceof String) {
                tip = "double click to create a new item";
                icon = this.icons[1];
                font = this.fonts[1];
                color = Color.blue;
            } else {
                Object o = node.getUserObject();
                String collectionName = o.toString();
                tip = this.buildToolTipText(collectionName, value);
                icon = this.icons[2];
                font = this.fonts[2];
                color = Color.black;
            }
            this.setIcon(icon);
            this.setFont(font);
            this.setForeground(color);
            this.setToolTipText(tip);
            return this;
        }

        private String buildToolTipText(String collname, Object item) {
            String tooltip;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)item;
            Object obj = node.getUserObject();
            if (obj instanceof Cmd) {
                Cmd cmd = (Cmd)obj;
                tooltip = cmd.buildCppExecCmdMethodSignature(PogoTree.this.server.class_name);
            } else if (obj instanceof Attrib) {
                String[] att_type = new String[]{"Scalar", "Spectrum", "Image"};
                Attrib attr = (Attrib)obj;
                tooltip = attr.dataType.cpp + "  " + attr.toString() + "  (" + att_type[attr.attrType] + ")";
            } else {
                tooltip = "Edit the " + item.toString() + " " + collname;
            }
            return tooltip;
        }
    }
}

