/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import fr.esrf.Tango.DispLevel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import pogo.appli.NotAllowedDialog;
import pogo.appli.PogoAppli;
import pogo.appli.PogoAppliDefs;
import pogo.gene.Attrib;
import pogo.gene.DevStateTable;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoUtil;

public class AttributeDialog
extends JDialog
implements PogoAppliDefs,
PogoDefs {
    private static int returnStatus = 0;
    private int attr_idx = -1;
    private JFrame parent;
    private PogoClass server;
    private int poll_period = 0;
    private String name;
    private String assAttr;
    private int xSize;
    private int ySize;
    private Vector prop_txt;
    private DevStateTable notAllowedFor;
    private JRadioButton changeEvtCode;
    private JRadioButton changeEvtChecked;
    private JRadioButton archiveEvtCode;
    private JRadioButton archiveEvtChecked;
    private final int EMPTY_FIELD = -1;
    private final int NEGATIVE_FIELD = -2;
    private final int INVALID_FIELD = -3;
    private JButton allowedBtn;
    private JLabel assAttrLBL;
    private JTextField assAttrTF;
    private JTextArea attrPropDescription;
    private JTextField attrPropDispUnit;
    private JTextField attrPropFormat;
    private JTextField attrPropLabel;
    private JTextField attrPropMaxAlarm;
    private JTextField attrPropMaxValue;
    private JTextField attrPropMinAlarm;
    private JTextField attrPropMinValue;
    private JTextField attrPropStdUnit;
    private JTextField attrPropUnit;
    private JComboBox attrTypeCB;
    private JButton cancelBtn;
    private JComboBox dataTypeCB;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane;
    private JLabel nameLbl;
    private JTextField nameText;
    private JButton okBtn;
    private JButton propertyBtn;
    private JPanel propertyPanel;
    private JComboBox rwTypeCB;
    private JLabel rwTypeLBL;
    private JLabel xDataLBL;
    private JTextField xDataTF;
    private JLabel yDataLBL;
    private JTextField yDataTF;
    private JRadioButton levelBtn;
    private JRadioButton polledBtn;
    private JRadioButton memorizedBtn;
    private JRadioButton memorizedInitBtn;
    private JLabel periodLabel;
    private JLabel periodUnitLabel;
    private JTextField periodText;

    public AttributeDialog(JFrame parent, PogoClass server, Attrib attr, int action) {
        super((Frame)parent, true);
        this.parent = parent;
        this.server = server;
        this.initComponents();
        this.addElements();
        this.initializeWindow(attr);
        if (action == 0) {
            this.attr_idx = -1;
        } else {
            for (int i = 0; i < server.attributes.size(); ++i) {
                if (server.attributes.attributeAt(i) != attr) continue;
                this.attr_idx = i;
            }
        }
        this.pack();
    }

    private void addElements() {
        int i;
        for (i = 0; i < PogoDefs.AttrTypeArray.length; ++i) {
            this.attrTypeCB.addItem(PogoDefs.AttrTypeArray[i]);
        }
        for (i = 0; i < PogoDefs.AttrDataArray.length; ++i) {
            this.dataTypeCB.addItem(PogoDefs.AttrDataArray[i]);
        }
        for (i = 0; i < PogoDefs.AttrRWtypeArray.length; ++i) {
            this.rwTypeCB.addItem("Tango::" + PogoDefs.AttrRWtypeArray[i]);
        }
        this.propertyPanel.setVisible(false);
        this.prop_txt = new Vector();
        this.prop_txt.addElement(this.attrPropLabel);
        this.prop_txt.addElement(this.attrPropUnit);
        this.prop_txt.addElement(this.attrPropStdUnit);
        this.prop_txt.addElement(this.attrPropDispUnit);
        this.prop_txt.addElement(this.attrPropFormat);
        this.prop_txt.addElement(this.attrPropMaxValue);
        this.prop_txt.addElement(this.attrPropMinValue);
        this.prop_txt.addElement(this.attrPropMaxAlarm);
        this.prop_txt.addElement(this.attrPropMinAlarm);
        this.prop_txt.addElement(this.attrPropDescription);
        int y = 14;
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel lbl = new JLabel("Controled by : ");
        gbc.gridx = 0;
        gbc.gridy = ++y;
        gbc.fill = 2;
        this.jPanel2.add((Component)lbl, gbc);
        this.levelBtn = new JRadioButton();
        this.levelBtn.setToolTipText("Display Level (expert or operator)");
        this.levelBtn.setText(" Expert Only  ");
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.levelBtn, gbc);
        lbl = new JLabel("Change Event : ");
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.fill = 2;
        this.jPanel2.add((Component)lbl, gbc);
        this.changeEvtCode = new JRadioButton("Pushed by code");
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.changeEvtCode, gbc);
        this.changeEvtChecked = new JRadioButton("Event criteria checked by library");
        this.changeEvtChecked.setSelected(true);
        this.changeEvtChecked.setVisible(false);
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.changeEvtChecked, gbc);
        this.changeEvtCode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.evtByCodeBtnActionPerformed(evt);
            }
        });
        lbl = new JLabel("Archive Event : ");
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.fill = 2;
        this.jPanel2.add((Component)lbl, gbc);
        this.archiveEvtCode = new JRadioButton("Pushed by code");
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.archiveEvtCode, gbc);
        this.archiveEvtChecked = new JRadioButton("Event criteria checked by library");
        this.archiveEvtChecked.setSelected(true);
        this.archiveEvtChecked.setVisible(false);
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.archiveEvtChecked, gbc);
        this.archiveEvtCode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.evtByCodeBtnActionPerformed(evt);
            }
        });
        this.polledBtn = new JRadioButton();
        this.polledBtn.setToolTipText("Attribute polled");
        this.polledBtn.setText("Polled");
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.polledBtn, gbc);
        this.polledBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.polledBtnActionPerformed(evt);
            }
        });
        this.periodLabel = new JLabel("  Polling Period :");
        this.periodLabel.setHorizontalAlignment(4);
        gbc.gridx = 0;
        gbc.gridy = y;
        this.jPanel2.add((Component)this.periodLabel, gbc);
        this.periodText = new JTextField();
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.periodText, gbc);
        this.periodText.setRequestFocusEnabled(true);
        this.periodUnitLabel = new JLabel(" ms  ");
        gbc.gridx = 2;
        gbc.gridy = y++;
        this.jPanel2.add((Component)this.periodUnitLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = y++;
        this.jPanel2.add((Component)new JLabel(" "), gbc);
        this.setPeriodEnabled(false);
        this.memorizedBtn = new JRadioButton();
        this.memorizedBtn.setToolTipText("Attribute setpoint memorized .");
        this.memorizedBtn.setText(" Memorized  ");
        this.memorizedBtn.setVisible(false);
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.memorizedBtn, gbc);
        this.memorizedBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.memorizedBtnActionPerformed(evt);
            }
        });
        this.memorizedInitBtn = new JRadioButton();
        this.memorizedInitBtn.setToolTipText("Attribute setpoint memorized witten on hardware at startup");
        this.memorizedInitBtn.setText(" Write hardware at init ");
        this.memorizedInitBtn.setVisible(false);
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.memorizedInitBtn, gbc);
        gbc.gridx = 1;
        gbc.gridy = y;
        this.jPanel2.add((Component)new JLabel(" "), gbc);
    }

    private void evtByCodeBtnActionPerformed(ActionEvent evt) {
        Object o = evt.getSource();
        if (o == this.changeEvtCode) {
            this.changeEvtChecked.setVisible(this.changeEvtCode.getSelectedObjects() != null);
        } else if (o == this.archiveEvtCode) {
            this.archiveEvtChecked.setVisible(this.archiveEvtCode.getSelectedObjects() != null);
        }
        this.pack();
    }

    private void setPeriodEnabled(boolean state) {
        this.periodLabel.setVisible(state);
        this.periodText.setVisible(state);
        this.periodUnitLabel.setVisible(state);
        if (state) {
            String txt = this.poll_period == 0 ? "2000" : "" + this.poll_period;
            this.periodText.setText(txt);
            this.pack();
        }
    }

    private void memorizedBtnActionPerformed(ActionEvent evt) {
        this.memorizedInitBtn.setVisible(this.memorizedBtn.getSelectedObjects() != null);
    }

    private void polledBtnActionPerformed(ActionEvent evt) {
        boolean state = this.polledBtn.getSelectedObjects() != null;
        this.setPeriodEnabled(state);
        if (state) {
            this.periodText.selectAll();
            this.periodText.requestFocus();
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.nameLbl = new JLabel();
        this.attrTypeCB = new JComboBox();
        this.jLabel1 = new JLabel();
        this.nameText = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.dataTypeCB = new JComboBox();
        this.xDataLBL = new JLabel();
        this.yDataLBL = new JLabel();
        this.xDataTF = new JTextField();
        this.yDataTF = new JTextField();
        this.rwTypeCB = new JComboBox();
        this.jLabel5 = new JLabel();
        this.assAttrLBL = new JLabel();
        this.assAttrTF = new JTextField();
        this.rwTypeLBL = new JLabel();
        this.propertyPanel = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.attrPropLabel = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.attrPropUnit = new JTextField();
        this.attrPropStdUnit = new JTextField();
        this.attrPropDispUnit = new JTextField();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.attrPropFormat = new JTextField();
        this.attrPropMaxValue = new JTextField();
        this.attrPropMinValue = new JTextField();
        this.attrPropMaxAlarm = new JTextField();
        this.attrPropMinAlarm = new JTextField();
        this.jLabel16 = new JLabel();
        this.jScrollPane = new JScrollPane();
        this.attrPropDescription = new JTextArea();
        this.jPanel1 = new JPanel();
        this.allowedBtn = new JButton();
        this.propertyBtn = new JButton();
        this.jLabel17 = new JLabel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.setTitle("Edit Attribute Window");
        this.setBackground(new Color(198, 178, 168));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AttributeDialog.this.closeDialog(evt);
            }
        });
        this.jPanel2.setLayout(new GridBagLayout());
        this.nameLbl.setFont(new Font("Arial", 1, 12));
        this.nameLbl.setText("Attribute name ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.nameLbl, gridBagConstraints);
        this.attrTypeCB.setFont(new Font("Arial", 1, 12));
        this.attrTypeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.attrTypeCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel2.add((Component)this.attrTypeCB, gridBagConstraints);
        this.jLabel1.setFont(new Font("Arial", 1, 12));
        this.jLabel1.setText("Attribute Type: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.nameText.setFont(new Font("Arial", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel2.add((Component)this.nameText, gridBagConstraints);
        this.jLabel2.setText(" ");
        this.jLabel2.setMinimumSize(new Dimension(50, 50));
        this.jLabel2.setPreferredSize(new Dimension(50, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(" ");
        this.jLabel3.setMinimumSize(new Dimension(20, 15));
        this.jLabel3.setPreferredSize(new Dimension(20, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setFont(new Font("Arial", 1, 12));
        this.jLabel4.setText("Data Type: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.dataTypeCB.setFont(new Font("Arial", 1, 12));
        this.dataTypeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.dataTypeCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel2.add((Component)this.dataTypeCB, gridBagConstraints);
        this.xDataLBL.setFont(new Font("Arial", 1, 12));
        this.xDataLBL.setText("Maximum X data size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.xDataLBL, gridBagConstraints);
        this.yDataLBL.setFont(new Font("Arial", 1, 12));
        this.yDataLBL.setText("Maximum Y data size: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.yDataLBL, gridBagConstraints);
        this.xDataTF.setFont(new Font("Arial", 1, 12));
        this.xDataTF.setMinimumSize(new Dimension(100, 20));
        this.xDataTF.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel2.add((Component)this.xDataTF, gridBagConstraints);
        this.yDataTF.setFont(new Font("Arial", 1, 12));
        this.yDataTF.setMinimumSize(new Dimension(100, 20));
        this.yDataTF.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel2.add((Component)this.yDataTF, gridBagConstraints);
        this.rwTypeCB.setFont(new Font("Arial", 1, 12));
        this.rwTypeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.rwTypeCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel2.add((Component)this.rwTypeCB, gridBagConstraints);
        this.jLabel5.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.assAttrLBL.setFont(new Font("Arial", 1, 12));
        this.assAttrLBL.setText("Associated Attribute:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.assAttrLBL, gridBagConstraints);
        this.assAttrTF.setFont(new Font("Arial", 1, 12));
        this.assAttrTF.setMinimumSize(new Dimension(100, 20));
        this.assAttrTF.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel2.add((Component)this.assAttrTF, gridBagConstraints);
        this.rwTypeLBL.setFont(new Font("Arial", 1, 12));
        this.rwTypeLBL.setText("Read/Write Type: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.rwTypeLBL, gridBagConstraints);
        this.propertyPanel.setLayout(new GridBagLayout());
        this.jLabel6.setFont(new Font("Dialog", 0, 12));
        this.jLabel6.setText("Default Attribute Properties");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.propertyPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setFont(new Font("Dialog", 0, 12));
        this.jLabel7.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.propertyPanel.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.propertyPanel.add((Component)this.attrPropLabel, gridBagConstraints);
        this.jLabel8.setFont(new Font("Dialog", 0, 12));
        this.jLabel8.setText("Unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.propertyPanel.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setFont(new Font("Dialog", 0, 12));
        this.jLabel9.setText("Standard Unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.propertyPanel.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setFont(new Font("Dialog", 0, 12));
        this.jLabel10.setText("Display Unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.propertyPanel.add((Component)this.jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.propertyPanel.add((Component)this.attrPropUnit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.propertyPanel.add((Component)this.attrPropStdUnit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.propertyPanel.add((Component)this.attrPropDispUnit, gridBagConstraints);
        this.jLabel11.setFont(new Font("Dialog", 0, 12));
        this.jLabel11.setText("Display Format       ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.propertyPanel.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel12.setFont(new Font("Dialog", 0, 12));
        this.jLabel12.setText("Max. Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.propertyPanel.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel13.setFont(new Font("Dialog", 0, 12));
        this.jLabel13.setText("Min. Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.propertyPanel.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel14.setFont(new Font("Dialog", 0, 12));
        this.jLabel14.setText("Max. Alarm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        this.propertyPanel.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel15.setFont(new Font("Dialog", 0, 12));
        this.jLabel15.setText("Min. Alarm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.propertyPanel.add((Component)this.jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.propertyPanel.add((Component)this.attrPropFormat, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.propertyPanel.add((Component)this.attrPropMaxValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.propertyPanel.add((Component)this.attrPropMinValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.propertyPanel.add((Component)this.attrPropMaxAlarm, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.propertyPanel.add((Component)this.attrPropMinAlarm, gridBagConstraints);
        this.jLabel16.setFont(new Font("Dialog", 0, 12));
        this.jLabel16.setText("Description :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        this.propertyPanel.add((Component)this.jLabel16, gridBagConstraints);
        this.jScrollPane.setPreferredSize(new Dimension(350, 100));
        this.attrPropDescription.setColumns(80);
        this.attrPropDescription.setRows(20);
        this.jScrollPane.setViewportView(this.attrPropDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.propertyPanel.add((Component)this.jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel2.add((Component)this.propertyPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel1.setLayout(new FlowLayout(2));
        this.allowedBtn.setText("Allowed for State,,,");
        this.allowedBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.allowedBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.allowedBtn);
        this.propertyBtn.setText("Default Properties");
        this.propertyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.propertyBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.propertyBtn);
        this.jLabel17.setText("        ");
        this.jPanel1.add(this.jLabel17);
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
    }

    private void allowedBtnActionPerformed(ActionEvent evt) {
        if (this.server.states.size() == 0) {
            JOptionPane.showMessageDialog(this, "There is no state defined !", "Error Window", 0);
            return;
        }
        NotAllowedDialog dialog = new NotAllowedDialog(this.parent, "Attribute " + this.nameText.getText(), this.server.states);
        int ret = dialog.showDialog(this.notAllowedFor);
        if (ret == 1) {
            this.notAllowedFor = dialog.getInput();
        }
    }

    private void propertyBtnActionPerformed(ActionEvent evt) {
        this.propertyPanel.setVisible(!this.propertyPanel.isVisible());
        this.propertyBtn.setVisible(false);
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        String message = null;
        this.name = this.nameText.getText();
        try {
            this.name = PogoUtil.checkCmdAttrName(this.name, this.server.commands, this.server.attributes, this.attr_idx, 3);
        }
        catch (PogoException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Error Window", 1);
            return;
        }
        this.nameText.setText(this.name);
        int attrType = this.attrTypeCB.getSelectedIndex();
        block2 : switch (attrType) {
            case 0: {
                if (this.rwTypeCB.getSelectedIndex() == 3) {
                    this.assAttr = this.assAttrTF.getText();
                    break;
                }
                this.assAttr = "";
                break;
            }
            case 1: {
                this.xSize = this.checkIntField(this.xDataTF.getText());
                switch (this.xSize) {
                    case -1: {
                        message = "Spectrum Attribute needs an X length of data";
                        break;
                    }
                    case -2: {
                        message = "Spectrum Attribute needs a POSITIVE X length of data";
                        break;
                    }
                    case -3: {
                        message = "Cannot parse an integer value for X length !";
                    }
                }
                break;
            }
            case 2: {
                this.xSize = this.checkIntField(this.xDataTF.getText());
                switch (this.xSize) {
                    case -1: {
                        message = "Image Attribute needs an X length of data";
                        break;
                    }
                    case -2: {
                        message = "Image Attribute needs a POSITIVE X length of data";
                        break;
                    }
                    case -3: {
                        message = "Cannot parse an integer value for X length !";
                    }
                }
                this.ySize = this.checkIntField(this.yDataTF.getText());
                switch (this.ySize) {
                    case -1: {
                        message = "Image Attribute needs an Y length of data";
                        break block2;
                    }
                    case -2: {
                        message = "Image Attribute needs a POSITIVE Y length of data";
                        break block2;
                    }
                    case -3: {
                        message = "Cannot parse an integer value for Y length !";
                    }
                }
            }
        }
        if (this.polledBtn.getSelectedObjects() != null) {
            String strval = this.periodText.getText();
            try {
                this.poll_period = Integer.parseInt(strval);
                if (this.poll_period < 20 && this.poll_period != 0) {
                    message = "The polling period minimum value is  20 ms";
                }
            }
            catch (NumberFormatException e) {
                message = e.toString() + "\n\nBad Value in Polling period field !";
            }
        }
        if (message != null) {
            JOptionPane.showMessageDialog(this, message, "Error Window", 0);
        } else {
            this.doClose(1);
        }
    }

    private void rwTypeCBActionPerformed(ActionEvent evt) {
        this.updateWindow();
    }

    private void dataTypeCBActionPerformed(ActionEvent evt) {
        this.updateWindow();
    }

    private void attrTypeCBActionPerformed(ActionEvent evt) {
        this.updateWindow();
        if (this.rwTypeCB.getItemCount() == 0) {
            return;
        }
        String item = "Tango::" + PogoDefs.AttrRWtypeArray[PogoDefs.AttrRWtypeArray.length - 1];
        switch (this.attrTypeCB.getSelectedIndex()) {
            case 0: {
                if (this.rwTypeCB.getItemCount() >= PogoDefs.AttrRWtypeArray.length) break;
                this.rwTypeCB.addItem(item);
                break;
            }
            default: {
                if (this.rwTypeCB.getItemCount() < PogoDefs.AttrRWtypeArray.length) break;
                this.rwTypeCB.removeItem(item);
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private int checkIntField(String s) {
        int end = s.indexOf(46);
        if (end >= 0) {
            s = s.substring(0, end);
        }
        try {
            if (s.length() == 0) {
                return -1;
            }
            int value = new Integer(s);
            if (value < 0) {
                return -2;
            }
            return value;
        }
        catch (NumberFormatException e) {
            return -3;
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    public int showDialog() {
        PogoAppli.centerDialog(this, this.parent);
        this.setVisible(true);
        return returnStatus;
    }

    private void initializeWindow(Attrib attr) {
        if (attr != null) {
            int i;
            this.nameText.setText(attr.name);
            this.xDataTF.setText(new Integer(attr.xSize).toString());
            this.yDataTF.setText(new Integer(attr.ySize).toString());
            this.assAttrTF.setText(attr.assAttr);
            this.attrTypeCB.setSelectedIndex(attr.attrType);
            this.rwTypeCB.setSelectedIndex(attr.rwType);
            this.notAllowedFor = new DevStateTable(attr.notAllowedFor);
            for (i = 0; i < this.dataTypeCB.getItemCount(); ++i) {
                String item = (String)this.dataTypeCB.getItemAt(i);
                if (!item.equals(attr.dataType.cpp_code_str)) continue;
                this.dataTypeCB.setSelectedIndex(i);
            }
            if (attr.properties != null) {
                for (i = 0; i <= 9; ++i) {
                    JTextComponent txt = (JTextComponent)this.prop_txt.elementAt(i);
                    String value = attr.properties[i];
                    if (value == null) continue;
                    if (i == 9) {
                        StringBuffer sb = new StringBuffer();
                        for (int j = 0; j < value.length(); ++j) {
                            if (value.charAt(j) == '\\' && value.charAt(j + 1) == 'n') {
                                sb.append("\n");
                                ++j;
                                continue;
                            }
                            sb.append(value.charAt(j));
                        }
                        txt.setText(sb.toString());
                        continue;
                    }
                    txt.setText(value);
                }
            }
            this.updateWindow();
            if (attr.disp_level == DispLevel.EXPERT) {
                this.levelBtn.setSelected(true);
            }
            if ((this.poll_period = attr.polled_period) > 0) {
                this.polledBtn.setSelected(true);
                this.setPeriodEnabled(true);
            } else {
                this.setPeriodEnabled(false);
            }
            this.memorizedBtn.setSelected(attr.memorized);
            this.memorizedInitBtn.setVisible(attr.memorized);
            if (attr.memorized) {
                this.memorizedInitBtn.setSelected(attr.memorized_init);
            }
            boolean[] ch = attr.getFireEvent(0);
            this.changeEvtCode.setSelected(ch[0]);
            this.changeEvtChecked.setSelected(ch[1]);
            this.changeEvtChecked.setVisible(ch[0]);
            boolean[] ar = attr.getFireEvent(1);
            this.archiveEvtCode.setSelected(ar[0]);
            this.archiveEvtChecked.setSelected(ar[1]);
            this.archiveEvtChecked.setVisible(ar[0]);
        }
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public Attrib getInput() {
        Attrib attr;
        switch (this.attrTypeCB.getSelectedIndex()) {
            case 1: {
                attr = new Attrib(this.name, 1, this.dataTypeCB.getSelectedItem().toString(), this.rwTypeCB.getSelectedIndex(), this.xSize);
                break;
            }
            case 2: {
                attr = new Attrib(this.name, 2, this.dataTypeCB.getSelectedItem().toString(), this.rwTypeCB.getSelectedIndex(), this.xSize, this.ySize);
                break;
            }
            default: {
                attr = new Attrib(this.name, 0, this.dataTypeCB.getSelectedItem().toString(), this.rwTypeCB.getSelectedIndex(), this.assAttr);
            }
        }
        if (this.notAllowedFor == null) {
            this.notAllowedFor = new DevStateTable();
        }
        attr.notAllowedFor = this.notAllowedFor;
        if (this.polledBtn.getSelectedObjects() != null) {
            String strval = this.periodText.getText();
            attr.polled_period = Integer.parseInt(strval);
        }
        if (this.levelBtn.getSelectedObjects() != null) {
            attr.disp_level = DispLevel.EXPERT;
        }
        attr.setMemorized(this.memorizedBtn.getSelectedObjects() != null);
        attr.setMemorizedInit(this.memorizedInitBtn.getSelectedObjects() != null);
        for (int i = 0; i <= 9; ++i) {
            JTextComponent txt = (JTextComponent)this.prop_txt.elementAt(i);
            String value = txt.getText();
            if (i == 9) {
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < value.length(); ++j) {
                    if (value.charAt(j) == '\n') {
                        sb.append("\\n");
                        continue;
                    }
                    sb.append(value.charAt(j));
                }
                attr.properties[i] = sb.toString();
                continue;
            }
            attr.properties[i] = value;
        }
        attr.setFireEvent(0, this.changeEvtCode.getSelectedObjects() != null, this.changeEvtChecked.getSelectedObjects() != null);
        attr.setFireEvent(1, this.archiveEvtCode.getSelectedObjects() != null, this.archiveEvtChecked.getSelectedObjects() != null);
        return attr;
    }

    private void updateWindow() {
        this.xDataTF.setVisible(false);
        this.yDataTF.setVisible(false);
        this.xDataLBL.setVisible(false);
        this.yDataLBL.setVisible(false);
        this.assAttrTF.setVisible(false);
        this.assAttrLBL.setVisible(false);
        if (this.memorizedBtn != null) {
            this.memorizedBtn.setVisible(false);
            this.memorizedInitBtn.setVisible(false);
        }
        switch (this.attrTypeCB.getSelectedIndex()) {
            case 0: {
                switch (this.rwTypeCB.getSelectedIndex()) {
                    case 3: {
                        this.assAttrTF.setVisible(true);
                        this.assAttrLBL.setVisible(true);
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (this.memorizedBtn == null) break;
                        this.memorizedBtn.setVisible(true);
                        this.memorizedInitBtn.setVisible(false);
                    }
                }
                break;
            }
            case 1: {
                this.xDataTF.setVisible(true);
                this.xDataLBL.setVisible(true);
                break;
            }
            case 2: {
                this.xDataTF.setVisible(true);
                this.yDataTF.setVisible(true);
                this.xDataLBL.setVisible(true);
                this.yDataLBL.setVisible(true);
            }
        }
        this.pack();
    }
}

