/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Cmd;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;

public class CmdTable
extends Vector
implements PogoDefs {
    Exception except = null;

    private void createVirtualStatusCmd() {
        Cmd cmd1 = new Cmd("State", "StateCmd", "Tango::DEV_VOID", "Tango::DEV_STATE", "none.", "State Code", "This command gets the device state (stored in its <i>device_state</i> data member) and returns it to the caller.");
        cmd1.virtual_method = true;
        cmd1.override_method = 0;
        this.addElement(cmd1);
        Cmd cmd2 = new Cmd("Status", "StatusCmd", "Tango::DEV_VOID", "Tango::CONST_DEV_STRING", "none.", "Status description", "This command gets the device status (stored in its <i>device_status</i> data member) and returns it to the caller.");
        cmd2.virtual_method = true;
        cmd2.override_method = 0;
        this.addElement(cmd2);
    }

    public CmdTable() {
        this.createVirtualStatusCmd();
    }

    public CmdTable(Vector v_in) {
        if (v_in.size() == 0) {
            this.createVirtualStatusCmd();
        }
        for (int i = this.size(); i < v_in.size(); ++i) {
            this.addElement(v_in.elementAt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    public CmdTable(String filename, int deviceImpl) throws FileNotFoundException, SecurityException, IOException, PogoException {
        void var3_4;
        String add_list_str;
        boolean lang;
        if (filename.indexOf(".cpp") > 0) {
            lang = true;
            add_list_str = "command_list.push_back";
        } else if (filename.indexOf(".java") > 0) {
            lang = false;
            add_list_str = "command_list.addElement";
        } else {
            throw new PogoException("Unrecognised file type !");
        }
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        this.createVirtualStatusCmd();
        int start = code.str.indexOf("::command_factory()");
        start = code.str.indexOf("{", start);
        int end = code.outMethod(start);
        String cmd_factory = code.str.substring(start, end);
        int i = 0;
        while ((i = cmd_factory.indexOf((String)var3_4, i)) > 0) {
            void var4_3;
            start = cmd_factory.indexOf("new ", i) + "new ".length();
            while (cmd_factory.charAt(start) <= ' ') {
                ++start;
            }
            end = cmd_factory.indexOf("));", start);
            Cmd cmd = new Cmd(cmd_factory.substring(start, end));
            cmd.setPolledPerriod(cmd_factory, (int)var4_3);
            switch (var4_3) {
                case 1: {
                    if (deviceImpl >= 3) break;
                    cmd.setNotAllowedFor(code.str, (int)var4_3);
                    break;
                }
                case 0: {
                    String path = new PogoString(filename).extractPathFromFullPath();
                    String jcode = PogoUtil.readFile(path + "/" + cmd.cmd_class + ".java");
                    cmd.setNotAllowedFor(jcode, (int)var4_3);
                }
            }
            this.addElement(cmd);
            ++i;
        }
    }

    void setAllowedState(String class_name, String filename, boolean is_abstractclass) throws FileNotFoundException, SecurityException, IOException, PogoException {
        PogoString readcode;
        try {
            readcode = new PogoString(PogoUtil.readFile(filename));
        }
        catch (FileNotFoundException e) {
            if (is_abstractclass) {
                return;
            }
            this.except = e;
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            Cmd cmd = this.cmdAt(i);
            String signature = cmd.allowedFullSignatureMethod(class_name);
            int start = readcode.indexOf(signature);
            if (start <= 0) continue;
            String method = readcode.extractMethodCore(start);
            cmd.notAllowedFor = new DevStateTable(method);
        }
    }

    public String buildCommandFactoryMethod(int lang) throws PogoException {
        Cmd cmd;
        int i;
        StringBuffer sb = new StringBuffer("{\n");
        for (i = 0; i < this.size(); ++i) {
            cmd = this.cmdAt(i);
            if (cmd.virtual_method) continue;
            sb.append(cmd.AddCmdFactoryLine(lang));
        }
        switch (lang) {
            case 0: {
                sb.append("\n\t\t//\tadd polling if any\n");
                sb.append("\t\tfor (int i=0 ; i<command_list.size(); i++)\n\t\t{\n");
                sb.append("\t\t\tCommand\tcmd = (Command)command_list.elementAt(i);\n");
                break;
            }
            case 1: {
                sb.append("\n\t//\tadd polling if any\n");
                sb.append("\tfor (unsigned int i=0 ; i<command_list.size(); i++)\n\t{\n");
            }
        }
        for (i = 0; i < this.size(); ++i) {
            cmd = this.cmdAt(i);
            if (cmd.virtual_method) continue;
            sb.append(cmd.AddCmdPollingLine(lang));
        }
        if (lang == 0) {
            sb.append("\t");
        }
        sb.append("\t}\n");
        if (lang == 0) {
            sb.append("\t");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public void getDescriptions(String descFile, String serverClass, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String readcode = PogoUtil.readFile(descFile);
        for (int i = 0; i < this.size(); ++i) {
            if (this.cmdAt((int)i).virtual_method) continue;
            this.cmdAt(i).getExecMethodDescription(readcode, lang);
        }
    }

    public String checkArgsType() {
        String str = "";
        for (int i = 0; i < this.size(); ++i) {
            Cmd cmd = this.cmdAt(i);
            if (cmd.argin.code == -1) {
                str = str + "Argin type (" + cmd.argin.cpp + ") unknown for command " + cmd.name + "!\n";
            }
            if (cmd.argout.code != -1) continue;
            str = str + "Argout type (" + cmd.argout.cpp + ") unknown for command " + cmd.name + "!\n";
        }
        if (str.length() > 0) {
            return str;
        }
        return null;
    }

    public Cmd cmdAt(int idx) {
        return (Cmd)this.elementAt(idx);
    }

    protected String addCommentsTable() {
        int max = 0;
        for (int i = 0; i < this.size(); ++i) {
            Cmd cmd = this.cmdAt(i);
            if (cmd.name.length() <= max) continue;
            max = cmd.name.length();
        }
        max += 2;
        String str = "//===================================================================\n//\n//\tThe following table gives the correspondance\n//\tbetween commands and method's name.\n//\n//  Command's name";
        for (int j = "Command's name".length(); j < max; ++j) {
            str = str + " ";
        }
        str = str + "|  Method's name\n";
        str = str + "//\t----------------------------------------\n";
        for (int i = 0; i < this.size(); ++i) {
            Cmd cmd = this.cmdAt(i);
            str = str + "//  " + cmd.name;
            for (int j = cmd.name.length(); j < max; ++j) {
                str = str + " ";
            }
            str = str + "|  " + cmd.exec_method + "()\n";
        }
        str = str + "//\n//===================================================================";
        return str;
    }

    public String toString(int idx) throws PogoException {
        if (idx >= this.size()) {
            throw new PogoException("Command index out of bounds !");
        }
        Cmd cmd = this.cmdAt(idx);
        String str = cmd.name + ", " + cmd.cmd_class + ", " + cmd.argin.cpp_code_str + ", " + cmd.argout.cpp_code_str;
        return str;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.size(); ++i) {
            Cmd cmd = this.cmdAt(i);
            str = str + "--------------------------------------------\n";
            str = str + cmd.name + ", " + cmd.cmd_class + ", " + cmd.argin.cpp_code_str + ", " + cmd.argout.cpp_code_str;
            str = cmd.argin.description != null ? str + ",\n\t" + cmd.argin.description + "\n\t" + cmd.argout.description + "\n" : str + "\n";
        }
        return str;
    }
}

