/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Attrib;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.ProjectFiles;

public class AttribTable
extends Vector
implements PogoDefs {
    Exception except = null;

    public AttribTable() {
    }

    public AttribTable(Vector v_in) {
        for (int i = 0; i < v_in.size(); ++i) {
            this.addElement(v_in.elementAt(i));
        }
    }

    public AttribTable(ProjectFiles prjfiles, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        int start;
        boolean toWWW = System.getProperty("CVSROOT") != null;
        String filename = prjfiles.getServerClass();
        int devimpl = 1;
        if (lang == 1) {
            devimpl = PogoUtil.deviceImplRevisionNumber(prjfiles.getServer_h());
        }
        PogoString pgs = new PogoString(PogoUtil.readFile(filename));
        if (toWWW) {
            System.out.println("Reading " + filename);
        }
        if ((start = pgs.str.indexOf("attribute_factory(")) < 0) {
            System.out.println("Attribute factory not found in :\n" + filename);
            return;
        }
        PogoString method = new PogoString(pgs.extractMethodCore(start));
        if (lang == 0 || devimpl < 3) {
            start = 0;
            String patern = "Attr(\"";
            while ((start = method.str.indexOf(patern, start)) >= 0) {
                Attrib attr;
                int xSize;
                start = method.str.lastIndexOf("\n", start);
                int end = method.str.indexOf("(", start) + 1;
                String constructor = method.str.substring(start, end);
                start = end;
                end = method.str.indexOf(")", start);
                PogoString s = new PogoString(method.str.substring(start, end));
                String[] params = s.getParams();
                int type = 0;
                if (constructor.indexOf("Image") >= 0) {
                    int ySize;
                    if (params.length > 4) {
                        for (int i = 0; i < PogoDefs.AttrRWtypeArray.length; ++i) {
                            String target = lang == 0 ? "AttrWriteType." + PogoDefs.AttrRWtypeArray[i] : "Tango::" + PogoDefs.AttrRWtypeArray[i];
                            if (!params[2].equals(target)) continue;
                            type = i;
                        }
                        try {
                            xSize = new Integer(params[3]);
                            ySize = new Integer(params[4]);
                        }
                        catch (NumberFormatException e) {
                            if (toWWW) {
                                ySize = 1;
                                xSize = 1;
                            }
                            throw e;
                        }
                    } else {
                        try {
                            xSize = new Integer(params[2]);
                            ySize = new Integer(params[3]);
                        }
                        catch (NumberFormatException e) {
                            if (toWWW) {
                                ySize = 1;
                                xSize = 1;
                            }
                            throw e;
                        }
                    }
                    attr = new Attrib(params[0], 2, params[1], type, xSize, ySize);
                } else if (constructor.indexOf("Spectrum") >= 0) {
                    if (params.length > 3) {
                        for (int i = 0; i < PogoDefs.AttrRWtypeArray.length; ++i) {
                            String target = lang == 0 ? "AttrWriteType." + PogoDefs.AttrRWtypeArray[i] : "Tango::" + PogoDefs.AttrRWtypeArray[i];
                            if (!params[2].equals(target)) continue;
                            type = i;
                        }
                        try {
                            xSize = new Integer(params[3]);
                        }
                        catch (NumberFormatException e) {
                            if (toWWW) {
                                xSize = 1;
                            }
                            throw e;
                        }
                    } else {
                        try {
                            xSize = new Integer(params[2]);
                        }
                        catch (NumberFormatException e) {
                            if (toWWW) {
                                xSize = 1;
                            }
                            throw e;
                        }
                    }
                    attr = new Attrib(params[0], 1, params[1], type, xSize);
                } else {
                    for (int i = 0; i < PogoDefs.AttrRWtypeArray.length; ++i) {
                        String target = lang == 0 ? "AttrWriteType." + PogoDefs.AttrRWtypeArray[i] : "Tango::" + PogoDefs.AttrRWtypeArray[i];
                        if (params.length <= 2 || !params[2].equals(target)) continue;
                        type = i;
                    }
                    attr = params.length == 4 && type == 3 ? new Attrib(params[0], 0, params[1], type, params[3]) : new Attrib(params[0], 0, params[1], type, "");
                }
                attr.getDefaultProperties(method, lang);
                this.addElement(attr);
            }
        } else {
            String header = PogoUtil.readFile(prjfiles.getServerClass_h());
            String pattern = "Attribute : ";
            start = 0;
            while ((start = method.indexOf(pattern, start)) > 0) {
                if (!method.isCommentLine(start)) continue;
                int end = method.nextCr(start += pattern.length());
                String name = method.substring(start, end);
                Attrib attr = new Attrib(name, header);
                attr.getDefaultProperties(method, lang);
                this.addElement(attr);
            }
        }
    }

    void setAllowedState(String class_name, String filename, boolean is_abstractclass) throws FileNotFoundException, SecurityException, IOException, PogoException {
        PogoString readcode;
        try {
            readcode = new PogoString(PogoUtil.readFile(filename));
        }
        catch (FileNotFoundException e) {
            if (is_abstractclass) {
                return;
            }
            this.except = e;
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            Attrib attr = this.attributeAt(i);
            String signature = attr.allowedFullSignatureMethod(class_name);
            int start = readcode.indexOf(signature);
            if (start <= 0) continue;
            String method = readcode.extractMethodCore(start);
            attr.notAllowedFor = new DevStateTable(method);
        }
    }

    public Attrib attributeAt(int idx) {
        return (Attrib)this.elementAt(idx);
    }

    public String buildFactory(int lang) {
        String tab = lang == 0 ? "\t" : "";
        String str = tab + "{\n";
        String addKeyWord = lang == 0 ? "att_list.addElement" : "att_list.push_back";
        for (int i = 0; i < this.size(); ++i) {
            Attrib attr = this.attributeAt(i);
            str = str + tab + "\t" + "//\tAttribute : " + attr.name + "\n";
            str = str + attr.buildCodeForAttributeConstructor(lang);
            str = str + attr.buitCodeForDefaultProperties(lang);
            str = str + tab + "\t" + addKeyWord + "(" + attr.getLowerName() + ");\n\n";
        }
        str = str + tab + "}\n";
        return str;
    }

    String readHardwareFullSignatureMethod(String class_name) {
        return this.signature(class_name, true);
    }

    String readHardwareSignatureMethod(String class_name) {
        return this.signature(class_name, false);
    }

    private String signature(String class_name, boolean full) {
        int start;
        String target;
        PogoString pgs = new PogoString("/**\n *\tHardware acquisition for attributes.\n */\n\tvirtual void CLASS::read_attr_hardware(vector<long> &attr_list)");
        if (class_name == null) {
            pgs.replace("CLASS::", "");
        } else {
            pgs.replace("CLASS", class_name);
            if (full) {
                target = " *\t";
                start = pgs.indexOf(target, "/**".length());
                int end = pgs.nextCr(start += target.length());
                String desc = pgs.substring(start, end);
                PogoString separator = new PogoString("//+----------------------------------------------------------------------------\n//\n// method : \t\tCLASS::METHOD\n// \n// description : \tDESCRIPTION\n//\n//-----------------------------------------------------------------------------\n");
                separator.replace("CLASS", class_name);
                separator.replace("METHOD", "read_attr_hardware");
                separator.replace("DESCRIPTION", desc);
                target = " */\n\tvirtual ";
                end = pgs.indexOf(target);
                String comments = pgs.substring(0, end + target.length());
                pgs.replace(comments, separator.str);
            }
        }
        if (!full) {
            target = " */\n\tvirtual ";
            start = pgs.indexOf(target);
            return pgs.substring(start += target.length());
        }
        return pgs.str;
    }

    public String[] isJavaCompatible() {
        String[] AttrDataArray = new String[]{"Tango::DEV_BOOLEAN", "Tango::DEV_SHORT", "Tango::DEV_LONG", "Tango::DEV_DOUBLE", "Tango::DEV_STRING"};
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.size(); ++i) {
            Attrib attr = this.attributeAt(i);
            if (attr.memorized) {
                v.add("Attribute memorized  (" + attr.name + ")");
            }
            boolean found = false;
            for (int t = 0; !found && t < AttrDataArray.length; ++t) {
                found = attr.dataType.cpp_code_str.equals(AttrDataArray[t]);
            }
            if (!found) {
                v.add("Attribute type " + attr.dataType.cpp_code_str + "  (" + attr.name + ")");
            }
            if (!attr.getWritable() || attr.attrType == 0) continue;
            v.add("Write an attribute " + PogoDefs.AttrTypeArray[attr.attrType] + "  (" + attr.name + ")");
        }
        if (v.size() == 0) {
            return null;
        }
        String[] problems = new String[v.size()];
        System.out.println("Java Servers API do not support:");
        for (int i = 0; i < v.size(); ++i) {
            problems[i] = (String)v.elementAt(i);
            System.out.println(problems[i]);
        }
        return problems;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.size(); ++i) {
            Attrib attr = this.attributeAt(i);
            str = str + attr.name + "\t";
            str = str + attr.dataType.cpp_code_str + "\n";
        }
        return str;
    }

    public static void main(String[] args) {
        String filename = "/segfs/tango/tools/pogo/test/cpp/PowerSupply/PowerSupply.h";
        try {
            ProjectFiles prj = new ProjectFiles(filename);
            AttribTable table = new AttribTable(prj, 1);
            System.out.println(table);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }
}

