/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.appli.PogoAppliDefs;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGeneCpp;
import pogo.gene.PogoGeneDoc;
import pogo.gene.PogoGeneJava;

public class PogoCmdLine
implements PogoAppliDefs,
PogoDefs {
    private Vector sourcefiles = new Vector();
    private int action = -1;
    private PogoClass server = null;
    private static final int NOT_INITIALIZED = -1;
    private static final String[] known_actions = new String[]{"-src", "-doc"};

    public PogoCmdLine(String[] args) throws PogoException, FileNotFoundException, SecurityException, IOException, InterruptedException {
        this.manageArgs(args);
        switch (this.action) {
            case 0: {
                for (int i = 0; i < this.sourcefiles.size(); ++i) {
                    this.server = new PogoClass((String)this.sourcefiles.elementAt(i));
                    if (this.server.language == 0) {
                        new PogoGeneJava(this.server).generate();
                        continue;
                    }
                    new PogoGeneCpp(this.server).generate();
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.sourcefiles.size(); ++i) {
                    this.server = new PogoClass((String)this.sourcefiles.elementAt(i));
                    new PogoGeneDoc(this.server).generate();
                }
                break;
            }
            default: {
                throw new PogoException(known_actions[this.action] + " Not yet implemented");
            }
        }
    }

    private void manageArgs(String[] args) throws PogoException {
        int i;
        for (i = 0; i < args.length; ++i) {
            boolean found = false;
            for (int j = 0; !found && j < known_actions.length; ++j) {
                found = args[i].equals(known_actions[j]);
                if (!found) continue;
                this.action = j;
            }
            if (found) continue;
            this.sourcefiles.add(args[i]);
        }
        System.out.println("action: " + known_actions[this.action]);
        System.out.println("sourcefiles: ");
        for (i = 0; i < this.sourcefiles.size(); ++i) {
            System.out.println("\t" + this.sourcefiles.elementAt(i));
        }
        if (this.action == -1 || this.sourcefiles.size() == 0) {
            this.displaySyntax();
            throw new PogoException("");
        }
    }

    private void displaySyntax() {
        System.out.println("Syntax:");
        System.out.println("pogo <action> <filename1> <filename2>....");
        System.out.println();
        System.out.println("Without option, pogo start the Graphic User Interface");
        System.out.println();
        System.out.println("Actions:");
        System.out.println("\t-src:\twill re-generate the device server source files.");
        System.out.println("\t-doc:\twill generate the device server documentation.");
        System.out.println();
    }
}

