/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.attribute.NumberImageViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jive.ArgParser;
import jive.CommonPanel;
import jive.ConsolePanel;

class AttributePanel
extends JPanel
implements ActionListener,
ListSelectionListener,
TangoConst,
MouseListener {
    private AttributeInfo[] attList;
    private ConsolePanel console;
    private DeviceProxy device;
    private CommonPanel common;
    private JComboBox arginCombo;
    private JLabel arginLabel;
    private JLabel descrLabel;
    private JList attributeList;
    private JScrollPane attributeView;
    private JTextArea descrList;
    private JScrollPane descrView;
    private JButton readBtn;
    private JButton writeBtn;
    private JButton plotBtn;
    private JFrame chartDlg = null;
    private JLChart chart;
    private JLDataView plotData;
    private JFrame imageDlg = null;
    private NumberImageViewer image;

    AttributePanel(DeviceProxy deviceProxy, ConsolePanel consolePanel, CommonPanel commonPanel) throws DevFailed {
        this.setLayout(null);
        this.console = consolePanel;
        this.common = commonPanel;
        this.device = deviceProxy;
        this.attList = this.getAttributeList();
        this.arginLabel = new JLabel("Argin value");
        this.arginLabel.setFont(ATKConstant.labelFont);
        this.add(this.arginLabel);
        this.descrLabel = new JLabel();
        this.descrLabel.setFont(ATKConstant.labelFont);
        this.descrLabel.setHorizontalAlignment(4);
        this.add(this.descrLabel);
        this.arginCombo = new JComboBox();
        this.arginCombo.setEditable(true);
        this.arginCombo.setFont(ATKConstant.labelFont);
        this.add(this.arginCombo);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (int i = 0; i < this.attList.length; ++i) {
            defaultListModel.add(i, this.attList[i].name);
        }
        this.attributeList = new JList(defaultListModel);
        this.attributeList.addListSelectionListener(this);
        this.attributeList.addMouseListener(this);
        this.attributeView = new JScrollPane(this.attributeList);
        this.add(this.attributeView);
        this.descrList = new JTextArea();
        this.descrList.setFont(new Font("monospaced", 0, 12));
        this.descrList.setEditable(false);
        this.descrView = new JScrollPane(this.descrList);
        this.add(this.descrView);
        this.readBtn = new JButton("Read");
        this.readBtn.setFont(ATKConstant.labelFont);
        this.add(this.readBtn);
        this.readBtn.addActionListener(this);
        this.writeBtn = new JButton("Write");
        this.writeBtn.setFont(ATKConstant.labelFont);
        this.add(this.writeBtn);
        this.writeBtn.addActionListener(this);
        this.plotBtn = new JButton("Plot");
        this.plotBtn.setFont(ATKConstant.labelFont);
        this.add(this.plotBtn);
        this.plotBtn.addActionListener(this);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                AttributePanel.this.placeComponents(AttributePanel.this.getSize());
            }

            public void componentShown(ComponentEvent componentEvent) {
                AttributePanel.this.placeComponents(AttributePanel.this.getSize());
            }
        });
        this.attributeList.setSelectedIndex(0);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.attributeList.getSelectedIndex();
        if (this.attList.length == 0) {
            return;
        }
        AttributeInfo attributeInfo = this.attList[n];
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.isWritable(attributeInfo)) {
                this.descrLabel.setText(this.getExample(attributeInfo));
                this.arginCombo.setEnabled(true);
            } else {
                this.descrLabel.setText("");
                this.arginCombo.setEnabled(false);
            }
            this.descrList.setText("Name         " + attributeInfo.name + "\n" + "Label        " + attributeInfo.label + "\n" + "Writable     " + AttributePanel.getWriteString(attributeInfo) + "\n" + "Data format  " + AttributePanel.getFormatString(attributeInfo) + "\n" + "Data type    " + TangoConst.Tango_CmdArgTypeName[attributeInfo.data_type] + "\n" + "Max Dim X    " + attributeInfo.max_dim_x + "\n" + "Max Dim Y    " + attributeInfo.max_dim_y + "\n" + "Unit         " + attributeInfo.unit + "\n" + "Std Unit     " + attributeInfo.standard_unit + "\n" + "Disp Unit    " + attributeInfo.display_unit + "\n" + "Format       " + attributeInfo.format + "\n" + "Min value    " + attributeInfo.min_value + "\n" + "Max value    " + attributeInfo.max_value + "\n" + "Min alarm    " + attributeInfo.min_alarm + "\n" + "Max alarm    " + attributeInfo.max_alarm);
            this.descrList.setCaretPosition(0);
            this.plotBtn.setEnabled(this.isPlotable(attributeInfo));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.readAttribute();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.readBtn) {
            this.readAttribute();
        } else if (object == this.writeBtn) {
            this.writeAttribute();
        } else if (object == this.plotBtn) {
            this.plotAttribute();
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimunSize();
    }

    public Dimension getMinimunSize() {
        return new Dimension(450, 210);
    }

    static String getFormatString(AttributeInfo attributeInfo) {
        switch (attributeInfo.data_format.value()) {
            case 0: {
                return "Scalar";
            }
            case 1: {
                return "Spectrum";
            }
            case 2: {
                return "Image";
            }
        }
        return "Unknown";
    }

    static String getWriteString(AttributeInfo attributeInfo) {
        switch (attributeInfo.writable.value()) {
            case 0: {
                return "READ";
            }
            case 1: {
                return "READ_WITH_WRITE";
            }
            case 3: {
                return "READ_WRITE";
            }
            case 2: {
                return "WRITE";
            }
        }
        return "Unknown";
    }

    private AttributeInfo[] getAttributeList() throws DevFailed {
        AttributeInfo[] attributeInfoArray = this.device.get_attribute_info();
        boolean bl = false;
        int n = attributeInfoArray.length - 1;
        while (!bl) {
            bl = true;
            for (int i = 0; i < n; ++i) {
                if (attributeInfoArray[i].name.compareToIgnoreCase(attributeInfoArray[i + 1].name) <= 0) continue;
                bl = false;
                AttributeInfo attributeInfo = attributeInfoArray[i];
                attributeInfoArray[i] = attributeInfoArray[i + 1];
                attributeInfoArray[i + 1] = attributeInfo;
            }
            --n;
        }
        return attributeInfoArray;
    }

    private void placeComponents(Dimension dimension) {
        this.arginLabel.setBounds(10, 0, 80, 20);
        this.descrLabel.setBounds(90, 0, dimension.width - 100, 20);
        this.arginCombo.setBounds(10, 20, dimension.width - 20, 25);
        this.attributeView.setBounds(10, 50, 150, dimension.height - 60);
        this.attributeView.revalidate();
        this.descrView.setBounds(165, 50, dimension.width - 175, dimension.height - 90);
        this.descrView.revalidate();
        int n = (dimension.width - 180) / 3;
        this.readBtn.setBounds(165, dimension.height - 35, n, 25);
        this.writeBtn.setBounds(165 + n + 2, dimension.height - 35, n, 25);
        this.plotBtn.setBounds(165 + 2 * n + 5, dimension.height - 35, n, 25);
    }

    private void addArgin(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.arginCombo.getItemCount() && !bl) {
            bl = string.equals(this.arginCombo.getItemAt(n).toString());
            if (bl) continue;
            ++n;
        }
        if (!bl) {
            this.arginCombo.addItem(string);
        }
    }

    private boolean isPlotable(AttributeInfo attributeInfo) {
        if (attributeInfo.data_type == 8 || attributeInfo.data_type == 19 || attributeInfo.data_type == 1) {
            return false;
        }
        return attributeInfo.data_format.value() == 1 || attributeInfo.data_format.value() == 2;
    }

    private boolean isWritable(AttributeInfo attributeInfo) {
        return attributeInfo.writable.value() == 1 || attributeInfo.writable.value() == 3 || attributeInfo.writable.value() == 2;
    }

    private void writeAttribute() {
        try {
            AttributeInfo attributeInfo = this.attList[this.attributeList.getSelectedIndex()];
            String string = attributeInfo.name;
            String string2 = this.arginCombo.getSelectedItem().toString();
            if (string2 != null) {
                this.addArgin(string2);
            }
            DeviceAttribute deviceAttribute = new DeviceAttribute(string);
            this.insertData(string2, deviceAttribute, attributeInfo);
            long l = System.currentTimeMillis();
            this.device.write_attribute(deviceAttribute);
            long l2 = System.currentTimeMillis();
            this.console.print("----------------------------------------------------\n");
            this.console.print("Attribute: " + this.device.name() + "/" + string + "\n");
            this.console.print("Duration: " + (l2 - l) + " msec\n");
            this.console.print("Write OK\n");
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid argin syntaxt\n" + numberFormatException.getMessage());
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
        }
    }

    private void readAttribute() {
        try {
            AttributeInfo attributeInfo = this.attList[this.attributeList.getSelectedIndex()];
            String string = attributeInfo.name;
            long l = System.currentTimeMillis();
            DeviceAttribute deviceAttribute = this.device.read_attribute(string);
            long l2 = System.currentTimeMillis();
            this.console.print("----------------------------------------------------\n");
            this.console.print("Attribute: " + this.device.name() + "/" + string + "\n");
            this.console.print("Duration: " + (l2 - l) + " msec\n");
            this.console.print(this.extractData(deviceAttribute, attributeInfo));
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid argin syntaxt\n" + numberFormatException.getMessage());
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
        }
    }

    private void plotAttribute() {
        try {
            AttributeInfo attributeInfo = this.attList[this.attributeList.getSelectedIndex()];
            String string = attributeInfo.name;
            DeviceAttribute deviceAttribute = this.device.read_attribute(string);
            switch (attributeInfo.data_format.value()) {
                case 1: {
                    double[] dArray = this.extractSpectrumPlotData(deviceAttribute, attributeInfo);
                    if (this.chartDlg == null) {
                        this.chart = new JLChart();
                        this.chart.setPreferredSize(new Dimension(640, 480));
                        this.plotData = new JLDataView();
                        this.chart.getY1Axis().addDataView(this.plotData);
                        this.chart.getY1Axis().setAutoScale(true);
                        this.chart.getXAxis().setAnnotation(2);
                        this.chartDlg = new JFrame("Plot attribute [" + this.device.name() + "]");
                        this.chartDlg.setContentPane((Container)this.chart);
                    }
                    this.plotData.reset();
                    this.plotData.setName(string);
                    for (int i = 0; i < dArray.length; ++i) {
                        this.plotData.add((double)i, dArray[i]);
                    }
                    this.chart.repaint();
                    if (this.chartDlg.isVisible()) break;
                    ATKGraphicsUtils.centerFrameOnScreen((Frame)this.chartDlg);
                    this.chartDlg.setVisible(true);
                    break;
                }
                case 2: {
                    double[][] dArray = this.extractImagePlotData(deviceAttribute, attributeInfo);
                    if (this.imageDlg == null) {
                        this.image = new NumberImageViewer();
                        this.image.setAutoZoom(true);
                        this.imageDlg = new JFrame("Plot attribute [" + this.device.name() + "]");
                        this.imageDlg.setContentPane((Container)this.image);
                    }
                    this.image.setData(dArray);
                    if (this.imageDlg.isVisible()) break;
                    ATKGraphicsUtils.centerFrameOnScreen((Frame)this.imageDlg);
                    this.imageDlg.setVisible(true);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid argin syntaxt\n" + numberFormatException.getMessage());
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
        }
    }

    private String getExample(AttributeInfo attributeInfo) {
        String string = "";
        switch (attributeInfo.data_type) {
            case 19: {
                string = string + "0 (16bits value)";
                break;
            }
            case 22: {
                string = string + "10 or 0xa (unsigned 8bits)";
                break;
            }
            case 1: {
                string = string + "true,false or 0,1";
                break;
            }
            case 6: {
                string = string + "10 or 0xa (unsigned 16bits)";
                break;
            }
            case 2: {
                string = string + "10 or 0xa (signed 16bits)";
                break;
            }
            case 3: {
                string = string + "10 or 0xa (signed 32bits)";
                break;
            }
            case 4: {
                string = string + "2.3 (32bits float)";
                break;
            }
            case 5: {
                string = string + "2.3 (64bits float)";
                break;
            }
            case 8: {
                string = "quotes needed for string with space or special char";
                break;
            }
            default: {
                string = new String("");
            }
        }
        if (attributeInfo.data_format.value() == 1) {
            return "Array of " + string + " Ex: a,b,c";
        }
        if (attributeInfo.data_format.value() == 2) {
            return "Image of " + string + " Ex: [a,b,c][d,e,f][g,h,i]";
        }
        return "Ex: " + string;
    }

    private int getLimit(StringBuffer stringBuffer, int n, boolean bl) {
        if (n > 1) {
            if (bl) {
                stringBuffer.append("Write length: " + n + "\n");
            } else {
                stringBuffer.append("Read length: " + n + "\n");
            }
        }
        if (n > this.common.getAnswerLimit()) {
            stringBuffer.append("Array cannot be fully displayed. (You may change the AnswerLimit)\n");
            return this.common.getAnswerLimit();
        }
        return n;
    }

    private void insertData(String string, DeviceAttribute deviceAttribute, AttributeInfo attributeInfo) throws NumberFormatException {
        ArgParser argParser = new ArgParser(string);
        switch (attributeInfo.data_type) {
            case 22: {
                switch (attributeInfo.data_format.value()) {
                    case 0: {
                        deviceAttribute.insert_uc(argParser.parse_uchar());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert_uc(argParser.parse_uchar_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert_uc(argParser.parse_uchar_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 1: {
                switch (attributeInfo.data_format.value()) {
                    case 0: {
                        deviceAttribute.insert(argParser.parse_boolean());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert(argParser.parse_boolean_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert(argParser.parse_boolean_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 2: {
                switch (attributeInfo.data_format.value()) {
                    case 0: {
                        deviceAttribute.insert(argParser.parse_short());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert(argParser.parse_short_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert(argParser.parse_short_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 6: {
                switch (attributeInfo.data_format.value()) {
                    case 0: {
                        deviceAttribute.insert_us(argParser.parse_ushort());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert_us(argParser.parse_ushort_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert_us(argParser.parse_ushort_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 3: {
                switch (attributeInfo.data_format.value()) {
                    case 0: {
                        deviceAttribute.insert(argParser.parse_long());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert(argParser.parse_long_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert(argParser.parse_long_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 4: {
                switch (attributeInfo.data_format.value()) {
                    case 0: {
                        deviceAttribute.insert(argParser.parse_float());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert(argParser.parse_float_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert(argParser.parse_float_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 5: {
                switch (attributeInfo.data_format.value()) {
                    case 0: {
                        deviceAttribute.insert(argParser.parse_double());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert(argParser.parse_double_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert(argParser.parse_double_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 8: {
                switch (attributeInfo.data_format.value()) {
                    case 0: {
                        deviceAttribute.insert(argParser.parse_string());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert(argParser.parse_string_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert(argParser.parse_string_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            default: {
                throw new NumberFormatException("Attribute type not supported code=" + attributeInfo.data_type);
            }
        }
    }

    private void printArrayItem(StringBuffer stringBuffer, int n, boolean bl, String string, boolean bl2) {
        if (!bl2) {
            if (bl) {
                stringBuffer.append("Read [" + n + "]\t" + string + "\n");
            } else {
                stringBuffer.append("Read:\t" + string + "\n");
            }
        } else if (bl) {
            stringBuffer.append("Set [" + n + "]\t" + string + "\n");
        } else {
            stringBuffer.append("Set:\t" + string + "\n");
        }
    }

    private String extractData(DeviceAttribute deviceAttribute, AttributeInfo attributeInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            TimeVal timeVal = deviceAttribute.getTimeVal();
            Date date = new Date((long)((double)timeVal.tv_sec * 1000.0 + (double)timeVal.tv_usec / 1000.0));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            simpleDateFormat.setTimeZone(TimeZone.getDefault());
            stringBuffer.append("measure date: " + simpleDateFormat.format(date) + " + " + timeVal.tv_usec / 1000 + "ms\n");
            AttrQuality attrQuality = deviceAttribute.getQuality();
            stringBuffer.append("quality: ");
            switch (attrQuality.value()) {
                case 0: {
                    stringBuffer.append("VALID\n");
                    break;
                }
                case 1: {
                    stringBuffer.append("INVALID\n");
                    return stringBuffer.toString();
                }
                case 2: {
                    stringBuffer.append("ALARM\n");
                    break;
                }
                case 3: {
                    stringBuffer.append("CHANGING\n");
                    break;
                }
                case 4: {
                    stringBuffer.append("WARNING\n");
                    break;
                }
                default: {
                    stringBuffer.append("UNKNOWN\n");
                }
            }
            boolean bl = true;
            switch (attributeInfo.data_format.value()) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    stringBuffer.append("dim x: " + deviceAttribute.getDimX() + "\n");
                    break;
                }
                case 2: {
                    stringBuffer.append("dim x: " + deviceAttribute.getDimX() + "\n");
                    stringBuffer.append("dim y: " + deviceAttribute.getDimY() + "\n");
                    break;
                }
            }
            switch (attributeInfo.data_type) {
                case 19: {
                    stringBuffer.append(TangoConst.Tango_DevStateName[deviceAttribute.extractState().value()] + "\n");
                    break;
                }
                case 22: {
                    int n;
                    short[] sArray = deviceAttribute.extractUCharArray();
                    int n2 = deviceAttribute.getNbRead();
                    int n3 = sArray.length - n2;
                    int n4 = this.getLimit(stringBuffer, n2, false);
                    for (n = 0; n < n4; ++n) {
                        this.printArrayItem(stringBuffer, n, bl, Short.toString(sArray[n]), false);
                    }
                    if (this.isWritable(attributeInfo)) {
                        n4 = this.getLimit(stringBuffer, n3, true);
                        for (n = 0; n < n4; ++n) {
                            this.printArrayItem(stringBuffer, n, bl, Short.toString(sArray[n + n2]), true);
                        }
                    }
                    break;
                }
                case 2: {
                    int n;
                    short[] sArray = deviceAttribute.extractShortArray();
                    int n5 = deviceAttribute.getNbRead();
                    int n6 = sArray.length - n5;
                    int n7 = this.getLimit(stringBuffer, n5, false);
                    for (n = 0; n < n7; ++n) {
                        this.printArrayItem(stringBuffer, n, bl, Short.toString(sArray[n]), false);
                    }
                    if (this.isWritable(attributeInfo)) {
                        n7 = this.getLimit(stringBuffer, n6, true);
                        for (n = 0; n < n7; ++n) {
                            this.printArrayItem(stringBuffer, n, bl, Short.toString(sArray[n + n5]), true);
                        }
                    }
                    break;
                }
                case 1: {
                    int n;
                    boolean[] blArray = deviceAttribute.extractBooleanArray();
                    int n8 = deviceAttribute.getNbRead();
                    int n9 = blArray.length - n8;
                    int n10 = this.getLimit(stringBuffer, n8, false);
                    for (n = 0; n < n10; ++n) {
                        this.printArrayItem(stringBuffer, n, bl, Boolean.toString(blArray[n]), false);
                    }
                    if (this.isWritable(attributeInfo)) {
                        n10 = this.getLimit(stringBuffer, n9, true);
                        for (n = 0; n < n10; ++n) {
                            this.printArrayItem(stringBuffer, n, bl, Boolean.toString(blArray[n + n8]), true);
                        }
                    }
                    break;
                }
                case 6: {
                    int n;
                    int[] nArray = deviceAttribute.extractUShortArray();
                    int n11 = deviceAttribute.getNbRead();
                    int n12 = nArray.length - n11;
                    int n13 = this.getLimit(stringBuffer, n11, false);
                    for (n = 0; n < n13; ++n) {
                        this.printArrayItem(stringBuffer, n, bl, Integer.toString(nArray[n]), false);
                    }
                    if (this.isWritable(attributeInfo)) {
                        n13 = this.getLimit(stringBuffer, n12, true);
                        for (n = 0; n < n13; ++n) {
                            this.printArrayItem(stringBuffer, n, bl, Integer.toString(nArray[n + n11]), true);
                        }
                    }
                    break;
                }
                case 3: {
                    int n;
                    int[] nArray = deviceAttribute.extractLongArray();
                    int n14 = deviceAttribute.getNbRead();
                    int n15 = nArray.length - n14;
                    int n16 = this.getLimit(stringBuffer, n14, false);
                    for (n = 0; n < n16; ++n) {
                        this.printArrayItem(stringBuffer, n, bl, Integer.toString(nArray[n]), false);
                    }
                    if (this.isWritable(attributeInfo)) {
                        n16 = this.getLimit(stringBuffer, n15, true);
                        for (n = 0; n < n16; ++n) {
                            this.printArrayItem(stringBuffer, n, bl, Integer.toString(nArray[n + n14]), true);
                        }
                    }
                    break;
                }
                case 5: {
                    int n;
                    double[] dArray = deviceAttribute.extractDoubleArray();
                    int n17 = deviceAttribute.getNbRead();
                    int n18 = dArray.length - n17;
                    int n19 = this.getLimit(stringBuffer, n17, false);
                    for (n = 0; n < n19; ++n) {
                        this.printArrayItem(stringBuffer, n, bl, Double.toString(dArray[n]), false);
                    }
                    if (this.isWritable(attributeInfo)) {
                        n19 = this.getLimit(stringBuffer, n18, true);
                        for (n = 0; n < n19; ++n) {
                            this.printArrayItem(stringBuffer, n, bl, Double.toString(dArray[n + n17]), true);
                        }
                    }
                    break;
                }
                case 4: {
                    int n;
                    float[] fArray = deviceAttribute.extractFloatArray();
                    int n20 = deviceAttribute.getNbRead();
                    int n21 = fArray.length - n20;
                    int n22 = this.getLimit(stringBuffer, n20, false);
                    for (n = 0; n < n22; ++n) {
                        this.printArrayItem(stringBuffer, n, bl, Float.toString(fArray[n]), false);
                    }
                    if (this.isWritable(attributeInfo)) {
                        n22 = this.getLimit(stringBuffer, n21, true);
                        for (n = 0; n < n22; ++n) {
                            this.printArrayItem(stringBuffer, n, bl, Float.toString(fArray[n + n20]), true);
                        }
                    }
                    break;
                }
                case 8: {
                    int n;
                    String[] stringArray = deviceAttribute.extractStringArray();
                    int n23 = deviceAttribute.getNbRead();
                    int n24 = stringArray.length - n23;
                    int n25 = this.getLimit(stringBuffer, n23, false);
                    for (n = 0; n < n25; ++n) {
                        this.printArrayItem(stringBuffer, n, bl, stringArray[n], false);
                    }
                    if (this.isWritable(attributeInfo)) {
                        n25 = this.getLimit(stringBuffer, n24, true);
                        for (n = 0; n < n25; ++n) {
                            this.printArrayItem(stringBuffer, n, bl, stringArray[n + n23], true);
                        }
                    }
                    break;
                }
                default: {
                    stringBuffer.append("Unsupported attribute type code=" + attributeInfo.data_type + "\n");
                    break;
                }
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)(this.device.name() + "/" + attributeInfo.name), (DevFailed)devFailed);
        }
        return stringBuffer.toString();
    }

    private double[] extractSpectrumPlotData(DeviceAttribute deviceAttribute, AttributeInfo attributeInfo) {
        double[] dArray = new double[]{};
        try {
            switch (attributeInfo.data_type) {
                case 22: {
                    short[] sArray = deviceAttribute.extractUCharArray();
                    dArray = new double[deviceAttribute.getNbRead()];
                    for (int i = 0; i < deviceAttribute.getNbRead(); ++i) {
                        dArray[i] = sArray[i];
                    }
                    break;
                }
                case 2: {
                    short[] sArray = deviceAttribute.extractShortArray();
                    dArray = new double[deviceAttribute.getNbRead()];
                    for (int i = 0; i < deviceAttribute.getNbRead(); ++i) {
                        dArray[i] = sArray[i];
                    }
                    break;
                }
                case 6: {
                    int[] nArray = deviceAttribute.extractUShortArray();
                    dArray = new double[deviceAttribute.getNbRead()];
                    for (int i = 0; i < deviceAttribute.getNbRead(); ++i) {
                        dArray[i] = nArray[i];
                    }
                    break;
                }
                case 3: {
                    int[] nArray = deviceAttribute.extractLongArray();
                    dArray = new double[deviceAttribute.getNbRead()];
                    for (int i = 0; i < deviceAttribute.getNbRead(); ++i) {
                        dArray[i] = nArray[i];
                    }
                    break;
                }
                case 5: {
                    double[] dArray2 = deviceAttribute.extractDoubleArray();
                    dArray = new double[deviceAttribute.getNbRead()];
                    for (int i = 0; i < deviceAttribute.getNbRead(); ++i) {
                        dArray[i] = dArray2[i];
                    }
                    break;
                }
                case 4: {
                    float[] fArray = deviceAttribute.extractFloatArray();
                    dArray = new double[deviceAttribute.getNbRead()];
                    for (int i = 0; i < deviceAttribute.getNbRead(); ++i) {
                        dArray[i] = fArray[i];
                    }
                    break;
                }
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)(this.device.name() + "/" + attributeInfo.name), (DevFailed)devFailed);
        }
        return dArray;
    }

    private double[][] extractImagePlotData(DeviceAttribute deviceAttribute, AttributeInfo attributeInfo) {
        double[][] dArray = new double[0][0];
        try {
            int n = deviceAttribute.getDimX();
            int n2 = deviceAttribute.getDimY();
            switch (attributeInfo.data_type) {
                case 22: {
                    short[] sArray = deviceAttribute.extractUCharArray();
                    dArray = new double[n2][n];
                    int n3 = 0;
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            dArray[i][j] = sArray[n3++];
                        }
                    }
                    break;
                }
                case 2: {
                    short[] sArray = deviceAttribute.extractShortArray();
                    dArray = new double[n2][n];
                    int n4 = 0;
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            dArray[i][j] = sArray[n4++];
                        }
                    }
                    break;
                }
                case 6: {
                    int[] nArray = deviceAttribute.extractUShortArray();
                    dArray = new double[n2][n];
                    int n5 = 0;
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            dArray[i][j] = nArray[n5++];
                        }
                    }
                    break;
                }
                case 3: {
                    int[] nArray = deviceAttribute.extractLongArray();
                    dArray = new double[n2][n];
                    int n6 = 0;
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            dArray[i][j] = nArray[n6++];
                        }
                    }
                    break;
                }
                case 5: {
                    double[] dArray2 = deviceAttribute.extractDoubleArray();
                    dArray = new double[n2][n];
                    int n7 = 0;
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            dArray[i][j] = dArray2[n7++];
                        }
                    }
                    break;
                }
                case 4: {
                    float[] fArray = deviceAttribute.extractFloatArray();
                    dArray = new double[n2][n];
                    int n8 = 0;
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            dArray[i][j] = fArray[n8++];
                        }
                    }
                    break;
                }
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)(this.device.name() + "/" + attributeInfo.name), (DevFailed)devFailed);
        }
        return dArray;
    }
}

