/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.EncapsInfo;
import org.jacorb.orb.ORB;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;

public class CDROutputStream
extends org.omg.CORBA_2_3.portable.OutputStream {
    private static final IOR null_ior = new IOR("", new TaggedProfile[0]);
    private int index;
    private int pos;
    private int deferred_writes;
    private BufferManager bufMgr;
    protected byte[] buffer;
    private boolean closed;
    private int codeSet = CodeSet.getTCSDefault();
    private int codeSetW = CodeSet.getTCSWDefault();
    private int encaps_start = -1;
    private Stack encaps_stack;
    private Map recursiveTCMap;
    private Map valueMap;
    private Map repIdMap;
    private Map codebaseMap;
    private Map cachedTypecodes;
    private int chunk_size_tag_pos = -1;
    private int chunk_size_tag_index;
    private int chunk_octets_pos;
    private int valueNestingLevel = 0;
    private int writeValueNestingLevel = 0;
    private boolean writeReplaceCalled = false;
    private List deferredArrayQueue = new ArrayList();
    private org.omg.CORBA.ORB orb = null;
    protected int giop_minor = 2;
    private int chunkingFlag = 0;
    private boolean useBOM = false;
    private boolean chunkCustomRmiValuetypes = false;
    private int compactTypeCodes = 0;
    private boolean useIndirection = true;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$javax$rmi$CORBA$ClassDesc;
    static /* synthetic */ Class class$org$omg$CORBA$Any;
    static /* synthetic */ Class class$org$omg$CORBA$portable$OutputStream;

    private void configure(Configuration configuration) throws ConfigurationException {
        this.useBOM = configuration.getAttribute("jacorb.use_bom", "off").equals("on");
        this.chunkCustomRmiValuetypes = configuration.getAttribute("jacorb.interop.chunk_custom_rmi_valuetypes", "off").equals("on");
        this.compactTypeCodes = configuration.getAttributeAsInteger("jacorb.compactTypecodes", 0);
        this.useIndirection = !configuration.getAttribute("jacorb.interop.indirection_encoding_disable", "off").equals("on");
    }

    public CDROutputStream() {
        this.bufMgr = BufferManager.getInstance();
        this.buffer = this.bufMgr.getPreferredMemoryBuffer();
    }

    public CDROutputStream(org.omg.CORBA.ORB orb) {
        this();
        if (orb != null) {
            this.orb = orb;
            try {
                this.configure(((ORB)orb).getConfiguration());
            }
            catch (ConfigurationException ce) {
                throw new INTERNAL("ConfigurationException: " + ce.getMessage());
            }
        }
    }

    public CDROutputStream(byte[] buf) {
        this.bufMgr = BufferManager.getInstance();
        this.buffer = buf;
    }

    public org.omg.CORBA.ORB orb() {
        if (this.orb == null) {
            this.orb = org.omg.CORBA.ORB.init();
        }
        return this.orb;
    }

    private Stack getEncapsStack() {
        if (this.encaps_stack == null) {
            this.encaps_stack = new Stack();
        }
        return this.encaps_stack;
    }

    private Map getRecursiveTCMap() {
        if (this.recursiveTCMap == null) {
            this.recursiveTCMap = new HashMap();
        }
        return this.recursiveTCMap;
    }

    private Map getValueMap() {
        if (this.valueMap == null) {
            this.valueMap = ObjectUtil.createIdentityHashMap();
        }
        return this.valueMap;
    }

    private Map getRepIdMap() {
        if (this.repIdMap == null) {
            this.repIdMap = new HashMap();
        }
        return this.repIdMap;
    }

    private Map getCodebaseMap() {
        if (this.codebaseMap == null) {
            this.codebaseMap = new HashMap();
        }
        return this.codebaseMap;
    }

    public void write(OutputStream out, int start, int length) throws IOException {
        int write_idx = start;
        int read_idx = start;
        int skip_count = 0;
        int list_idx = 0;
        DeferredWriteFrame next_frame = null;
        if (this.deferredArrayQueue != null && this.deferredArrayQueue.size() > 0) {
            next_frame = (DeferredWriteFrame)this.deferredArrayQueue.get(list_idx++);
            while (next_frame.write_pos < start && list_idx < this.deferredArrayQueue.size()) {
                skip_count += next_frame.length;
                next_frame = (DeferredWriteFrame)this.deferredArrayQueue.get(list_idx++);
            }
            if (next_frame.write_pos < start && list_idx >= this.deferredArrayQueue.size()) {
                skip_count += next_frame.length;
                next_frame = null;
            }
        }
        while (write_idx < start + length) {
            if (next_frame != null && write_idx == next_frame.write_pos) {
                if (next_frame.length > start + length - write_idx) {
                    throw new MARSHAL("Deferred array does not fit");
                }
                out.write(next_frame.buf, next_frame.start, next_frame.length);
                write_idx += next_frame.length;
                next_frame = null;
                if (this.deferredArrayQueue != null && list_idx < this.deferredArrayQueue.size()) {
                    next_frame = (DeferredWriteFrame)this.deferredArrayQueue.get(list_idx++);
                    if (next_frame.write_pos > start + length) {
                        next_frame = null;
                    }
                }
            }
            if (write_idx >= start + length) continue;
            int write_now = Math.min(start + length, next_frame != null ? next_frame.write_pos : start + length);
            out.write(this.buffer, read_idx - skip_count, write_now -= write_idx);
            read_idx += write_now;
            write_idx += write_now;
        }
    }

    public void setCodeSet(int codeSet, int codeSetWide) {
        this.codeSet = codeSet;
        this.codeSetW = codeSetWide;
    }

    public void setGIOPMinor(int giop_minor) {
        this.giop_minor = giop_minor;
    }

    public int getGIOPMinor() {
        return this.giop_minor;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.bufMgr.returnBuffer(this.buffer, true);
        this.buffer = null;
        this.closed = true;
        if (this.deferredArrayQueue != null) {
            this.deferredArrayQueue.clear();
        }
        this.deferred_writes = 0;
    }

    private final void check(int i, int align) {
        int remainder = align - this.index % align;
        this.check(i + remainder);
        if (remainder != align) {
            int topad = Math.min(this.buffer.length - this.pos, 8);
            int j = 0;
            switch (topad) {
                case 8: {
                    this.buffer[this.pos + j++] = 0;
                }
                case 7: {
                    this.buffer[this.pos + j++] = 0;
                }
                case 6: {
                    this.buffer[this.pos + j++] = 0;
                }
                case 5: {
                    this.buffer[this.pos + j++] = 0;
                }
                case 4: {
                    this.buffer[this.pos + j++] = 0;
                }
                case 3: {
                    this.buffer[this.pos + j++] = 0;
                }
                case 2: {
                    this.buffer[this.pos + j++] = 0;
                }
                case 1: {
                    this.buffer[this.pos + j++] = 0;
                }
            }
            this.index += remainder;
            this.pos += remainder;
        }
    }

    private final void check(int i) {
        if (this.buffer == null || this.pos + i + 2 > this.buffer.length) {
            byte[] new_buf = this.bufMgr.getBuffer(this.pos + i + 2, true);
            if (this.buffer != null) {
                System.arraycopy(this.buffer, 0, new_buf, 0, this.pos);
            }
            this.bufMgr.returnBuffer(this.buffer, true);
            this.buffer = new_buf;
            java.lang.Object var2_2 = null;
        }
    }

    private static final void _write4int(byte[] buf, int _pos, int value) {
        buf[_pos] = (byte)(value >> 24 & 0xFF);
        buf[_pos + 1] = (byte)(value >> 16 & 0xFF);
        buf[_pos + 2] = (byte)(value >> 8 & 0xFF);
        buf[_pos + 3] = (byte)(value & 0xFF);
    }

    public final void beginEncapsulation() {
        this.check(8, 4);
        this.pos += 4;
        this.index += 4;
        this.getEncapsStack().push(new EncapsInfo(this.index, this.encaps_start, this.getValueMap(), this.getRepIdMap(), this.getCodebaseMap()));
        this.valueMap = ObjectUtil.createIdentityHashMap();
        this.repIdMap = new HashMap();
        this.codebaseMap = new HashMap();
        this.encaps_start = this.pos;
        this.beginEncapsulatedArray();
    }

    public final void beginEncapsulatedArray() {
        this.resetIndex();
        this.buffer[this.pos++] = 0;
        ++this.index;
    }

    public final void endEncapsulation() {
        if (this.encaps_start == -1) {
            throw new MARSHAL("Too many end-of-encapsulations");
        }
        if (this.encaps_stack == null) {
            throw new MARSHAL("Internal Error - closeEncapsulation failed");
        }
        int encaps_size = this.pos - this.encaps_start;
        this.buffer[this.encaps_start - 4] = (byte)(encaps_size >>> 24 & 0xFF);
        this.buffer[this.encaps_start - 3] = (byte)(encaps_size >>> 16 & 0xFF);
        this.buffer[this.encaps_start - 2] = (byte)(encaps_size >>> 8 & 0xFF);
        this.buffer[this.encaps_start - 1] = (byte)(encaps_size & 0xFF);
        EncapsInfo ei = (EncapsInfo)this.getEncapsStack().pop();
        this.encaps_start = ei.start;
        this.index = ei.index + encaps_size;
        this.valueMap = ei.valueMap;
        this.repIdMap = ei.repIdMap;
        this.codebaseMap = ei.codebaseMap;
    }

    public byte[] getBufferCopy() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.write(bos, 0, this.size());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    private void resetIndex() {
        this.index = 0;
    }

    public int size() {
        return this.pos + this.deferred_writes;
    }

    public void reset() {
        if (this.deferredArrayQueue != null) {
            this.deferredArrayQueue.clear();
        }
        this.pos = 0;
        this.deferred_writes = 0;
        this.index = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.bufMgr.returnBuffer(this.buffer, true);
        }
        finally {
            super.finalize();
        }
    }

    public final void skip(int step) {
        this.pos += step;
        this.index += step;
    }

    public final void reduceSize(int amount) {
        this.pos -= amount;
    }

    public final void increaseSize(int amount) {
        this.pos += amount;
        this.check(amount);
    }

    public void setBuffer(byte[] b) {
        this.bufMgr.returnBuffer(this.buffer, true);
        this.buffer = b;
        this.reset();
    }

    public void setBufferWithoutReset(byte[] b, int size) {
        this.close();
        this.buffer = b;
        this.pos = size;
    }

    public org.omg.CORBA.portable.InputStream create_input_stream() {
        if (this.deferred_writes > 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.index + 1);
            try {
                this.write(baos, 0, this.index);
            }
            catch (IOException e) {
                throw new MARSHAL(e.toString());
            }
            return new CDRInputStream(this.orb, baos.toByteArray());
        }
        byte[] result = new byte[this.index + 1];
        System.arraycopy(this.buffer, 0, result, 0, result.length);
        return new CDRInputStream(this.orb, result);
    }

    public final void write_any(Any value) {
        this.write_TypeCode(value.type());
        value.write_value(this);
    }

    public final void write_boolean(boolean value) {
        this.check(1);
        this.buffer[this.pos++] = value ? (byte)1 : 0;
        ++this.index;
    }

    public final void write_boolean_array(boolean[] value, int offset, int length) {
        if (value != null) {
            this.check(length);
            for (int i = offset; i < offset + length; ++i) {
                this.buffer[this.pos++] = value[i] ? (byte)1 : 0;
            }
            this.index += length;
        }
    }

    public final void write_char(char c) {
        int too_large_mask;
        this.check(1);
        int n = too_large_mask = this.codeSet == 65537 ? 65280 : 65408;
        if ((c & too_large_mask) != 0) {
            throw new DATA_CONVERSION("char (" + c + ") out of range for " + CodeSet.csName(this.codeSet));
        }
        ++this.index;
        this.buffer[this.pos++] = (byte)c;
    }

    public final void write_char_array(char[] value, int offset, int length) {
        if (value == null) {
            throw new MARSHAL("Null References");
        }
        this.check(length);
        int too_large_mask = this.codeSet == 65537 ? 65280 : 65408;
        for (int i = offset; i < offset + length; ++i) {
            if ((value[i] & too_large_mask) != 0) {
                throw new MARSHAL("char (" + value[i] + ") out of range for " + CodeSet.csName(this.codeSet));
            }
            this.buffer[this.pos++] = (byte)value[i];
        }
        this.index += length;
    }

    public final void write_string(String s) {
        if (s == null) {
            throw new MARSHAL("Null References");
        }
        int size = 4 + s.length() + 1;
        this.check(size, 4);
        int sizepos = this.pos;
        this.pos += 4;
        this.index += 4;
        for (int i = 0; i < s.length(); ++i) {
            this.write_char_i(s.charAt(i), false, false, this.codeSet);
        }
        this.buffer[this.pos++] = 0;
        ++this.index;
        size = this.pos - (sizepos + 4);
        CDROutputStream._write4int(this.buffer, sizepos, size);
    }

    public final void write_wchar(char c) {
        this.check(3);
        this.write_char_i(c, this.useBOM, true, this.codeSetW);
    }

    private final void write_char_i(char c, boolean write_bom, boolean write_length_indicator, int cs) {
        switch (cs) {
            case 65537: {
                this.buffer[this.pos++] = (byte)c;
                ++this.index;
                break;
            }
            case 0x5010001: {
                if (c <= '\u007f') {
                    if (this.giop_minor == 2 && write_length_indicator) {
                        this.write_octet((byte)1);
                    }
                    this.buffer[this.pos++] = (byte)c;
                    ++this.index;
                    break;
                }
                if (c > '\u07ff') {
                    if (this.giop_minor == 2 && write_length_indicator) {
                        this.write_octet((byte)3);
                    }
                    this.buffer[this.pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                    this.buffer[this.pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                    this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                    this.index += 3;
                    break;
                }
                if (this.giop_minor == 2 && write_length_indicator) {
                    this.write_octet((byte)2);
                }
                this.buffer[this.pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                this.index += 2;
                break;
            }
            case 65801: {
                if (this.giop_minor == 2) {
                    if (write_length_indicator) {
                        this.write_octet((byte)2);
                    }
                    if (write_bom) {
                        this.buffer[this.pos++] = -2;
                        this.buffer[this.pos++] = -1;
                        this.index += 2;
                    }
                    this.buffer[this.pos++] = (byte)(c >> 8 & 0xFF);
                    this.buffer[this.pos++] = (byte)(c & 0xFF);
                    this.index += 2;
                    break;
                }
                this.write_short((short)c);
                break;
            }
            default: {
                throw new CODESET_INCOMPATIBLE("Bad codeset: " + this.codeSet);
            }
        }
    }

    public final void write_wchar_array(char[] value, int offset, int length) {
        if (value == null) {
            throw new MARSHAL("Null References");
        }
        this.check(length * 3);
        for (int i = offset; i < offset + length; ++i) {
            this.write_wchar(value[i]);
        }
    }

    public final void write_wstring(String s) {
        if (s == null) {
            throw new MARSHAL("Null References");
        }
        this.check(4 + s.length() * 3 + 3, 4);
        int startPos = this.pos;
        this.pos += 4;
        this.index += 4;
        if (this.giop_minor == 2 && this.useBOM && s.length() > 0) {
            this.buffer[this.pos++] = -2;
            this.buffer[this.pos++] = -1;
            this.index += 2;
        }
        for (int i = 0; i < s.length(); ++i) {
            this.write_char_i(s.charAt(i), false, false, this.codeSetW);
        }
        if (this.giop_minor < 2) {
            this.write_char_i('\u0000', false, false, this.codeSetW);
        }
        int str_size = 0;
        if (this.giop_minor == 2) {
            str_size = this.pos - startPos - 4;
        } else if (this.codeSetW == 0x5010001) {
            str_size = this.pos - startPos - 4;
        } else if (this.codeSetW == 65801) {
            str_size = s.length() + 1;
        }
        CDROutputStream._write4int(this.buffer, startPos, str_size);
    }

    public final void write_double(double value) {
        this.write_longlong(Double.doubleToLongBits(value));
    }

    public final void write_double_array(double[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(7 + length * 8, 8);
        if (value != null) {
            for (int i = offset; i < offset + length; ++i) {
                long d = Double.doubleToLongBits(value[i]);
                this.buffer[this.pos] = (byte)(d >>> 56 & 0xFFL);
                this.buffer[this.pos + 1] = (byte)(d >>> 48 & 0xFFL);
                this.buffer[this.pos + 2] = (byte)(d >>> 40 & 0xFFL);
                this.buffer[this.pos + 3] = (byte)(d >>> 32 & 0xFFL);
                this.buffer[this.pos + 4] = (byte)(d >>> 24 & 0xFFL);
                this.buffer[this.pos + 5] = (byte)(d >>> 16 & 0xFFL);
                this.buffer[this.pos + 6] = (byte)(d >>> 8 & 0xFFL);
                this.buffer[this.pos + 7] = (byte)(d & 0xFFL);
                this.pos += 8;
            }
            this.index += 8 * length;
        }
    }

    public final void write_fixed(BigDecimal value) {
        int b;
        byte[] representation;
        String v = value.unscaledValue().toString();
        if (v.startsWith("-")) {
            v = v.substring(1);
        }
        if (v.length() % 2 == 0) {
            representation = new byte[v.length() / 2 + 1];
            representation[0] = 0;
            for (int i = 0; i < v.length(); ++i) {
                int c = Character.digit(v.charAt(i), 10);
                b = representation[(1 + i) / 2] << 4;
                representation[(1 + i) / 2] = (byte)(b |= c);
            }
        } else {
            representation = new byte[(v.length() + 1) / 2];
            for (int i = 0; i < v.length(); ++i) {
                int c = Character.digit(v.charAt(i), 10);
                b = representation[i / 2] << 4;
                representation[i / 2] = (byte)(b |= c);
            }
        }
        b = representation[representation.length - 1] << 4;
        representation[representation.length - 1] = (byte)(value.signum() < 0 ? b | 0xD : b | 0xC);
        this.check(representation.length);
        System.arraycopy(representation, 0, this.buffer, this.pos, representation.length);
        this.index += representation.length;
        this.pos += representation.length;
    }

    public final void write_float(float value) {
        this.write_long(Float.floatToIntBits(value));
    }

    public final void write_float_array(float[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(3 + length * 4, 4);
        if (value != null) {
            for (int i = offset; i < offset + length; ++i) {
                CDROutputStream._write4int(this.buffer, this.pos, Float.floatToIntBits(value[i]));
                this.pos += 4;
            }
            this.index += 4 * length;
        }
    }

    public final void write_long(int value) {
        this.check(7, 4);
        CDROutputStream._write4int(this.buffer, this.pos, value);
        this.pos += 4;
        this.index += 4;
    }

    public final void write_long_array(int[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(3 + length * 4, 4);
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (value != null) {
            for (int i = offset; i < offset + length; ++i) {
                CDROutputStream._write4int(this.buffer, this.pos, value[i]);
                this.pos += 4;
            }
            this.index += 4 * length;
        }
    }

    public final void write_longlong(long value) {
        this.check(15, 8);
        this.buffer[this.pos] = (byte)(value >>> 56 & 0xFFL);
        this.buffer[this.pos + 1] = (byte)(value >>> 48 & 0xFFL);
        this.buffer[this.pos + 2] = (byte)(value >>> 40 & 0xFFL);
        this.buffer[this.pos + 3] = (byte)(value >>> 32 & 0xFFL);
        this.buffer[this.pos + 4] = (byte)(value >>> 24 & 0xFFL);
        this.buffer[this.pos + 5] = (byte)(value >>> 16 & 0xFFL);
        this.buffer[this.pos + 6] = (byte)(value >>> 8 & 0xFFL);
        this.buffer[this.pos + 7] = (byte)(value & 0xFFL);
        this.index += 8;
        this.pos += 8;
    }

    public final void write_longlong_array(long[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(7 + length * 8, 8);
        if (value != null) {
            for (int i = offset; i < offset + length; ++i) {
                this.buffer[this.pos] = (byte)(value[i] >>> 56 & 0xFFL);
                this.buffer[this.pos + 1] = (byte)(value[i] >>> 48 & 0xFFL);
                this.buffer[this.pos + 2] = (byte)(value[i] >>> 40 & 0xFFL);
                this.buffer[this.pos + 3] = (byte)(value[i] >>> 32 & 0xFFL);
                this.buffer[this.pos + 4] = (byte)(value[i] >>> 24 & 0xFFL);
                this.buffer[this.pos + 5] = (byte)(value[i] >>> 16 & 0xFFL);
                this.buffer[this.pos + 6] = (byte)(value[i] >>> 8 & 0xFFL);
                this.buffer[this.pos + 7] = (byte)(value[i] & 0xFFL);
                this.pos += 8;
            }
            this.index += 8 * length;
        }
    }

    public void write_Object(Object value) {
        if (value == null) {
            IORHelper.write(this, null_ior);
        } else {
            if (value instanceof LocalObject) {
                throw new MARSHAL("Attempt to serialize a locality-constrained object.");
            }
            ObjectImpl obj = (ObjectImpl)value;
            IORHelper.write(this, ((Delegate)obj._get_delegate()).getIOR());
        }
    }

    public void write_IOR(IOR ior) {
        if (ior == null) {
            IORHelper.write(this, null_ior);
        } else {
            IORHelper.write(this, ior);
        }
    }

    public final void write_octet(byte value) {
        this.check(1);
        ++this.index;
        this.buffer[this.pos++] = value;
    }

    public final void write_octet_array(byte[] value, int offset, int length) {
        if (value != null) {
            if (length > 4000) {
                this.deferredArrayQueue.add(new DeferredWriteFrame(this.index, offset, length, value));
                this.index += length;
                this.deferred_writes += length;
            } else {
                this.check(length);
                System.arraycopy(value, offset, this.buffer, this.pos, length);
                this.index += length;
                this.pos += length;
            }
        }
    }

    public final void write_Principal(Principal value) {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    public final void write_short(short value) {
        this.check(3, 2);
        this.buffer[this.pos] = (byte)(value >> 8 & 0xFF);
        this.buffer[this.pos + 1] = (byte)(value & 0xFF);
        this.index += 2;
        this.pos += 2;
    }

    public final void write_short_array(short[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(2 * length + 3);
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (value != null) {
            for (int i = offset; i < offset + length; ++i) {
                this.buffer[this.pos] = (byte)(value[i] >>> 8 & 0xFF);
                this.buffer[this.pos + 1] = (byte)(value[i] & 0xFF);
                this.pos += 2;
            }
            this.index += 2 * length;
        }
    }

    public final void write_TypeCode(org.omg.CORBA.TypeCode value) {
        String id = null;
        org.omg.CORBA.TypeCode cached = null;
        try {
            id = value.id();
        }
        catch (BadKind e) {
            // empty catch block
        }
        if (this.compactTypeCodes > 0 && id != null) {
            if (this.cachedTypecodes == null) {
                this.cachedTypecodes = new HashMap();
            } else {
                cached = (org.omg.CORBA.TypeCode)this.cachedTypecodes.get(id);
            }
            if (cached == null) {
                value = value.get_compact_typecode();
                this.cachedTypecodes.put(id, value);
            } else {
                value = cached;
            }
        }
        this.write_TypeCode(value, null);
    }

    private final void writeRecursiveTypeCode(org.omg.CORBA.TypeCode value, Map tcMap) throws BadKind {
        this.write_long(-1);
        int negative_offset = (Integer)tcMap.get(value.id()) - this.size() - 4;
        this.write_long(negative_offset);
    }

    private final void write_TypeCode(org.omg.CORBA.TypeCode value, Map tcMap) {
        if (value == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        int _kind = value.kind().value();
        try {
            if (TypeCode.isRecursive(value) && tcMap != null && tcMap.containsKey(value.id())) {
                this.writeRecursiveTypeCode(value, tcMap);
            } else {
                switch (_kind) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: {
                        this.write_long(_kind);
                        break;
                    }
                    case 14: {
                        this.write_long(_kind);
                        this.beginEncapsulation();
                        this.write_string(value.id());
                        this.write_string(value.name());
                        this.endEncapsulation();
                        break;
                    }
                    case 15: 
                    case 22: {
                        if (this.useIndirection && tcMap != null && tcMap.containsKey(value.id())) {
                            this.writeRecursiveTypeCode(value, tcMap);
                            break;
                        }
                        this.write_long(_kind);
                        if (tcMap == null) {
                            tcMap = new HashMap<String, Integer>();
                        }
                        tcMap.put(value.id(), new Integer(this.pos));
                        this.getRecursiveTCMap().put(value.id(), value);
                        this.beginEncapsulation();
                        this.write_string(value.id());
                        this.write_string(value.name());
                        int _mc = value.member_count();
                        this.write_long(_mc);
                        for (int i = 0; i < _mc; ++i) {
                            this.write_string(value.member_name(i));
                            this.write_TypeCode(value.member_type(i), tcMap);
                        }
                        this.endEncapsulation();
                        break;
                    }
                    case 17: {
                        if (this.useIndirection && tcMap != null && tcMap.containsKey(value.id())) {
                            this.writeRecursiveTypeCode(value, tcMap);
                            break;
                        }
                        this.write_long(_kind);
                        if (tcMap == null) {
                            tcMap = new HashMap();
                        }
                        tcMap.put(value.id(), new Integer(this.pos));
                        this.getRecursiveTCMap().put(value.id(), value);
                        this.beginEncapsulation();
                        this.write_string(value.id());
                        this.write_string(value.name());
                        int _mc = value.member_count();
                        this.write_long(_mc);
                        for (int i = 0; i < _mc; ++i) {
                            this.write_string(value.member_name(i));
                        }
                        this.endEncapsulation();
                        break;
                    }
                    case 16: {
                        if (this.useIndirection && tcMap != null && tcMap.containsKey(value.id())) {
                            this.writeRecursiveTypeCode(value, tcMap);
                            break;
                        }
                        this.write_long(_kind);
                        if (tcMap == null) {
                            tcMap = new HashMap();
                        }
                        tcMap.put(value.id(), new Integer(this.pos));
                        this.getRecursiveTCMap().put(value.id(), value);
                        this.beginEncapsulation();
                        this.write_string(value.id());
                        this.write_string(value.name());
                        this.write_TypeCode(value.discriminator_type());
                        this.write_long(value.default_index());
                        int _mc = value.member_count();
                        this.write_long(_mc);
                        for (int i = 0; i < _mc; ++i) {
                            if (i == value.default_index()) {
                                this.write_octet((byte)0);
                            } else {
                                value.member_label(i).write_value(this);
                            }
                            this.write_string(value.member_name(i));
                            this.write_TypeCode(value.member_type(i), tcMap);
                        }
                        this.endEncapsulation();
                        break;
                    }
                    case 18: 
                    case 27: {
                        this.write_long(_kind);
                        this.write_long(value.length());
                        break;
                    }
                    case 28: {
                        this.write_long(_kind);
                        this.write_ushort(value.fixed_digits());
                        this.write_short(value.fixed_scale());
                        break;
                    }
                    case 19: 
                    case 20: {
                        this.write_long(_kind);
                        this.beginEncapsulation();
                        this.write_TypeCode(value.content_type(), tcMap);
                        this.write_long(value.length());
                        this.endEncapsulation();
                        break;
                    }
                    case 21: {
                        if (this.useIndirection && tcMap != null && tcMap.containsKey(value.id())) {
                            this.writeRecursiveTypeCode(value, tcMap);
                            break;
                        }
                        this.write_long(_kind);
                        if (tcMap == null) {
                            tcMap = new HashMap();
                        }
                        tcMap.put(value.id(), new Integer(this.pos));
                        this.getRecursiveTCMap().put(value.id(), value);
                        this.beginEncapsulation();
                        this.write_string(value.id());
                        this.write_string(value.name());
                        this.write_TypeCode(value.content_type(), tcMap);
                        this.endEncapsulation();
                        break;
                    }
                    case 29: {
                        if (this.useIndirection && tcMap != null && tcMap.containsKey(value.id())) {
                            this.writeRecursiveTypeCode(value, tcMap);
                            break;
                        }
                        this.write_long(_kind);
                        if (tcMap == null) {
                            tcMap = new HashMap();
                        }
                        tcMap.put(value.id(), new Integer(this.pos));
                        this.getRecursiveTCMap().put(value.id(), value);
                        this.beginEncapsulation();
                        this.write_string(value.id());
                        this.write_string(value.name());
                        this.write_short(value.type_modifier());
                        org.omg.CORBA.TypeCode base = value.concrete_base_type();
                        if (base != null) {
                            this.write_TypeCode(base, tcMap);
                        } else {
                            this.write_long(0);
                        }
                        int _mc = value.member_count();
                        this.write_long(_mc);
                        for (int i = 0; i < _mc; ++i) {
                            this.write_string(value.member_name(i));
                            this.write_TypeCode(value.member_type(i), tcMap);
                            this.write_short(value.member_visibility(i));
                        }
                        this.endEncapsulation();
                        break;
                    }
                    case 30: {
                        if (this.useIndirection && tcMap != null && tcMap.containsKey(value.id())) {
                            this.writeRecursiveTypeCode(value, tcMap);
                            break;
                        }
                        this.write_long(_kind);
                        if (tcMap == null) {
                            tcMap = new HashMap();
                        }
                        tcMap.put(value.id(), new Integer(this.pos));
                        this.getRecursiveTCMap().put(value.id(), value);
                        this.beginEncapsulation();
                        this.write_string(value.id());
                        this.write_string(value.name());
                        this.write_TypeCode(value.content_type(), tcMap);
                        this.endEncapsulation();
                        break;
                    }
                    case 32: {
                        if (this.useIndirection && tcMap != null && tcMap.containsKey(value.id())) {
                            this.writeRecursiveTypeCode(value, tcMap);
                            break;
                        }
                        this.write_long(_kind);
                        if (tcMap == null) {
                            tcMap = new HashMap();
                        }
                        tcMap.put(value.id(), new Integer(this.pos));
                        this.getRecursiveTCMap().put(value.id(), value);
                        this.beginEncapsulation();
                        this.write_string(value.id());
                        this.write_string(value.name());
                        this.endEncapsulation();
                        break;
                    }
                    default: {
                        throw new MARSHAL("Cannot handle TypeCode with kind: " + _kind);
                    }
                }
            }
        }
        catch (BadKind ex) {
            throw new MARSHAL("When processing TypeCode with kind: " + _kind + " caught " + ex);
        }
        catch (Bounds ex) {
            throw new MARSHAL("When processing TypeCode with kind: " + _kind + " caught " + ex);
        }
    }

    public final void write_ulong(int value) {
        this.write_long(value);
    }

    public final void write_ulong_array(int[] value, int offset, int length) {
        this.write_long_array(value, offset, length);
    }

    public final void write_ulonglong(long value) {
        this.write_longlong(value);
    }

    public final void write_ulonglong_array(long[] value, int offset, int length) {
        this.write_longlong_array(value, offset, length);
    }

    public final void write_ushort(short value) {
        this.write_short(value);
    }

    public final void write_ushort_array(short[] value, int offset, int length) {
        this.write_short_array(value, offset, length);
    }

    public void resizeBuffer(int size) {
        this.buffer = new byte[size];
        this.index = 0;
        this.pos = 0;
    }

    public final void write_float_no_check(float value) {
        int valuef = Float.floatToIntBits(value);
        CDROutputStream._write4int(this.buffer, this.pos, valuef);
        this.pos += 4;
        this.index += 4;
    }

    public final void write_long_no_check(int value) {
        CDROutputStream._write4int(this.buffer, this.pos, value);
        this.pos += 4;
        this.index += 4;
    }

    public final void write_short_no_check(short value) {
        this.buffer[this.pos] = (byte)(value >> 8 & 0xFF);
        this.buffer[this.pos + 1] = (byte)(value & 0xFF);
        this.index += 2;
        this.pos += 2;
    }

    public final void write_double_no_check(double value) {
        long lvalue = Double.doubleToLongBits(value);
        this.buffer[this.pos] = (byte)(lvalue >>> 56 & 0xFFL);
        this.buffer[this.pos + 1] = (byte)(lvalue >>> 48 & 0xFFL);
        this.buffer[this.pos + 2] = (byte)(lvalue >>> 40 & 0xFFL);
        this.buffer[this.pos + 3] = (byte)(lvalue >>> 32 & 0xFFL);
        this.buffer[this.pos + 4] = (byte)(lvalue >>> 24 & 0xFFL);
        this.buffer[this.pos + 5] = (byte)(lvalue >>> 16 & 0xFFL);
        this.buffer[this.pos + 6] = (byte)(lvalue >>> 8 & 0xFFL);
        this.buffer[this.pos + 7] = (byte)(lvalue & 0xFFL);
        this.index += 8;
        this.pos += 8;
    }

    public final void write_value(org.omg.CORBA.TypeCode tc, org.omg.CORBA.portable.InputStream in) {
        block75: {
            if (tc == null) {
                throw new BAD_PARAM("TypeCode is null");
            }
            int kind = tc.kind().value();
            try {
                switch (kind) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 8: {
                        this.write_boolean(in.read_boolean());
                        break;
                    }
                    case 9: {
                        this.write_char(in.read_char());
                        break;
                    }
                    case 26: {
                        this.write_wchar(in.read_wchar());
                        break;
                    }
                    case 10: {
                        this.write_octet(in.read_octet());
                        break;
                    }
                    case 2: {
                        this.write_short(in.read_short());
                        break;
                    }
                    case 4: {
                        this.write_ushort(in.read_ushort());
                        break;
                    }
                    case 3: {
                        this.write_long(in.read_long());
                        break;
                    }
                    case 5: {
                        this.write_ulong(in.read_ulong());
                        break;
                    }
                    case 6: {
                        this.write_float(in.read_float());
                        break;
                    }
                    case 7: {
                        this.write_double(in.read_double());
                        break;
                    }
                    case 23: {
                        this.write_longlong(in.read_longlong());
                        break;
                    }
                    case 24: {
                        this.write_ulonglong(in.read_ulonglong());
                        break;
                    }
                    case 11: {
                        this.write_any(in.read_any());
                        break;
                    }
                    case 12: {
                        this.write_TypeCode(in.read_TypeCode());
                        break;
                    }
                    case 13: {
                        throw new NO_IMPLEMENT("Principal deprecated");
                    }
                    case 14: {
                        this.write_Object(in.read_Object());
                        break;
                    }
                    case 18: {
                        this.write_string(in.read_string());
                        break;
                    }
                    case 27: {
                        this.write_wstring(in.read_wstring());
                        break;
                    }
                    case 28: {
                        this.write_fixed(in.read_fixed());
                        break;
                    }
                    case 20: {
                        int length = tc.length();
                        if (tc.content_type().kind().value() == 10) {
                            this.check(length);
                            in.read_octet_array(this.buffer, this.pos, length);
                            this.index += length;
                            this.pos += length;
                            break;
                        }
                        for (int i = 0; i < length; ++i) {
                            this.write_value(tc.content_type(), in);
                        }
                        break;
                    }
                    case 19: {
                        int len = in.read_long();
                        org.omg.CORBA.TypeCode content_tc = tc.content_type();
                        switch (content_tc.kind().value()) {
                            case 9: 
                            case 10: {
                                this.resizeBuffer(len + 4);
                                this.write_long(len);
                                for (int i = 0; i < len; ++i) {
                                    this.buffer[this.pos++] = (byte)in.read_char();
                                }
                                this.index += len;
                                break;
                            }
                            case 2: 
                            case 4: {
                                this.resizeBuffer(len * 2 + 4);
                                this.write_long(len);
                                for (int i = 0; i < len; ++i) {
                                    this.write_short_no_check(in.read_short());
                                }
                                break block75;
                            }
                            case 3: 
                            case 5: {
                                this.resizeBuffer(len * 4 + 4);
                                this.write_long(len);
                                for (int i = 0; i < len; ++i) {
                                    this.write_long_no_check(in.read_long());
                                }
                                break block75;
                            }
                            case 6: {
                                this.resizeBuffer(len * 4 + 4);
                                this.write_long(len);
                                for (int i = 0; i < len; ++i) {
                                    this.write_float_no_check(in.read_float());
                                }
                                break block75;
                            }
                            case 7: {
                                this.resizeBuffer(len * 8 + 8);
                                this.write_long(len);
                                this.write_long(0);
                                for (int i = 0; i < len; ++i) {
                                    this.write_double_no_check(in.read_double());
                                }
                                break block75;
                            }
                            default: {
                                this.write_long(len);
                                for (int i = 0; i < len; ++i) {
                                    this.write_value(content_tc, in);
                                }
                                break block75;
                            }
                        }
                        break;
                    }
                    case 22: {
                        this.write_string(in.read_string());
                    }
                    case 15: {
                        for (int i = 0; i < tc.member_count(); ++i) {
                            this.write_value(tc.member_type(i), in);
                        }
                        break;
                    }
                    case 17: {
                        this.write_long(in.read_long());
                        break;
                    }
                    case 16: {
                        org.omg.CORBA.TypeCode disc = tc.discriminator_type();
                        disc = TypeCode.originalType(disc);
                        int def_idx = tc.default_index();
                        int member_idx = -1;
                        block39 : switch (disc.kind().value()) {
                            case 2: {
                                short s = in.read_short();
                                this.write_short(s);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == def_idx || s != tc.member_label(i).extract_short()) continue;
                                    member_idx = i;
                                    break block39;
                                }
                                break;
                            }
                            case 4: {
                                short s = in.read_ushort();
                                this.write_ushort(s);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == def_idx || s != tc.member_label(i).extract_ushort()) continue;
                                    member_idx = i;
                                    break block39;
                                }
                                break;
                            }
                            case 3: {
                                int s = in.read_long();
                                this.write_long(s);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == def_idx || s != tc.member_label(i).extract_long()) continue;
                                    member_idx = i;
                                    break block39;
                                }
                                break;
                            }
                            case 5: {
                                int s = in.read_ulong();
                                this.write_ulong(s);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == def_idx || s != tc.member_label(i).extract_ulong()) continue;
                                    member_idx = i;
                                    break block39;
                                }
                                break;
                            }
                            case 23: {
                                long s = in.read_longlong();
                                this.write_longlong(s);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == def_idx || s != tc.member_label(i).extract_longlong()) continue;
                                    member_idx = i;
                                    break block39;
                                }
                                break;
                            }
                            case 24: {
                                long s = in.read_ulonglong();
                                this.write_ulonglong(s);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == def_idx || s != tc.member_label(i).extract_ulonglong()) continue;
                                    member_idx = i;
                                    break block39;
                                }
                                break;
                            }
                            case 8: {
                                boolean s = in.read_boolean();
                                this.write_boolean(s);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == def_idx || s != tc.member_label(i).extract_boolean()) continue;
                                    member_idx = i;
                                    break block39;
                                }
                                break;
                            }
                            case 17: {
                                int s = in.read_long();
                                this.write_long(s);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    int label;
                                    if (i == def_idx || s != (label = tc.member_label(i).create_input_stream().read_long())) continue;
                                    member_idx = i;
                                    break block39;
                                }
                                break;
                            }
                            case 9: {
                                char s = in.read_char();
                                this.write_char(s);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == def_idx || s != tc.member_label(i).extract_char()) continue;
                                    member_idx = i;
                                    break block39;
                                }
                                break;
                            }
                            default: {
                                throw new MARSHAL("Invalid union discriminator type: " + disc);
                            }
                        }
                        if (member_idx != -1) {
                            this.write_value(tc.member_type(member_idx), in);
                            break;
                        }
                        if (def_idx != -1) {
                            this.write_value(tc.member_type(def_idx), in);
                        }
                        break;
                    }
                    case 21: {
                        this.write_value(tc.content_type(), in);
                        break;
                    }
                    case 30: {
                        String id = tc.id();
                        BoxedValueHelper helper = ((ORB)this.orb).getBoxedValueHelper(id);
                        if (helper == null) {
                            throw new RuntimeException("No BoxedValueHelper for id " + id);
                        }
                        Serializable value = ((InputStream)in).read_value(helper);
                        this.write_value(value, helper);
                        break;
                    }
                    case -1: {
                        org.omg.CORBA.TypeCode _tc = (org.omg.CORBA.TypeCode)this.getRecursiveTCMap().get(tc.id());
                        if (_tc == null) {
                            throw new MARSHAL("Recursive TypeCode not found for " + tc.id());
                        }
                        this.write_value(_tc, in);
                        break;
                    }
                    default: {
                        throw new MARSHAL("Cannot handle TypeCode with kind " + kind);
                    }
                }
            }
            catch (BadKind ex) {
                throw new MARSHAL("When processing TypeCode with kind: " + kind + " caught " + ex);
            }
            catch (Bounds ex) {
                throw new MARSHAL("When processing TypeCode with kind: " + kind + " caught " + ex);
            }
        }
    }

    public void write_value(Serializable value) {
        if (!this.write_special_value(value)) {
            this.write_value_internal(value, ValueHandler.getRMIRepositoryID(value.getClass()));
        }
    }

    public void write_value(Serializable value, BoxedValueHelper factory) {
        if (!this.write_special_value(value)) {
            this.check(7, 4);
            this.getValueMap().put(value, new Integer(this.pos));
            this.write_previous_chunk_size();
            if (value instanceof IDLEntity || value instanceof String) {
                this.write_long(0x7FFFFF00 | this.chunkingFlag);
            } else {
                this.write_long(0x7FFFFF02 | this.chunkingFlag);
                this.write_repository_id(RepositoryID.repId(value.getClass()));
            }
            this.start_chunk();
            factory.write_value(this, value);
            this.end_chunk();
        }
    }

    public void write_value(Serializable value, Class clz) {
        if (!this.write_special_value(value)) {
            Class<?> c = value.getClass();
            String repId = ValueHandler.getRMIRepositoryID(c);
            if (c == clz && !repId.startsWith("RMI:")) {
                this.write_value_internal(value, null);
            } else if (clz.isInstance(value)) {
                this.write_value_internal(value, repId);
            } else {
                throw new BAD_PARAM();
            }
        }
    }

    public void write_value(Serializable value, String repository_id) {
        if (!this.write_special_value(value)) {
            this.write_value_internal(value, repository_id);
        }
    }

    private boolean write_special_value(Serializable value) {
        if (value == null) {
            this.write_long(0);
            return true;
        }
        Integer index = (Integer)this.getValueMap().get(value);
        if (index != null) {
            this.write_long(-1);
            this.write_long(index - this.size());
            return true;
        }
        return false;
    }

    private void write_repository_id(String repository_id) {
        Integer _index = (Integer)this.getRepIdMap().get(repository_id);
        if (_index == null) {
            int remainder = 4 - this.index % 4;
            if (remainder != 4) {
                this.index += remainder;
                this.pos += remainder;
            }
            this.getRepIdMap().put(repository_id, new Integer(this.pos));
            this.write_string(repository_id);
        } else {
            this.write_long(-1);
            this.write_long(_index - this.size());
        }
    }

    private void write_codebase(String codebase) {
        Integer _index = null;
        if (this.codebaseMap == null) {
            this.codebaseMap = new HashMap();
        } else {
            _index = (Integer)this.getCodebaseMap().get(codebase);
        }
        if (_index == null) {
            int remainder = 4 - this.index % 4;
            if (remainder != 4) {
                this.index += remainder;
                this.pos += remainder;
            }
            this.getCodebaseMap().put(codebase, new Integer(this.pos));
            this.write_string(codebase);
        } else {
            this.write_long(-1);
            this.write_long(_index - this.size());
        }
    }

    private void write_value_header(String[] repository_ids) {
        this.write_previous_chunk_size();
        if (repository_ids != null) {
            if (repository_ids.length > 1) {
                this.chunkingFlag = 8;
                this.write_long(0x7FFFFF06 | this.chunkingFlag);
                this.write_long(repository_ids.length);
                for (int i = 0; i < repository_ids.length; ++i) {
                    this.write_repository_id(repository_ids[i]);
                }
            } else {
                this.write_long(0x7FFFFF02 | this.chunkingFlag);
                this.write_repository_id(repository_ids[0]);
            }
        } else {
            this.write_long(0x7FFFFF00 | this.chunkingFlag);
        }
    }

    private void write_value_header(String[] repository_ids, String codebase) {
        if (codebase != null) {
            this.write_previous_chunk_size();
            if (repository_ids != null) {
                if (repository_ids.length > 1) {
                    this.chunkingFlag = 8;
                    this.write_long(0x7FFFFF07 | this.chunkingFlag);
                    this.write_codebase(codebase);
                    this.write_long(repository_ids.length);
                    for (int i = 0; i < repository_ids.length; ++i) {
                        this.write_repository_id(repository_ids[i]);
                    }
                } else {
                    this.write_long(0x7FFFFF03 | this.chunkingFlag);
                    this.write_codebase(codebase);
                    this.write_repository_id(repository_ids[0]);
                }
            } else {
                this.write_long(0x7FFFFF01 | this.chunkingFlag);
                this.write_codebase(codebase);
            }
        } else {
            this.write_value_header(repository_ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write_value_internal(Serializable value, String repository_id) {
        this.check(7, 4);
        this.getValueMap().put(value, new Integer(this.pos));
        if (value.getClass() == (class$java$lang$String == null ? (class$java$lang$String = CDROutputStream.class$("java.lang.String")) : class$java$lang$String)) {
            String[] stringArray;
            if (repository_id == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = repository_id;
            }
            String[] repository_ids = stringArray;
            this.write_value_header(repository_ids);
            this.start_chunk();
            this.write_wstring((String)((java.lang.Object)value));
            this.end_chunk();
        } else if (value.getClass() == (class$java$lang$Class == null ? (class$java$lang$Class = CDROutputStream.class$("java.lang.Class")) : class$java$lang$Class)) {
            String[] repository_ids = new String[]{ValueHandler.getRMIRepositoryID(class$javax$rmi$CORBA$ClassDesc == null ? (class$javax$rmi$CORBA$ClassDesc = CDROutputStream.class$("javax.rmi.CORBA.ClassDesc")) : class$javax$rmi$CORBA$ClassDesc)};
            this.write_value_header(repository_ids);
            this.start_chunk();
            this.write_value((Serializable)((java.lang.Object)ValueHandler.getCodebase((Class)value)));
            this.write_value((Serializable)((java.lang.Object)ValueHandler.getRMIRepositoryID((Class)value)));
            this.end_chunk();
        } else if (value instanceof StreamableValue) {
            StreamableValue streamable = (StreamableValue)value;
            this.write_value_header(streamable._truncatable_ids());
            this.start_chunk();
            ((StreamableValue)value)._write(this);
            this.end_chunk();
        } else {
            String[] stringArray;
            if (repository_id == null) {
                stringArray = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = repository_id;
            }
            String[] repository_ids = stringArray;
            Class<?> cls = value.getClass();
            String codebase = ValueHandler.getCodebase(cls);
            if (value instanceof IDLEntity) {
                Method writeMethod = null;
                if (cls != (class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = CDROutputStream.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any)) {
                    String helperClassName = cls.getName() + "Helper";
                    try {
                        Class<?> helperClass = cls.getClassLoader().loadClass(helperClassName);
                        Class[] paramTypes = new Class[]{class$org$omg$CORBA$portable$OutputStream == null ? (class$org$omg$CORBA$portable$OutputStream = CDROutputStream.class$("org.omg.CORBA.portable.OutputStream")) : class$org$omg$CORBA$portable$OutputStream, cls};
                        writeMethod = helperClass.getMethod("write", paramTypes);
                    }
                    catch (ClassNotFoundException e) {
                        throw new MARSHAL("Error loading class " + helperClassName + ": " + e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new MARSHAL("No write method in helper class " + helperClassName + ": " + e);
                    }
                }
                this.write_value_header(repository_ids, codebase);
                this.start_chunk();
                if (writeMethod == null) {
                    this.write_any((Any)value);
                } else {
                    try {
                        writeMethod.invoke(null, this, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new MARSHAL("Internal error: " + e);
                    }
                    catch (InvocationTargetException e) {
                        throw new MARSHAL("Exception marshaling IDLEntity: " + e.getTargetException());
                    }
                }
                this.end_chunk();
            } else {
                try {
                    ++this.writeValueNestingLevel;
                    if (this.chunkCustomRmiValuetypes && ValueHandler.isCustomMarshaled(cls)) {
                        this.chunkingFlag = 8;
                    }
                    this.write_value_header(repository_ids, codebase);
                    this.start_chunk();
                    if (!this.writeReplaceCalled) {
                        Serializable newValue = ValueHandler.writeReplace(value);
                        this.writeReplaceCalled = true;
                        if (newValue != value) {
                            Integer index = (Integer)this.getValueMap().get(newValue);
                            if (index != null) {
                                this.write_long(-1);
                                this.write_long(index - this.size());
                            } else if (value instanceof Object) {
                                this.write_Object((Object)((java.lang.Object)newValue));
                            } else {
                                ValueHandler.writeValue(this, newValue);
                            }
                        } else {
                            ValueHandler.writeValue(this, value);
                        }
                    } else {
                        ValueHandler.writeValue(this, value);
                    }
                    this.end_chunk();
                    java.lang.Object var11_19 = null;
                    if (--this.writeValueNestingLevel == 0) {
                        this.writeReplaceCalled = false;
                    }
                }
                catch (Throwable throwable) {
                    java.lang.Object var11_20 = null;
                    if (--this.writeValueNestingLevel == 0) {
                        this.writeReplaceCalled = false;
                    }
                    throw throwable;
                }
            }
        }
    }

    private void start_chunk() {
        if (this.chunkingFlag > 0) {
            this.write_previous_chunk_size();
            ++this.valueNestingLevel;
            this.skip_chunk_size_tag();
        }
    }

    private void end_chunk() {
        if (this.chunkingFlag > 0) {
            this.write_previous_chunk_size();
            this.write_long(-this.valueNestingLevel);
            if (--this.valueNestingLevel == 0) {
                this.chunkingFlag = 0;
            } else {
                this.skip_chunk_size_tag();
            }
        }
    }

    private void write_previous_chunk_size() {
        if (this.chunk_size_tag_pos != -1) {
            if (this.pos == this.chunk_octets_pos) {
                this.pos = this.chunk_size_tag_pos;
                this.index = this.chunk_size_tag_index;
            } else {
                int current_pos = this.pos;
                int current_idx = this.index;
                this.pos = this.chunk_size_tag_pos;
                this.index = this.chunk_size_tag_index;
                this.write_long(current_pos - this.chunk_octets_pos);
                this.pos = current_pos;
                this.index = current_idx;
            }
            this.chunk_size_tag_pos = -1;
        }
    }

    private void skip_chunk_size_tag() {
        this.chunk_size_tag_pos = this.pos;
        this.chunk_size_tag_index = this.index;
        this.write_long(0);
        this.chunk_octets_pos = this.pos;
    }

    public void write_abstract_interface(java.lang.Object object) {
        if (object instanceof Object) {
            this.write_boolean(true);
            this.write_Object((Object)object);
        } else {
            this.write_boolean(false);
            this.write_value((Serializable)object);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DeferredWriteFrame {
        public int write_pos = 0;
        public int start = 0;
        public int length = 0;
        public byte[] buf = null;

        public DeferredWriteFrame(int write_pos, int start, int length, byte[] buf) {
            this.write_pos = write_pos;
            this.start = start;
            this.length = length;
            this.buf = buf;
        }
    }
}

