/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.Comparator;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.HeapEntry;

class QueueUtil {
    static final Message[] MESSAGE_ARRAY_TEMPLATE = new Message[0];
    static final HeapEntry[] HEAP_ENTRY_ARRAY_TEMPLATE = new HeapEntry[0];
    static Comparator ASCENDING_TIMEOUT_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            Message message = QueueUtil.toMessage(object);
            Message message2 = QueueUtil.toMessage(object2);
            if (message.hasTimeout()) {
                if (!message2.hasTimeout()) {
                    return -1;
                }
                return (int)(message.getTimeout() - message2.getTimeout());
            }
            if (message2.hasTimeout()) {
                return 1;
            }
            return 0;
        }
    };
    static Comparator ASCENDING_AGE_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            HeapEntry heapEntry = (HeapEntry)object;
            HeapEntry heapEntry2 = (HeapEntry)object2;
            return (int)(heapEntry.order_ - heapEntry2.order_);
        }
    };
    static Comparator DESCENDING_AGE_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return -ASCENDING_AGE_COMPARATOR.compare(object, object2);
        }
    };
    static Comparator ASCENDING_PRIORITY_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            Message message = QueueUtil.toMessage(object2);
            Message message2 = QueueUtil.toMessage(object);
            return message2.getPriority() - message.getPriority();
        }
    };
    static Comparator DESCENDING_PRIORITY_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return -ASCENDING_PRIORITY_COMPARATOR.compare(object, object2);
        }
    };

    private QueueUtil() {
    }

    static Message toMessage(Object object) {
        Message message;
        if (object instanceof HeapEntry) {
            message = ((HeapEntry)object).event_;
        } else if (object instanceof Message) {
            message = (Message)object;
        } else {
            throw new IllegalArgumentException();
        }
        return message;
    }
}

