/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.AbstractEventChannel;
import org.jacorb.notification.ChannelManager;
import org.jacorb.notification.EventChannelFactoryImpl;
import org.jacorb.notification.IFactory;
import org.jacorb.notification.TypedEventChannelFactoryImpl;
import org.jacorb.notification.container.BiDirGiopPOAComponentAdapter;
import org.jacorb.notification.container.PicoContainerFactory;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.AdminPropertySet;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyError;
import org.omg.CosNotification.PropertyRange;
import org.omg.CosNotification.QoSError_code;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ChannelNotFound;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;

public abstract class AbstractChannelFactory
implements ManageableServant,
Disposable {
    private static final String STANDARD_IMPL_NAME = "JacORB-NotificationService";
    private static final long SHUTDOWN_INTERVAL = 1000L;
    private static final String EVENTCHANNEL_FACTORY_POA_NAME = "EventChannelFactoryPOA";
    private NameComponent[] registeredName_ = null;
    private NamingContext namingContext_;
    private Runnable destroyMethod_ = new Runnable(){

        public void run() {
            AbstractChannelFactory.this.dispose();
        }
    };
    protected final MutablePicoContainer container_;
    protected final ComponentAdapterFactory componentAdapterFactory_;
    protected final Configuration config_;
    protected final Object thisRef_;
    protected final Logger logger_;
    private final String ior_;
    private final String corbaLoc_;
    private final POA eventChannelFactoryPOA_;
    private final ChannelManager channelManager_ = new ChannelManager();
    private final SynchronizedInt eventChannelIDPool_ = new SynchronizedInt(-1);
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Configuration;
    static /* synthetic */ Class class$org$picocontainer$defaults$ComponentAdapterFactory;
    static /* synthetic */ Class class$org$omg$PortableServer$POA;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$org$jacorb$notification$IFactory;

    protected AbstractChannelFactory(PicoContainer picoContainer, ORB oRB) throws UserException {
        this.container_ = PicoContainerFactory.createRootContainer(picoContainer, (org.jacorb.orb.ORB)oRB);
        this.config_ = (Configuration)this.container_.getComponentInstance((java.lang.Object)(class$org$apache$avalon$framework$configuration$Configuration == null ? (class$org$apache$avalon$framework$configuration$Configuration = AbstractChannelFactory.class$("org.apache.avalon.framework.configuration.Configuration")) : class$org$apache$avalon$framework$configuration$Configuration));
        this.logger_ = ((org.jacorb.config.Configuration)this.config_).getNamedLogger(this.getClass().getName());
        this.componentAdapterFactory_ = (ComponentAdapterFactory)this.container_.getComponentInstance((java.lang.Object)(class$org$picocontainer$defaults$ComponentAdapterFactory == null ? (class$org$picocontainer$defaults$ComponentAdapterFactory = AbstractChannelFactory.class$("org.picocontainer.defaults.ComponentAdapterFactory")) : class$org$picocontainer$defaults$ComponentAdapterFactory));
        POA pOA = (POA)this.container_.getComponentInstance((java.lang.Object)(class$org$omg$PortableServer$POA == null ? (class$org$omg$PortableServer$POA = AbstractChannelFactory.class$("org.omg.PortableServer.POA")) : class$org$omg$PortableServer$POA));
        ArrayList<IdAssignmentPolicy> arrayList = new ArrayList<IdAssignmentPolicy>();
        arrayList.add(pOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID));
        BiDirGiopPOAComponentAdapter.addBiDirGiopPolicy(arrayList, oRB, this.config_);
        Policy[] policyArray = arrayList.toArray(new Policy[arrayList.size()]);
        this.eventChannelFactoryPOA_ = pOA.create_POA(EVENTCHANNEL_FACTORY_POA_NAME, pOA.the_POAManager(), policyArray);
        for (int i = 0; i < policyArray.length; ++i) {
            policyArray[i].destroy();
        }
        pOA.the_POAManager().activate();
        byte[] byArray = this.getObjectName().getBytes();
        this.eventChannelFactoryPOA_.activate_object_with_id(byArray, this.getServant());
        this.thisRef_ = this.eventChannelFactoryPOA_.id_to_reference(byArray);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("activated EventChannelFactory with OID '" + new String(byArray) + "' on '" + this.eventChannelFactoryPOA_.the_name() + "'");
        }
        this.ior_ = oRB.object_to_string(this.eventChannelFactoryPOA_.id_to_reference(byArray));
        this.corbaLoc_ = this.createCorbaLoc();
        ((org.jacorb.orb.ORB)oRB).addObjectKey(this.getShortcut(), this.ior_);
    }

    protected abstract AbstractEventChannel newEventChannel() throws ConfigurationException;

    protected abstract Object create_abstract_channel(Property[] var1, Property[] var2, IntHolder var3) throws UnsupportedAdmin, UnsupportedQoS;

    protected abstract String getObjectName();

    protected abstract String getShortcut();

    protected abstract Servant getServant();

    protected int getLocalPort() {
        org.jacorb.orb.ORB oRB = (org.jacorb.orb.ORB)this.getORB();
        return oRB.getBasicAdapter().getPort();
    }

    protected String getLocalAddress() {
        org.jacorb.orb.ORB oRB = (org.jacorb.orb.ORB)this.getORB();
        return oRB.getBasicAdapter().getAddress();
    }

    private String createCorbaLoc() {
        StringBuffer stringBuffer = new StringBuffer("corbaloc::");
        stringBuffer.append(this.getLocalAddress());
        stringBuffer.append(":");
        stringBuffer.append(this.getLocalPort());
        stringBuffer.append("/");
        stringBuffer.append(this.getShortcut());
        return stringBuffer.toString();
    }

    public synchronized Object activate() {
        return this.thisRef_;
    }

    public void setDestroyMethod(Runnable runnable) {
        this.destroyMethod_ = runnable;
    }

    protected ORB getORB() {
        return (ORB)this.container_.getComponentInstance((java.lang.Object)(class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = AbstractChannelFactory.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB));
    }

    public final void deactivate() {
        try {
            this.eventChannelFactoryPOA_.deactivate_object(this.eventChannelFactoryPOA_.servant_to_id(this.getServant()));
        }
        catch (Exception exception) {
            this.logger_.fatalError("unable to deactivate object", exception);
            throw new RuntimeException();
        }
    }

    protected Configuration getConfiguration() {
        return this.config_;
    }

    public void dispose() {
        try {
            this.unregisterName();
        }
        catch (Exception exception) {
            this.logger_.error("unable to unregister NameService registration", exception);
        }
        this.channelManager_.dispose();
        this.container_.dispose();
        this.getORB().shutdown(true);
    }

    protected void addToChannels(int n, AbstractEventChannel abstractEventChannel) {
        this.channelManager_.add_channel(n, abstractEventChannel);
    }

    protected int[] getAllChannels() {
        return this.channelManager_.get_all_channels();
    }

    protected AbstractEventChannel get_event_channel_servant(int n) throws ChannelNotFound {
        return this.channelManager_.get_channel_servant(n);
    }

    protected Iterator getChannelIterator() {
        return this.channelManager_.getChannelIterator();
    }

    protected AbstractEventChannel create_channel_servant(IntHolder intHolder, Property[] propertyArray, Property[] propertyArray2) throws UnsupportedAdmin, UnsupportedQoS, ConfigurationException {
        AdminPropertySet adminPropertySet = new AdminPropertySet(this.config_);
        adminPropertySet.set_admin(propertyArray2);
        QoSPropertySet qoSPropertySet = new QoSPropertySet(this.config_, 0);
        qoSPropertySet.set_qos(propertyArray);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("uniqueQoSProps: " + qoSPropertySet);
            this.logger_.debug("uniqueAdminProps: " + adminPropertySet);
        }
        this.checkQoSSettings(qoSPropertySet);
        AbstractEventChannel abstractEventChannel = this.newEventChannel();
        intHolder.value = abstractEventChannel.getID();
        abstractEventChannel.set_qos(qoSPropertySet.toArray());
        abstractEventChannel.set_admin(adminPropertySet.toArray());
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("created channel_servant id=" + intHolder.value);
        }
        return abstractEventChannel;
    }

    private int createChannelIdentifier() {
        return this.eventChannelIDPool_.increment();
    }

    private void checkQoSSettings(PropertySet propertySet) throws UnsupportedQoS {
        short s;
        if (propertySet.containsKey("EventReliability")) {
            s = propertySet.get("EventReliability").extract_short();
            switch (s) {
                case 0: {
                    this.logger_.info("EventReliability=BestEffort");
                    break;
                }
                case 1: {
                    this.throwPersistentNotSupported("EventReliability");
                }
                default: {
                    this.throwBadValue("EventReliability");
                }
            }
        }
        s = 0;
        if (propertySet.containsKey("ConnectionReliability")) {
            s = propertySet.get("ConnectionReliability").extract_short();
            switch (s) {
                case 0: {
                    this.logger_.info("ConnectionReliability=BestEffort");
                    break;
                }
                case 1: {
                    this.throwPersistentNotSupported("ConnectionReliability");
                    break;
                }
                default: {
                    this.throwBadValue("ConnectionReliability");
                }
            }
        }
    }

    private void throwPersistentNotSupported(String string) throws UnsupportedQoS {
        Any any = this.getORB().create_any();
        Any any2 = this.getORB().create_any();
        any.insert_short((short)0);
        any2.insert_short((short)0);
        UnsupportedQoS unsupportedQoS = new UnsupportedQoS(new PropertyError[]{new PropertyError(QoSError_code.UNSUPPORTED_VALUE, string, new PropertyRange(any, any2))});
        throw unsupportedQoS;
    }

    private void throwBadValue(String string) throws UnsupportedQoS {
        Any any = this.getORB().create_any();
        Any any2 = this.getORB().create_any();
        any.insert_short((short)0);
        any2.insert_short((short)0);
        UnsupportedQoS unsupportedQoS = new UnsupportedQoS("The specified Property Value is not supported", new PropertyError[]{new PropertyError(QoSError_code.BAD_VALUE, string, new PropertyRange(any, any2))});
        throw unsupportedQoS;
    }

    public void destroy() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    AbstractChannelFactory.this.logger_.info("Notification Service is going down in 1000 ms");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AbstractChannelFactory.this.destroyMethod_.run();
            }
        };
        thread.start();
    }

    public void shutdown(ShutdownCallback shutdownCallback) {
        int n = 0;
        Iterator iterator = this.getChannelIterator();
        while (iterator.hasNext()) {
            AbstractEventChannel abstractEventChannel = (AbstractEventChannel)((Map.Entry)iterator.next()).getValue();
            n += abstractEventChannel.getNumberOfConnectedClients();
        }
        int n2 = 4000;
        int n3 = n * n2;
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("Connected Clients: " + n);
            this.logger_.info("Connection Timeout: " + n2 + " ms");
            this.logger_.info("Estimated Shutdowntime: " + n3 + " ms");
        }
        shutdownCallback.needTime(n3);
        this.logger_.info("NotificationService is going down");
        this.dispose();
        this.logger_.info("NotificationService down");
        shutdownCallback.shutdownComplete();
    }

    public String getIOR() {
        return this.ior_;
    }

    public String getCorbaLoc() {
        return this.corbaLoc_;
    }

    private static AbstractChannelFactory newChannelFactory(PicoContainer picoContainer, ORB oRB, boolean bl) throws UserException {
        if (bl) {
            return new TypedEventChannelFactoryImpl(picoContainer, oRB);
        }
        return new EventChannelFactoryImpl(picoContainer, oRB);
    }

    public static AbstractChannelFactory newFactory(PicoContainer picoContainer, final ORB oRB, boolean bl, Properties properties) throws Exception {
        AbstractChannelFactory abstractChannelFactory = AbstractChannelFactory.newChannelFactory(picoContainer, oRB, "on".equals(properties.get("jacorb.notification.enable_typed_channel")));
        abstractChannelFactory.activate();
        abstractChannelFactory.printIOR(properties);
        abstractChannelFactory.printCorbaLoc(properties);
        abstractChannelFactory.writeFile(properties);
        abstractChannelFactory.registerName(properties);
        abstractChannelFactory.startChannels(properties);
        if (bl) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    oRB.run();
                }
            });
            thread.setName("Notification ORB Runner Thread");
            thread.setDaemon(false);
            thread.start();
        }
        return abstractChannelFactory;
    }

    public static AbstractChannelFactory newFactory(ORB oRB, boolean bl, Properties properties) throws Exception {
        return AbstractChannelFactory.newFactory(null, oRB, bl, properties);
    }

    public static AbstractChannelFactory newFactory(PicoContainer picoContainer, Properties properties) throws Exception {
        properties.put("jacorb.implname", STANDARD_IMPL_NAME);
        ORB oRB = ORB.init(new String[0], properties);
        AbstractChannelFactory abstractChannelFactory = AbstractChannelFactory.newFactory(picoContainer, oRB, true, properties);
        return abstractChannelFactory;
    }

    public static AbstractChannelFactory newFactory(Properties properties) throws Exception {
        return AbstractChannelFactory.newFactory(null, properties);
    }

    private void registerName(Properties properties) throws Exception {
        this.registerName(properties.getProperty("jacorb.notification.register_name.id"), properties.getProperty("jacorb.notification.register_name.kind", ""));
    }

    private synchronized void registerName(String string, String string2) throws Exception {
        if (string == null) {
            return;
        }
        this.namingContext_ = NamingContextHelper.narrow(this.getORB().resolve_initial_references("NameService"));
        if (this.namingContext_ == null) {
            throw new ConfigurationException("could not resolve initial reference 'NameService'");
        }
        NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent(string, string2)};
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("namingContext.rebind(" + string + (string2 != null && string2.length() > 0 ? "." + string2 : "") + " => " + this.getCorbaLoc() + ")");
        }
        this.namingContext_.rebind(nameComponentArray, this.thisRef_);
        this.registeredName_ = nameComponentArray;
    }

    private synchronized void unregisterName() throws Exception {
        if (this.namingContext_ != null && this.registeredName_ != null) {
            this.namingContext_.unbind(this.registeredName_);
            this.registeredName_ = null;
        }
    }

    private void startChannels(Properties properties) throws UnsupportedQoS, UnsupportedAdmin {
        if (properties.containsKey("jacorb.notification.start_channels")) {
            this.startChannels(Integer.parseInt((String)properties.get("jacorb.notification.start_channels")));
        }
    }

    private void startChannels(int n) throws UnsupportedQoS, UnsupportedAdmin {
        for (int i = 0; i < n; ++i) {
            IntHolder intHolder = new IntHolder();
            this.create_abstract_channel(new Property[0], new Property[0], intHolder);
        }
    }

    private void printIOR(Properties properties) {
        if ("on".equals(properties.get("jacorb.notification.print_ior"))) {
            System.out.println(this.getIOR());
        }
    }

    private void printCorbaLoc(Properties properties) {
        if ("on".equals(properties.get("jacorb.notification.print_corbaloc"))) {
            System.out.println(this.getCorbaLoc());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(Properties properties) {
        String string = (String)properties.get("jacorb.notification.ior_file");
        if (string != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(string));
                try {
                    printWriter.println(this.getIOR());
                    printWriter.flush();
                }
                finally {
                    printWriter.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public POA _default_POA() {
        return this.eventChannelFactoryPOA_;
    }

    protected MutablePicoContainer newContainerForChannel() {
        final MutablePicoContainer mutablePicoContainer = PicoContainerFactory.createChildContainer(this.container_);
        final int n = this.createChannelIdentifier();
        IFactory iFactory = new IFactory(){

            public MutablePicoContainer getContainer() {
                return mutablePicoContainer;
            }

            public int getChannelID() {
                return n;
            }

            public void destroy() {
                AbstractChannelFactory.this.container_.removeChildContainer((PicoContainer)mutablePicoContainer);
            }
        };
        mutablePicoContainer.registerComponentInstance((java.lang.Object)(class$org$jacorb$notification$IFactory == null ? (class$org$jacorb$notification$IFactory = AbstractChannelFactory.class$("org.jacorb.notification.IFactory")) : class$org$jacorb$notification$IFactory), (java.lang.Object)iFactory);
        return mutablePicoContainer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static interface ShutdownCallback {
        public void needTime(int var1);

        public void shutdownComplete();
    }
}

