/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarBooleanArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarFloatArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DeviceHelper;
import fr.esrf.Tango.DeviceOperations;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoDs.Attribute;
import fr.esrf.TangoDs.DServer;
import fr.esrf.TangoDs.DServerClass;
import fr.esrf.TangoDs.DeviceClass;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.Logging;
import fr.esrf.TangoDs.PollObj;
import fr.esrf.TangoDs.PollThCmd;
import fr.esrf.TangoDs.PollThread;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.TangoMonitor;
import fr.esrf.TangoDs.TimedAttrData;
import fr.esrf.TangoDs.UtilPrint;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;

public class Util
implements TangoConst {
    private static Util _instance = null;
    private String ds_exec_name;
    private String ds_instance_name;
    private StringBuffer ds_name;
    private UtilExt ext;
    static int _tracelevel = 0;
    public static UtilPrint out1;
    public static UtilPrint out2;
    public static UtilPrint out3;
    public static UtilPrint out4;
    public static UtilPrint out5;
    public static boolean _UseDb;
    public static boolean _daemon;
    public static int _sleep_between_connect;
    private String db_host;
    private Database db = null;
    private String hostname;
    private String version_str;
    private int pid;
    private String pid_str;
    private Vector class_list;
    private ORB orb;
    private POA _poa;
    private Vector cmd_line_name_list = new Vector();
    private Vector class_name_list = new Vector();

    public static Util instance() {
        if (_instance == null) {
            System.err.println("Util is not initialised !!!");
            System.err.println("Exiting");
            System.exit(-1);
        }
        return _instance;
    }

    public static Util init(String[] argv, String exec_name) {
        if (_instance == null) {
            _instance = new Util(argv, exec_name);
        }
        return _instance;
    }

    protected Util(String[] argv, String class_name) {
        this.ds_exec_name = class_name;
        if (argv.length < 1) {
            this.print_usage();
            System.exit(-1);
        }
        this.check_args(argv);
        out1 = new UtilPrint(Level.INFO);
        out2 = new UtilPrint(Level.INFO);
        out3 = new UtilPrint(Level.DEBUG);
        out4 = new UtilPrint(Level.DEBUG);
        out5 = new UtilPrint(Level.DEBUG);
        if (_UseDb) {
            this.read_env();
        }
        POA root_poa = null;
        try {
            ApiUtil.set_in_server(true);
            this.orb = ApiUtil.get_orb();
            root_poa = POAHelper.narrow(this.orb.resolve_initial_references("RootPOA"));
        }
        catch (InvalidName ex) {
            System.err.println("Can't intialise CORBA ORB !!!");
            System.err.println("Failed when trying to get root POA reference");
            System.exit(-1);
        }
        catch (DevFailed ex) {
            System.err.println("Can't intialise CORBA ORB !!!");
            System.err.println("Failed when trying to get root POA reference");
            System.exit(-1);
        }
        POA nodb_poa = null;
        try {
            if (!_UseDb) {
                IdAssignmentPolicy pol = root_poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID);
                Policy[] policy_list = new Policy[]{pol, root_poa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
                POAManager manager = root_poa.the_POAManager();
                nodb_poa = root_poa.create_POA("nodb_poa", manager, policy_list);
            }
        }
        catch (AdapterAlreadyExists ex) {
            System.err.println("Can't create CORBA POA !!!");
            System.err.println("POA already exists");
            System.exit(-1);
        }
        catch (InvalidPolicy ex) {
            System.err.println("Can't create CORBA POA !!!");
            System.err.println("Invalid policy");
            System.exit(-1);
        }
        this._poa = _UseDb ? root_poa : nodb_poa;
        if (_UseDb) {
            this.connect_db();
        }
        Logging.init(this.ds_name.toString(), _tracelevel, this.db);
        if (_UseDb) {
            this.server_already_running();
        }
        this.ext = new UtilExt();
        this.ext.poll_th = new PollThread(this.ext.shared_data, this.ext.poll_mon);
        this.ext.poll_th.start();
        this.misc_init();
        out4.println("Util object singleton constructed");
    }

    private void check_args(String[] argv) {
        if (argv[0].charAt(0) == '-') {
            this.print_usage();
            System.exit(-1);
        }
        this.ds_instance_name = argv[0];
        if (argv.length > 1) {
            int ind = 1;
            block7: while (ind < argv.length) {
                if (argv[ind].charAt(0) == '-') {
                    switch (argv[ind].charAt(1)) {
                        case 'v': {
                            if (argv[ind].length() == 2) {
                                if (argv.length - 1 > ind) {
                                    if (argv[ind + 1].charAt(0) == '-') {
                                        this.set_trace_level(4);
                                    } else {
                                        this.print_usage();
                                        System.exit(-1);
                                    }
                                } else {
                                    this.set_trace_level(4);
                                }
                                ++ind;
                                continue block7;
                            }
                            String level_str = argv[ind].substring(2);
                            int level = 0;
                            try {
                                level = Integer.parseInt(level_str);
                            }
                            catch (NumberFormatException ex) {
                                this.print_usage();
                                System.exit(-1);
                            }
                            this.set_trace_level(level);
                            ++ind;
                            continue block7;
                        }
                        case 'n': {
                            if (!argv[ind].equals("-nodb")) {
                                this.print_usage();
                                System.exit(-1);
                                continue block7;
                            }
                            _UseDb = false;
                            ++ind;
                            continue block7;
                        }
                        case 'd': {
                            String str;
                            if (!argv[ind].equals("-dlist")) {
                                this.print_usage();
                                System.exit(-1);
                                continue block7;
                            }
                            if (_UseDb) {
                                this.print_usage();
                                System.exit(-1);
                            }
                            if (++ind == argv.length) {
                                this.print_usage();
                                System.exit(-1);
                                continue block7;
                            }
                            String dlist = argv[ind].toLowerCase();
                            int start = 0;
                            int pos = 0;
                            while ((pos = dlist.indexOf(44, start)) != -1) {
                                str = dlist.substring(start, pos);
                                start = pos + 1;
                                this.cmd_line_name_list.addElement(str);
                            }
                            if (start != dlist.length()) {
                                str = dlist.substring(start);
                                this.cmd_line_name_list.addElement(str);
                            }
                            for (int i = 0; i < this.cmd_line_name_list.size(); ++i) {
                                for (int j = 0; j < this.cmd_line_name_list.size(); ++j) {
                                    if (i == j || !this.cmd_line_name_list.elementAt(i).equals((String)this.cmd_line_name_list.elementAt(j))) continue;
                                    System.err.println("Each device name must have different name");
                                    System.exit(-1);
                                }
                            }
                            continue block7;
                        }
                    }
                    ++ind;
                    continue;
                }
                if (argv[ind - 1].substring(0, 2).equals("-v")) {
                    this.print_usage();
                    System.exit(-1);
                }
                ++ind;
            }
        }
        this.ds_exec_name = this.ds_exec_name.toLowerCase();
        this.ds_instance_name = this.ds_instance_name.toLowerCase();
        this.ds_name = new StringBuffer(this.ds_exec_name);
        this.ds_name.append("/");
        this.ds_name.append(this.ds_instance_name);
        if (this.ds_name.length() > 255) {
            System.err.println("The device server name is too long! Max length is 255 characters.");
            System.exit(-1);
        }
    }

    private void print_usage() {
        System.err.print("usage : " + this.ds_exec_name + " instance_name [-v[trace level]]");
        System.err.println(" [-nodb [-dlist <device name list>]]");
    }

    private void read_env() {
        try {
            String env = System.getProperty("TANGO_HOST");
            if (env == null) {
                Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Property \"TANGO_HOST\" not exported", "TangoDs.Util.read_env()");
            }
            if (env.indexOf(":") < 0) {
                Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Unknown \"TANGO_HOST\" property " + env, "TangoDs.Util.read_env()");
            }
            String[] array = ApiUtil.parseTangoHost(env);
            this.db_host = array[0];
        }
        catch (DevFailed e) {
            Except.print_exception(e);
            System.exit(-1);
        }
    }

    private void misc_init() {
        this.pid = 0;
        this.pid_str = String.valueOf(this.pid);
        try {
            String tmp_host1 = InetAddress.getLocalHost().toString();
            int pos = tmp_host1.indexOf(47);
            String tmp_host2 = tmp_host1.substring(0, pos);
            pos = tmp_host2.indexOf(46);
            this.hostname = pos == -1 ? tmp_host2 : tmp_host2.substring(0, pos);
        }
        catch (UnknownHostException ex) {
            System.err.println("Cant retrieve server host name");
            System.exit(1);
        }
        out4.println("Hostname = " + this.hostname);
        this.version_str = String.valueOf(2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void connect_db() {
        if (!_daemon) {
            try {
                this.db = ApiUtil.get_db_obj();
                if (this.db == null) {
                    System.err.println("Can't build connection to TANGO database server, exiting");
                    System.err.println("DB server host = " + this.db_host);
                    System.exit(-1);
                }
            }
            catch (Exception ex) {
                System.err.println("Can't build connection to TANGO database server, exiting");
                System.err.println("DB server host = " + this.db_host);
                System.exit(-1);
            }
        } else {
            boolean connected = false;
            while (!connected) {
                try {
                    this.db = ApiUtil.get_db_obj();
                    if (this.db == null) {
                        out4.println("Can't contact db server, will try later");
                        try {
                            this.wait(_sleep_between_connect * 1000);
                        }
                        catch (InterruptedException ex) {}
                        continue;
                    }
                    connected = true;
                }
                catch (Exception e) {
                    out4.println("Can't contact db server, will try later");
                    try {
                        this.wait(_sleep_between_connect * 1000);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        out4.println("Connected to database");
    }

    private synchronized void server_already_running() {
        out4.println("Entering Tango::server_already_running method");
        Random rand = new Random();
        int sl = rand.nextInt(1000);
        out4.println("Waiting " + sl + " ms....");
        try {
            this.wait(sl);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        StringBuffer dev_name = new StringBuffer("dserver");
        dev_name.append('/');
        dev_name.append(this.ds_name);
        String dev_name_str = new String(dev_name);
        DeviceOperations dev = null;
        try {
            DbDevImportInfo db_dev = this.db.import_device(dev_name_str);
            out4.println("db.import_device(" + dev_name_str + ");    DONE ");
            out4.println("db_dev.exported ==" + db_dev.exported);
            if (!db_dev.exported) {
                out4.println("Leaving Tango::server_already_running method");
                return;
            }
            Object obj = this.orb.string_to_object(db_dev.ior);
            out4.println("orb.string_to_object(db_dev.ior);    DONE ");
            dev = DeviceHelper.narrow(obj);
            out4.println("dev = DeviceHelper.narrow(obj);    DONE ");
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("DB_DeviceNotDefined")) {
                System.err.println("This device server is not defined in database. Exiting!");
                System.exit(-1);
            }
        }
        catch (BAD_OPERATION e) {
            System.err.println("Can't pack/unpack data sent to/from database in/to Any object");
            System.exit(-1);
        }
        catch (TRANSIENT e) {
            out4.println("Leaving Tango::server_already_running method");
            return;
        }
        catch (OBJECT_NOT_EXIST e) {
            out4.println("Leaving Tango::server_already_running method");
            return;
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        if (dev == null) {
            out4.println("Leaving Tango::server_already_running method");
            return;
        }
        try {
            String n = dev.name();
            if (n.equals(dev_name_str)) {
                System.err.println("This server is already running, exiting!");
                System.exit(-1);
            }
        }
        catch (NO_RESPONSE e) {
            System.err.println("This server is already running but is blocked!");
            System.exit(-1);
        }
        catch (SystemException e) {
            // empty catch block
        }
        out4.println("Leaving Tango::server_already_running method");
    }

    public void server_init() throws DevFailed {
        DServerClass.init();
        this.polling_configure();
    }

    public void server_run() {
        this.orb.run();
    }

    public Vector get_device_list(String pattern) {
        Vector<DeviceImpl> dl = new Vector<DeviceImpl>();
        if (pattern.indexOf(42) == -1) {
            DeviceImpl dev = null;
            try {
                dev = this.get_device_by_name(pattern);
            }
            catch (DevFailed df) {
                // empty catch block
            }
            if (dev != null) {
                dl.add(dev);
                return dl;
            }
        }
        Vector dcl = this.get_class_list();
        Vector temp_dl = new Vector();
        if (pattern.equals("*")) {
            for (int i = 0; i < dcl.size(); ++i) {
                temp_dl = ((DeviceClass)dcl.elementAt(i)).get_device_list();
                Iterator it = temp_dl.iterator();
                while (it.hasNext()) {
                    DeviceImpl dev = (DeviceImpl)it.next();
                    dl.add(dev);
                }
            }
            return dl;
        }
        DeviceImpl dev = null;
        Iterator dcl_it = dcl.iterator();
        pattern = pattern.replace('*', '.');
        Pattern p = Pattern.compile(pattern);
        while (dcl_it.hasNext()) {
            temp_dl = ((DeviceClass)dcl_it.next()).get_device_list();
            Iterator dl_it = temp_dl.iterator();
            while (dl_it.hasNext()) {
                dev = (DeviceImpl)dl_it.next();
                String dev_name = dev.get_name();
                dev_name.toLowerCase();
                if (!p.matcher(dev_name).matches()) continue;
                dl.add(dev);
            }
        }
        return dl;
    }

    public Vector get_device_list_by_class(String class_name) throws DevFailed {
        int i;
        Vector cl_list = this.class_list;
        int nb_class = cl_list.size();
        for (i = 0; i < nb_class && !((DeviceClass)cl_list.elementAt(i)).get_name().equals(class_name); ++i) {
        }
        if (i == nb_class) {
            StringBuffer o = new StringBuffer("Class ");
            o.append(class_name);
            o.append(" not found");
            Except.throw_exception("API_ClassNotFound", new String(o), new String("Util::get_device_list_by_class()"));
        }
        return ((DeviceClass)cl_list.elementAt(i)).get_device_list();
    }

    public DeviceImpl get_device_by_name(String dev_name) throws DevFailed {
        DServerClass ds_class;
        String name;
        Vector cl_list = this.class_list;
        dev_name = dev_name.toLowerCase();
        Vector dev_list = this.get_device_list_by_class(((DeviceClass)cl_list.elementAt(0)).get_name());
        int nb_class = cl_list.size();
        int nb_dev = 0;
        int j = 0;
        int i = 0;
        boolean found = false;
        for (i = 0; i < nb_class; ++i) {
            dev_list = this.get_device_list_by_class(((DeviceClass)cl_list.elementAt(i)).get_name());
            nb_dev = dev_list.size();
            for (j = 0; j < nb_dev; ++j) {
                if (!((DeviceImpl)dev_list.elementAt(j)).get_name().toLowerCase().equals(dev_name)) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found && (name = ((DeviceImpl)(dev_list = (ds_class = DServerClass.instance()).get_device_list()).elementAt(0)).get_name()).compareToIgnoreCase(dev_name) == 0) {
            j = 0;
            found = true;
        }
        if (i == nb_class && j == nb_dev) {
            StringBuffer o = new StringBuffer("Device ");
            o.append(dev_name);
            o.append(" not found");
            Except.throw_exception("API_DeviceNotFound", new String(o), new String("Util::get_device_by_name()"));
        }
        return (DeviceImpl)dev_list.elementAt(j);
    }

    public DServer get_dserver_device() {
        return (DServer)DServerClass.instance().get_device_list().elementAt(0);
    }

    public void unregister_server() {
        out4.println("Entering Tango::unregister_server method");
        if (_UseDb) {
            try {
                this.db.unexport_server(this.ds_name.toString());
            }
            catch (SystemException e) {
                Except.print_exception(e);
                System.exit(-1);
            }
            catch (DevFailed e) {
                Except.print_exception(e);
                System.exit(-1);
            }
            catch (UserException e) {
                Except.print_exception(e);
                System.exit(-1);
            }
        }
        out4.println("Leaving Tango::unregister_server method");
    }

    public static Any return_empty_any(String cmd) throws DevFailed {
        Any ret = null;
        try {
            ret = Util.instance().get_orb().create_any();
        }
        catch (OutOfMemoryError ex) {
            StringBuffer o = new StringBuffer(cmd);
            o.append(".execute");
            out3.println("Bad allocation while in " + cmd + ".execute()");
            Except.throw_exception("API_MemoryAllocation", new String("Can't allocate memory in server"), new String(o));
        }
        out4.println("Leaving " + cmd + ".execute()");
        return ret;
    }

    public void set_trace_level(int level) {
        _tracelevel = level;
    }

    public int get_trace_level() {
        return _tracelevel;
    }

    public String get_ds_inst_name() {
        return this.ds_instance_name;
    }

    public String get_ds_exec_name() {
        return this.ds_exec_name;
    }

    public String get_ds_name() {
        return new String(this.ds_name);
    }

    public String get_host_name() {
        return this.hostname;
    }

    public String get_version_str() {
        return this.version_str;
    }

    public Database get_database() {
        return this.db;
    }

    public ORB get_orb() {
        return this.orb;
    }

    public POA get_poa() {
        return this._poa;
    }

    public String get_pid_str() {
        return this.pid_str;
    }

    public void set_class_list(Vector list) {
        this.class_list = list;
    }

    Vector get_class_list() {
        return this.class_list;
    }

    Vector get_cmd_line_name_list() {
        return this.cmd_line_name_list;
    }

    public void add_class(String name) {
        this.class_name_list.addElement(name);
    }

    public Vector get_class_name_list() {
        return this.class_name_list;
    }

    void registerDeviceForJacorb(String name) {
        StringTokenizer st = new StringTokenizer(name, "/");
        String[] field = new String[3];
        for (int i = 0; i < 3 && st.countTokens() > 0; ++i) {
            field[i] = st.nextToken().toString();
        }
        String separator = "&%25";
        String targetname = new String("StandardImplName/nodb_poa/" + field[0] + separator + field[1] + separator + field[2]);
        org.jacorb.orb.ORB jacorb = (org.jacorb.orb.ORB)this.orb;
        jacorb.putObjectKeyMap(name, targetname);
    }

    public static double fabs(double d) {
        if (d >= 0.0) {
            return d;
        }
        return -1.0 * d;
    }

    void polling_configure() {
        DServer adm_dev = this.get_dserver_device();
        try {
            adm_dev.stop_polling();
        }
        catch (DevFailed e) {
            Except.print_exception(e);
        }
        Vector tmp_cl_list = adm_dev.get_class_list();
        DevVarLongStringArray send = new DevVarLongStringArray();
        send.lvalue = new int[1];
        send.svalue = new String[3];
        for (int i = 0; i < tmp_cl_list.size(); ++i) {
            DeviceClass dc = (DeviceClass)tmp_cl_list.elementAt(i);
            Vector dev_list = dc.get_device_list();
            for (int j = 0; j < dev_list.size(); ++j) {
                String strval;
                int upd;
                int k;
                DeviceImpl dev = (DeviceImpl)dev_list.elementAt(j);
                Vector poll_cmd_list = dev.get_polled_cmd();
                Vector poll_attr_list = dev.get_polled_attr();
                for (k = 0; k < poll_cmd_list.size(); ++k) {
                    if (k == 0) {
                        send.svalue[0] = dev.get_name();
                        send.svalue[1] = "command";
                    }
                    if ((upd = Integer.parseInt(strval = (String)poll_cmd_list.elementAt(k + 1))) != 0) {
                        send.lvalue[0] = upd;
                        send.svalue[2] = (String)poll_cmd_list.elementAt(k);
                        try {
                            adm_dev.add_obj_polling(send, false);
                        }
                        catch (DevFailed e) {
                            // empty catch block
                        }
                    }
                    ++k;
                }
                for (k = 0; k < poll_attr_list.size(); ++k) {
                    if (k == 0) {
                        send.svalue[0] = dev.get_name();
                        send.svalue[1] = "attribute";
                    }
                    if ((upd = Integer.parseInt(strval = (String)poll_attr_list.elementAt(k + 1))) != 0) {
                        send.lvalue[0] = upd;
                        send.svalue[2] = (String)poll_attr_list.elementAt(k);
                        try {
                            adm_dev.add_obj_polling(send, false);
                        }
                        catch (DevFailed e) {
                            // empty catch block
                        }
                    }
                    ++k;
                }
            }
        }
        try {
            adm_dev.start_polling();
        }
        catch (DevFailed e) {
            Except.print_exception(e);
        }
    }

    PollThCmd get_poll_shared_cmd() {
        return this.ext.shared_data;
    }

    TangoMonitor get_poll_monitor() {
        return this.ext.poll_mon;
    }

    void poll_status(boolean state) {
        this.ext.poll_on = state;
    }

    boolean poll_status() {
        return this.ext.poll_on;
    }

    void trigger_attr_polling(DeviceImpl dev, String name) throws DevFailed {
        String obj_name;
        PollObj item;
        long tmp_upd;
        out4.println("Sending trigger to polling thread");
        if (!dev.is_polled()) {
            Except.throw_exception("API_DeviceNotPolled", "Device " + dev.get_name() + " is not polled", "Util.trigger_attr_polling");
        }
        if ((tmp_upd = (long)(item = dev.get_polled_obj_by_type_name(1, obj_name = name.toLowerCase())).get_upd()) != 0L) {
            Except.throw_exception("API_NotSupported", "Polling for attribute " + name + " (device " + dev.get_name() + ")  is not externally triggered.", "Util.trigger_attr_polling");
        }
        TangoMonitor mon = this.get_poll_monitor();
        PollThCmd shared_cmd = this.get_poll_shared_cmd();
        mon.get_monitor();
        if (shared_cmd.trigger) {
            try {
                mon.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        shared_cmd.trigger = true;
        shared_cmd.dev = dev;
        shared_cmd.name = obj_name;
        shared_cmd.type = 1;
        mon.signal();
        out4.println("Trigger sent to polling thread");
        dev.get_dev_monitor();
        while (shared_cmd.trigger) {
            boolean interupted = mon.wait_it(3000L);
            if (!shared_cmd.trigger || interupted) continue;
            out4.println("TIME OUT");
            Except.throw_exception("API_CommandTimedOut", "Polling thread blocked !!!", "Util.trigger_attr_polling");
        }
        mon.rel_monitor();
        out4.println("Thread cmd normally executed");
    }

    public void fill_attr_polling_buffer(DeviceImpl dev, String att_name, TimedAttrData[] data) throws DevFailed {
        int nb_poll;
        int nb_elt;
        if (!dev.is_polled()) {
            Except.throw_exception("API_DeviceNotPolled", "Device " + dev.get_name() + " is not polled", "Util.fill_attr_polling_buffer()");
        }
        String obj_name = att_name.toLowerCase();
        dev.get_polled_obj_by_type_name(1, obj_name);
        Attribute att = dev.get_device_attr().get_attr_by_name(att_name);
        AttrWriteType w_type = att.get_writable();
        if (w_type != AttrWriteType.READ) {
            String desc = "Attribute " + att_name + " of device " + dev.get_name() + " is not READ only";
            Except.throw_exception("API_DeviceNotPolled", desc, "Util.fill_attr_polling_buffer()");
        }
        if ((nb_elt = data.length) > (nb_poll = dev.get_poll_ring_depth())) {
            String desc = "The polling buffer depth for attribute " + att_name + " for device " + dev.get_name() + " is only " + nb_poll + " which is less than " + nb_elt + " !";
            Except.throw_exception("API_DeviceNotPolled", desc, "Util.fill_attr_polling_buffer()");
        }
        DevFailed save_except = null;
        AttributeValue back = null;
        TimeVal zero = new TimeVal(0, 0, 0);
        for (int i = 0; i < nb_elt; ++i) {
            boolean attr_failed = false;
            if (data[i].err != null && data[i].err.length > 0) {
                attr_failed = true;
                save_except = new DevFailed(data[i].err);
            } else {
                back = new AttributeValue();
                back.time = new TimeVal(0, 0, 0);
                back.time.tv_sec = data[i].t_val.tv_sec;
                back.time.tv_usec = data[i].t_val.tv_usec;
                back.time.tv_nsec = 0;
                back.quality = data[i].qual;
                back.name = att_name;
                back.dim_x = 0;
                back.dim_y = 0;
                if (data[i].qual == AttrQuality.ATTR_VALID || data[i].qual == AttrQuality.ATTR_ALARM || data[i].qual == AttrQuality.ATTR_CHANGING) {
                    att.wanted_date(false);
                    att.set_date(data[i].t_val);
                    att.set_quality(data[i].qual);
                    Any any = ApiUtil.get_orb().create_any();
                    switch (att.get_data_type()) {
                        case 1: {
                            att.set_value(data[i].bool_ptr, data[i].x, data[i].y);
                            DevVarBooleanArrayHelper.insert(any, att.get_boolean_value());
                            break;
                        }
                        case 2: {
                            att.set_value(data[i].sh_ptr, data[i].x, data[i].y);
                            DevVarShortArrayHelper.insert(any, att.get_short_value());
                            break;
                        }
                        case 3: {
                            att.set_value(data[i].lg_ptr, data[i].x, data[i].y);
                            DevVarLongArrayHelper.insert(any, att.get_long_value());
                            break;
                        }
                        case 4: {
                            att.set_value(data[i].fl_ptr, data[i].x, data[i].y);
                            DevVarFloatArrayHelper.insert(any, att.get_float_value());
                            break;
                        }
                        case 5: {
                            att.set_value(data[i].db_ptr, data[i].x, data[i].y);
                            DevVarDoubleArrayHelper.insert(any, att.get_double_value());
                            break;
                        }
                        case 8: {
                            att.set_value(data[i].str_ptr, data[i].x, data[i].y);
                            DevVarStringArrayHelper.insert(any, att.get_string_value());
                            break;
                        }
                        default: {
                            Except.throw_exception("Api_DataTypeNotSupported", "att.get_data_type() returns " + att.get_data_type() + "\nType NOT supported", "Util.fill_attr_polling_buffer()");
                        }
                    }
                    back.value = any;
                    back.dim_x = data[i].x;
                    back.dim_y = data[i].y;
                }
            }
            try {
                this.get_poll_monitor().get_monitor();
                PollObj item = dev.get_polled_obj_by_type_name(1, obj_name);
                TimeVal when = new TimeVal(0, 0, 0);
                if (!attr_failed) {
                    when.tv_sec = back.time.tv_sec - 1002000000;
                    when.tv_usec = back.time.tv_usec;
                    item.insert_data(back, when, zero);
                } else {
                    when.tv_sec = data[i].t_val.tv_sec - 1002000000;
                    when.tv_usec = data[i].t_val.tv_usec;
                    item.insert_except(save_except, when, zero);
                }
                this.get_poll_monitor().rel_monitor();
                continue;
            }
            catch (DevFailed e) {
                this.get_poll_monitor().rel_monitor();
            }
        }
    }

    static {
        _UseDb = true;
        _daemon = false;
        _sleep_between_connect = 60;
    }

    class UtilExt {
        Vector cmd_line_name_list;
        PollThread poll_th;
        PollThCmd shared_data = new PollThCmd();
        TangoMonitor poll_mon;
        boolean poll_on;

        UtilExt() {
            this.shared_data.cmd_pending = false;
            this.poll_mon = new TangoMonitor();
        }
    }
}

