/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.Attr;
import fr.esrf.TangoDs.AttrProperty;
import fr.esrf.TangoDs.Attribute;
import fr.esrf.TangoDs.DeviceClass;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import fr.esrf.TangoDs.WAttribute;
import java.util.Vector;

public class MultiAttribute
implements TangoConst {
    protected Vector attr_list = new Vector();
    protected Vector writable_attr_list = new Vector();
    protected Vector alarm_attr_list = new Vector();
    private static final AttrProperty[] def_opt_prop = new AttrProperty[]{new AttrProperty("label", "No label"), new AttrProperty("description", "No description"), new AttrProperty("unit", "No unit"), new AttrProperty("standard_unit", "No standard unit"), new AttrProperty("display_unit", "No display unit"), new AttrProperty("format", "No format"), new AttrProperty("min_value", "Not specified"), new AttrProperty("max_value", "Not specified"), new AttrProperty("min_alarm", "Not specified"), new AttrProperty("max_alarm", "Not specified"), new AttrProperty("writable_attr_name", "None")};

    public MultiAttribute(String dev_name, DeviceClass dev_class) throws DevFailed {
        int i;
        Util.out4.println("Entering MultiAttribute class constructor for device " + dev_name);
        Vector tmp_attr_list = dev_class.get_class_attr().get_attr_list();
        int nb_attr = tmp_attr_list.size();
        if (nb_attr != 0) {
            Util tg = Util.instance();
            String[] db_dev_attr_prop = null;
            if (Util._UseDb) {
                String[] send_list = new String[nb_attr + 1];
                send_list[0] = dev_name;
                for (i = 0; i < nb_attr; ++i) {
                    send_list[i + 1] = ((Attr)tmp_attr_list.elementAt(i)).get_name();
                }
                DeviceData send = new DeviceData();
                send.insert(send_list);
                DeviceData received_prop = tg.get_database().command_inout("DbGetDeviceAttributeProperty", send);
                String[] db_attr_prop_list = received_prop.extractStringArray();
                int nb_db_data = db_attr_prop_list.length - 2;
                db_dev_attr_prop = new String[nb_db_data];
                for (i = 0; i < nb_db_data; ++i) {
                    db_dev_attr_prop[i] = db_attr_prop_list[i + 2];
                }
            }
            int ind = 0;
            for (i = 0; i < nb_attr; ++i) {
                Attr attr = dev_class.get_class_attr().get_attr(((Attr)tmp_attr_list.elementAt(i)).get_name());
                Vector class_prop = attr.get_class_properties();
                Vector def_user_prop = attr.get_user_default_properties();
                Vector<AttrProperty> dev_prop = new Vector<AttrProperty>();
                if (Util._UseDb) {
                    int nb_prop = Integer.parseInt((String)db_dev_attr_prop[++ind]);
                    ++ind;
                    for (int j = 0; j < nb_prop; ++j) {
                        dev_prop.addElement(new AttrProperty(db_dev_attr_prop[ind], db_dev_attr_prop[ind + 1]));
                        ind += 2;
                    }
                }
                Vector prop_list = new Vector();
                this.concat(dev_prop, class_prop, prop_list);
                this.add_user_default(prop_list, def_user_prop);
                this.add_default(prop_list);
                if (attr.get_writable() == AttrWriteType.WRITE || attr.get_writable() == AttrWriteType.READ_WRITE) {
                    this.attr_list.addElement(new WAttribute(prop_list, attr, dev_name));
                } else {
                    this.attr_list.addElement(new Attribute(prop_list, attr, dev_name));
                }
                if (((Attribute)this.attr_list.elementAt(i)).get_writable() == AttrWriteType.WRITE || ((Attribute)this.attr_list.elementAt(i)).get_writable() == AttrWriteType.READ_WRITE) {
                    this.writable_attr_list.addElement(new Integer(i));
                }
                if (((Attribute)this.attr_list.elementAt(i)).is_alarmed() && ((Attribute)this.attr_list.elementAt(i)).get_writable() != AttrWriteType.WRITE) {
                    this.alarm_attr_list.addElement(new Integer(i));
                }
                Util.out4.println(this.attr_list.elementAt(i));
            }
        }
        for (i = 0; i < nb_attr; ++i) {
            this.check_associated(i, dev_name);
        }
        Util.out4.println("Leaving MultiAttribute class constructor");
    }

    private void concat(Vector dev_prop, Vector class_prop, Vector result) {
        int i = 0;
        for (i = 0; i < dev_prop.size(); ++i) {
            result.addElement(dev_prop.elementAt(i));
        }
        Vector tmp_result = (Vector)result.clone();
        int nb_class_check = class_prop.size();
        for (i = 0; i < nb_class_check; ++i) {
            int j = 0;
            for (j = 0; j < tmp_result.size() && !((AttrProperty)tmp_result.elementAt(j)).get_name().equals(((AttrProperty)class_prop.elementAt(i)).get_name()); ++j) {
            }
            if (j != tmp_result.size()) continue;
            result.addElement(class_prop.elementAt(i));
        }
    }

    private void add_default(Vector prop_list) {
        int nb_opt_prop = def_opt_prop.length;
        for (int i = 0; i < nb_opt_prop; ++i) {
            String opt_prop_name = def_opt_prop[i].get_name();
            int j = 0;
            for (j = 0; j < prop_list.size() && !((AttrProperty)prop_list.elementAt(j)).get_name().equals(opt_prop_name); ++j) {
            }
            if (j != prop_list.size()) continue;
            prop_list.addElement(def_opt_prop[i]);
        }
    }

    void add_user_default(Vector prop_list, Vector user_default) {
        int nb_user = user_default.size();
        for (int i = 0; i < nb_user; ++i) {
            String user_prop_name = ((AttrProperty)user_default.elementAt(i)).get_name();
            int j = 0;
            for (j = 0; j < prop_list.size() && !((AttrProperty)prop_list.elementAt(j)).get_name().equals(user_prop_name); ++j) {
            }
            if (j != prop_list.size()) continue;
            prop_list.addElement(user_default.elementAt(i));
        }
    }

    void check_associated(int index, String dev_name) throws DevFailed {
        Attribute att = (Attribute)this.attr_list.elementAt(index);
        if (att.get_writable() == AttrWriteType.READ_WITH_WRITE || att.get_writable() == AttrWriteType.READ_WRITE) {
            StringBuffer o;
            Attribute tmp_att;
            if (att.get_data_format().value() != 0) {
                StringBuffer o2 = new StringBuffer("Device --> ");
                o2.append(dev_name);
                o2.append("\nProperty writable_attr_name for attribute ");
                o2.append(att.get_name());
                o2.append(" is defined but this attribute data format is not SCALAR");
                Except.throw_exception("API_AttrOptProp", o2.toString(), "MultiAttribute.check_associated");
            }
            int j = 0;
            int tmp_ind = 0;
            String assoc_name = att.get_assoc_name();
            for (j = 0; j < this.writable_attr_list.size() && !((Attribute)this.attr_list.elementAt(tmp_ind = ((Integer)this.writable_attr_list.elementAt(j)).intValue())).get_name().equals(assoc_name); ++j) {
            }
            if (j == this.writable_attr_list.size()) {
                StringBuffer o3 = new StringBuffer("Device --> ");
                o3.append(dev_name);
                o3.append("\nProperty writable_attr_name for attribute ");
                o3.append(att.get_name());
                o3.append(" is set to ");
                o3.append(assoc_name);
                o3.append(", but this attribute does not exists or is not writable");
                Except.throw_exception("API_AttrOptProp", o3.toString(), "MultiAttribute.check_associated");
            }
            if ((tmp_att = (Attribute)this.attr_list.elementAt(tmp_ind)).get_data_format().value() != 0) {
                o = new StringBuffer("Device --> ");
                o.append(dev_name);
                o.append("\nProperty writable_attr_name for attribute ");
                o.append(att.get_name());
                o.append(" is set to ");
                o.append(assoc_name);
                o.append(", but this attribute is not of the SCALAR data format");
                Except.throw_exception("API_AttrOptProp", o.toString(), "MultiAttribute.check_assiocated");
            }
            if (tmp_att.get_data_type() != att.get_data_type()) {
                o = new StringBuffer("Device --> ");
                o.append(dev_name);
                o.append("\nProperty writable_attr_name for attribute ");
                o.append(att.get_name());
                o.append(" is set to ");
                o.append(assoc_name);
                o.append(", but these two attributes do not support the same data type");
                Except.throw_exception("API_AttrOptProp", o.toString(), "MultiAttribute.check_associated");
            }
            att.set_assoc_ind(tmp_ind);
        }
    }

    void add_attribute(String dev_name, DeviceClass dev_class, int index) throws DevFailed {
        Util.out4.println("Entering MultiAttribute::add_attribute");
        Vector tmp_attr_list = dev_class.get_class_attr().get_attr_list();
        String[] db_dev_attr_prop = null;
        if (Util._UseDb) {
            Util tg = Util.instance();
            String[] send_list = new String[]{dev_name, ((Attr)tmp_attr_list.elementAt(index)).get_name()};
            DeviceData send = new DeviceData();
            send.insert(send_list);
            DeviceData received_prop = tg.get_database().command_inout("DbGetDeviceAttributeProperty", send);
            String[] db_attr_prop_list = received_prop.extractStringArray();
            int nb_db_data = db_attr_prop_list.length - 2;
            db_dev_attr_prop = new String[nb_db_data];
            for (int i = 0; i < nb_db_data; ++i) {
                db_dev_attr_prop[i] = db_attr_prop_list[i + 2];
            }
        }
        int ind = 0;
        Attr attr = dev_class.get_class_attr().get_attr(((Attr)tmp_attr_list.elementAt(index)).get_name());
        Vector class_prop = attr.get_class_properties();
        Vector def_user_prop = attr.get_user_default_properties();
        Vector<AttrProperty> dev_prop = new Vector<AttrProperty>();
        if (Util._UseDb) {
            int nb_prop = Integer.parseInt((String)db_dev_attr_prop[++ind]);
            ++ind;
            for (int j = 0; j < nb_prop; ++j) {
                dev_prop.addElement(new AttrProperty(db_dev_attr_prop[ind], db_dev_attr_prop[ind + 1]));
                ind += 2;
            }
        }
        Vector prop_list = new Vector();
        this.concat(dev_prop, class_prop, prop_list);
        this.add_user_default(prop_list, def_user_prop);
        this.add_default(prop_list);
        if (attr.get_writable() == AttrWriteType.WRITE || attr.get_writable() == AttrWriteType.READ_WRITE) {
            this.attr_list.addElement(new WAttribute(prop_list, attr, dev_name));
        } else {
            this.attr_list.addElement(new Attribute(prop_list, attr, dev_name));
        }
        index = this.attr_list.size() - 1;
        if (((Attribute)this.attr_list.elementAt(index)).get_writable() == AttrWriteType.WRITE || ((Attribute)this.attr_list.elementAt(index)).get_writable() == AttrWriteType.READ_WRITE) {
            this.writable_attr_list.addElement(new Integer(index));
        }
        if (((Attribute)this.attr_list.elementAt(index)).is_alarmed() && ((Attribute)this.attr_list.elementAt(index)).get_writable() != AttrWriteType.WRITE) {
            this.alarm_attr_list.addElement(new Integer(index));
        }
        this.check_associated(index, dev_name);
        Util.out4.println("Leaving MultiAttribute::add_attribute");
    }

    public void remove_attribute(String attname) throws DevFailed {
        Attribute attr = this.get_attr_by_name(attname);
        this.attr_list.remove(attr);
    }

    public Attribute get_attr_by_name(String attr_name) throws DevFailed {
        int i = 0;
        int nb = this.attr_list.size();
        for (i = 0; i < nb && !((Attribute)this.attr_list.elementAt(i)).get_name().equalsIgnoreCase(attr_name); ++i) {
        }
        if (i == nb) {
            Util.out3.println("MultiAttribute.get_attr throwing exception");
            Except.throw_exception("API_AttrNotFound", attr_name + " attribute not found", "MultiAttribute.get_attr");
        }
        return (Attribute)this.attr_list.elementAt(i);
    }

    public WAttribute get_w_attr_by_name(String attr_name) throws DevFailed {
        Attribute att = this.get_attr_by_name(attr_name);
        return (WAttribute)att;
    }

    public int get_attr_ind_by_name(String attr_name) throws DevFailed {
        int i;
        int nb_attr = this.attr_list.size();
        for (i = 0; i < nb_attr && !((Attribute)this.attr_list.elementAt(i)).get_name().equalsIgnoreCase(attr_name); ++i) {
        }
        if (i == nb_attr) {
            Util.out3.println("MultiAttribute.get_attr_ind_by_name throwing exception");
            StringBuffer o = new StringBuffer(attr_name);
            o.append(" attribute not found");
            Except.throw_exception("API_AttrNotFound", o.toString(), "MultiAttribute.get_attr_ind_by_name");
        }
        return i;
    }

    public boolean check_alarm() throws DevFailed {
        boolean ret = false;
        int nb_alarm = this.alarm_attr_list.size();
        for (int i = 0; i < nb_alarm; ++i) {
            boolean tmp_ret = this.check_alarm((Integer)this.alarm_attr_list.elementAt(i));
            if (!tmp_ret) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean check_alarm(String attr_name) throws DevFailed {
        return this.get_attr_by_name(attr_name).check_alarm();
    }

    public boolean check_alarm(int ind) throws DevFailed {
        return this.get_attr_by_ind(ind).check_alarm();
    }

    void add_write_value(Attribute att) {
        WAttribute assoc_att = this.get_w_attr_by_ind(att.get_assoc_ind());
        switch (att.get_data_type()) {
            case 1: {
                boolean bool_write_val = assoc_att.get_bool_write_value();
                att.add_write_value(bool_write_val);
                break;
            }
            case 2: {
                short sh_write_val = assoc_att.get_sh_write_value();
                att.add_write_value(sh_write_val);
                break;
            }
            case 3: {
                int lg_write_val = assoc_att.get_lg_write_value();
                att.add_write_value(lg_write_val);
                break;
            }
            case 5: {
                double db_write_val = assoc_att.get_db_write_value();
                att.add_write_value(db_write_val);
                break;
            }
            case 8: {
                String str_write_val = assoc_att.get_str_write_value();
                att.add_write_value(str_write_val);
            }
        }
    }

    public void read_alarm(StringBuffer status) {
        int i = 0;
        for (i = 0; i < this.alarm_attr_list.size(); ++i) {
            Attribute att = this.get_attr_by_ind((Integer)this.alarm_attr_list.elementAt(i));
            if (att.get_quality().value() != 2) continue;
            if (att.is_min_alarm()) {
                status.append("\nAlarm : Value too low for attribute ");
                status.append(att.get_name());
            }
            if (!att.is_max_alarm()) continue;
            status.append("\nAlarm : Value too high for attribute ");
            status.append(att.get_name());
        }
    }

    public Vector get_alarm_list() {
        return this.alarm_attr_list;
    }

    public int get_attr_nb() {
        return this.attr_list.size();
    }

    public Attribute get_attr_by_ind(int ind) {
        return (Attribute)this.attr_list.elementAt(ind);
    }

    public WAttribute get_w_attr_by_ind(int ind) {
        return (WAttribute)this.attr_list.elementAt(ind);
    }
}

