/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttributeDim;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevAttrHistory_3;
import fr.esrf.Tango.DevBooleanHelper;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevDoubleHelper;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevFloatHelper;
import fr.esrf.Tango.DevLongHelper;
import fr.esrf.Tango.DevShortHelper;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevStateHelper;
import fr.esrf.Tango.DevStringHelper;
import fr.esrf.Tango.DevULongHelper;
import fr.esrf.Tango.DevUShortHelper;
import fr.esrf.Tango.DevVarBooleanArrayHelper;
import fr.esrf.Tango.DevVarCharArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarDoubleStringArrayHelper;
import fr.esrf.Tango.DevVarFloatArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarLongStringArrayHelper;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevVarULongArrayHelper;
import fr.esrf.Tango.DevVarUShortArrayHelper;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoDs.Except;
import org.omg.CORBA.Any;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class DeviceDataHistory {
    private Any any;
    private DevCmdHistory cmd_histo;
    private AttributeValue_3 attrval;
    private TimeVal tval;
    public static final int COMMAND = 0;
    public static final int ATTRIBUTE = 1;
    public int source;
    public String name;
    public boolean failed;
    public DevError[] errors;

    public DeviceDataHistory(String cmdname, DevCmdHistory cmd_hist) throws DevFailed {
        this.any = cmd_hist.value;
        this.source = 0;
        this.cmd_histo = cmd_hist;
        this.name = cmdname;
        this.tval = this.cmd_histo.time;
        this.failed = this.cmd_histo.cmd_failed;
        this.errors = this.cmd_histo.errors;
    }

    public DeviceDataHistory(DevAttrHistory att_histo) throws DevFailed {
        this.any = att_histo.value.value;
        this.source = 1;
        this.attrval = new AttributeValue_3(this.any, att_histo.value.quality, att_histo.value.time, att_histo.value.name, new AttributeDim(att_histo.value.dim_x, att_histo.value.dim_y), new AttributeDim(0, 0), att_histo.errors);
        this.name = att_histo.value.name;
        this.tval = att_histo.value.time;
        this.failed = att_histo.attr_failed;
        this.errors = att_histo.errors;
    }

    public DeviceDataHistory(DevAttrHistory_3 att_histo) throws DevFailed {
        this.any = att_histo.value.value;
        this.source = 1;
        this.attrval = att_histo.value;
        this.name = att_histo.value.name;
        this.tval = att_histo.value.time;
        this.failed = att_histo.attr_failed;
        this.errors = att_histo.value.err_list;
    }

    public TimeVal getTimeVal() {
        return this.tval;
    }

    public long getTimeValSec() {
        return this.tval.tv_sec;
    }

    public long getTime() {
        return (long)this.tval.tv_sec * 1000L + (long)(this.tval.tv_usec / 1000);
    }

    public AttrQuality getAttrQuality() throws DevFailed {
        if (this.source == 0) {
            Except.throw_non_supported_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getAttrQuality()");
        }
        return this.attrval.quality;
    }

    public int getDimX() throws DevFailed {
        if (this.source == 0) {
            Except.throw_non_supported_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getDimX()");
        }
        return this.attrval.r_dim.dim_x;
    }

    public int getDimY() throws DevFailed {
        if (this.source == 0) {
            Except.throw_non_supported_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getDimY()");
        }
        return this.attrval.r_dim.dim_y;
    }

    public Any extractAny() {
        return this.any;
    }

    public boolean extractBoolean() {
        return DevBooleanHelper.extract(this.any);
    }

    public short extractUChar() throws DevFailed {
        short[] array = this.extractUCharArray();
        return array[0];
    }

    public short extractShort() {
        if (this.source == 1) {
            short[] array = this.extractShortArray();
            return array[0];
        }
        return DevShortHelper.extract(this.any);
    }

    public short extractUShort() {
        return DevUShortHelper.extract(this.any);
    }

    public int extractLong() {
        if (this.source == 1) {
            int[] array = this.extractLongArray();
            return array[0];
        }
        return DevLongHelper.extract(this.any);
    }

    public int extractULong() {
        return DevULongHelper.extract(this.any);
    }

    public float extractFloat() {
        return DevFloatHelper.extract(this.any);
    }

    public double extractDouble() {
        if (this.source == 1) {
            double[] array = this.extractDoubleArray();
            return array[0];
        }
        return DevDoubleHelper.extract(this.any);
    }

    public String extractString() {
        if (this.source == 1) {
            String[] array = this.extractStringArray();
            return array[0];
        }
        return DevStringHelper.extract(this.any);
    }

    public DevState extractDevState() {
        return DevStateHelper.extract(this.any);
    }

    public boolean[] extractBooleanArray() {
        return DevVarBooleanArrayHelper.extract(this.any);
    }

    public byte[] extractByteArray() {
        return DevVarCharArrayHelper.extract(this.any);
    }

    public short[] extractUCharArray() throws DevFailed {
        byte[] argout = DevVarCharArrayHelper.extract(this.attrval.value);
        short[] val = new short[argout.length];
        int mask = 255;
        for (int i = 0; i < argout.length; ++i) {
            val[i] = (short)(mask & argout[i]);
        }
        return val;
    }

    public short[] extractShortArray() {
        return DevVarShortArrayHelper.extract(this.any);
    }

    public short[] extractUShortArray() {
        return DevVarUShortArrayHelper.extract(this.any);
    }

    public int[] extractLongArray() {
        return DevVarLongArrayHelper.extract(this.any);
    }

    public int[] extractULongArray() {
        return DevVarULongArrayHelper.extract(this.any);
    }

    public float[] extractFloatArray() {
        return DevVarFloatArrayHelper.extract(this.any);
    }

    public double[] extractDoubleArray() {
        return DevVarDoubleArrayHelper.extract(this.any);
    }

    public String[] extractStringArray() {
        if (this.any == null) {
            System.out.println("any = null !!");
        }
        return DevVarStringArrayHelper.extract(this.any);
    }

    public DevVarLongStringArray extractLongStringArray() {
        return DevVarLongStringArrayHelper.extract(this.any);
    }

    public DevVarDoubleStringArray extractDoubleStringArray() {
        return DevVarDoubleStringArrayHelper.extract(this.any);
    }

    public DevError[] getErrStack() {
        return this.attrval.err_list;
    }

    public TypeCode type() {
        return this.any.type();
    }

    public String getName() {
        return this.attrval.name;
    }

    private int DIM_MINI(int x) {
        return x == 0 ? 1 : x;
    }

    public int getNbRead() {
        return this.attrval.r_dim.dim_x * this.DIM_MINI(this.attrval.r_dim.dim_y);
    }

    public int getNbWritten() {
        return this.attrval.w_dim.dim_x * this.DIM_MINI(this.attrval.w_dim.dim_y);
    }

    public int getWrittenDimX() {
        return this.attrval.w_dim.dim_x;
    }

    public int getWrittenDimY() {
        return this.attrval.w_dim.dim_y;
    }

    public int getType() throws DevFailed {
        int type = -1;
        try {
            TypeCode tc = this.attrval.value.type();
            if (tc.kind().value() == 17) {
                return 19;
            }
            TypeCode tc_alias = tc.content_type();
            TypeCode tc_seq = tc_alias.content_type();
            TCKind kind = tc_seq.kind();
            switch (kind.value()) {
                case 1: {
                    type = 0;
                    break;
                }
                case 8: {
                    type = 1;
                    break;
                }
                case 9: {
                    type = 21;
                    break;
                }
                case 10: {
                    type = 22;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 4: {
                    type = 6;
                    break;
                }
                case 3: {
                    type = 3;
                    break;
                }
                case 5: {
                    type = 7;
                    break;
                }
                case 6: {
                    type = 4;
                    break;
                }
                case 7: {
                    type = 5;
                    break;
                }
                case 18: {
                    type = 8;
                }
            }
        }
        catch (BadKind e) {
            Except.throw_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type ", "DeviceDataHistory.getType()");
        }
        return type;
    }
}

