/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttributeDim;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevStateHelper;
import fr.esrf.Tango.DevVarBooleanArrayHelper;
import fr.esrf.Tango.DevVarCharArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarFloatArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevVarUShortArrayHelper;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoDs.Except;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class DeviceAttribute {
    AttributeValue_3 attrval = new AttributeValue_3();

    private void buildAttributeValueObject(String name) {
        this.attrval.name = name;
        this.attrval.quality = AttrQuality.ATTR_VALID;
        this.attrval.time = new TimeVal();
        this.attrval.r_dim = new AttributeDim();
        this.attrval.w_dim = new AttributeDim();
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        this.attrval.w_dim.dim_x = 0;
        this.attrval.w_dim.dim_y = 0;
        try {
            this.attrval.value = ApiUtil.get_orb().create_any();
        }
        catch (DevFailed e) {
            // empty catch block
        }
        long now = System.currentTimeMillis();
        this.attrval.time.tv_sec = (int)(now / 1000L);
        this.attrval.time.tv_usec = (int)(now - (long)(this.attrval.time.tv_sec * 1000)) * 1000;
        this.attrval.time.tv_nsec = 0;
        this.attrval.err_list = null;
    }

    public DeviceAttribute(AttributeValue_3 attrval) {
        this.attrval = attrval;
    }

    public DeviceAttribute(AttributeValue attrval) {
        this.attrval.value = attrval.value;
        this.attrval.name = attrval.name;
        this.attrval.quality = attrval.quality;
        this.attrval.time = attrval.time;
        this.attrval.r_dim = new AttributeDim();
        this.attrval.w_dim = new AttributeDim();
        this.attrval.r_dim.dim_x = attrval.dim_x;
        this.attrval.r_dim.dim_y = attrval.dim_y;
        this.attrval.w_dim.dim_x = 0;
        this.attrval.w_dim.dim_y = 0;
        this.attrval.err_list = null;
    }

    public DeviceAttribute(String name) {
        this.buildAttributeValueObject(name);
    }

    public DeviceAttribute(String name, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.attrval.r_dim.dim_x = dim_x;
        this.attrval.r_dim.dim_y = dim_y;
    }

    public DeviceAttribute(String name, boolean value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public DeviceAttribute(String name, boolean[] value, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(value, dim_x, dim_y);
    }

    public DeviceAttribute(String name, byte value) {
        this.buildAttributeValueObject(name);
        this.insert_uc(value);
    }

    public DeviceAttribute(String name, byte[] value, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert_uc(value, dim_x, dim_y);
    }

    public DeviceAttribute(String name, short value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public DeviceAttribute(String name, short[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    public DeviceAttribute(String name, int value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public DeviceAttribute(String name, int[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    public DeviceAttribute(String name, float value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public DeviceAttribute(String name, float[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    public DeviceAttribute(String name, double value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public DeviceAttribute(String name, double[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    public DeviceAttribute(String name, String value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public DeviceAttribute(String name, String[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    public boolean hasFailed() {
        return this.attrval.err_list != null && this.attrval.err_list.length > 0;
    }

    public DevError[] getErrStack() {
        return this.attrval.err_list;
    }

    public void setAttributeValue(AttributeValue_3 attrval) {
        this.attrval = attrval;
    }

    public void setAttributeValue(AttributeValue attrval) {
        this.attrval.value = attrval.value;
        this.attrval.name = attrval.name;
        this.attrval.quality = attrval.quality;
        this.attrval.time = attrval.time;
        this.attrval.r_dim.dim_x = attrval.dim_x;
        this.attrval.r_dim.dim_y = attrval.dim_y;
        this.attrval.w_dim.dim_x = 0;
        this.attrval.w_dim.dim_y = 0;
        this.attrval.err_list = null;
    }

    public void insert(boolean argin) {
        boolean[] values = new boolean[]{argin};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarBooleanArrayHelper.insert(this.attrval.value, values);
    }

    public void insert(boolean[] argin) {
        this.attrval.r_dim.dim_x = argin.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarBooleanArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert(boolean[] argin, int dim_x, int dim_y) {
        this.attrval.r_dim.dim_x = dim_x;
        this.attrval.r_dim.dim_y = dim_y;
        DevVarBooleanArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert_uc(byte argin) {
        byte[] values = new byte[1];
        this.attrval.r_dim.dim_x = 1;
        values[0] = argin;
        this.attrval.r_dim.dim_y = 0;
        DevVarCharArrayHelper.insert(this.attrval.value, values);
    }

    public void insert_uc(short argin) {
        byte[] values = new byte[]{(byte)(argin & 0xFF)};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarCharArrayHelper.insert(this.attrval.value, values);
    }

    public void insert_uc(short[] argin) {
        byte[] values = new byte[argin.length];
        for (int i = 0; i < argin.length; ++i) {
            values[i] = (byte)(argin[i] & 0xFF);
        }
        this.attrval.r_dim.dim_x = argin.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarCharArrayHelper.insert(this.attrval.value, values);
    }

    public void insert_uc(short[] argin, int dim_x, int dim_y) {
        byte[] values = new byte[argin.length];
        for (int i = 0; i < argin.length; ++i) {
            values[i] = (byte)(argin[i] & 0xFF);
        }
        this.attrval.r_dim.dim_x = dim_x;
        this.attrval.r_dim.dim_y = dim_y;
        DevVarCharArrayHelper.insert(this.attrval.value, values);
    }

    public void insert_uc(byte[] argin, int dim_x, int dim_y) {
        this.attrval.r_dim.dim_x = dim_x;
        this.attrval.r_dim.dim_y = dim_y;
        DevVarCharArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert(short argin) {
        short[] values = new short[]{argin};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarShortArrayHelper.insert(this.attrval.value, values);
    }

    public void insert(short[] argin) {
        this.attrval.r_dim.dim_x = argin.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarShortArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert(short[] argin, int dim_x, int dim_y) {
        this.attrval.r_dim.dim_x = dim_x;
        this.attrval.r_dim.dim_y = dim_y;
        DevVarShortArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert_us(short argin) {
        short[] values = new short[]{argin};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarUShortArrayHelper.insert(this.attrval.value, values);
    }

    public void insert_us(int argin) {
        short[] values = new short[]{(short)(argin & 0xFFFF)};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarUShortArrayHelper.insert(this.attrval.value, values);
    }

    public void insert_us(short[] argin) {
        this.attrval.r_dim.dim_x = argin.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarUShortArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert_us(int[] argin) {
        short[] values = new short[argin.length];
        for (int i = 0; i < argin.length; ++i) {
            values[i] = (short)(argin[i] & 0xFFFF);
        }
        this.attrval.r_dim.dim_x = argin.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarUShortArrayHelper.insert(this.attrval.value, values);
    }

    public void insert_us(short[] argin, int dim_x, int dim_y) {
        this.attrval.r_dim.dim_x = dim_x;
        this.attrval.r_dim.dim_y = dim_y;
        DevVarUShortArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert_us(int[] argin, int dim_x, int dim_y) {
        short[] values = new short[argin.length];
        for (int i = 0; i < argin.length; ++i) {
            values[i] = (short)(argin[i] & 0xFFFF);
        }
        this.attrval.r_dim.dim_x = dim_x;
        this.attrval.r_dim.dim_y = dim_y;
        DevVarUShortArrayHelper.insert(this.attrval.value, values);
    }

    public void insert(int argin) {
        int[] values = new int[]{argin};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarLongArrayHelper.insert(this.attrval.value, values);
    }

    public void insert(int[] argin) {
        this.attrval.r_dim.dim_x = argin.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarLongArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert(int[] argin, int dim_x, int dim_y) {
        this.attrval.r_dim.dim_x = dim_x;
        this.attrval.r_dim.dim_y = dim_y;
        DevVarLongArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert(float argin) {
        float[] values = new float[]{argin};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarFloatArrayHelper.insert(this.attrval.value, values);
    }

    public void insert(float[] argin) {
        this.attrval.r_dim.dim_x = argin.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarFloatArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert(float[] argin, int dim_x, int dim_y) {
        this.attrval.r_dim.dim_x = dim_x;
        this.attrval.r_dim.dim_y = dim_y;
        DevVarFloatArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert(double argin) {
        double[] values = new double[]{argin};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarDoubleArrayHelper.insert(this.attrval.value, values);
    }

    public void insert(double[] argin) {
        this.attrval.r_dim.dim_x = argin.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarDoubleArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert(double[] argin, int dim_x, int dim_y) {
        this.attrval.r_dim.dim_x = dim_x;
        this.attrval.r_dim.dim_y = dim_y;
        DevVarDoubleArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert(String argin) {
        String[] values = new String[]{argin};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarStringArrayHelper.insert(this.attrval.value, values);
    }

    public void insert(String[] argin) {
        this.attrval.r_dim.dim_x = argin.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarStringArrayHelper.insert(this.attrval.value, argin);
    }

    public void insert(String[] argin, int dim_x, int dim_y) {
        this.attrval.r_dim.dim_x = dim_x;
        this.attrval.r_dim.dim_y = dim_y;
        DevVarStringArrayHelper.insert(this.attrval.value, argin);
    }

    private void manageExceptions(String method_name) throws DevFailed {
        if (this.attrval.err_list != null && this.attrval.err_list.length > 0) {
            throw new WrongData(this.attrval.err_list);
        }
        if (this.attrval.quality == AttrQuality.ATTR_INVALID) {
            Except.throw_wrong_data_exception("AttrQuality_ATTR_INVALID", "Attrubute quality factor is INVALID", "DeviceAttribute." + method_name + "()");
        }
    }

    public boolean extractBoolean() throws DevFailed {
        this.manageExceptions("extractBoolean");
        boolean[] array = this.extractBooleanArray();
        return array[0];
    }

    public boolean[] extractBooleanArray() throws DevFailed {
        this.manageExceptions("extractBooleanArray()");
        return DevVarBooleanArrayHelper.extract(this.attrval.value);
    }

    public short extractUChar() throws DevFailed {
        this.manageExceptions("extractUChar");
        short[] array = this.extractUCharArray();
        return array[0];
    }

    public short[] extractUCharArray() throws DevFailed {
        this.manageExceptions("extractUCharArray()");
        byte[] argout = DevVarCharArrayHelper.extract(this.attrval.value);
        short[] val = new short[argout.length];
        int mask = 255;
        for (int i = 0; i < argout.length; ++i) {
            val[i] = (short)(mask & argout[i]);
        }
        return val;
    }

    public byte[] extractCharArray() throws DevFailed {
        this.manageExceptions("extractCharArray()");
        return DevVarCharArrayHelper.extract(this.attrval.value);
    }

    public short extractShort() throws DevFailed {
        this.manageExceptions("xtractShort()");
        short[] array = this.extractShortArray();
        return array[0];
    }

    public short[] extractShortArray() throws DevFailed {
        this.manageExceptions("extractShortArray");
        return DevVarShortArrayHelper.extract(this.attrval.value);
    }

    public int extractUShort() throws DevFailed {
        this.manageExceptions("extractUShort");
        int[] array = this.extractUShortArray();
        return array[0];
    }

    public int[] extractUShortArray() throws DevFailed {
        this.manageExceptions("extractUShortArray");
        short[] argout = DevVarUShortArrayHelper.extract(this.attrval.value);
        int[] val = new int[argout.length];
        for (int i = 0; i < argout.length; ++i) {
            val[i] = 0xFFFF & argout[i];
        }
        return val;
    }

    public int extractLong() throws DevFailed {
        this.manageExceptions("extractLong");
        int[] array = this.extractLongArray();
        return array[0];
    }

    public int[] extractLongArray() throws DevFailed {
        this.manageExceptions("extractLongArray");
        return DevVarLongArrayHelper.extract(this.attrval.value);
    }

    public float extractFloat() throws DevFailed {
        this.manageExceptions("extractFloat");
        float[] array = this.extractFloatArray();
        return array[0];
    }

    public float[] extractFloatArray() throws DevFailed {
        this.manageExceptions("extractFloatArray");
        return DevVarFloatArrayHelper.extract(this.attrval.value);
    }

    public double extractDouble() throws DevFailed {
        this.manageExceptions("extractDouble");
        double[] array = this.extractDoubleArray();
        return array[0];
    }

    public double[] extractDoubleArray() throws DevFailed {
        this.manageExceptions("extractDoubleArray");
        return DevVarDoubleArrayHelper.extract(this.attrval.value);
    }

    public DevState extractState() throws DevFailed {
        this.manageExceptions("extractState");
        return DevStateHelper.extract(this.attrval.value);
    }

    public String extractString() throws DevFailed {
        this.manageExceptions("extractString");
        String[] array = this.extractStringArray();
        return array[0];
    }

    public String[] extractStringArray() throws DevFailed {
        this.manageExceptions("extractStringArray");
        return DevVarStringArrayHelper.extract(this.attrval.value);
    }

    public AttrQuality getQuality() throws DevFailed {
        this.manageExceptions("getQuality");
        return this.attrval.quality;
    }

    public TimeVal getTimeVal() throws DevFailed {
        this.manageExceptions("getTimeVal");
        return this.attrval.time;
    }

    public long getTimeValSec() throws DevFailed {
        this.manageExceptions("getTimeValSec");
        return this.attrval.time.tv_sec;
    }

    public long getTimeValMillisSec() throws DevFailed {
        this.manageExceptions("getTimeValMillisSec");
        return (long)this.attrval.time.tv_sec * 1000L + (long)this.attrval.time.tv_usec / 1000L;
    }

    public String getName() throws DevFailed {
        return this.attrval.name;
    }

    private int DIM_MINI(int x) {
        return x == 0 ? 1 : x;
    }

    public int getNbRead() throws DevFailed {
        this.manageExceptions("getNbRead");
        return this.attrval.r_dim.dim_x * this.DIM_MINI(this.attrval.r_dim.dim_y);
    }

    public int getNbWritten() throws DevFailed {
        this.manageExceptions("getNbWritten");
        return this.attrval.w_dim.dim_x * this.DIM_MINI(this.attrval.w_dim.dim_y);
    }

    public int getDimX() throws DevFailed {
        this.manageExceptions("getDimX");
        return this.attrval.r_dim.dim_x;
    }

    public int getDimY() throws DevFailed {
        this.manageExceptions("getDimY");
        return this.attrval.r_dim.dim_y;
    }

    public int getWrittenDimX() throws DevFailed {
        this.manageExceptions("getWrittenDimX");
        return this.attrval.w_dim.dim_x;
    }

    public int getWrittenDimY() throws DevFailed {
        this.manageExceptions("getWrittenDimY");
        return this.attrval.w_dim.dim_y;
    }

    public AttributeValue getAttributeValueObject_2() {
        AttributeValue attrval = new AttributeValue();
        attrval.value = this.attrval.value;
        attrval.name = this.attrval.name;
        attrval.quality = this.attrval.quality;
        attrval.time = this.attrval.time;
        attrval.dim_x = this.attrval.r_dim.dim_x;
        attrval.dim_y = this.attrval.r_dim.dim_y;
        return attrval;
    }

    public AttributeValue_3 getAttributeValueObject_3() {
        return this.attrval;
    }

    public long getTime() throws DevFailed {
        this.manageExceptions("getTime");
        return (long)this.attrval.time.tv_sec * 1000L + (long)(this.attrval.time.tv_usec / 1000);
    }

    public int getType() throws DevFailed {
        int type = -1;
        try {
            TypeCode tc = this.attrval.value.type();
            if (tc.kind().value() == 17) {
                return 19;
            }
            TypeCode tc_alias = tc.content_type();
            TypeCode tc_seq = tc_alias.content_type();
            TCKind kind = tc_seq.kind();
            switch (kind.value()) {
                case 1: {
                    type = 0;
                    break;
                }
                case 8: {
                    type = 1;
                    break;
                }
                case 9: {
                    type = 21;
                    break;
                }
                case 10: {
                    type = 22;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 4: {
                    type = 6;
                    break;
                }
                case 3: {
                    type = 3;
                    break;
                }
                case 5: {
                    type = 7;
                    break;
                }
                case 6: {
                    type = 4;
                    break;
                }
                case 7: {
                    type = 5;
                    break;
                }
                case 18: {
                    type = 8;
                }
            }
        }
        catch (BadKind e) {
            Except.throw_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type ", "DeviceAttribute.getType()");
        }
        return type;
    }
}

