/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.NetEditor;
import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import fr.esrf.tangoatk.widget.util.interlock.NetUtils;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class NetObjectDlg
extends JDialog
implements ActionListener {
    private JPanel generalPanel;
    private JPanel extPanel;
    private JLabel[] extLabel;
    private JTextField[] extText;
    private JPanel labelPanel;
    private JScrollPane labelScroll;
    private JTextArea labelText;
    private JLabel justifyLabel;
    private JComboBox justifyCombo;
    private JLabel textFontLabel;
    private JComboBox textFontCombo;
    private JCheckBox textFontBold;
    private JTextField textFontSize;
    private JPanel propPanel;
    private JLabel shapeLabel;
    private JComboBox shapeCombo;
    private JLabel sizeLabel;
    private JTextField sizeText;
    private JButton closeBtn;
    private JButton applyBtn;
    private NetObject theObject;
    private NetEditor parentEditor;
    private int curY;
    private boolean modified;

    public NetObjectDlg(JDialog jDialog, NetEditor netEditor) {
        super((Dialog)jDialog, true);
        this.parentEditor = netEditor;
        this.initComponents();
    }

    public NetObjectDlg(JFrame jFrame, NetEditor netEditor) {
        super((Frame)jFrame, true);
        this.parentEditor = netEditor;
        this.initComponents();
    }

    public void editObject(NetObject netObject) {
        this.theObject = netObject;
        this.curY = 0;
        int n = this.theObject.getExtendedParamNumber();
        this.extPanel.removeAll();
        if (n > 0) {
            this.extLabel = new JLabel[n];
            this.extText = new JTextField[n];
            for (int i = 0; i < n; ++i) {
                this.extLabel[i] = NetUtils.createLabel(this.theObject.extParamName[i]);
                this.extLabel[i].setBounds(10, this.curY + 20, 90, 25);
                this.extText[i] = new JTextField();
                this.extText[i].setEditable(true);
                this.extText[i].setBounds(105, this.curY + 20, 190, 25);
                this.extText[i].setText(this.theObject.getExtendedParam(i));
                this.extPanel.add(this.extLabel[i]);
                this.extPanel.add(this.extText[i]);
                this.curY += 30;
            }
            this.curY += 30;
            this.extPanel.setBounds(5, 5, 305, this.curY);
            this.extPanel.setVisible(true);
        } else {
            this.extPanel.setVisible(false);
        }
        if (this.theObject.type == 1) {
            this.sizeText.setText(Integer.toString(this.theObject.getSize()));
            this.shapeCombo.setSelectedIndex(this.theObject.getShape());
            this.shapeCombo.setEnabled(this.theObject.editableShape);
            this.propPanel.setBounds(5, 5 + this.curY, 305, 90);
            this.propPanel.setVisible(true);
            this.curY += 90;
        } else {
            this.propPanel.setVisible(false);
        }
        this.justifyCombo.setSelectedIndex(this.theObject.getJustify());
        this.labelText.setText(this.theObject.getLabel());
        if (this.theObject.type == 2) {
            this.labelPanel.setBounds(5, this.curY + 5, 305, 165);
            this.textFontLabel.setVisible(true);
            this.textFontCombo.setVisible(true);
            this.textFontBold.setVisible(true);
            this.textFontSize.setVisible(true);
            this.textFontCombo.setSelectedIndex(NetUtils.getIdx(this.theObject.getTextFont().getName()));
            this.textFontSize.setText(Integer.toString(this.theObject.getTextFont().getSize()));
            this.textFontBold.setSelected(this.theObject.getTextFont().isBold());
            this.curY += 30;
        } else {
            this.labelPanel.setBounds(5, this.curY + 5, 305, 135);
            this.textFontLabel.setVisible(false);
            this.textFontCombo.setVisible(false);
            this.textFontBold.setVisible(false);
            this.textFontSize.setVisible(false);
        }
        this.closeBtn.setBounds(208, this.curY + 145, 100, 25);
        this.applyBtn.setBounds(7, this.curY + 145, 100, 25);
        this.setTitle(this.theObject.getName() + " options");
        this.modified = false;
        NetUtils.centerDialog(this, 315, 175 + this.curY);
        this.setVisible(true);
    }

    public boolean getModified() {
        return this.modified;
    }

    private void initComponents() {
        this.getContentPane().setLayout(null);
        this.generalPanel = new JPanel();
        this.generalPanel.setLayout(null);
        this.extPanel = new JPanel();
        this.extPanel.setLayout(null);
        this.extPanel.setBorder(NetUtils.createTitleBorder("Bubble parameters"));
        this.generalPanel.add(this.extPanel);
        this.propPanel = new JPanel();
        this.propPanel.setLayout(null);
        this.propPanel.setBorder(NetUtils.createTitleBorder("Bubble shape"));
        this.shapeLabel = NetUtils.createLabel("Shape");
        this.shapeLabel.setBounds(10, 20, 90, 25);
        this.shapeCombo = new JComboBox();
        this.shapeCombo.addItem("Circle");
        this.shapeCombo.addItem("Square");
        this.shapeCombo.addItem("Hexagon");
        this.shapeCombo.addItem("VCC symbol");
        this.shapeCombo.addItem("Ground symbol");
        this.shapeCombo.addItem("Dot");
        this.shapeCombo.addItem("Computer1");
        this.shapeCombo.addItem("Device1");
        this.shapeCombo.addItem("Device2");
        this.shapeCombo.addItem("Device3");
        this.shapeCombo.addItem("NetDevice1");
        this.shapeCombo.addItem("NetDevice2");
        this.shapeCombo.addItem("NetDevice3");
        this.shapeCombo.addItem("Printer1");
        this.shapeCombo.addItem("Printer2");
        this.shapeCombo.addItem("Printer3");
        this.shapeCombo.addItem("Server1");
        this.shapeCombo.addItem("Server2");
        this.shapeCombo.addItem("Storage1");
        this.shapeCombo.addItem("Storage2");
        this.shapeCombo.addItem("Storage3");
        this.shapeCombo.addItem("Storage4");
        this.shapeCombo.addItem("Storage5");
        this.shapeCombo.addItem("XTerm");
        this.shapeCombo.addActionListener(this);
        this.shapeCombo.setBounds(105, 20, 190, 25);
        this.sizeLabel = NetUtils.createLabel("Bubble size");
        this.sizeLabel.setBounds(10, 50, 90, 25);
        this.sizeText = new JTextField();
        this.sizeText.setEditable(true);
        this.sizeText.setBounds(105, 50, 190, 25);
        this.propPanel.add(this.shapeLabel);
        this.propPanel.add(this.shapeCombo);
        this.propPanel.add(this.sizeLabel);
        this.propPanel.add(this.sizeText);
        this.generalPanel.add(this.propPanel);
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(null);
        this.labelPanel.setBorder(NetUtils.createTitleBorder("Label"));
        this.justifyLabel = NetUtils.createLabel("Justify");
        this.justifyLabel.setBounds(10, 100, 90, 25);
        this.justifyCombo = new JComboBox();
        this.justifyCombo.addItem("Left");
        this.justifyCombo.addItem("Right");
        this.justifyCombo.addItem("Center");
        this.justifyCombo.setBounds(105, 100, 190, 25);
        this.labelText = new JTextArea();
        this.labelText.setEditable(true);
        this.labelScroll = new JScrollPane(this.labelText);
        this.labelScroll.setBounds(10, 20, 285, 75);
        this.textFontLabel = NetUtils.createLabel("Text font");
        this.textFontLabel.setBounds(10, 130, 90, 25);
        this.textFontCombo = NetUtils.createFontCombo();
        this.textFontCombo.setBounds(105, 130, 95, 25);
        this.textFontSize = new JTextField();
        this.textFontSize.setEditable(true);
        this.textFontSize.setBounds(200, 130, 35, 25);
        this.textFontBold = new JCheckBox();
        this.textFontBold.setFont(NetUtils.labelFont);
        this.textFontBold.setText("Bold");
        this.textFontBold.setBounds(235, 130, 50, 25);
        this.labelPanel.add(this.labelScroll);
        this.labelPanel.add(this.justifyLabel);
        this.labelPanel.add(this.justifyCombo);
        this.labelPanel.add(this.textFontLabel);
        this.labelPanel.add(this.textFontCombo);
        this.labelPanel.add(this.textFontSize);
        this.labelPanel.add(this.textFontBold);
        this.generalPanel.add(this.labelPanel);
        this.closeBtn = new JButton();
        this.closeBtn.setText("Dismiss");
        this.closeBtn.setFont(NetUtils.labelFont);
        this.closeBtn.addActionListener(this);
        this.applyBtn = new JButton();
        this.applyBtn.setText("Apply");
        this.applyBtn.setFont(NetUtils.labelFont);
        this.applyBtn.addActionListener(this);
        this.generalPanel.add(this.closeBtn);
        this.generalPanel.add(this.applyBtn);
        this.setContentPane(this.generalPanel);
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeBtn) {
            this.hide();
        } else if (actionEvent.getSource() == this.applyBtn) {
            if (this.extPanel.isVisible()) {
                for (int i = 0; i < this.extLabel.length; ++i) {
                    this.theObject.setExtendedParam(i, this.extText[i].getText());
                }
            }
            this.theObject.setLabel(this.labelText.getText());
            this.theObject.setJustify(this.justifyCombo.getSelectedIndex());
            if (this.theObject.type == 2) {
                this.theObject.setTextFont(new Font(this.textFontCombo.getSelectedItem().toString(), this.textFontBold.isSelected() ? 1 : 0, Integer.parseInt(this.textFontSize.getText())));
            }
            if (this.propPanel.isVisible()) {
                this.theObject.setShape(this.shapeCombo.getSelectedIndex());
                try {
                    this.theObject.setSize(Integer.parseInt(this.sizeText.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Invalid size value\n" + numberFormatException.getMessage());
                }
            }
            this.modified = true;
            this.parentEditor.repaint();
        }
    }
}

