/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class JSmoothProgressBar
extends JComponent {
    private static Color darkProgressDefault = new Color(110, 110, 160);
    private static Color backProgressDefault = new Color(156, 154, 206);
    private static Color lightProgressDefault = new Color(196, 200, 240);
    private int off_x = 0;
    private int off_y = 0;
    private float currentValue = 0.0f;
    private float maxValue = 100.0f;
    private boolean stringPaint;
    private Color darkProgress = darkProgressDefault;
    private Color backProgress = backProgressDefault;
    private Color lightProgress = lightProgressDefault;
    private Insets borderMargin;
    private int ascent;
    private int[] dgSize;
    private int prSize;
    private int totalSize;
    private int[] digit;
    private double ratio;

    public JSmoothProgressBar() {
        this.setBackground(new Color(206, 206, 206));
        this.setForeground(backProgressDefault);
        this.setFont(new Font("Dialog", 1, 12));
        this.stringPaint = false;
        this.setOpaque(true);
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.updateDigit();
    }

    public void setProgressBarColors(Color color, Color color2, Color color3) {
        this.darkProgress = color3;
        this.lightProgress = color2;
        this.backProgress = color;
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this.borderMargin = border == null ? new Insets(0, 0, 0, 0) : this.getBorder().getBorderInsets(this);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.dgSize = new int[10];
        for (int i = 0; i < 10; ++i) {
            this.dgSize[i] = ATKGraphicsUtils.measureString((String)Integer.toString((int)i), (Font)font).width + 1;
        }
        this.prSize = ATKGraphicsUtils.measureString((String)"%", (Font)font).width;
        this.ascent = (int)((double)ATKGraphicsUtils.getLineMetrics("100%", font).getAscent() + 0.5);
    }

    public void setValue(int n) {
        this.currentValue = (float)n >= this.maxValue ? this.maxValue : (float)n;
        this.updateDigit();
        this.repaint();
    }

    public int getValue() {
        return (int)this.currentValue;
    }

    public void setMaximum(int n) {
        this.maxValue = n;
        if (this.maxValue <= this.currentValue) {
            this.currentValue = this.maxValue;
        }
        this.updateDigit();
        this.repaint();
    }

    public int getMaximum() {
        return (int)this.maxValue;
    }

    public void setIndeterminate(boolean bl) {
    }

    public void setStringPainted(boolean bl) {
        this.stringPaint = bl;
        this.repaint();
    }

    public void setValueOffsets(int n, int n2) {
        this.off_x = n;
        this.off_y = n2;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n - (this.borderMargin.left + this.borderMargin.right + 1);
        int n4 = n2 - (this.borderMargin.bottom + this.borderMargin.top + 1);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        int n5 = (int)Math.rint((double)n3 * this.ratio);
        graphics.setColor(this.backProgress);
        graphics.fillRect(this.borderMargin.left, this.borderMargin.top, n5, n4);
        graphics.setColor(this.lightProgress);
        graphics.drawLine(this.borderMargin.left, this.borderMargin.top, this.borderMargin.left + n5, this.borderMargin.top);
        graphics.drawLine(this.borderMargin.left, this.borderMargin.top, this.borderMargin.left, this.borderMargin.top + n4);
        graphics.setColor(this.darkProgress);
        graphics.drawLine(this.borderMargin.left + n5, this.borderMargin.top, this.borderMargin.left + n5, this.borderMargin.top + n4);
        graphics.drawLine(this.borderMargin.left + n5, this.borderMargin.top + n4, this.borderMargin.left, this.borderMargin.top + n4);
        if (this.stringPaint) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int n6 = (n - this.totalSize) / 2 + this.off_x;
            int n7 = (n4 + this.ascent) / 2 + this.off_y + this.borderMargin.top;
            int n8 = 0;
            graphics.setFont(this.getFont());
            for (int i = 0; i < this.digit.length; ++i) {
                graphics.setColor(this.selectColor(n6 + n8 + this.dgSize[this.digit[i]] / 3 > n5));
                graphics.drawString(Integer.toString(this.digit[i]), n6 + n8, n7);
                n8 += this.dgSize[this.digit[i]];
            }
            graphics.setColor(this.selectColor(n6 + n8 + this.prSize / 3 > n5));
            graphics.drawString("%", n6 + n8, n7);
        }
        this.paintBorder(graphics);
    }

    private Color selectColor(boolean bl) {
        if (bl) {
            return this.getForeground();
        }
        return this.getBackground();
    }

    private void updateDigit() {
        this.ratio = (double)(this.currentValue / this.maxValue) + 1.0E-4;
        if (this.ratio < 0.0) {
            this.ratio = 0.0;
        }
        if (this.ratio > 1.0) {
            this.ratio = 1.0;
        }
        if (Double.isNaN(this.ratio)) {
            this.ratio = 0.0;
        }
        int n = (int)this.ratio;
        int n2 = (int)(this.ratio * 10.0) % 10;
        int n3 = (int)(this.ratio * 100.0) % 10;
        if (n == 0) {
            if (n2 == 0) {
                this.digit = new int[1];
                this.digit[0] = n3;
            } else {
                this.digit = new int[2];
                this.digit[0] = n2;
                this.digit[1] = n3;
            }
        } else {
            this.digit = new int[3];
            this.digit[0] = n;
            this.digit[1] = n2;
            this.digit[2] = n3;
        }
        this.totalSize = this.prSize;
        for (int i = 0; i < this.digit.length; ++i) {
            this.totalSize += this.dgSize[this.digit[i]];
        }
    }
}

