/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.widget.attribute.NumberScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.attribute.StringScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.StringScalarEditor;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ScalarListSetter
extends JPanel
implements JAutoScrolledTextListener {
    public static final String NUMBER_DEFAULT_SETTER = "WheelEditor";
    public static final String NUMBER_COMBO_SETTER = "ComboEditor";
    public static final String STRING_DEFAULT_SETTER = "StringScalarEditor";
    public static final String STRING_COMBO_SETTER = "StringComboEditor";
    private Vector listModel = null;
    private Vector scalarLabels = null;
    private Vector scalarViewers = null;
    private Vector scalarSetters = null;
    private Vector scalarPropButtons = null;
    private SimplePropertyFrame propFrame = new SimplePropertyFrame();
    private Font theFont = new Font("Dialog", 0, 14);
    private boolean labelVisible = true;
    private boolean viewerVisible = true;
    private boolean propertyButtonVisible = true;
    private boolean propertyListEditable = true;
    private boolean unitVisible = true;
    private String numberSetterType = "WheelEditor";
    private String stringSetterType = "StringScalarEditor";
    private Color arrowColor = null;

    public ScalarListSetter() {
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
    }

    public void setModel(AttributeList attributeList) {
        if (attributeList == null) {
            if (this.listModel != null) {
                this.removeComponents();
            }
            return;
        }
        if (this.listModel != null) {
            return;
        }
        int n = attributeList.getSize();
        if (n <= 0) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            IScalarAttribute iScalarAttribute;
            Object object = attributeList.getElementAt(i);
            if (!(object instanceof INumberScalar) && !(object instanceof IStringScalar) || !(iScalarAttribute = (IScalarAttribute)object).isWritable()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        this.initComponents(attributeList);
        this.setVisible(true);
    }

    private void removeComponents() {
        Object var3_1 = null;
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        StringScalarEditor stringScalarEditor = null;
        StringScalarComboEditor stringScalarComboEditor = null;
        Object var12_8 = null;
        this.propFrame = null;
        this.propFrame = new SimplePropertyFrame();
        int n = this.listModel.size();
        for (int i = 0; i < n; ++i) {
            try {
                INumberScalar iNumberScalar = null;
                IStringScalar iStringScalar = null;
                var3_1 = this.listModel.get(i);
                if (var3_1 instanceof INumberScalar) {
                    iNumberScalar = var3_1;
                } else if (var3_1 instanceof IStringScalar) {
                    iStringScalar = var3_1;
                }
                if (iNumberScalar == null && iStringScalar == null) continue;
                var3_1 = this.scalarLabels.get(i);
                if (var3_1 instanceof LabelViewer) {
                    labelViewer = var3_1;
                    labelViewer.setModel(null);
                }
                if ((var3_1 = this.scalarViewers.get(i)) instanceof SimpleScalarViewer) {
                    simpleScalarViewer = var3_1;
                    simpleScalarViewer.clearModel();
                }
                if ((var3_1 = this.scalarSetters.get(i)) instanceof NumberScalarWheelEditor) {
                    numberScalarWheelEditor = var3_1;
                    numberScalarWheelEditor.setModel(null);
                    continue;
                }
                if (var3_1 instanceof NumberScalarComboEditor) {
                    numberScalarComboEditor = var3_1;
                    numberScalarComboEditor.setNumberModel(null);
                    continue;
                }
                if (var3_1 instanceof StringScalarEditor) {
                    stringScalarEditor = var3_1;
                    stringScalarEditor.setModel(null);
                    continue;
                }
                if (!(var3_1 instanceof StringScalarComboEditor)) continue;
                stringScalarComboEditor = var3_1;
                stringScalarComboEditor.setStringModel(null);
                continue;
            }
            catch (Exception exception) {
                System.out.println("ScalarListSetter : setTheFont : Caught exception  " + exception.getMessage());
            }
        }
        this.scalarLabels.removeAllElements();
        this.scalarViewers.removeAllElements();
        this.scalarSetters.removeAllElements();
        this.scalarPropButtons.removeAllElements();
        this.listModel.removeAllElements();
        this.removeAll();
        this.listModel = null;
        this.scalarLabels = null;
        this.scalarViewers = null;
        this.scalarSetters = null;
        this.scalarPropButtons = null;
    }

    public Font getTheFont() {
        return this.theFont;
    }

    public void setTheFont(Font font) {
        Object var4_2 = null;
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        Object var7_5 = null;
        Object var8_6 = null;
        JButton jButton = null;
        JComponent jComponent = null;
        if (font != null) {
            this.theFont = font;
            if (this.listModel != null) {
                int n = this.listModel.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        var4_2 = this.scalarLabels.get(i);
                        if (var4_2 instanceof LabelViewer) {
                            labelViewer = var4_2;
                            labelViewer.setFont(this.theFont);
                        }
                        if ((var4_2 = this.scalarViewers.get(i)) instanceof SimpleScalarViewer) {
                            simpleScalarViewer = var4_2;
                            simpleScalarViewer.setFont(this.theFont);
                        }
                        if ((var4_2 = this.scalarSetters.get(i)) instanceof NumberScalarWheelEditor || var4_2 instanceof NumberScalarComboEditor || var4_2 instanceof StringScalarEditor || var4_2 instanceof StringScalarComboEditor) {
                            jComponent = var4_2;
                            jComponent.setFont(this.theFont);
                        }
                        if (!((var4_2 = this.scalarPropButtons.get(i)) instanceof JButton)) continue;
                        jButton = var4_2;
                        jButton.setFont(this.theFont);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("ScalarListSetter : setTheFont : Caught exception  " + exception.getMessage());
                    }
                }
            }
        }
    }

    public boolean getLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean bl) {
        if (this.labelVisible != bl) {
            this.labelVisible = bl;
            this.changeLabelVisibility();
        }
    }

    private void changeLabelVisibility() {
        Object var3_1 = null;
        LabelViewer labelViewer = null;
        if (this.scalarLabels != null) {
            int n = this.scalarLabels.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.scalarLabels.get(i);
                    if (!(var3_1 instanceof LabelViewer)) continue;
                    labelViewer = var3_1;
                    labelViewer.setVisible(this.labelVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListSetter : changeLabelVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getViewerVisible() {
        return this.viewerVisible;
    }

    public void setViewerVisible(boolean bl) {
        if (this.viewerVisible != bl) {
            this.viewerVisible = bl;
            this.changeViewerVisibility();
        }
    }

    private void changeViewerVisibility() {
        Object var3_1 = null;
        JComponent jComponent = null;
        if (this.scalarViewers != null) {
            int n = this.scalarViewers.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.scalarViewers.get(i);
                    if (!(var3_1 instanceof SimpleScalarViewer)) continue;
                    jComponent = var3_1;
                    jComponent.setVisible(this.viewerVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListSetter : changeViewerVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyButtonVisible() {
        return this.propertyButtonVisible;
    }

    public void setPropertyButtonVisible(boolean bl) {
        if (this.propertyButtonVisible != bl) {
            this.propertyButtonVisible = bl;
            this.changePropButtonVisibility();
        }
    }

    private void changePropButtonVisibility() {
        Object var3_1 = null;
        JButton jButton = null;
        if (this.scalarPropButtons != null) {
            int n = this.scalarPropButtons.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.scalarPropButtons.get(i);
                    if (!(var3_1 instanceof JButton)) continue;
                    jButton = var3_1;
                    jButton.setVisible(this.propertyButtonVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListSetter : changePropButtonVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyListEditable() {
        return this.propertyListEditable;
    }

    public void setPropertyListEditable(boolean bl) {
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean bl) {
        if (this.unitVisible != bl) {
            this.unitVisible = bl;
            this.changeUnitVisibility();
        }
    }

    private void changeUnitVisibility() {
        Object var3_1 = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        if (this.scalarViewers != null) {
            int n = this.scalarViewers.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.scalarViewers.get(i);
                    if (var3_1 instanceof SimpleScalarViewer) {
                        simpleScalarViewer = var3_1;
                        simpleScalarViewer.setUnitVisible(this.unitVisible);
                    }
                    if (!((var3_1 = this.scalarSetters.get(i)) instanceof NumberScalarComboEditor)) continue;
                    numberScalarComboEditor = var3_1;
                    numberScalarComboEditor.setUnitVisible(this.unitVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListSetter : changeUnitVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public String getNumberSetterType() {
        return this.numberSetterType;
    }

    public void setNumberSetterType(String string) {
        if (this.listModel != null) {
            return;
        }
        this.numberSetterType = string.equalsIgnoreCase(NUMBER_DEFAULT_SETTER) ? NUMBER_DEFAULT_SETTER : (string.equalsIgnoreCase(NUMBER_COMBO_SETTER) ? NUMBER_COMBO_SETTER : NUMBER_DEFAULT_SETTER);
    }

    public String getStringSetterType() {
        return this.stringSetterType;
    }

    public void setStringSetterType(String string) {
        if (this.listModel != null) {
            return;
        }
        this.stringSetterType = string.equalsIgnoreCase(STRING_DEFAULT_SETTER) ? STRING_DEFAULT_SETTER : (string.equalsIgnoreCase(STRING_COMBO_SETTER) ? STRING_COMBO_SETTER : STRING_DEFAULT_SETTER);
    }

    public Color getArrowColor() {
        if (this.arrowColor == null) {
            return this.getBackground();
        }
        return this.arrowColor;
    }

    public void setArrowColor(Color color) {
        if (color == this.arrowColor) {
            return;
        }
        this.changeArrowColors(color);
        this.arrowColor = color;
    }

    private void changeArrowColors(Color color) {
        Object var4_2 = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        if (this.scalarSetters != null) {
            int n = this.scalarSetters.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var4_2 = this.scalarSetters.get(i);
                    if (!(var4_2 instanceof NumberScalarWheelEditor)) continue;
                    numberScalarWheelEditor = var4_2;
                    if (color == null) {
                        numberScalarWheelEditor.setButtonColor(numberScalarWheelEditor.getBackground());
                        continue;
                    }
                    numberScalarWheelEditor.setButtonColor(color);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changeArrowColors : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public void textExceedBounds(JAutoScrolledText jAutoScrolledText) {
        this.revalidate();
    }

    private void initComponents(AttributeList attributeList) {
        int n;
        Object object;
        Object object2;
        int n2;
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        StringScalarEditor stringScalarEditor = null;
        StringScalarComboEditor stringScalarComboEditor = null;
        JComponent jComponent = null;
        JButton jButton = null;
        this.listModel = new Vector();
        this.scalarLabels = new Vector();
        this.scalarViewers = new Vector();
        this.scalarSetters = new Vector();
        this.scalarPropButtons = new Vector();
        int n3 = 0;
        int n4 = attributeList.size();
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            labelViewer = null;
            simpleScalarViewer = null;
            numberScalarWheelEditor = null;
            numberScalarComboEditor = null;
            jComponent = null;
            stringScalarEditor = null;
            stringScalarComboEditor = null;
            jButton = null;
            object2 = attributeList.getElementAt(n2);
            if (!(object2 instanceof AAttribute) || !(object = (AAttribute)object2).isWritable() || !(object2 instanceof INumberScalar) && !(object2 instanceof IStringScalar)) continue;
            INumberScalar iNumberScalar = null;
            IStringScalar iStringScalar = null;
            if (object2 instanceof INumberScalar) {
                iNumberScalar = (INumberScalar)object2;
                if (this.numberSetterType.equalsIgnoreCase(NUMBER_COMBO_SETTER)) {
                    numberScalarComboEditor = new NumberScalarComboEditor();
                    numberScalarComboEditor.setFont(this.theFont);
                    numberScalarComboEditor.setBackground(this.getBackground());
                    numberScalarComboEditor.setUnitVisible(this.unitVisible);
                    numberScalarComboEditor.setNumberModel(iNumberScalar);
                    this.scalarSetters.add(numberScalarComboEditor);
                    jComponent = numberScalarComboEditor;
                } else {
                    numberScalarWheelEditor = new NumberScalarWheelEditor();
                    numberScalarWheelEditor.setFont(this.theFont);
                    numberScalarWheelEditor.setBackground(this.getBackground());
                    numberScalarWheelEditor.setModel(iNumberScalar);
                    this.scalarSetters.add(numberScalarWheelEditor);
                    jComponent = numberScalarWheelEditor;
                }
            } else {
                iStringScalar = (IStringScalar)object2;
                if (this.stringSetterType.equalsIgnoreCase(STRING_COMBO_SETTER)) {
                    stringScalarComboEditor = new StringScalarComboEditor();
                    stringScalarComboEditor.setFont(this.theFont);
                    stringScalarComboEditor.setStringModel(iStringScalar);
                    this.scalarSetters.add(stringScalarComboEditor);
                    jComponent = stringScalarComboEditor;
                } else {
                    stringScalarEditor = new StringScalarEditor();
                    stringScalarEditor.setFont(this.theFont);
                    stringScalarEditor.setModel(iStringScalar);
                    this.scalarSetters.add(stringScalarEditor);
                    jComponent = stringScalarEditor;
                }
            }
            labelViewer = new LabelViewer();
            simpleScalarViewer = new SimpleScalarViewer();
            jButton = new JButton();
            labelViewer.setFont(this.theFont);
            labelViewer.setHorizontalAlignment(JSmoothLabel.RIGHT_ALIGNMENT);
            labelViewer.setBackground(this.getBackground());
            if (this.labelVisible) {
                labelViewer.setVisible(true);
            } else {
                labelViewer.setVisible(false);
            }
            if (iNumberScalar != null) {
                labelViewer.setModel((IAttribute)iNumberScalar);
            } else {
                labelViewer.setModel((IAttribute)iStringScalar);
            }
            simpleScalarViewer.setFont(this.theFont);
            simpleScalarViewer.setFont(this.theFont);
            simpleScalarViewer.setUnitVisible(this.unitVisible);
            simpleScalarViewer.setBackgroundColor(this.getBackground());
            simpleScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
            simpleScalarViewer.setAlarmEnabled(true);
            simpleScalarViewer.setVisible(this.viewerVisible);
            if (iNumberScalar != null) {
                simpleScalarViewer.setModel(iNumberScalar);
            } else {
                simpleScalarViewer.setModel(iStringScalar);
            }
            jButton.setFont(this.theFont);
            jButton.setBackground(this.getBackground());
            jButton.setText(" ... ");
            jButton.setMargin(new Insets(-3, 0, 3, 0));
            if (!this.propertyButtonVisible && jButton != null) {
                jButton.setVisible(false);
            }
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScalarListSetter.this.propertyButtonActionPerformed(actionEvent);
                }
            });
            if (iNumberScalar != null) {
                iNumberScalar.refresh();
            } else {
                iStringScalar.refresh();
            }
            simpleScalarViewer.addTextListener(this);
            n = labelViewer.getPreferredSize().height;
            if (n > n5) {
                n5 = n;
            }
            if ((n = simpleScalarViewer.getPreferredSize().height) > n5) {
                n5 = n;
            }
            if ((n = jComponent.getPreferredSize().height) > n5) {
                n5 = n;
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(1, 5, 1, 1);
            this.add((Component)labelViewer, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(1, 2, 1, 1);
            this.add((Component)simpleScalarViewer, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.fill = 1;
            if (iNumberScalar != null) {
                gridBagConstraints.insets = new Insets(1, 1, 1, 1);
                this.add((Component)jComponent, gridBagConstraints);
            } else {
                gridBagConstraints.insets = new Insets(1, 3, 1, 1);
                this.add((Component)jComponent, gridBagConstraints);
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.insets = new Insets(1, 3, 1, 5);
            this.add((Component)jButton, gridBagConstraints);
            if (iNumberScalar != null) {
                this.listModel.add(iNumberScalar);
            } else {
                this.listModel.add(iStringScalar);
            }
            this.scalarLabels.add(labelViewer);
            this.scalarViewers.add(simpleScalarViewer);
            this.scalarPropButtons.add(jButton);
            ++n3;
        }
        int n6 = this.scalarViewers.size();
        for (n2 = 0; n2 < n6; ++n2) {
            int n7;
            object2 = this.scalarViewers.get(n2);
            if (object2 instanceof SimpleScalarViewer) {
                simpleScalarViewer = (SimpleScalarViewer)object2;
                n = simpleScalarViewer.getPreferredSize().height;
                if (n < n5) {
                    n7 = (n5 - n) / 2;
                    object = simpleScalarViewer.getMargin();
                    object.top += n7;
                    object.bottom += n7;
                    simpleScalarViewer.setMargin((Insets)object);
                }
            }
            if (!((object2 = this.scalarSetters.get(n2)) instanceof StringScalarEditor)) continue;
            stringScalarEditor = (StringScalarEditor)object2;
            n = stringScalarEditor.getPreferredSize().height;
            if (n >= n5) continue;
            n7 = (n5 - n) / 2;
            object = stringScalarEditor.getMargin();
            object.top += n7;
            object.bottom += n7;
            stringScalarEditor.setMargin((Insets)object);
            stringScalarEditor.setMargin(new Insets(n7, 3, n7 + 2, 3));
        }
    }

    private void propertyButtonActionPerformed(ActionEvent actionEvent) {
        Object e;
        int n = -1;
        if (this.scalarPropButtons == null) {
            return;
        }
        if (this.listModel == null) {
            return;
        }
        int n2 = this.scalarPropButtons.size();
        for (int i = 0; i < n2; ++i) {
            try {
                JButton jButton;
                e = this.scalarPropButtons.get(i);
                if (!(e instanceof JButton) || !(jButton = (JButton)e).equals(actionEvent.getSource())) continue;
                n = i;
                break;
            }
            catch (Exception exception) {
                System.out.println("ScalarListSetter : propertyButtonActionPerformed : Caught exception  " + exception.getMessage());
                return;
            }
        }
        if (n < 0) {
            return;
        }
        INumberScalar iNumberScalar = null;
        IStringScalar iStringScalar = null;
        try {
            e = this.listModel.get(n);
            if (e instanceof INumberScalar) {
                iNumberScalar = (INumberScalar)e;
            } else if (e instanceof IStringScalar) {
                iStringScalar = (IStringScalar)e;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iNumberScalar == null && iStringScalar == null) {
            return;
        }
        if (this.propFrame != null) {
            if (iNumberScalar != null) {
                this.propFrame.setModel((IAttribute)iNumberScalar);
            } else {
                this.propFrame.setModel((IAttribute)iStringScalar);
            }
            this.propFrame.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        final AttributeList attributeList = new AttributeList();
        ScalarListSetter scalarListSetter = new ScalarListSetter();
        try {
            scalarListSetter.setViewerVisible(false);
            INumberScalar iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_un");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_deux");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_trois");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_quatre");
            IStringScalar iStringScalar = (IStringScalar)attributeList.add("jlp/test/1/att_cinq");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_six");
            scalarListSetter.setPropertyButtonVisible(false);
            scalarListSetter.setModel(attributeList);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                attributeList.startRefresher();
            }
        });
        jFrame.setContentPane(scalarListSetter);
        jFrame.pack();
        jFrame.show();
        try {
            Thread.sleep(4000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

