/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import com.braju.format.Format;
import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class NumberScalarComboEditor
extends JComboBox
implements ActionListener,
INumberScalarListener,
JDrawable {
    static String[] exts = new String[]{"valueList"};
    private String jdrawExts = "";
    private DefaultComboBoxModel comboModel = null;
    private String defActionCmd = "setAttActionCmd";
    private String modelFormat = "";
    private String modelUnit = "";
    private String[] defOptionList = new String[]{"0.0"};
    private String[] optionList = new String[]{"0.0"};
    private INumberScalar numberModel = null;
    private boolean unitVisible = true;

    public NumberScalarComboEditor() {
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.setActionCommand(this.defActionCmd);
        this.addActionListener(this);
    }

    public INumberScalar getNumberModel() {
        return this.numberModel;
    }

    public void setNumberModel(INumberScalar iNumberScalar) {
        double[] dArray = null;
        int n = 0;
        String[] stringArray = null;
        if (this.numberModel != null) {
            this.numberModel.removeNumberScalarListener((INumberScalarListener)this);
            this.numberModel = null;
            this.modelFormat = "";
            this.optionList = this.defOptionList;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
        if (iNumberScalar == null) {
            return;
        }
        if (!iNumberScalar.isWritable()) {
            throw new IllegalArgumentException("NumberScalarComboEditor: Only accept writeable attribute.");
        }
        this.numberModel = iNumberScalar;
        this.modelFormat = this.numberModel.getProperty("format").getPresentation();
        this.modelUnit = this.numberModel.getProperty("unit").getPresentation();
        Double d = new Double(0.0);
        Object[] objectArray = new Object[]{d};
        String string = Format.sprintf((String)this.modelFormat, (Object[])objectArray);
        string = string.replace('0', '?');
        dArray = this.numberModel.getPossibleValues();
        stringArray = null;
        if (dArray != null && (n = dArray.length) > 0) {
            stringArray = new String[n + 1];
            int n2 = 0;
            stringArray[0] = new String(string + " ");
            for (n2 = 0; n2 < n; ++n2) {
                String string2;
                if (this.modelFormat.indexOf(37) == -1) {
                    string2 = AttrManip.format((String)this.modelFormat, (double)dArray[n2]);
                } else {
                    Double d2 = new Double(dArray[n2]);
                    Object[] objectArray2 = new Object[]{d2};
                    string2 = Format.sprintf((String)this.modelFormat, (Object[])objectArray2);
                }
                stringArray[n2 + 1] = this.unitVisible ? new String(string2 + " " + this.numberModel.getUnit()) : new String(string2 + " ");
            }
        }
        if (stringArray == null) {
            stringArray = new String[]{new String(string + " ")};
        }
        if (stringArray != null) {
            this.optionList = stringArray;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
        this.numberModel.addNumberScalarListener((INumberScalarListener)this);
        this.numberModel.refresh();
    }

    public void setUnitVisible(boolean bl) {
        if (this.unitVisible != bl) {
            this.changeUnitVisibility(bl);
        }
        this.unitVisible = bl;
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    private void changeUnitVisibility(boolean bl) {
        double[] dArray = null;
        int n = 0;
        String[] stringArray = null;
        if (this.numberModel == null) {
            return;
        }
        Double d = new Double(0.0);
        Object[] objectArray = new Object[]{d};
        String string = Format.sprintf((String)this.modelFormat, (Object[])objectArray);
        string = string.replace('0', '?');
        dArray = this.numberModel.getPossibleValues();
        stringArray = null;
        if (dArray != null && (n = dArray.length) > 0) {
            stringArray = new String[n + 1];
            int n2 = 0;
            stringArray[0] = new String(string + " ");
            for (n2 = 0; n2 < n; ++n2) {
                String string2;
                if (this.modelFormat.indexOf(37) == -1) {
                    string2 = AttrManip.format((String)this.modelFormat, (double)dArray[n2]);
                } else {
                    Double d2 = new Double(dArray[n2]);
                    Object[] objectArray2 = new Object[]{d2};
                    string2 = Format.sprintf((String)this.modelFormat, (Object[])objectArray2);
                }
                stringArray[n2 + 1] = bl ? new String(string2 + " " + this.numberModel.getUnit()) : new String(string2 + " ");
            }
        }
        if (stringArray == null) {
            stringArray = new String[]{new String(string + " ")};
        }
        if (stringArray != null) {
            this.optionList = stringArray;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        double d = Double.NaN;
        d = this.hasFocus() ? this.numberModel.getNumberScalarSetPointFromDevice() : this.numberModel.getNumberScalarSetPoint();
        this.changeSelectedOption(d);
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.changeSelectedOption(Double.NaN);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = null;
        String string = null;
        double d = 0.0;
        int n = 0;
        String string2 = null;
        jComboBox = (JComboBox)actionEvent.getSource();
        string = (String)jComboBox.getSelectedItem();
        if (!actionEvent.getActionCommand().equals(this.defActionCmd)) {
            return;
        }
        if (string == null) {
            return;
        }
        if (this.numberModel == null) {
            return;
        }
        n = string.indexOf(" " + this.numberModel.getUnit());
        string2 = n > 0 ? string.substring(0, n) : string;
        d = Double.NaN;
        d = this.parseSelectedValue(string2);
        if (!Double.isNaN(d)) {
            this.numberModel.setValue(d);
        }
    }

    private double parseSelectedValue(String string) {
        double d = Double.NaN;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        return d;
    }

    private void changeSelectedOption(double d) {
        int n;
        double[] dArray = null;
        int n2 = 0;
        if (this.numberModel == null) {
            return;
        }
        int n3 = this.getSelectedIndex();
        if (Double.isNaN(d)) {
            if (n3 != 0) {
                this.changeCurrentSelection(0);
            }
            return;
        }
        dArray = this.numberModel.getPossibleValues();
        if (dArray == null) {
            if (n3 != 0) {
                this.changeCurrentSelection(0);
            }
            return;
        }
        n2 = dArray.length;
        if (n2 <= 0) {
            if (n3 != 0) {
                this.changeCurrentSelection(0);
            }
            return;
        }
        for (n = 0; n < n2; ++n) {
            if (dArray[n] != d) continue;
            if (n3 != n + 1) {
                this.changeCurrentSelection(n + 1);
            }
            return;
        }
        if (n >= n2) {
            if (n3 != 0) {
                this.changeCurrentSelection(0);
            }
            return;
        }
    }

    private void changeCurrentSelection(int n) {
        this.disableExecution();
        this.setSelectedIndex(n);
        this.repaint();
        this.enableExecution();
    }

    public void enableExecution() {
        this.setActionCommand(this.defActionCmd);
    }

    public void disableExecution() {
        this.setActionCommand("dummy");
    }

    public void initForEditing() {
    }

    public JComponent getComponent() {
        return this;
    }

    public String getDescription(String string) {
        if (string.equalsIgnoreCase("valueList")) {
            return "The list of values to be proposed in the ComboBox.";
        }
        return "";
    }

    public String[] getExtensionList() {
        return exts;
    }

    public boolean setExtendedParam(String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("valueList")) {
            this.jdrawExts = "";
            String[] stringArray = string2.split(",");
            if (stringArray.length == 0) {
                return true;
            }
            if (stringArray.length < 0) {
                this.showJdrawError(bl, "valueList", "Float value list expected: val,val,val");
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) {
                    this.showJdrawError(bl, "valueList", "Float value list expected: val,val,val; No empty value.");
                    return false;
                }
                try {
                    double d = Double.parseDouble(stringArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    this.showJdrawError(bl, "valueList", "Float value list expected: val,val,val; All number values.");
                    return false;
                }
            }
            this.jdrawExts = string2;
            return true;
        }
        return false;
    }

    public String getExtendedParam(String string) {
        if (string.equalsIgnoreCase("valueList")) {
            return this.jdrawExts;
        }
        return "";
    }

    private void showJdrawError(boolean bl, String string, String string2) {
        if (bl) {
            JOptionPane.showMessageDialog(null, "NumberScalarComboEditor: " + string + " incorrect.\n" + string2, "Error", 0);
        }
    }

    public static void main(String[] stringArray) {
        final AttributeList attributeList = new AttributeList();
        NumberScalarComboEditor numberScalarComboEditor = new NumberScalarComboEditor();
        double[] dArray = new double[]{0.1, 0.3, 1.0, 3.0, 10.0, 30.0, 100.0, 300.0};
        JFrame jFrame = null;
        try {
            IEntity iEntity = attributeList.add("sr/d-tm/ntm/BandWidth");
            INumberScalar iNumberScalar = iEntity instanceof INumberScalar ? (INumberScalar)iEntity : null;
            if (iNumberScalar == null) {
                System.exit(-1);
            }
            iNumberScalar.setPossibleValues(dArray);
            numberScalarComboEditor.setNumberModel(iNumberScalar);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                attributeList.startRefresher();
            }
        });
        jFrame.setContentPane(numberScalarComboEditor);
        jFrame.pack();
        jFrame.show();
    }
}

