/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.attribute.ANumberScalarHelper;
import fr.esrf.tangoatk.core.attribute.NumberScalarHistory;
import fr.esrf.tangoatk.core.attribute.UCharImageHelper;
import fr.esrf.tangoatk.core.attribute.UCharSpectrumHelper;
import java.util.Vector;

public class UCharScalarHelper
extends ANumberScalarHelper {
    UCharImageHelper imageHelper;

    public UCharScalarHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
        this.spectrumHelper = new UCharSpectrumHelper(iAttribute);
        this.imageHelper = new UCharImageHelper(iAttribute);
    }

    void insert(double d) {
        double d2 = 1.0;
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        d2 = this.attribute.getDisplayUnitFactor();
        if (d2 == 1.0) {
            deviceAttribute.insert_uc((short)d);
        } else {
            short s = (short)(d / d2);
            deviceAttribute.insert_uc(s);
        }
    }

    double getNumberScalarValue(DeviceAttribute deviceAttribute) {
        short[] sArray = null;
        try {
            sArray = deviceAttribute.extractUCharArray();
        }
        catch (DevFailed devFailed) {
            return Double.NaN;
        }
        if (sArray == null) {
            return Double.NaN;
        }
        if (sArray.length < 1) {
            return Double.NaN;
        }
        return sArray[0];
    }

    double getNumberScalarSetPoint(DeviceAttribute deviceAttribute) {
        short[] sArray = null;
        try {
            sArray = deviceAttribute.extractUCharArray();
        }
        catch (DevFailed devFailed) {
            return Double.NaN;
        }
        if (sArray == null) {
            return Double.NaN;
        }
        if (sArray.length < 1) {
            return Double.NaN;
        }
        if (sArray.length > 1) {
            return sArray[1];
        }
        return sArray[0];
    }

    double getNumberScalarDisplayValue(DeviceAttribute deviceAttribute) {
        short[] sArray = null;
        double d = this.attribute.getDisplayUnitFactor();
        try {
            sArray = deviceAttribute.extractUCharArray();
        }
        catch (DevFailed devFailed) {
            return Double.NaN;
        }
        if (sArray == null) {
            return Double.NaN;
        }
        if (sArray.length < 1) {
            return Double.NaN;
        }
        return (double)sArray[0] * d;
    }

    double getNumberScalarDisplaySetPoint(DeviceAttribute deviceAttribute) {
        short[] sArray = null;
        double d = this.attribute.getDisplayUnitFactor();
        try {
            sArray = deviceAttribute.extractUCharArray();
        }
        catch (DevFailed devFailed) {
            return Double.NaN;
        }
        if (sArray == null) {
            return Double.NaN;
        }
        if (sArray.length < 1) {
            return Double.NaN;
        }
        if (sArray.length > 1) {
            return (double)sArray[1] * d;
        }
        return (double)sArray[0] * d;
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Double(d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Double(d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Double(d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Double(d));
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Double(d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Double(d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Double(d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Double(d), bl);
    }

    protected INumberScalarHistory[] getNumberScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        Vector<NumberScalarHistory> vector = new Vector<NumberScalarHistory>();
        for (int i = 0; i < deviceDataHistoryArray.length; ++i) {
            NumberScalarHistory numberScalarHistory = new NumberScalarHistory();
            try {
                numberScalarHistory.setTimestamp(deviceDataHistoryArray[i].getTime());
            }
            catch (Exception exception) {
                numberScalarHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[i].getAttrQuality();
                if (0 == attrQuality.value()) {
                    numberScalarHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    numberScalarHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    numberScalarHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    numberScalarHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    numberScalarHistory.setState("CHANGING");
                } else {
                    numberScalarHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                numberScalarHistory.setState("UNKNOWN");
            }
            try {
                boolean bl = false;
                double d = (double)bl;
                numberScalarHistory.setValue(d);
            }
            catch (Exception exception) {
                numberScalarHistory.setValue(Double.NaN);
            }
            vector.add(i, numberScalarHistory);
        }
        INumberScalarHistory[] iNumberScalarHistoryArray = vector.toArray(new NumberScalarHistory[0]);
        return iNumberScalarHistoryArray;
    }

    protected IAttributeScalarHistory[] getScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getNumberScalarAttHistory(deviceDataHistoryArray);
    }

    public String getVersion() {
        return "$Id: UCharScalarHelper.java,v 1.2 2006/06/29 11:19:13 poncet Exp $";
    }
}

