/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;

class LongImageHelper
extends ANumberImageHelper {
    public LongImageHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void insert(double[] dArray) {
        double d = 1.0;
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        d = this.attribute.getDisplayUnitFactor();
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)(dArray[i] / d);
        }
        deviceAttribute.insert(nArray, this.attribute.getXDimension(), this.attribute.getYDimension());
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Long((long)d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Long((long)d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Long((long)d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Long((long)d));
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Long((long)d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Long((long)d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Long((long)d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Long((long)d), bl);
    }

    double[][] getNumberImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new double[n][n2];
        }
        int[] nArray = deviceAttribute.extractLongArray();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = nArray[n3++];
            }
        }
        return this.retval;
    }

    double[][] getNumberImageDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractLongArray();
        double d = this.attribute.getDisplayUnitFactor();
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new double[n][n2];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = (double)nArray[n3++] * d;
            }
        }
        return this.retval;
    }

    String[][] getImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractLongArray();
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        String[][] stringArray = new String[n][n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray[i][j] = Integer.toString(nArray[n3++]);
            }
        }
        return stringArray;
    }

    public String getVersion() {
        return "$Id: LongImageHelper.java,v 1.8 2006/06/29 11:19:13 poncet Exp $";
    }
}

