/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.IRefreshee;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class Refresher
extends Thread
implements Serializable {
    public boolean stop = false;
    public boolean running = false;
    private boolean synchronizedPeriod = false;
    private boolean traceUnexpected = false;
    long refreshInterval = 1000L;
    private long before;
    private long after;
    private long sleepingPeriod;
    IRefreshee refreshee;
    protected static ThreadGroup refreshers = new ThreadGroup("ATKRefreshers");

    public Refresher() {
    }

    public Refresher(String string) {
        super(refreshers, string);
    }

    public void setRefreshInterval(long l) {
        this.refreshInterval = l;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.stop = false;
        super.start();
    }

    public void stopRunning() {
        this.running = false;
        this.stop = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void run() {
        while (true) {
            block7: {
                if (this.stop) {
                    return;
                }
                this.before = System.currentTimeMillis();
                try {
                    this.refreshee.refresh();
                }
                catch (Exception exception) {
                    if (!this.traceUnexpected) break block7;
                    System.out.println("!!!!!!!!!!! Unexpected exception in refreshment !!!!!!!!!!!!!!!!!!!!!!");
                    exception.printStackTrace();
                }
            }
            try {
                if (this.synchronizedPeriod) {
                    this.synchronRefresh();
                    continue;
                }
                Refresher.sleep(this.refreshInterval);
                continue;
            }
            catch (Exception exception) {
                if (!this.traceUnexpected) continue;
                System.out.println("!!!!!!!!!!! Refreshment sleep exception !!!!!!!!!!!!!!!!!!!!!!");
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public Thread addRefreshee(IRefreshee iRefreshee) {
        this.refreshee = iRefreshee;
        return this;
    }

    public String getVersion() {
        return "$Id: Refresher.java,v 1.6 2006/05/23 09:34:58 ounsy Exp $";
    }

    private void synchronRefresh() {
        block3: {
            this.after = System.currentTimeMillis();
            this.sleepingPeriod = this.refreshInterval - (this.after - this.before);
            if (this.sleepingPeriod < 0L) {
                this.sleepingPeriod = 0L;
            }
            try {
                Refresher.sleep(this.sleepingPeriod);
            }
            catch (InterruptedException interruptedException) {
                if (!this.traceUnexpected) break block3;
                System.out.println("!!!!!!!!!!! Refreshment sleep exception !!!!!!!!!!!!!!!!!!!!!!");
                interruptedException.printStackTrace();
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading EntityList ");
        objectInputStream.defaultReadObject();
        this.stopRunning();
    }

    public void setSynchronizedPeriod(boolean bl) {
        this.synchronizedPeriod = bl;
    }

    public boolean isSynchronizedPeriod() {
        return this.synchronizedPeriod;
    }

    public void setTraceUnexpected(boolean bl) {
        this.traceUnexpected = bl;
    }

    public boolean isTraceUnexpected() {
        return this.traceUnexpected;
    }
}

