/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.command;

import fr.esrf.TangoApi.DeviceData;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.command.ACommand;
import fr.esrf.tangoatk.core.command.ACommandHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Vector;

class ScalarCommandHelper
extends ACommandHelper {
    ScalarCommandHelper(ACommand aCommand) {
        super(aCommand);
    }

    public DeviceData setInput(List list) {
        String string = (String)list.get(0);
        try {
            switch (this.getInType()) {
                case 1: {
                    this.data.insert(new Boolean(string).booleanValue());
                    break;
                }
                case 2: {
                    this.data.insert(Short.parseShort(string));
                    break;
                }
                case 4: {
                    this.data.insert(Float.parseFloat(string));
                    break;
                }
                case 5: {
                    this.data.insert(Double.parseDouble(string));
                    break;
                }
                case 6: {
                    this.data.insert_us(Integer.parseInt(string));
                    break;
                }
                case 7: {
                    this.data.insert_ul(Long.parseLong(string));
                    break;
                }
                case 3: {
                    this.data.insert(Integer.parseInt(string));
                    break;
                }
                case 8: {
                    this.data.insert(string);
                }
            }
        }
        catch (Exception exception) {
            this.cmdError("setInput failed with " + exception + " on " + string, exception);
        }
        return this.data;
    }

    protected List extractOutput(DeviceData deviceData) {
        String string = "unsuported type";
        Vector<String> vector = new Vector<String>();
        switch (this.getOutType()) {
            case 1: {
                string = deviceData.extractBoolean() ? "TRUE" : "FALSE";
                break;
            }
            case 2: {
                string = Short.toString(deviceData.extractShort());
                break;
            }
            case 4: {
                string = Float.toString(deviceData.extractFloat());
                break;
            }
            case 5: {
                string = Double.toString(deviceData.extractDouble());
                break;
            }
            case 6: {
                string = Integer.toString(deviceData.extractUShort());
                break;
            }
            case 7: {
                string = Long.toString(deviceData.extractULong());
                break;
            }
            case 3: {
                string = Integer.toString(deviceData.extractLong());
                break;
            }
            case 8: {
                string = deviceData.extractString();
                break;
            }
            case 19: {
                string = Device.toString(deviceData.extractDevState());
            }
        }
        vector.add(string);
        return vector;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.serializeInit();
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public String toString() {
        return "ScalarCommandHelper";
    }

    public String getVersion() {
        return "$Id: ScalarCommandHelper.java,v 1.4 2005/02/15 16:07:01 jlpons Exp $";
    }
}

