/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberImage;
import java.io.IOException;
import java.io.ObjectInputStream;

public class NumberSpectrum
extends NumberImage
implements INumberSpectrum {
    double[] spectrumValue;
    ANumberSpectrumHelper numberSpectrumHelper;

    public void setNumberHelper(ANumberSpectrumHelper aNumberSpectrumHelper) {
        this.numberHelper = aNumberSpectrumHelper;
        this.numberSpectrumHelper = aNumberSpectrumHelper;
    }

    public void addImageListener(IImageListener iImageListener) {
        this.numberSpectrumHelper.addImageListener(iImageListener);
    }

    public void removeImageListener(IImageListener iImageListener) {
        this.numberSpectrumHelper.removeImageListener(iImageListener);
    }

    public void addSpectrumListener(ISpectrumListener iSpectrumListener) {
        this.propChanges.addSpectrumListener(iSpectrumListener);
    }

    public void removeSpectrumListener(ISpectrumListener iSpectrumListener) {
        this.propChanges.removeSpectrumListener(iSpectrumListener);
    }

    public void setValue(double[][] dArray) {
        this.setValue(dArray[0]);
    }

    public double[][] getValue() {
        double[][] dArrayArray = new double[][]{this.getSpectrumValue()};
        return dArrayArray;
    }

    public void setValue(double[] dArray) {
        try {
            this.insert(dArray);
            this.writeAtt();
            this.numberSpectrumHelper.fireSpectrumValueChanged(dArray, System.currentTimeMillis());
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
    }

    protected void checkDimensions(double[] dArray) {
        if (dArray.length > this.getMaxXDimension()) {
            throw new IllegalStateException();
        }
    }

    protected void insert(double[] dArray) {
        this.checkDimensions(dArray);
        this.numberSpectrumHelper.insert(dArray);
    }

    public void refresh() {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                this.spectrumValue = this.numberSpectrumHelper.getNumberSpectrumDisplayValue(this.readValueFromNetwork());
                this.numberSpectrumHelper.fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.spectrumValue = null;
            System.out.println("NumberSpectrum.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberSpectrum.refresh()------------------------------------------------");
        }
    }

    public void dispatch(DeviceAttribute deviceAttribute) {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                if (deviceAttribute == null) {
                    return;
                }
                this.attribute = deviceAttribute;
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.numberSpectrumHelper.getNumberSpectrumDisplayValue(deviceAttribute);
                this.numberSpectrumHelper.fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            this.spectrumValue = null;
            System.out.println("NumberSpectrum.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberSpectrum.dispatch()------------------------------------------------");
        }
    }

    public void dispatchError(DevFailed devFailed) {
        this.spectrumValue = null;
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    public double[] getSpectrumValue() {
        return this.spectrumValue;
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "NumberSpectrum.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.spectrumValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.spectrumValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.spectrumValue = null;
            System.out.println("NumberSpectrum.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberSpectrum.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.numberSpectrumHelper.getNumberSpectrumDisplayValue(deviceAttribute);
                this.numberSpectrumHelper.fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.spectrumValue = null;
                System.out.println("NumberSpectrum.periodic.getNumberSpectrumDisplayValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberSpectrum.periodic.getNumberSpectrumDisplayValue()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "NumberSpectrum.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.spectrumValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.spectrumValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.spectrumValue = null;
            System.out.println("NumberSpectrum.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberSpectrum.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.numberSpectrumHelper.getNumberSpectrumDisplayValue(deviceAttribute);
                this.numberSpectrumHelper.fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.spectrumValue = null;
                System.out.println("NumberSpectrum.change.getNumberSpectrumDisplayValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberSpectrum.change.getNumberSpectrumDisplayValue()------------------------------------------------");
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    public String getVersion() {
        return "$Id: NumberSpectrum.java,v 1.15 2006/07/28 15:59:25 ounsy Exp $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }

    public int getYDimension() {
        return 1;
    }

    public int getMaxYDimension() {
        return 1;
    }
}

