/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.attribute.ANumberScalarHelper;
import fr.esrf.tangoatk.core.attribute.LongImageHelper;
import fr.esrf.tangoatk.core.attribute.LongSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberScalarHistory;
import java.util.Vector;

public class LongScalarHelper
extends ANumberScalarHelper {
    public LongScalarHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
        this.spectrumHelper = new LongSpectrumHelper(iAttribute);
        this.imageHelper = new LongImageHelper(iAttribute);
    }

    void insert(double d) {
        double d2 = 1.0;
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        d2 = this.attribute.getDisplayUnitFactor();
        if (d2 == 1.0) {
            deviceAttribute.insert((int)d);
        } else {
            int n = (int)(d / d2);
            deviceAttribute.insert(n);
        }
    }

    double getNumberScalarValue(DeviceAttribute deviceAttribute) {
        int[] nArray = null;
        try {
            nArray = deviceAttribute.extractLongArray();
        }
        catch (DevFailed devFailed) {
            return Double.NaN;
        }
        if (nArray == null) {
            return Double.NaN;
        }
        if (nArray.length < 1) {
            return Double.NaN;
        }
        return nArray[0];
    }

    double getNumberScalarSetPoint(DeviceAttribute deviceAttribute) {
        int[] nArray = null;
        try {
            nArray = deviceAttribute.extractLongArray();
        }
        catch (DevFailed devFailed) {
            return Double.NaN;
        }
        if (nArray == null) {
            return Double.NaN;
        }
        if (nArray.length < 1) {
            return Double.NaN;
        }
        if (nArray.length > 1) {
            return nArray[1];
        }
        return nArray[0];
    }

    double getNumberScalarDisplayValue(DeviceAttribute deviceAttribute) {
        int[] nArray = null;
        double d = this.attribute.getDisplayUnitFactor();
        try {
            nArray = deviceAttribute.extractLongArray();
        }
        catch (DevFailed devFailed) {
            return Double.NaN;
        }
        if (nArray == null) {
            return Double.NaN;
        }
        if (nArray.length < 1) {
            return Double.NaN;
        }
        return (double)nArray[0] * d;
    }

    double getNumberScalarDisplaySetPoint(DeviceAttribute deviceAttribute) {
        int[] nArray = null;
        double d = this.attribute.getDisplayUnitFactor();
        try {
            nArray = deviceAttribute.extractLongArray();
        }
        catch (DevFailed devFailed) {
            return Double.NaN;
        }
        if (nArray == null) {
            return Double.NaN;
        }
        if (nArray.length < 1) {
            return Double.NaN;
        }
        if (nArray.length > 1) {
            return (double)nArray[1] * d;
        }
        return (double)nArray[0] * d;
    }

    protected INumberScalarHistory[] getNumberScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        Vector<NumberScalarHistory> vector = new Vector<NumberScalarHistory>();
        for (int i = 0; i < deviceDataHistoryArray.length; ++i) {
            NumberScalarHistory numberScalarHistory = new NumberScalarHistory();
            try {
                numberScalarHistory.setTimestamp(deviceDataHistoryArray[i].getTime());
            }
            catch (Exception exception) {
                numberScalarHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[i].getAttrQuality();
                if (0 == attrQuality.value()) {
                    numberScalarHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    numberScalarHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    numberScalarHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    numberScalarHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    numberScalarHistory.setState("CHANGING");
                } else {
                    numberScalarHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                numberScalarHistory.setState("UNKNOWN");
            }
            try {
                int n = deviceDataHistoryArray[i].extractLong();
                double d = n;
                numberScalarHistory.setValue(d);
            }
            catch (Exception exception) {
                numberScalarHistory.setValue(Double.NaN);
            }
            vector.add(i, numberScalarHistory);
        }
        INumberScalarHistory[] iNumberScalarHistoryArray = vector.toArray(new NumberScalarHistory[0]);
        return iNumberScalarHistoryArray;
    }

    protected IAttributeScalarHistory[] getScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getNumberScalarAttHistory(deviceDataHistoryArray);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Long((long)d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Long((long)d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Long((long)d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Long((long)d));
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Long((long)d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Long((long)d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Long((long)d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Long((long)d), bl);
    }

    public String getVersion() {
        return "$Id: LongScalarHelper.java,v 1.9 2006/06/29 11:19:13 poncet Exp $";
    }
}

