/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import jive.DevWizard;
import jive.JiveUtils;
import jive.ServerDlg;
import jive3.MainPanel;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskAttributeNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPollingNode;
import jive3.TreePanel;

public class TreePanelServer
extends TreePanel {
    public TreePanelServer(MainPanel mainPanel) {
        this.invoker = mainPanel;
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    public TangoNode createRoot() {
        return new RootNode();
    }

    public void selectDevice(String string, String string2, String string3) {
        int n = string2.indexOf(47);
        String string4 = string2.substring(0, n);
        String string5 = string2.substring(n + 1);
        TangoNode tangoNode = this.searchNode(this.root, string4);
        if (tangoNode == null) {
            return;
        }
        TangoNode tangoNode2 = this.searchNode(tangoNode, string5);
        if (tangoNode2 == null) {
            return;
        }
        TangoNode tangoNode3 = this.searchNode(tangoNode2, string);
        if (tangoNode3 == null) {
            return;
        }
        TangoNode tangoNode4 = this.searchNode(tangoNode3, string3);
        if (tangoNode4 == null) {
            return;
        }
        TreePath treePath = new TreePath(this.root);
        treePath = treePath.pathByAddingChild(tangoNode);
        treePath = treePath.pathByAddingChild(tangoNode2);
        treePath = treePath.pathByAddingChild(tangoNode3);
        treePath = treePath.pathByAddingChild(tangoNode4);
        this.tree.setSelectionPath(treePath);
    }

    public void selectClass(String string, String string2) {
        int n = string2.indexOf(47);
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        TangoNode tangoNode = this.searchNode(this.root, string3);
        if (tangoNode == null) {
            return;
        }
        TangoNode tangoNode2 = this.searchNode(tangoNode, string4);
        if (tangoNode2 == null) {
            return;
        }
        TangoNode tangoNode3 = this.searchNode(tangoNode2, string);
        if (tangoNode3 == null) {
            return;
        }
        TreePath treePath = new TreePath(this.root);
        treePath = treePath.pathByAddingChild(tangoNode);
        treePath = treePath.pathByAddingChild(tangoNode2);
        treePath = treePath.pathByAddingChild(tangoNode3);
        this.tree.setSelectionPath(treePath);
    }

    public void selectServer(String string) {
        int n = string.indexOf(47);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        TangoNode tangoNode = this.searchNode(this.root, string2);
        if (tangoNode == null) {
            return;
        }
        TangoNode tangoNode2 = this.searchNode(tangoNode, string3);
        if (tangoNode2 == null) {
            return;
        }
        TreePath treePath = new TreePath(this.root);
        treePath = treePath.pathByAddingChild(tangoNode);
        treePath = treePath.pathByAddingChild(tangoNode2);
        this.tree.setSelectionPath(treePath);
    }

    public void selectServerRoot(String string) {
        TangoNode tangoNode = this.searchNode(this.root, string);
        if (tangoNode == null) {
            return;
        }
        TreePath treePath = new TreePath(this.root);
        treePath = treePath.pathByAddingChild(tangoNode);
        this.tree.setSelectionPath(treePath);
    }

    class DeviceNode
    extends TangoNode {
        private String server;
        private String instance;
        private String className;
        private String devName;

        DeviceNode(String string, String string2, String string3, String string4) {
            this.server = string;
            this.instance = string2;
            this.className = string3;
            this.devName = string4;
        }

        void populateNode() throws DevFailed {
            this.add(new TaskDevicePropertyNode(TreePanelServer.this.self, TreePanelServer.this.db, this.devName));
            this.add(new TaskPollingNode(TreePanelServer.this.db, this.devName));
            this.add(new TaskEventNode(TreePanelServer.this.db, this.devName));
            this.add(new TaskAttributeNode(TreePanelServer.this.db, this.devName));
            this.add(new TaskLoggingNode(TreePanelServer.this.db, this.devName));
        }

        public String toString() {
            return this.devName;
        }

        ImageIcon getIcon() {
            return TangoNodeRenderer.devicon;
        }

        String getValue() {
            return TreePanelServer.this.getDeviceInfo(this.devName);
        }

        String getTitle() {
            return "Device Info";
        }

        int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[]{8, 9, 11};
            }
            return new int[]{0, 1, 8, 9, 10, 11, 12, 13};
        }

        void execAction(int n) {
            switch (n) {
                case 0: {
                    String string = JOptionPane.showInputDialog(null, "Rename device", this.devName);
                    if (string == null) {
                        return;
                    }
                    if (!this.renameDevice(string)) break;
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectDevice(this.className, this.server + "/" + this.instance, string);
                    break;
                }
                case 1: {
                    int n2 = JOptionPane.showConfirmDialog(TreePanelServer.this.invoker, "Delete device " + this.devName + " ?", "Confirm delete", 0);
                    if (n2 != 0) break;
                    try {
                        TreePanelServer.this.db.delete_device(this.devName);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    TreePanelServer.this.refresh();
                    break;
                }
                case 8: {
                    new atkpanel.MainPanel(this.devName, false, true, !JiveUtils.readOnly);
                    break;
                }
                case 9: {
                    TreePanelServer.this.testDevice(this.devName);
                    break;
                }
                case 10: {
                    String string = JOptionPane.showInputDialog(null, "Define device alias", "");
                    if (string == null) {
                        return;
                    }
                    try {
                        TreePanelServer.this.db.put_device_alias(this.devName, string);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    break;
                }
                case 11: {
                    TreePanelServer.this.invoker.goToDeviceNode(this.devName);
                    break;
                }
                case 12: {
                    try {
                        DeviceProxy deviceProxy = new DeviceProxy("dserver/" + this.server + "/" + this.instance);
                        DeviceData deviceData = new DeviceData();
                        deviceData.insert(this.devName);
                        deviceProxy.command_inout("DevRestart", deviceData);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    break;
                }
                case 13: {
                    DevWizard devWizard = new DevWizard(TreePanelServer.this.invoker);
                    devWizard.showDeviceWizard(this.server + "/" + this.instance, this.className, this.devName);
                }
            }
        }

        boolean renameDevice(String string) {
            boolean bl = false;
            boolean bl2 = false;
            try {
                DbDevImportInfo dbDevImportInfo = TreePanelServer.this.db.import_device(string);
                JiveUtils.showJiveError("The device " + string + " already exits.\nServer: " + dbDevImportInfo.server);
            }
            catch (DevFailed devFailed) {
                try {
                    TreePanelServer.this.db.add_device(string, this.className, this.server + "/" + this.instance);
                    bl2 = true;
                    DeviceProxy deviceProxy = null;
                    try {
                        deviceProxy = new DeviceProxy(this.devName);
                        deviceProxy.ping();
                        bl = true;
                    }
                    catch (DevFailed devFailed2) {
                        // empty catch block
                    }
                    int n = JOptionPane.showConfirmDialog(TreePanelServer.this.invoker, "Do you want to copy propeties of " + this.devName + " to " + string + " ?", "Confirm propety move", 0);
                    if (n == 0) {
                        String[] stringArray;
                        String[] stringArray2 = TreePanelServer.this.db.get_device_property_list(this.devName, "*");
                        if (stringArray2.length > 0) {
                            stringArray = TreePanelServer.this.db.get_device_property(this.devName, stringArray2);
                            TreePanelServer.this.db.put_device_property(string, (DbDatum[])stringArray);
                        }
                        if (bl) {
                            try {
                                stringArray = deviceProxy.get_attribute_list();
                                if (stringArray.length > 0) {
                                    DbAttribute[] dbAttributeArray = TreePanelServer.this.db.get_device_attribute_property(this.devName, stringArray);
                                    TreePanelServer.this.db.put_device_attribute_property(string, dbAttributeArray);
                                }
                            }
                            catch (DevFailed devFailed3) {
                                JiveUtils.showJiveError("Failed to copy attribute properties of " + this.devName + "\n" + devFailed3.errors[0].desc);
                            }
                        } else {
                            JiveUtils.showJiveError("Cannot copy attribute properties of " + this.devName + "\nThe device is not alive.");
                        }
                    }
                    if (bl) {
                        JiveUtils.showJiveWarning("The old device " + this.devName + " is still alive and should be removed by hand.");
                    } else {
                        TreePanelServer.this.db.delete_device(this.devName);
                    }
                }
                catch (DevFailed devFailed4) {
                    JiveUtils.showTangoError(devFailed4);
                }
            }
            return bl2;
        }
    }

    class ClassNode
    extends TangoNode {
        private String server;
        private String instance;
        private String className;

        ClassNode(String string, String string2, String string3) {
            this.server = string;
            this.instance = string2;
            this.className = string3;
        }

        void populateNode() throws DevFailed {
            String[] stringArray = TreePanelServer.this.db.get_device_name(this.server + "/" + this.instance, this.className);
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(new DeviceNode(this.server, this.instance, this.className, stringArray[i]));
            }
        }

        ImageIcon getIcon() {
            return TangoNodeRenderer.classicon;
        }

        public String toString() {
            return this.className;
        }

        int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[0];
            }
            return new int[]{0, 1, 6, 7};
        }

        void execAction(int n) {
            switch (n) {
                case 0: {
                    String string = JOptionPane.showInputDialog(null, "Rename class", this.className);
                    if (string == null) {
                        return;
                    }
                    if (TreePanelServer.this.searchNode((TangoNode)this.getParent(), string) != null) {
                        JiveUtils.showJiveError("Name already exists.");
                        return;
                    }
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        TangoNode tangoNode = (TangoNode)this.getChildAt(i);
                        try {
                            TreePanelServer.this.db.add_device(tangoNode.toString(), string, this.server + "/" + this.instance);
                            continue;
                        }
                        catch (DevFailed devFailed) {
                            JiveUtils.showTangoError(devFailed);
                        }
                    }
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectClass(string, this.server + "/" + this.instance);
                    break;
                }
                case 1: {
                    int n2 = JOptionPane.showConfirmDialog(TreePanelServer.this.invoker, "Delete class " + this.className + " ?", "Confirm delete", 0);
                    if (n2 != 0) break;
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        TangoNode tangoNode = (TangoNode)this.getChildAt(i);
                        try {
                            TreePanelServer.this.db.delete_device(tangoNode.toString());
                            continue;
                        }
                        catch (DevFailed devFailed) {
                            JiveUtils.showTangoError(devFailed);
                        }
                    }
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectServer(this.server + "/" + this.instance);
                    break;
                }
                case 6: {
                    ServerDlg serverDlg = new ServerDlg(TreePanelServer.this.invoker);
                    serverDlg.setValidFields(false, false);
                    serverDlg.setDefaults(this.server + "/" + this.instance, this.className);
                    if (!serverDlg.showDlg()) break;
                    String[] stringArray = serverDlg.getDeviceNames();
                    String string = serverDlg.getServerName();
                    String string2 = serverDlg.getClassName();
                    try {
                        for (int i = 0; i < stringArray.length; ++i) {
                            TreePanelServer.this.db.add_device(stringArray[i], string2, string);
                        }
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectClass(string2, string);
                    break;
                }
                case 7: {
                    DevWizard devWizard = new DevWizard(TreePanelServer.this.invoker);
                    devWizard.showDevicesWizard(this.server + "/" + this.instance, this.className);
                    TreePanelServer.this.refresh();
                }
            }
        }
    }

    class InstanceNode
    extends TangoNode {
        private String server;
        private String instance;

        InstanceNode(String string, String string2) {
            this.server = string;
            this.instance = string2;
        }

        void populateNode() throws DevFailed {
            String[] stringArray = null;
            String[] stringArray2 = null;
            try {
                String string = "dserver/" + this.server + "/" + this.instance;
                DeviceProxy deviceProxy = new DeviceProxy(string);
                DeviceData deviceData = deviceProxy.command_inout("QueryClass");
                stringArray = deviceData.extractStringArray();
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            stringArray2 = TreePanelServer.this.db.get_server_class_list(this.server + "/" + this.instance);
            if (stringArray != null) {
                int n;
                for (n = 0; n < stringArray.length; ++n) {
                    this.add(new ClassNode(this.server, this.instance, stringArray[n]));
                }
                for (n = 0; n < stringArray2.length; ++n) {
                    if (JiveUtils.contains(stringArray, stringArray2[n])) continue;
                    this.add(new ClassNode(this.server, this.instance, stringArray2[n]));
                }
            } else {
                for (int i = 0; i < stringArray2.length; ++i) {
                    this.add(new ClassNode(this.server, this.instance, stringArray2[i]));
                }
            }
        }

        ImageIcon getIcon() {
            return TangoNodeRenderer.srvicon;
        }

        public String toString() {
            return this.instance;
        }

        String getValue() {
            String string = "";
            try {
                DbServInfo dbServInfo = TreePanelServer.this.db.get_server_info(this.server + "/" + this.instance);
                string = dbServInfo.toString();
            }
            catch (DevFailed devFailed) {
                for (int i = 0; i < devFailed.errors.length; ++i) {
                    string = string + "Desc -> " + devFailed.errors[i].desc + "\n";
                    string = string + "Reason -> " + devFailed.errors[i].reason + "\n";
                    string = string + "Origin -> " + devFailed.errors[i].origin + "\n";
                }
            }
            return string;
        }

        String getTitle() {
            return "Server Info";
        }

        int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[]{3, 4};
            }
            return new int[]{0, 1, 2, 3, 4, 5};
        }

        void execAction(int n) {
            switch (n) {
                case 0: {
                    String string = JOptionPane.showInputDialog(null, "Rename instance", this.instance);
                    if (string == null) {
                        return;
                    }
                    if (TreePanelServer.this.searchNode((TangoNode)this.getParent(), string) != null) {
                        JiveUtils.showJiveError("Name already exists.");
                        return;
                    }
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        TangoNode tangoNode = (TangoNode)this.getChildAt(i);
                        for (int j = 0; j < tangoNode.getChildCount(); ++j) {
                            TangoNode tangoNode2 = (TangoNode)tangoNode.getChildAt(j);
                            try {
                                TreePanelServer.this.db.add_device(tangoNode2.toString(), tangoNode.toString(), this.server + "/" + string);
                                continue;
                            }
                            catch (DevFailed devFailed) {
                                JiveUtils.showTangoError(devFailed);
                            }
                        }
                    }
                    try {
                        TreePanelServer.this.db.delete_server(this.server + "/" + this.instance);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectServer(this.server + "/" + string);
                    break;
                }
                case 1: {
                    int n2 = JOptionPane.showConfirmDialog(TreePanelServer.this.invoker, "Delete server " + this.server + "/" + this.instance + " ?", "Confirm delete", 0);
                    if (n2 != 0) break;
                    try {
                        TreePanelServer.this.db.delete_server(this.server + "/" + this.instance);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectServerRoot(this.server);
                    break;
                }
                case 2: {
                    ServerDlg serverDlg = new ServerDlg(TreePanelServer.this.invoker);
                    serverDlg.setValidFields(false, true);
                    serverDlg.setDefaults(this.server + "/" + this.instance, "");
                    if (!serverDlg.showDlg()) break;
                    String[] stringArray = serverDlg.getDeviceNames();
                    String string = serverDlg.getServerName();
                    String string2 = serverDlg.getClassName();
                    try {
                        for (int i = 0; i < stringArray.length; ++i) {
                            TreePanelServer.this.db.add_device(stringArray[i], string2, string);
                        }
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectClass(string2, string);
                    break;
                }
                case 3: {
                    TreePanelServer.this.testDevice("dserver/" + this.server + "/" + this.instance);
                    break;
                }
                case 4: {
                    int n3;
                    JFileChooser jFileChooser = new JFileChooser(".");
                    int n4 = 0;
                    if (TreePanel.lastFile != null) {
                        jFileChooser.setSelectedFile(TreePanel.lastFile);
                    }
                    if ((n3 = jFileChooser.showSaveDialog(TreePanelServer.this.invoker)) != 0 || (TreePanel.lastFile = jFileChooser.getSelectedFile()) == null) break;
                    if (TreePanel.lastFile.exists()) {
                        n4 = JOptionPane.showConfirmDialog(TreePanelServer.this.invoker, "Do you want to overwrite " + TreePanel.lastFile.getName() + " ?", "Confirm overwrite", 0);
                    }
                    if (n4 != 0) break;
                    try {
                        FileWriter fileWriter = new FileWriter(TreePanel.lastFile.getAbsolutePath());
                        Date date = new Date(System.currentTimeMillis());
                        fileWriter.write("#\n# Resource backup , created " + date + "\n#\n\n");
                        this.saveServerData(fileWriter);
                        fileWriter.close();
                    }
                    catch (IOException iOException) {
                        JiveUtils.showJiveError("Failed to create resource file !\n" + iOException.getMessage());
                    }
                    break;
                }
                case 5: {
                    DevWizard devWizard = new DevWizard(TreePanelServer.this.invoker);
                    devWizard.showClassesWizard(this.server + "/" + this.instance);
                    TreePanelServer.this.refresh();
                }
            }
        }

        void saveServerData(FileWriter fileWriter) throws IOException {
            String string = this.server + "/" + this.instance;
            try {
                String[] stringArray = TreePanelServer.this.db.get_server_class_list(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    int n;
                    boolean bl;
                    DbAttribute[] dbAttributeArray;
                    String[] stringArray2;
                    String[] stringArray3;
                    int n2;
                    String[] stringArray4;
                    if (!JiveUtils.isSavedClass(stringArray[i])) {
                        fileWriter.write("#---------------------------------------------------------\n");
                        fileWriter.write("# CLASS " + stringArray[i] + " properties\n");
                        fileWriter.write("#---------------------------------------------------------\n\n");
                        stringArray4 = TreePanelServer.this.db.get_class_property_list(stringArray[i], "*");
                        for (n2 = 0; n2 < stringArray4.length; ++n2) {
                            stringArray3 = TreePanelServer.this.db.get_class_property(stringArray[i], stringArray4[n2]).extractStringArray();
                            if (stringArray4[n2].indexOf(32) != -1) {
                                stringArray4[n2] = "\"" + stringArray4[n2] + "\"";
                            }
                            JiveUtils.printFormatedRes("CLASS/" + stringArray[i] + "->" + stringArray4[n2] + ": ", stringArray3, fileWriter);
                        }
                        stringArray2 = TreePanelServer.this.db.get_class_attribute_list(stringArray[i], "*");
                        dbAttributeArray = TreePanelServer.this.db.get_class_attribute_property(stringArray[i], stringArray2);
                        bl = false;
                        for (n = 0; n < dbAttributeArray.length; ++n) {
                            stringArray4 = dbAttributeArray[n].get_property_list();
                            for (n2 = 0; n2 < stringArray4.length; ++n2) {
                                if (!bl) {
                                    fileWriter.write("\n# CLASS " + stringArray[i] + " attribute properties\n\n");
                                    bl = true;
                                }
                                if (stringArray4[n2].indexOf(32) != -1) {
                                    stringArray4[n2] = "\"" + stringArray4[n2] + "\"";
                                }
                                stringArray3 = dbAttributeArray[n].get_value(n2);
                                JiveUtils.printFormatedRes("CLASS/" + stringArray[i] + "/" + stringArray2[n] + "->" + stringArray4[n2] + ": ", stringArray3, fileWriter);
                            }
                        }
                        fileWriter.write("\n");
                        JiveUtils.addSavedClass(stringArray[i]);
                    }
                    fileWriter.write("#---------------------------------------------------------\n");
                    fileWriter.write("# SERVER " + string + ", " + stringArray[i] + " device declaration\n");
                    fileWriter.write("#---------------------------------------------------------\n\n");
                    stringArray3 = TreePanelServer.this.db.get_device_name(string, stringArray[i]);
                    JiveUtils.printFormatedRes(string + "/DEVICE/" + stringArray[i] + ": ", stringArray3, fileWriter);
                    fileWriter.write("\n");
                    for (int j = 0; j < stringArray3.length; ++j) {
                        String[] stringArray5;
                        stringArray4 = TreePanelServer.this.db.get_device_property_list(stringArray3[j], "*");
                        if (stringArray4.length > 0) {
                            fileWriter.write("\n# --- " + stringArray3[j] + " properties\n\n");
                            for (n2 = 0; n2 < stringArray4.length; ++n2) {
                                stringArray5 = TreePanelServer.this.db.get_device_property(stringArray3[j], stringArray4[n2]).extractStringArray();
                                if (stringArray4[n2].indexOf(32) != -1) {
                                    stringArray4[n2] = "\"" + stringArray4[n2] + "\"";
                                }
                                JiveUtils.printFormatedRes(stringArray3[j] + "->" + stringArray4[n2] + ": ", stringArray5, fileWriter);
                            }
                        }
                        try {
                            stringArray5 = new DeviceProxy(stringArray3[j]);
                            stringArray2 = stringArray5.get_attribute_list();
                            dbAttributeArray = TreePanelServer.this.db.get_device_attribute_property(stringArray3[j], stringArray2);
                            bl = false;
                            for (n = 0; n < dbAttributeArray.length; ++n) {
                                stringArray4 = dbAttributeArray[n].get_property_list();
                                for (n2 = 0; n2 < stringArray4.length; ++n2) {
                                    if (!bl) {
                                        fileWriter.write("\n# --- " + stringArray3[j] + " attribute properties\n\n");
                                        bl = true;
                                    }
                                    if (stringArray4[n2].indexOf(32) != -1) {
                                        stringArray4[n2] = "\"" + stringArray4[n2] + "\"";
                                    }
                                    String[] stringArray6 = dbAttributeArray[n].get_value(n2);
                                    JiveUtils.printFormatedRes(stringArray3[j] + "/" + stringArray2[n] + "->" + stringArray4[n2] + ": ", stringArray6, fileWriter);
                                }
                            }
                            continue;
                        }
                        catch (DevFailed devFailed) {
                            JiveUtils.showJiveError("Attribute properties for " + stringArray3[j] + " has not been saved !\n" + devFailed.errors[0].desc);
                        }
                    }
                    fileWriter.write("\n");
                }
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }
    }

    class ServerNode
    extends TangoNode {
        private String server;

        ServerNode(String string) {
            this.server = string;
        }

        void populateNode() throws DevFailed {
            String[] stringArray = TreePanelServer.this.db.get_instance_name_list(this.server);
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(new InstanceNode(this.server, stringArray[i]));
            }
        }

        public String toString() {
            return this.server;
        }

        ImageIcon getIcon() {
            return TangoNodeRenderer.srvicon;
        }

        int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[0];
            }
            return new int[]{0};
        }

        void execAction(int n) {
            switch (n) {
                case 0: {
                    String string = JOptionPane.showInputDialog(null, "Rename server", this.server);
                    if (string == null) {
                        return;
                    }
                    if (TreePanelServer.this.searchNode(TreePanelServer.this.root, string) != null) {
                        JiveUtils.showJiveError("Name already exists.");
                        return;
                    }
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        TangoNode tangoNode = (TangoNode)this.getChildAt(i);
                        for (int j = 0; j < tangoNode.getChildCount(); ++j) {
                            TangoNode tangoNode2 = (TangoNode)tangoNode.getChildAt(j);
                            for (int k = 0; k < tangoNode2.getChildCount(); ++k) {
                                TangoNode tangoNode3 = (TangoNode)tangoNode2.getChildAt(k);
                                try {
                                    TreePanelServer.this.db.add_device(tangoNode3.toString(), tangoNode2.toString(), string + "/" + tangoNode.toString());
                                    continue;
                                }
                                catch (DevFailed devFailed) {
                                    JiveUtils.showTangoError(devFailed);
                                }
                            }
                        }
                        try {
                            TreePanelServer.this.db.delete_server(this.server + "/" + tangoNode.toString());
                            continue;
                        }
                        catch (DevFailed devFailed) {
                            JiveUtils.showTangoError(devFailed);
                        }
                    }
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectServerRoot(string);
                }
            }
        }
    }

    class RootNode
    extends TangoNode {
        RootNode() {
        }

        void populateNode() throws DevFailed {
            String[] stringArray = TreePanelServer.this.db.get_server_name_list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(new ServerNode(stringArray[i]));
            }
        }

        public String toString() {
            return "Server :";
        }
    }
}

