/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import jive.JiveUtils;
import jive3.MainPanel;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskAttributeNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPollingNode;
import jive3.TreePanel;

public class TreePanelDevice
extends TreePanel {
    public TreePanelDevice(MainPanel mainPanel) {
        this.invoker = mainPanel;
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    public void selectDevice(String string) {
        int n = string.indexOf(47);
        int n2 = string.lastIndexOf(47);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n2);
        String string4 = string.substring(n2 + 1);
        TangoNode tangoNode = this.searchNode(this.root, string2);
        if (tangoNode == null) {
            return;
        }
        TangoNode tangoNode2 = this.searchNode(tangoNode, string3);
        if (tangoNode2 == null) {
            return;
        }
        TangoNode tangoNode3 = this.searchNode(tangoNode2, string4);
        if (tangoNode3 == null) {
            return;
        }
        TreePath treePath = new TreePath(this.root);
        treePath = treePath.pathByAddingChild(tangoNode);
        treePath = treePath.pathByAddingChild(tangoNode2);
        treePath = treePath.pathByAddingChild(tangoNode3);
        this.tree.setSelectionPath(treePath);
    }

    public TangoNode createRoot() {
        return new RootNode();
    }

    class DeviceNode
    extends TangoNode {
        private String domain;
        private String family;
        private String member;
        private String devName;

        DeviceNode(String string, String string2, String string3) {
            this.domain = string;
            this.family = string2;
            this.member = string3;
            this.devName = this.domain + "/" + this.family + "/" + string3;
        }

        void populateNode() throws DevFailed {
            this.add(new TaskDevicePropertyNode(TreePanelDevice.this.self, TreePanelDevice.this.db, this.devName));
            this.add(new TaskPollingNode(TreePanelDevice.this.db, this.devName));
            this.add(new TaskEventNode(TreePanelDevice.this.db, this.devName));
            this.add(new TaskAttributeNode(TreePanelDevice.this.db, this.devName));
            this.add(new TaskLoggingNode(TreePanelDevice.this.db, this.devName));
        }

        public String toString() {
            return this.member;
        }

        ImageIcon getIcon() {
            return TangoNodeRenderer.devicon;
        }

        String getValue() {
            return TreePanelDevice.this.getDeviceInfo(this.devName);
        }

        String getTitle() {
            return "Device Info";
        }

        int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[]{8, 9, 14, 15};
            }
            return new int[]{1, 8, 9, 10, 14, 12, 15};
        }

        void execAction(int n) {
            switch (n) {
                case 1: {
                    int n2 = JOptionPane.showConfirmDialog(TreePanelDevice.this.invoker, "Delete device " + this.devName + " ?", "Confirm delete", 0);
                    if (n2 != 0) break;
                    try {
                        TreePanelDevice.this.db.delete_device(this.devName);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    TreePanelDevice.this.refresh();
                    break;
                }
                case 8: {
                    new atkpanel.MainPanel(this.devName, false, true, !JiveUtils.readOnly);
                    break;
                }
                case 9: {
                    TreePanelDevice.this.testDevice(this.devName);
                    break;
                }
                case 10: {
                    String string = JOptionPane.showInputDialog(null, "Define device alias", "");
                    if (string == null) {
                        return;
                    }
                    try {
                        TreePanelDevice.this.db.put_device_alias(this.devName, string);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    break;
                }
                case 14: {
                    try {
                        DbDevImportInfo dbDevImportInfo = TreePanelDevice.this.db.import_device(this.devName);
                        TreePanelDevice.this.invoker.goToServerNode(dbDevImportInfo.server);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    break;
                }
                case 12: {
                    try {
                        DbDevImportInfo dbDevImportInfo = TreePanelDevice.this.db.import_device(this.devName);
                        DeviceProxy deviceProxy = new DeviceProxy("dserver/" + dbDevImportInfo.server);
                        DeviceData deviceData = new DeviceData();
                        deviceData.insert(this.devName);
                        deviceProxy.command_inout("DevRestart", deviceData);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    break;
                }
                case 15: {
                    try {
                        DbDevImportInfo dbDevImportInfo = TreePanelDevice.this.db.import_device(this.devName);
                        TreePanelDevice.this.selectDevice("dserver/" + dbDevImportInfo.server);
                        break;
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                }
            }
        }
    }

    class FamilyNode
    extends TangoNode {
        private String domain;
        private String family;

        FamilyNode(String string, String string2) {
            this.domain = string;
            this.family = string2;
        }

        void populateNode() throws DevFailed {
            String string = this.domain + "/" + this.family + "/";
            String[] stringArray = TreePanelDevice.this.db.get_device_member(string + "*");
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(new DeviceNode(this.domain, this.family, stringArray[i]));
            }
        }

        public String toString() {
            return this.family;
        }
    }

    class DomainNode
    extends TangoNode {
        private String domain;

        DomainNode(String string) {
            this.domain = string;
        }

        void populateNode() throws DevFailed {
            String[] stringArray = TreePanelDevice.this.db.get_device_family(this.domain + "/*");
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(new FamilyNode(this.domain, stringArray[i]));
            }
        }

        public String toString() {
            return this.domain;
        }
    }

    class RootNode
    extends TangoNode {
        RootNode() {
        }

        void populateNode() throws DevFailed {
            String[] stringArray = TreePanelDevice.this.db.get_device_domain("*");
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(new DomainNode(stringArray[i]));
            }
        }

        public String toString() {
            return "Device: ";
        }
    }
}

