/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.IOP.ServiceContext;

public class CodeSet {
    public static final int ISO8859_1 = 65537;
    public static final int UTF16 = 65801;
    public static final int UTF8 = 0x5010001;

    public static String csName(int n) {
        switch (n) {
            case 65537: {
                return "ISO-8859-1";
            }
            case 65801: {
                return "UTF-16";
            }
            case 0x5010001: {
                return "UTF-8";
            }
        }
        return "Unknown TCS: " + Integer.toHexString(n);
    }

    public static int getTCSDefault() {
        return 65537;
    }

    public static int getTCSWDefault() {
        return 65801;
    }

    public static int getConversionDefault() {
        return 0x5010001;
    }

    public static int selectTCS(CodeSetComponentInfo codeSetComponentInfo) {
        int n = CodeSet.selectCodeSet(codeSetComponentInfo.ForCharData, CodeSet.getTCSDefault());
        if (n == -1) {
            return CodeSet.selectCodeSet(codeSetComponentInfo.ForCharData, CodeSet.getConversionDefault());
        }
        return n;
    }

    public static int selectTCSW(CodeSetComponentInfo codeSetComponentInfo) {
        int n = CodeSet.selectCodeSet(codeSetComponentInfo.ForWcharData, CodeSet.getTCSWDefault());
        if (n == -1) {
            return CodeSet.selectCodeSet(codeSetComponentInfo.ForWcharData, CodeSet.getConversionDefault());
        }
        return n;
    }

    private static int selectCodeSet(CodeSetComponent codeSetComponent, int n) {
        if (codeSetComponent.native_code_set == n) {
            return n;
        }
        for (int i = 0; i < codeSetComponent.conversion_code_sets.length; ++i) {
            if (codeSetComponent.conversion_code_sets[i] != n) continue;
            return n;
        }
        return -1;
    }

    public static ServiceContext createCodesetContext(int n, int n2) {
        CDROutputStream cDROutputStream = new CDROutputStream();
        cDROutputStream.beginEncapsulatedArray();
        CodeSetContextHelper.write(cDROutputStream, new CodeSetContext(n, n2));
        return new ServiceContext(1, cDROutputStream.getBufferCopy());
    }

    public static CodeSetContext getCodeSetContext(ServiceContext[] serviceContextArray) {
        for (int i = 0; i < serviceContextArray.length; ++i) {
            if (serviceContextArray[i].context_id != 1) continue;
            CDRInputStream cDRInputStream = new CDRInputStream(null, serviceContextArray[i].context_data);
            cDRInputStream.openEncapsulatedArray();
            return CodeSetContextHelper.read(cDRInputStream);
        }
        return null;
    }
}

