/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.AbstractMessage;
import org.jacorb.notification.filter.ComponentName;
import org.jacorb.notification.filter.ETCLEvaluator;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.RuntimeVariable;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.ArrayOperator;
import org.jacorb.notification.filter.etcl.AssocOperator;
import org.jacorb.notification.filter.etcl.ETCLComponentName;
import org.jacorb.notification.filter.etcl.IdentValue;
import org.jacorb.notification.filter.etcl.ImplicitOperator;
import org.jacorb.notification.filter.etcl.ImplicitOperatorNode;
import org.jacorb.notification.filter.etcl.NumberValue;
import org.jacorb.notification.filter.etcl.UnionPositionOperator;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.util.AbstractPoolable;
import org.jacorb.notification.util.LogUtil;
import org.omg.CORBA.Any;

public class EvaluationContext
extends AbstractPoolable {
    private final ETCLEvaluator dynamicEvaluator_;
    private Message message_;
    private final Map resultCache_;
    private final Map anyCache_;
    private final Logger logger_ = LogUtil.getLogger(this.getClass().getName());

    public EvaluationContext(ETCLEvaluator eTCLEvaluator) {
        this.dynamicEvaluator_ = eTCLEvaluator;
        this.resultCache_ = new WeakHashMap();
        this.anyCache_ = new WeakHashMap();
    }

    public void reset() {
        this.resultCache_.clear();
        this.anyCache_.clear();
    }

    public ETCLEvaluator getDynamicEvaluator() {
        return this.dynamicEvaluator_;
    }

    public Message getCurrentMessage() {
        return this.message_;
    }

    public void setCurrentMessage(Message message) {
        this.message_ = message;
    }

    public void storeResult(String string, EvaluationResult evaluationResult) {
        this.resultCache_.put(string, evaluationResult);
    }

    public EvaluationResult lookupResult(String string) {
        return (EvaluationResult)this.resultCache_.get(string);
    }

    public void eraseResult(String string) {
        this.resultCache_.remove(string);
    }

    public void storeAny(String string, Any any) {
        this.anyCache_.put(string, any);
    }

    public Any lookupAny(String string) {
        return (Any)this.anyCache_.get(string);
    }

    public void eraseAny(String string) {
        this.anyCache_.remove(string);
    }

    public EvaluationResult extractFromMessage(EvaluationResult evaluationResult, ComponentName componentName, RuntimeVariable runtimeVariable) throws EvaluationException {
        ETCLComponentName eTCLComponentName = (ETCLComponentName)componentName;
        if (eTCLComponentName.right() != null) {
            return this.extractFromAny(eTCLComponentName.right(), evaluationResult.getAny(), runtimeVariable.toString());
        }
        return evaluationResult;
    }

    public EvaluationResult extractFromMessage(AbstractMessage abstractMessage, ComponentName componentName) throws EvaluationException {
        ETCLComponentName eTCLComponentName = (ETCLComponentName)componentName;
        return this.extractFromAny(eTCLComponentName.left(), abstractMessage.toAny(), eTCLComponentName.toString());
    }

    private EvaluationResult extractFromAny(AbstractTCLNode abstractTCLNode, Any any, String string) throws EvaluationException {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("extractFromAny\n\trootname=" + string + "\n\tvalue=" + any);
        }
        EvaluationResult evaluationResult = null;
        Any any2 = null;
        Any any3 = any;
        StringBuffer stringBuffer = new StringBuffer(string);
        for (AbstractTCLNode abstractTCLNode2 = abstractTCLNode; abstractTCLNode2 != null; abstractTCLNode2 = (AbstractTCLNode)abstractTCLNode2.getNextSibling()) {
            block16: {
                block15: {
                    stringBuffer.append(abstractTCLNode2.toString());
                    if (this.logger_.isDebugEnabled()) {
                        this.logger_.debug("current path=" + stringBuffer.toString());
                        this.logger_.debug("current operator=" + abstractTCLNode2.toString());
                        this.logger_.debug("current any=" + any3);
                    }
                    if ((any2 = this.lookupAny(stringBuffer.toString())) != null) break block15;
                    switch (abstractTCLNode2.getType()) {
                        case 6: {
                            break block16;
                        }
                        case 32: {
                            this.logger_.debug("evaluate union by position");
                            UnionPositionOperator unionPositionOperator = (UnionPositionOperator)abstractTCLNode2;
                            any2 = unionPositionOperator.isDefault() ? this.getDynamicEvaluator().evaluateUnion(any3) : this.getDynamicEvaluator().evaluateUnion(any3, unionPositionOperator.getPosition());
                            break block16;
                        }
                        case 11: {
                            String string2 = ((IdentValue)abstractTCLNode2).getIdentifier();
                            any2 = this.getDynamicEvaluator().evaluateIdentifier(any3, string2);
                            break block16;
                        }
                        case 21: {
                            int n = ((NumberValue)abstractTCLNode2).getNumber().intValue();
                            any2 = this.getDynamicEvaluator().evaluateIdentifier(any3, n);
                            break block16;
                        }
                        case 33: {
                            ImplicitOperator implicitOperator = ((ImplicitOperatorNode)abstractTCLNode2).getOperator();
                            if (this.logger_.isDebugEnabled()) {
                                this.logger_.debug(implicitOperator + " is an implict Operator");
                            }
                            any2 = implicitOperator.evaluateImplicit(this.getDynamicEvaluator(), any3);
                            evaluationResult = EvaluationResult.fromAny(any2);
                            evaluationResult.addAny(any3);
                            if (this.logger_.isDebugEnabled()) {
                                this.logger_.debug("result=" + any2);
                            }
                            return evaluationResult;
                        }
                        case 30: {
                            int n = ((ArrayOperator)abstractTCLNode2).getArrayIndex();
                            any2 = this.getDynamicEvaluator().evaluateArrayIndex(any3, n);
                            break block16;
                        }
                        case 31: {
                            String string3 = ((AssocOperator)abstractTCLNode2).getAssocName();
                            any2 = this.getDynamicEvaluator().evaluateNamedValueList(any3, string3);
                            break block16;
                        }
                        default: {
                            throw new RuntimeException("unexpected operator: " + AbstractTCLNode.getNameForType(abstractTCLNode2.getType()));
                        }
                    }
                }
                this.logger_.debug("Any Cache HIT");
            }
            if (any2 == null) continue;
            this.storeAny(stringBuffer.toString(), any2);
            any3 = any2;
        }
        evaluationResult = EvaluationResult.fromAny(any2);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("extracted: " + evaluationResult);
        }
        return evaluationResult;
    }
}

