/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Date;

public abstract class AbstractFilterUsageDecorator {
    private final Date created_ = new Date();
    protected final FilterInvocationHandler invocationHandler_;

    public AbstractFilterUsageDecorator(Object object) {
        this.invocationHandler_ = new FilterInvocationHandler(object);
    }

    public Date getLastUsage() {
        return new Date(this.invocationHandler_.getLastUsage());
    }

    public Date getCreationDate() {
        return this.created_;
    }

    protected class FilterInvocationHandler
    implements InvocationHandler {
        private long lastUsage_;
        private final Object delegate_;
        private long matchCount_ = 0L;
        private long matchStructuredCount_ = 0L;
        private long matchTypedCount_ = 0L;

        public FilterInvocationHandler(Object object) {
            this.delegate_ = object;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            this.updateUsage(method);
            return method.invoke(this.delegate_, objectArray);
        }

        private void updateUsage(Method method) {
            this.lastUsage_ = System.currentTimeMillis();
            if (method.getName().equals("match")) {
                ++this.matchCount_;
            } else if (method.getName().equals("match_structured")) {
                ++this.matchStructuredCount_;
            } else if (method.getName().equals("match_typed")) {
                ++this.matchTypedCount_;
            }
        }

        public long getLastUsage() {
            return this.lastUsage_;
        }
    }
}

