/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.IContainer;
import org.jacorb.notification.IFactory;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.FilterStageSource;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractSupplierAdmin;
import org.jacorb.notification.servant.FilterStageListManager;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.AdminPropertySet;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimit;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.AdminNotFound;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;

public abstract class AbstractEventChannel
implements Disposable,
ManageableServant {
    private static final Integer DEFAULT_ADMIN_KEY = new Integer(0);
    private final DisposableManager disposables_ = new DisposableManager();
    protected final Logger logger_;
    protected final ORB orb_;
    protected final POA poa_;
    protected final Configuration configuration_;
    private final SynchronizedInt maxNumberOfSuppliers_ = new SynchronizedInt(0);
    private final SynchronizedInt maxNumberOfConsumers_ = new SynchronizedInt(0);
    private final AdminPropertySet adminSettings_;
    private final QoSPropertySet qosSettings_;
    private final FilterStageListManager listManager_;
    private final FilterFactory defaultFilterFactory_;
    private final Object modifyConsumerAdminsLock_ = new Object();
    private final Object modifySupplierAdminsLock_ = new Object();
    private final Map consumerAdminServants_ = new HashMap();
    private final Map supplierAdminServants_ = new HashMap();
    private final SynchronizedInt adminIdPool_ = new SynchronizedInt(1);
    private final SynchronizedInt numberOfConsumers_ = new SynchronizedInt(0);
    private final SynchronizedInt numberOfSuppliers_ = new SynchronizedInt(0);
    protected boolean duringConstruction_ = true;
    private final ProxyEventListener proxyConsumerEventListener_ = new ProxyEventListener(){

        public void actionProxyCreationRequest(ProxyEvent proxyEvent) throws AdminLimitExceeded {
            AbstractEventChannel.this.addConsumer();
        }

        public void actionProxyCreated(ProxyEvent proxyEvent) {
        }

        public void actionProxyDisposed(ProxyEvent proxyEvent) {
            AbstractEventChannel.this.removeConsumer();
        }
    };
    private final ProxyEventListener proxySupplierEventListener_ = new ProxyEventListener(){

        public void actionProxyCreationRequest(ProxyEvent proxyEvent) throws AdminLimitExceeded {
            AbstractEventChannel.this.addSupplier();
        }

        public void actionProxyCreated(ProxyEvent proxyEvent) {
        }

        public void actionProxyDisposed(ProxyEvent proxyEvent) {
            AbstractEventChannel.this.removeSupplier();
        }
    };
    protected final MutablePicoContainer container_;
    private final int id_;
    private final SynchronizedBoolean destroyed_ = new SynchronizedBoolean(false);
    static /* synthetic */ Class class$org$jacorb$notification$SubscriptionManager;
    static /* synthetic */ Class class$org$jacorb$notification$OfferManager;
    static /* synthetic */ Class class$org$jacorb$notification$IContainer;

    public AbstractEventChannel(IFactory iFactory, ORB oRB, POA pOA, Configuration configuration, FilterFactory filterFactory) {
        this.id_ = iFactory.getChannelID();
        this.orb_ = oRB;
        this.poa_ = pOA;
        this.configuration_ = configuration;
        this.defaultFilterFactory_ = filterFactory;
        this.container_ = iFactory.getContainer();
        this.logger_ = ((org.jacorb.config.Configuration)configuration).getNamedLogger(this.getClass().getName());
        this.container_.registerComponent((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)(class$org$jacorb$notification$SubscriptionManager == null ? (class$org$jacorb$notification$SubscriptionManager = AbstractEventChannel.class$("org.jacorb.notification.SubscriptionManager")) : class$org$jacorb$notification$SubscriptionManager), class$org$jacorb$notification$SubscriptionManager == null ? (class$org$jacorb$notification$SubscriptionManager = AbstractEventChannel.class$("org.jacorb.notification.SubscriptionManager")) : class$org$jacorb$notification$SubscriptionManager)));
        this.container_.registerComponent((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)(class$org$jacorb$notification$OfferManager == null ? (class$org$jacorb$notification$OfferManager = AbstractEventChannel.class$("org.jacorb.notification.OfferManager")) : class$org$jacorb$notification$OfferManager), class$org$jacorb$notification$OfferManager == null ? (class$org$jacorb$notification$OfferManager = AbstractEventChannel.class$("org.jacorb.notification.OfferManager")) : class$org$jacorb$notification$OfferManager)));
        this.adminSettings_ = new AdminPropertySet(this.configuration_);
        this.qosSettings_ = new QoSPropertySet(this.configuration_, 0);
        this.listManager_ = new FilterStageListManager(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fetchListData(FilterStageListManager.List list) {
                Object object = AbstractEventChannel.this.modifyConsumerAdminsLock_;
                synchronized (object) {
                    Iterator iterator = AbstractEventChannel.this.consumerAdminServants_.keySet().iterator();
                    while (iterator.hasNext()) {
                        Integer n = (Integer)iterator.next();
                        list.add((FilterStage)AbstractEventChannel.this.consumerAdminServants_.get(n));
                    }
                }
            }
        };
    }

    private void addConsumer() throws AdminLimitExceeded {
        if (this.maxNumberOfConsumers_.get() != 0 && this.numberOfConsumers_.compareTo(this.maxNumberOfConsumers_) >= 0) {
            Any any = this.orb_.create_any();
            any.insert_long(this.maxNumberOfConsumers_.get());
            AdminLimit adminLimit = new AdminLimit("consumer limit", any);
            throw new AdminLimitExceeded("Consumer creation request exceeds AdminLimit.", adminLimit);
        }
        this.numberOfConsumers_.increment();
    }

    private void removeConsumer() {
        this.numberOfConsumers_.decrement();
    }

    private void addSupplier() throws AdminLimitExceeded {
        if (this.maxNumberOfSuppliers_.get() != 0 && this.numberOfSuppliers_.compareTo(this.maxNumberOfSuppliers_) >= 0) {
            Any any = this.orb_.create_any();
            any.insert_long(this.maxNumberOfSuppliers_.get());
            AdminLimit adminLimit = new AdminLimit("suppliers limit", any);
            throw new AdminLimitExceeded("supplier creation request exceeds AdminLimit.", adminLimit);
        }
        this.numberOfSuppliers_.increment();
    }

    private void removeSupplier() {
        this.numberOfSuppliers_.decrement();
    }

    public final int getAdminID() {
        if (this.duringConstruction_) {
            return 0;
        }
        return this.adminIdPool_.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isDefaultConsumerAdminActive() {
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            return this.consumerAdminServants_.containsKey(DEFAULT_ADMIN_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isDefaultSupplierAdminActive() {
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            return this.supplierAdminServants_.containsKey(DEFAULT_ADMIN_KEY);
        }
    }

    public final FilterFactory default_filter_factory() {
        return this.defaultFilterFactory_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] get_all_consumeradmins() {
        int[] nArray;
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            nArray = new int[this.consumerAdminServants_.size()];
            Iterator iterator = this.consumerAdminServants_.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                nArray[n++] = (Integer)iterator.next();
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] get_all_supplieradmins() {
        int[] nArray;
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            nArray = new int[this.supplierAdminServants_.size()];
            Iterator iterator = this.supplierAdminServants_.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                nArray[n++] = (Integer)iterator.next();
            }
        }
        return nArray;
    }

    public final Property[] get_admin() {
        return this.adminSettings_.toArray();
    }

    public final Property[] get_qos() {
        return this.qosSettings_.toArray();
    }

    public final void set_qos(Property[] propertyArray) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, new NamedPropertyRangeSeqHolder());
        this.qosSettings_.set_qos(propertyArray);
    }

    public final void validate_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, namedPropertyRangeSeqHolder);
    }

    public final void set_admin(Property[] propertyArray) throws UnsupportedAdmin {
        this.adminSettings_.validate_admin(propertyArray);
        this.adminSettings_.set_admin(propertyArray);
        this.configureAdminLimits(this.adminSettings_);
    }

    private void configureAdminLimits(PropertySet propertySet) {
        Any any = propertySet.get("MaxConsumers");
        this.maxNumberOfConsumers_.set(any.extract_long());
        Any any2 = propertySet.get("MaxSuppliers");
        this.maxNumberOfSuppliers_.set(any2.extract_long());
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set MaxNumberOfConsumers=" + this.maxNumberOfConsumers_);
            this.logger_.info("set MaxNumberOfSuppliers=" + this.maxNumberOfSuppliers_);
        }
    }

    public final void destroy() {
        if (this.destroyed_.commit(false, true)) {
            this.container_.dispose();
            List list = this.container_.getComponentInstancesOfType(class$org$jacorb$notification$IContainer == null ? (class$org$jacorb$notification$IContainer = AbstractEventChannel.class$("org.jacorb.notification.IContainer")) : class$org$jacorb$notification$IContainer);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IContainer iContainer = (IContainer)iterator.next();
                iContainer.destroy();
            }
        } else {
            throw new OBJECT_NOT_EXIST();
        }
    }

    public final void dispose() {
        this.logger_.info("destroy channel " + this.id_);
        this.deactivate();
        this.disposables_.dispose();
    }

    public final POA _default_POA() {
        return this.poa_;
    }

    public boolean isPersistent() {
        return false;
    }

    public final int getNumberOfConnectedClients() {
        return this.numberOfConsumers_.get() + this.numberOfSuppliers_.get();
    }

    public final int getMaxNumberOfSuppliers() {
        return this.maxNumberOfSuppliers_.get();
    }

    public final int getMaxNumberOfConsumers() {
        return this.maxNumberOfConsumers_.get();
    }

    public final void deactivate() {
        try {
            this.poa_.deactivate_object(this.poa_.servant_to_id(this.getServant()));
        }
        catch (Exception exception) {
            this.logger_.error("Unable to deactivate EventChannel Object", exception);
            throw new RuntimeException();
        }
    }

    protected abstract Servant getServant();

    private Property[] createQoSPropertiesForAdmin() {
        HashMap hashMap = new HashMap(this.qosSettings_.toMap());
        hashMap.remove("EventReliability");
        return PropertySet.map2Props(hashMap);
    }

    protected AbstractAdmin get_consumeradmin_internal(int n) throws AdminNotFound {
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            Integer n2 = new Integer(n);
            if (this.consumerAdminServants_.containsKey(n2)) {
                AbstractAdmin abstractAdmin = (AbstractAdmin)this.consumerAdminServants_.get(n2);
                return abstractAdmin;
            }
            throw new AdminNotFound("ID " + n + " does not exist.");
        }
    }

    protected AbstractAdmin get_supplieradmin_internal(int n) throws AdminNotFound {
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            Integer n2 = new Integer(n);
            if (this.supplierAdminServants_.containsKey(n2)) {
                AbstractAdmin abstractAdmin = (AbstractAdmin)this.supplierAdminServants_.get(n2);
                return abstractAdmin;
            }
            throw new AdminNotFound("ID " + n + " does not exist.");
        }
    }

    List getAllConsumerAdmins() {
        return this.listManager_.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractAdmin getDefaultConsumerAdminServant() {
        AbstractAdmin abstractAdmin;
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            abstractAdmin = (AbstractAdmin)this.consumerAdminServants_.get(DEFAULT_ADMIN_KEY);
            if (abstractAdmin == null) {
                abstractAdmin = this.newConsumerAdminServant(DEFAULT_ADMIN_KEY);
                try {
                    abstractAdmin.set_qos(this.createQoSPropertiesForAdmin());
                }
                catch (UnsupportedQoS unsupportedQoS) {
                    this.logger_.fatalError("unable to set qos", unsupportedQoS);
                }
                this.addToConsumerAdmins(abstractAdmin);
            }
        }
        return abstractAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToConsumerAdmins(AbstractAdmin abstractAdmin) {
        final Integer n = abstractAdmin.getID();
        abstractAdmin.addDisposeHook(new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = AbstractEventChannel.this.modifyConsumerAdminsLock_;
                synchronized (object) {
                    AbstractEventChannel.this.consumerAdminServants_.remove(n);
                    AbstractEventChannel.this.listManager_.actionSourceModified();
                }
            }
        });
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            this.consumerAdminServants_.put(n, abstractAdmin);
            this.listManager_.actionSourceModified();
        }
    }

    protected AbstractAdmin new_for_consumers_servant(InterFilterGroupOperator interFilterGroupOperator, IntHolder intHolder) {
        AbstractAdmin abstractAdmin = this.newConsumerAdminServant(this.createAdminID());
        abstractAdmin.setInterFilterGroupOperator(interFilterGroupOperator);
        intHolder.value = abstractAdmin.getID();
        try {
            abstractAdmin.set_qos(this.createQoSPropertiesForAdmin());
        }
        catch (UnsupportedQoS unsupportedQoS) {
            this.logger_.error("unable to set QoS", unsupportedQoS);
        }
        abstractAdmin.addProxyEventListener(this.proxySupplierEventListener_);
        this.addToConsumerAdmins(abstractAdmin);
        return abstractAdmin;
    }

    private int createAdminID() {
        return this.adminIdPool_.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSupplierAdmins(AbstractAdmin abstractAdmin) {
        final Integer n = abstractAdmin.getID();
        abstractAdmin.addDisposeHook(new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = AbstractEventChannel.this.modifySupplierAdminsLock_;
                synchronized (object) {
                    AbstractEventChannel.this.supplierAdminServants_.remove(n);
                }
            }
        });
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            this.supplierAdminServants_.put(n, abstractAdmin);
        }
    }

    protected AbstractAdmin new_for_suppliers_servant(InterFilterGroupOperator interFilterGroupOperator, IntHolder intHolder) {
        AbstractAdmin abstractAdmin = this.newSupplierAdminServant(this.createAdminID());
        intHolder.value = abstractAdmin.getID();
        abstractAdmin.setInterFilterGroupOperator(interFilterGroupOperator);
        try {
            abstractAdmin.set_qos(this.createQoSPropertiesForAdmin());
        }
        catch (UnsupportedQoS unsupportedQoS) {
            this.logger_.fatalError("error setting qos", unsupportedQoS);
        }
        abstractAdmin.addProxyEventListener(this.proxyConsumerEventListener_);
        this.addToSupplierAdmins(abstractAdmin);
        return abstractAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractAdmin getDefaultSupplierAdminServant() {
        AbstractAdmin abstractAdmin;
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            abstractAdmin = (AbstractAdmin)this.supplierAdminServants_.get(DEFAULT_ADMIN_KEY);
            if (abstractAdmin == null) {
                abstractAdmin = this.newSupplierAdminServant(DEFAULT_ADMIN_KEY);
                try {
                    abstractAdmin.set_qos(this.createQoSPropertiesForAdmin());
                }
                catch (UnsupportedQoS unsupportedQoS) {
                    this.logger_.fatalError("unable to set qos", unsupportedQoS);
                }
                this.addToSupplierAdmins(abstractAdmin);
            }
        }
        return abstractAdmin;
    }

    private AbstractAdmin newConsumerAdminServant(int n) {
        AbstractAdmin abstractAdmin = this.newConsumerAdmin(n);
        return abstractAdmin;
    }

    protected abstract AbstractAdmin newConsumerAdmin(int var1);

    private AbstractAdmin newSupplierAdminServant(int n) {
        AbstractSupplierAdmin abstractSupplierAdmin = this.newSupplierAdmin(n);
        abstractSupplierAdmin.setSubsequentFilterStageSource(new FilterStageSourceAdapter(this));
        return abstractSupplierAdmin;
    }

    protected abstract AbstractSupplierAdmin newSupplierAdmin(int var1);

    public int getID() {
        return this.id_;
    }

    public final void addDisposeHook(Disposable disposable) {
        this.disposables_.addDisposable(disposable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FilterStageSourceAdapter
    implements FilterStageSource {
        final WeakReference channelRef_;

        FilterStageSourceAdapter(AbstractEventChannel abstractEventChannel) {
            this.channelRef_ = new WeakReference<AbstractEventChannel>(abstractEventChannel);
        }

        public List getSubsequentFilterStages() {
            return ((AbstractEventChannel)this.channelRef_.get()).getAllConsumerAdmins();
        }
    }
}

