/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.IOP.IOR;

public class IORdump {
    private String iorString = null;
    private String type_id = null;
    private String iiopVersion = null;
    private String host = null;
    private String hostname = "";
    private int port = -1;
    private int prg_number = -1;
    private String devname = null;
    public boolean is_taco = false;

    public IORdump(String string, String string2) throws DevFailed {
        this.devname = string == null ? "unknown" : string;
        if (string2 == null) {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            string2 = deviceProxy.get_ior();
        } else {
            this.iorString = string2;
        }
        if (string2 != null) {
            if (string2.equals("nada")) {
                string2 = null;
            } else {
                this.iorAnalysis(string2);
            }
        }
    }

    public IORdump(String string) throws DevFailed {
        this.devname = string;
        DeviceProxy deviceProxy = new DeviceProxy(string);
        this.iorString = deviceProxy.get_ior();
        if (this.iorString != null) {
            if (this.iorString.equals("nada")) {
                this.iorString = null;
            } else {
                this.iorAnalysis(this.iorString);
            }
        }
    }

    public IORdump(DeviceProxy deviceProxy) throws DevFailed {
        this.devname = deviceProxy.name();
        this.iorString = deviceProxy.get_ior();
        if (this.iorString != null) {
            if (this.iorString.equals("nada")) {
                this.iorString = null;
            } else {
                this.iorAnalysis(this.iorString);
            }
        }
    }

    public String toString() {
        if (this.iorString == null) {
            return new String("No IOR found in database for " + this.devname + "\n" + "(Maybe, the device has never been exported...)");
        }
        String string = new String("Device:          " + this.devname + "\n" + "type_id:         " + this.get_type_id() + "\n");
        if (!this.is_taco) {
            string = string + "iiop_version:    " + this.get_iiop_version() + "\n";
        }
        string = string + "host:            " + this.get_host() + "\n";
        string = !this.is_taco ? string + "port:            " + this.get_port() : string + "prg number:      " + this.get_prg_number();
        return string;
    }

    private void iorAnalysis(String string) throws DevFailed {
        if (string == null) {
            return;
        }
        if (string.startsWith("rpc:")) {
            this.is_taco = true;
            this.type_id = "Taco";
            this.host = string.substring("rpc:".length(), string.indexOf(":", "rpc:".length() + 1));
            String string2 = string.substring(string.indexOf(":", "rpc:".length() + 1) + 1);
            this.prg_number = Integer.parseInt(string2);
            return;
        }
        if (!string.startsWith("IOR:")) {
            return;
        }
        ParsedIOR parsedIOR = new ParsedIOR(string, ApiUtil.get_orb(), null);
        IOR iOR = parsedIOR.getIOR();
        this.type_id = iOR.type_id;
        List list = parsedIOR.getProfiles();
        for (int i = 0; i < list.size(); ++i) {
            IIOPProfile iIOPProfile = (IIOPProfile)list.get(i);
            this.iiopVersion = "" + iIOPProfile.version().major + "." + iIOPProfile.version().minor;
            String string3 = iIOPProfile.getAddress().getHostname();
            try {
                InetAddress inetAddress = InetAddress.getByName(string3);
                String string4 = inetAddress.getHostAddress();
                this.hostname = inetAddress.getHostName();
                this.host = new String(this.hostname + " (" + string4 + ")");
            }
            catch (Exception exception) {
                this.host = new String(string3 + " (" + exception + ")");
            }
            this.port = iIOPProfile.getAddress().getPort();
            if (this.port >= 0) continue;
            this.port += 65536;
        }
    }

    public String get_type_id() {
        return this.type_id;
    }

    public String get_host() {
        return this.host;
    }

    public String get_hostname() {
        return this.hostname;
    }

    public int get_port() {
        return this.port;
    }

    public int get_prg_number() {
        return this.prg_number;
    }

    public String get_iiop_version() {
        return this.iiopVersion;
    }

    public static void printSyntax() {
        System.out.println("IORdump <ior string>      or");
        System.out.println("IORdump -f <ior file name>");
    }

    public static String getIor(String string) throws FileNotFoundException, SecurityException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = fileInputStream.available();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        String string2 = new String(byArray);
        fileInputStream.close();
        return string2;
    }

    public static void main(String[] stringArray) {
        try {
            switch (stringArray.length) {
                case 1: {
                    System.out.println(new IORdump(stringArray[0]).toString());
                    break;
                }
                case 2: {
                    if (stringArray[0].equals("-f")) {
                        System.out.println(new IORdump(null, IORdump.getIor(stringArray[1])).toString());
                        break;
                    }
                }
                default: {
                    IORdump.printSyntax();
                    break;
                }
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception(devFailed);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Device name ?");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

