/*
 * Decompiled with CFR 0.152.
 */
package atktuning;

import atktuning.TuningConfig;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.command.CommandMenuViewer;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

class TuningPanel
extends JPanel
implements ActionListener {
    private JSmoothLabel title;
    private LabelViewer[] labels;
    private SimpleScalarViewer[] values;
    private NumberScalarWheelEditor[] setters;
    private CommandMenuViewer[] commands;
    private JButton[] propBtn;
    private int maxLabWidth = 0;
    private int maxWheelWidth = 0;
    private int height = 0;
    private TuningConfig theCfg;
    private JFrame parentFrame;
    private static SimplePropertyFrame propFrame = null;
    private static Color uColor = new Color(130, 130, 130);

    public TuningPanel(TuningConfig cfg, Font f, Font tf, int maxH, JFrame parent) {
        Dimension d;
        INumberScalar m;
        int i;
        int nb = cfg.getNbItem();
        this.theCfg = cfg;
        this.height = maxH;
        this.parentFrame = parent;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.labels = new LabelViewer[nb];
        for (i = 0; i < nb; ++i) {
            this.labels[i] = new LabelViewer();
            this.labels[i].setFont(f);
            m = cfg.getAtt(i);
            this.labels[i].setModel((IAttribute)m);
            this.labels[i].setBackground(this.getBackground());
            this.labels[i].setHorizontalAlignment(JSmoothLabel.RIGHT_ALIGNMENT);
            d = this.labels[i].getPreferredSize();
            if (d.width > this.maxLabWidth) {
                this.maxLabWidth = d.width;
            }
            this.add((Component)this.labels[i]);
        }
        this.setters = new NumberScalarWheelEditor[nb];
        for (i = 0; i < nb; ++i) {
            m = cfg.getAtt(i);
            if (m.isWritable()) {
                this.setters[i] = new NumberScalarWheelEditor();
                this.setters[i].setFont(f);
                this.setters[i].setBackground(this.getBackground());
                this.setters[i].setModel(m);
                d = this.setters[i].getPreferredSize();
                if (d.width > this.maxWheelWidth) {
                    this.maxWheelWidth = d.width;
                }
                this.add((Component)this.setters[i]);
                continue;
            }
            this.setters[i] = null;
        }
        this.title = new JSmoothLabel();
        this.title.setFont(tf);
        this.title.setBackground(this.getBackground());
        this.title.setHorizontalAlignment(JSmoothLabel.CENTER_ALIGNMENT);
        this.title.setText(this.getConfig().getTitle());
        this.title.setValueOffsets(0, -5);
        this.add((Component)this.title);
        this.values = new SimpleScalarViewer[nb];
        for (i = 0; i < nb; ++i) {
            this.values[i] = new SimpleScalarViewer();
            this.values[i].setFont(f);
            this.values[i].setBorder(BorderFactory.createLoweredBevelBorder());
            this.values[i].setBounds(this.maxLabWidth + 4, (i + 1) * 32, 150, 30);
            this.values[i].setHorizontalAlignment(JAutoScrolledText.CENTER_ALIGNMENT);
            this.values[i].setModel(cfg.getAtt(i));
            this.values[i].setValueOffsets(0, -3);
            this.values[i].setBackground(uColor);
            this.values[i].setText("------");
            this.add((Component)this.values[i]);
        }
        this.commands = new CommandMenuViewer[nb];
        for (i = 0; i < nb; ++i) {
            this.commands[i] = new CommandMenuViewer();
            this.commands[i].setBackground(this.getBackground());
            this.commands[i].setModel(cfg.getCmds(i));
            this.add((Component)this.commands[i]);
        }
        this.propBtn = new JButton[nb];
        for (i = 0; i < nb; ++i) {
            this.propBtn[i] = new JButton();
            this.propBtn[i].setFont(f);
            this.propBtn[i].setText("?");
            this.propBtn[i].setMargin(new Insets(0, 0, 0, 0));
            this.propBtn[i].addActionListener(this);
            this.add(this.propBtn[i]);
        }
        this.computeMaxWidth();
        this.placeComponents();
    }

    private void placeComponents() {
        int nb = this.theCfg.getNbItem();
        this.title.setBounds(2, 2, 186 + this.maxWheelWidth + this.maxLabWidth, 28);
        for (int i = 0; i < nb; ++i) {
            this.labels[i].setBounds(2, (i + 1) * 32, this.maxLabWidth, 30);
            this.values[i].setBounds(this.maxLabWidth + 4, (i + 1) * 32, 150, 30);
            if (this.setters[i] != null) {
                this.setters[i].setBounds(this.maxLabWidth + 156, (i + 1) * 32, this.maxWheelWidth, 32);
            }
            this.commands[i].setBounds(this.maxLabWidth + this.maxWheelWidth + 157, (i + 1) * 32, 30, 28);
            this.propBtn[i].setBounds(this.maxLabWidth + this.maxWheelWidth + 187, (i + 1) * 32, 30, 28);
        }
    }

    private void computeMaxWidth() {
        Dimension d;
        int i;
        int nb = this.theCfg.getNbItem();
        this.maxLabWidth = 0;
        this.maxWheelWidth = 0;
        for (i = 0; i < nb; ++i) {
            d = this.labels[i].getPreferredSize();
            if (d.width <= this.maxLabWidth) continue;
            this.maxLabWidth = d.width;
        }
        for (i = 0; i < nb; ++i) {
            if (this.setters[i] == null) continue;
            d = this.setters[i].getPreferredSize();
            if (d.width <= this.maxWheelWidth) continue;
            this.maxWheelWidth = d.width;
        }
    }

    public void actionPerformed(ActionEvent e) {
        int i = 0;
        boolean found = false;
        while (i < this.theCfg.getNbItem() && !found) {
            found = this.propBtn[i].equals(e.getSource());
            if (found) continue;
            ++i;
        }
        if (found) {
            if (propFrame == null) {
                propFrame = new SimplePropertyFrame(this.parentFrame, true);
            }
            propFrame.setModel((IAttribute)this.theCfg.getAtt(i));
            propFrame.setVisible(true);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(220 + this.maxWheelWidth + this.maxLabWidth, this.height + 2);
    }

    public Dimension getMinimunSize() {
        return this.getPreferredSize();
    }

    public TuningConfig getConfig() {
        return this.theCfg;
    }
}

