/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.StructuredProxyPushSupplierImpl;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.PropertySetAdapter;
import org.jacorb.notification.util.PropertySetListener;
import org.omg.CORBA.ORB;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierOperations;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierPOATie;
import org.omg.CosNotifyComm.SequencePushConsumer;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.omg.TimeBase.TimeTHelper;

public class SequenceProxyPushSupplierImpl
extends StructuredProxyPushSupplierImpl
implements SequenceProxyPushSupplierOperations {
    private final Runnable schedulePushOperation_;
    private SequencePushConsumer sequencePushConsumer_;
    private Object taskId_;
    private final SynchronizedInt maxBatchSize_ = new SynchronizedInt(1);
    private final SynchronizedLong pacingInterval_ = new SynchronizedLong(0L);
    private long timeSpent_ = 0L;

    public SequenceProxyPushSupplierImpl(IAdmin iAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, ConsumerAdmin consumerAdmin) throws ConfigurationException {
        super(iAdmin, oRB, pOA, configuration, taskProcessor, pushTaskExecutorFactory, offerManager, subscriptionManager, consumerAdmin);
        this.configureMaxBatchSize();
        this.configurePacingInterval();
        this.schedulePushOperation_ = new Runnable(){

            public void run() {
                SequenceProxyPushSupplierImpl.this.schedulePush();
            }
        };
        this.qosSettings_.addPropertySetListener("MaximumBatchSize", (PropertySetListener)new PropertySetAdapter(){

            public void actionPropertySetChanged(PropertySet propertySet) throws UnsupportedQoS {
                SequenceProxyPushSupplierImpl.this.configureMaxBatchSize();
            }
        });
        this.qosSettings_.addPropertySetListener("PacingInterval", (PropertySetListener)new PropertySetAdapter(){

            public void actionPropertySetChanged(PropertySet propertySet) throws UnsupportedQoS {
                SequenceProxyPushSupplierImpl.this.configurePacingInterval();
            }
        });
    }

    public ProxyType MyType() {
        return ProxyType.PUSH_SEQUENCE;
    }

    public void pushPendingData() {
        this.deliverPendingMessages(false);
    }

    private void deliverPendingMessages(boolean bl) {
        Message[] messageArray = bl ? this.getAllMessages() : this.getAtLeastMessages(this.maxBatchSize_.get());
        if (messageArray != null && messageArray.length > 0) {
            StructuredEvent[] structuredEventArray = new StructuredEvent[messageArray.length];
            for (int i = 0; i < messageArray.length; ++i) {
                structuredEventArray[i] = messageArray[i].toStructuredEvent();
                messageArray[i].dispose();
            }
            try {
                this.deliverPendingMessagesInternal(structuredEventArray);
            }
            catch (Throwable throwable) {
                PushSequenceOperation pushSequenceOperation = new PushSequenceOperation(structuredEventArray);
                this.handleFailedPushOperation(pushSequenceOperation, throwable);
            }
        }
    }

    void deliverPendingMessagesInternal(StructuredEvent[] structuredEventArray) throws Disconnected {
        long l = System.currentTimeMillis();
        this.sequencePushConsumer_.push_structured_events(structuredEventArray);
        this.timeSpent_ += System.currentTimeMillis() - l;
        this.resetErrorCounter();
    }

    public void connect_sequence_push_consumer(SequencePushConsumer sequencePushConsumer) throws AlreadyConnected, TypeError {
        this.logger_.debug("connect_sequence_push_consumer");
        this.checkIsNotConnected();
        this.sequencePushConsumer_ = sequencePushConsumer;
        this.connectClient(sequencePushConsumer);
        this.startCronJob();
    }

    protected void connectionResumed() {
        this.schedulePush();
        this.startCronJob();
    }

    protected void connectionSuspended() {
        this.stopCronJob();
    }

    public void disconnect_sequence_push_supplier() {
        this.destroy();
    }

    protected void disconnectClient() {
        this.stopCronJob();
        this.sequencePushConsumer_.disconnect_sequence_push_consumer();
        this.sequencePushConsumer_ = null;
    }

    private void startCronJob() {
        if (this.pacingInterval_.get() > 0L && this.taskId_ != null) {
            this.taskId_ = this.getTaskProcessor().executeTaskPeriodically(this.pacingInterval_.get(), this.schedulePushOperation_, true);
        }
    }

    private synchronized void stopCronJob() {
        if (this.taskId_ != null) {
            this.getTaskProcessor().cancelTask(this.taskId_);
            this.taskId_ = null;
        }
    }

    private void checkCronJob() {
        if (this.pacingInterval_.get() > 0L) {
            this.startCronJob();
        } else {
            this.stopCronJob();
        }
    }

    private boolean configurePacingInterval() {
        if (this.qosSettings_.containsKey("PacingInterval")) {
            long l = TimeTHelper.extract(this.qosSettings_.get("PacingInterval"));
            if (this.pacingInterval_.get() != l) {
                if (this.logger_.isInfoEnabled()) {
                    this.logger_.info("set PacingInterval=" + l);
                }
                this.pacingInterval_.set(l);
                this.checkCronJob();
                return true;
            }
        }
        return false;
    }

    private boolean configureMaxBatchSize() {
        if (this.qosSettings_.containsKey("MaximumBatchSize")) {
            int n = this.qosSettings_.get("MaximumBatchSize").extract_long();
            if (this.maxBatchSize_.get() != n) {
                if (this.logger_.isInfoEnabled()) {
                    this.logger_.info("set MaxBatchSize=" + n);
                }
                this.maxBatchSize_.set(n);
                return true;
            }
        }
        return false;
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new SequenceProxyPushSupplierPOATie(this);
        }
        return this.thisServant_;
    }

    protected long getCost() {
        return this.timeSpent_;
    }

    private class PushSequenceOperation
    implements PushOperation {
        private final StructuredEvent[] structuredEvents_;

        public PushSequenceOperation(StructuredEvent[] structuredEventArray) {
            this.structuredEvents_ = structuredEventArray;
        }

        public void invokePush() throws Disconnected {
            SequenceProxyPushSupplierImpl.this.deliverPendingMessagesInternal(this.structuredEvents_);
        }

        public void dispose() {
        }
    }
}

