/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.EventTypeWrapper;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.AbstractProxyConsumerI;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.PropertySetAdapter;
import org.jacorb.notification.util.PropertySetListener;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotification.EventType;
import org.omg.CosNotifyChannelAdmin.ObtainInfoMode;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.NotifyPublishOperations;
import org.omg.CosNotifyComm.NotifySubscribe;
import org.omg.CosNotifyComm.NotifySubscribeHelper;
import org.omg.CosNotifyComm.NotifySubscribeOperations;
import org.omg.PortableServer.POA;

abstract class AbstractProxyConsumer
extends AbstractProxy
implements AbstractProxyConsumerI,
NotifyPublishOperations {
    private static final EventType[] EMPTY_EVENT_TYPE_ARRAY = new EventType[0];
    private final MessageFactory messageFactory_;
    private final SynchronizedBoolean isStartTimeSupported_ = new SynchronizedBoolean(true);
    private final SynchronizedBoolean isStopTimeSupported_ = new SynchronizedBoolean(true);
    private List subsequentDestinations_;
    private NotifySubscribeOperations proxySubscriptionListener_;
    private NotifySubscribe subscriptionListener_;
    protected final SupplierAdmin supplierAdmin_;
    private PropertySetAdapter reconfigureQoS_ = new PropertySetAdapter(){

        public void actionPropertySetChanged(PropertySet propertySet) {
            AbstractProxyConsumer.this.configureStartTimeSupported();
            AbstractProxyConsumer.this.configureStopTimeSupported();
        }
    };

    protected AbstractProxyConsumer(IAdmin iAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, MessageFactory messageFactory, SupplierAdmin supplierAdmin, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        super(iAdmin, oRB, pOA, configuration, taskProcessor, offerManager, subscriptionManager);
        this.supplierAdmin_ = supplierAdmin;
        this.messageFactory_ = messageFactory;
        this.configureStartTimeSupported();
        this.configureStopTimeSupported();
        this.qosSettings_.addPropertySetListener(new String[]{"Priority", "Timeout", "StartTimeSupported", "StopTimeSupported"}, (PropertySetListener)this.reconfigureQoS_);
    }

    protected MessageFactory getMessageFactory() {
        return this.messageFactory_;
    }

    public final List getSubsequentFilterStages() {
        return this.subsequentDestinations_;
    }

    public void setSubsequentDestinations(List list) {
        this.subsequentDestinations_ = list;
    }

    private void configureStartTimeSupported() {
        try {
            this.isStartTimeSupported_.set(this.qosSettings_.get("StartTimeSupported").extract_boolean());
        }
        catch (Exception exception) {
            this.isStartTimeSupported_.set("on".equals("on"));
        }
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set QoS: StartTimeSupported=" + this.isStartTimeSupported_);
        }
    }

    private void configureStopTimeSupported() {
        try {
            this.isStopTimeSupported_.set(this.qosSettings_.get("StopTimeSupported").extract_boolean());
        }
        catch (Exception exception) {
            this.isStopTimeSupported_.set("on".equals("on"));
        }
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set QoS: StopTimeSupported=" + this.isStopTimeSupported_);
        }
    }

    protected void schedulePullTask(MessageSupplier messageSupplier) {
        try {
            this.getTaskProcessor().scheduleTimedPullTask(messageSupplier);
        }
        catch (InterruptedException interruptedException) {
            this.logger_.info("interrupt during schedule pull for MessageSupplier", interruptedException);
        }
    }

    protected void checkMessageProperties(Message message) {
    }

    public FilterStage getFirstStage() {
        return this;
    }

    public boolean isTimeOutSupported() {
        return this.isStopTimeSupported_.get();
    }

    public boolean isStartTimeSupported() {
        return this.isStartTimeSupported_.get();
    }

    public final SupplierAdmin MyAdmin() {
        return this.supplierAdmin_;
    }

    public final MessageConsumer getMessageConsumer() {
        throw new UnsupportedOperationException();
    }

    public final boolean hasMessageConsumer() {
        return false;
    }

    public void offer_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) throws InvalidEventType {
        this.offerManager_.offer_change(eventTypeArray, eventTypeArray2);
    }

    public final EventType[] obtain_subscription_types(ObtainInfoMode obtainInfoMode) {
        EventType[] eventTypeArray;
        switch (obtainInfoMode.value()) {
            case 1: {
                this.registerListener();
                eventTypeArray = this.subscriptionManager_.obtain_subscription_types();
                break;
            }
            case 0: {
                eventTypeArray = this.subscriptionManager_.obtain_subscription_types();
                this.removeListener();
                break;
            }
            case 3: {
                eventTypeArray = EMPTY_EVENT_TYPE_ARRAY;
                this.registerListener();
                break;
            }
            case 2: {
                eventTypeArray = EMPTY_EVENT_TYPE_ARRAY;
                this.removeListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal ObtainInfoMode: ObtainInfoMode." + obtainInfoMode.value());
            }
        }
        return eventTypeArray;
    }

    private void registerListener() {
        NotifySubscribeOperations notifySubscribeOperations;
        if (this.proxySubscriptionListener_ == null && (notifySubscribeOperations = this.getSubscriptionListener()) != null) {
            this.proxySubscriptionListener_ = new NotifySubscribeOperations(){

                public void subscription_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) {
                    try {
                        notifySubscribeOperations.subscription_change(eventTypeArray, eventTypeArray2);
                    }
                    catch (NO_IMPLEMENT nO_IMPLEMENT) {
                        AbstractProxyConsumer.this.logger_.info("disable subscription_change for Supplier", nO_IMPLEMENT);
                        AbstractProxyConsumer.this.removeListener();
                    }
                    catch (InvalidEventType invalidEventType) {
                        if (AbstractProxyConsumer.this.logger_.isDebugEnabled()) {
                            AbstractProxyConsumer.this.logger_.debug("subscription_change(" + EventTypeWrapper.toString(eventTypeArray) + ", " + EventTypeWrapper.toString(eventTypeArray2) + ") failed", invalidEventType);
                        } else {
                            AbstractProxyConsumer.this.logger_.error("invalid event type", invalidEventType);
                        }
                    }
                    catch (Exception exception) {
                        AbstractProxyConsumer.this.logger_.error("subscription change failed", exception);
                    }
                }
            };
            this.subscriptionManager_.addListener(this.proxySubscriptionListener_);
        }
    }

    protected void removeListener() {
        if (this.proxySubscriptionListener_ != null) {
            this.subscriptionManager_.removeListener(this.proxySubscriptionListener_);
            this.proxySubscriptionListener_ = null;
        }
    }

    protected void connectClient(Object object) {
        super.connectClient(object);
        try {
            this.subscriptionListener_ = NotifySubscribeHelper.narrow(object);
            this.logger_.debug("successfully narrowed connecting Supplier to NotifySubscribe");
        }
        catch (Throwable throwable) {
            this.logger_.info("connecting Supplier does not support subscription_change");
        }
    }

    final NotifySubscribeOperations getSubscriptionListener() {
        return this.subscriptionListener_;
    }

    protected void processMessage(Message message) {
        this.getTaskProcessor().processMessage(message);
    }
}

