/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.MessageQueue;
import org.jacorb.notification.queue.MessageQueueAdapter;

public class BasicMessageQueueAdapter
implements MessageQueueAdapter {
    private final MessageQueue queue_;
    private static final Message[] EMPTY = new Message[0];

    public BasicMessageQueueAdapter(MessageQueue messageQueue) {
        this.queue_ = messageQueue;
    }

    public void enqeue(Message message) {
        this.queue_.put(message);
    }

    public boolean hasPendingMessages() {
        return !this.queue_.isEmpty();
    }

    public int getPendingMessagesCount() {
        return this.queue_.getSize();
    }

    public Message getMessageBlocking() throws InterruptedException {
        return this.queue_.getMessage(true);
    }

    public Message getMessageNoBlock() throws InterruptedException {
        return this.queue_.getMessage(false);
    }

    public Message[] getAllMessages() throws InterruptedException {
        return this.queue_.getAllMessages(false);
    }

    public Message[] getUpToMessages(int n) throws InterruptedException {
        return this.queue_.getMessages(n, false);
    }

    public Message[] getAtLeastMessages(int n) throws InterruptedException {
        if (this.queue_.getSize() >= n) {
            return this.queue_.getAllMessages(true);
        }
        return EMPTY;
    }

    public void clear() {
        try {
            Message[] messageArray = this.queue_.getAllMessages(false);
            for (int i = 0; i < messageArray.length; ++i) {
                Message message = messageArray[i];
                message.dispose();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.queue_.toString();
    }
}

