/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.engine.RetryStrategy;
import org.jacorb.notification.interfaces.IProxyPushSupplier;
import org.jacorb.notification.util.LogUtil;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CosEventComm.Disconnected;

public abstract class AbstractRetryStrategy
implements RetryStrategy {
    protected final Logger logger_ = LogUtil.getLogger(this.getClass().getName());
    protected final PushOperation pushOperation_;
    protected final IProxyPushSupplier pushSupplier_;
    private boolean active_ = true;

    public AbstractRetryStrategy(IProxyPushSupplier iProxyPushSupplier, PushOperation pushOperation) {
        this.pushSupplier_ = iProxyPushSupplier;
        this.pushOperation_ = pushOperation;
    }

    public void dispose() {
        this.pushOperation_.dispose();
    }

    protected boolean isRetryAllowed() {
        return this.active_ && this.pushSupplier_.isRetryAllowed();
    }

    protected void remoteExceptionOccured(Throwable throwable) throws RetryException {
        this.logger_.debug("Error during retry", throwable);
        if (AbstractRetryStrategy.isFatalException(throwable)) {
            this.pushSupplier_.destroy();
            this.active_ = false;
            throw new RetryException("fatal exception while retrying push");
        }
        this.pushSupplier_.incErrorCounter();
        if (!this.isRetryAllowed()) {
            this.pushSupplier_.destroy();
            this.active_ = false;
            throw new RetryException("no more retries. giving up.");
        }
        this.waitUntilNextTry();
    }

    public static boolean isFatalException(Throwable throwable) {
        if (throwable instanceof OBJECT_NOT_EXIST) {
            return true;
        }
        return throwable instanceof Disconnected;
    }

    protected abstract long getTimeToWait();

    public final void retry() throws RetryException {
        if (this.isRetryAllowed()) {
            this.waitUntilNextTry();
            this.retryInternal();
        } else {
            this.dispose();
        }
    }

    protected abstract void retryInternal() throws RetryException;

    private void waitUntilNextTry() {
        long l = this.getTimeToWait();
        try {
            if (l > 0L) {
                Thread.sleep(l);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

