/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DispLevel;
import fr.esrf.TangoDs.Command;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.omg.CORBA.Any;

public class TemplCommand
extends Command
implements TangoConst {
    protected Method exe_method;
    protected Method state_method;
    protected String exe_method_name;
    protected String state_method_name;

    public TemplCommand(String name, String exe_method, String state_method) {
        super(name, 0, 0);
        this.exe_method_name = exe_method;
        this.state_method_name = state_method;
        this.template_cmd = true;
    }

    public TemplCommand(String name, String exe_method) {
        super(name, 0, 0);
        this.exe_method_name = exe_method;
        this.state_method_name = null;
        this.template_cmd = true;
    }

    public TemplCommand(String name, String exe_method, String state_method, String in_desc, String out_desc) {
        super(name, 0, 0, in_desc, out_desc);
        this.exe_method_name = exe_method;
        this.state_method_name = state_method;
        this.template_cmd = true;
    }

    public TemplCommand(String name, String exe_method, String in_desc, String out_desc) {
        super(name, 0, 0, in_desc, out_desc);
        this.exe_method_name = exe_method;
        this.state_method_name = null;
        this.template_cmd = true;
    }

    public TemplCommand(String name) {
        super(name, 0, 0);
    }

    public TemplCommand(String name, String in_desc, String out_desc, double dummy) {
        super(name, 0, 0, in_desc, out_desc);
    }

    public TemplCommand(String name, String exe_method, String state_method, DispLevel disp) {
        super(name, 0, 0, disp);
        this.exe_method_name = exe_method;
        this.state_method_name = state_method;
        this.template_cmd = true;
    }

    public TemplCommand(String name, String exe_method, DispLevel disp) {
        super(name, 0, 0, disp);
        this.exe_method_name = exe_method;
        this.state_method_name = null;
        this.template_cmd = true;
    }

    public TemplCommand(String name, String exe_method, String state_method, String in_desc, String out_desc, DispLevel disp) {
        super(name, 0, 0, in_desc, out_desc, disp);
        this.exe_method_name = exe_method;
        this.state_method_name = state_method;
        this.template_cmd = true;
    }

    public TemplCommand(String name, String exe_method, String in_desc, String out_desc, DispLevel disp) {
        super(name, 0, 0, in_desc, out_desc, disp);
        this.exe_method_name = exe_method;
        this.state_method_name = null;
        this.template_cmd = true;
    }

    public TemplCommand(String name, DispLevel disp) {
        super(name, 0, 0, disp);
    }

    public TemplCommand(String name, String in_desc, String out_desc, DispLevel disp, double dummy) {
        super(name, 0, 0, in_desc, out_desc, disp);
    }

    public void analyse_methods() throws DevFailed {
        this.exe_method = this.analyse_method_exe(this.device_class_name, this.exe_method_name);
        if (this.state_method_name != null) {
            this.state_method = this.analyse_method_state(this.device_class_name, this.state_method_name);
        }
    }

    private Method analyse_method_exe(String cl_name, String exe_method) throws DevFailed {
        Method meth = null;
        try {
            Class<?> ret_type;
            Class<?>[] param_type;
            StringBuffer mess;
            StringBuffer str = new StringBuffer(cl_name);
            str.append(".");
            str.append(cl_name);
            Class<?> cl = Class.forName(str.toString());
            Method[] meth_list = cl.getDeclaredMethods();
            if (meth_list.length == 0) {
                mess = new StringBuffer("Command ");
                mess.append(this.name);
                mess.append(": Can't find method ");
                mess.append(exe_method);
                Except.throw_exception("API_MethodNotFound", new String(mess), new String("TemplCommand.analyse_method_exe()"));
            }
            if (!Modifier.isPublic((meth = this.find_method(meth_list, exe_method)).getModifiers())) {
                mess = new StringBuffer("Command ");
                mess.append(this.name);
                mess.append(": The method ");
                mess.append(exe_method);
                mess.append(" is not public");
                Except.throw_exception("API_MethodArgument", new String(mess), new String("TemplCommand.analyse_method_exe()"));
            }
            if ((param_type = meth.getParameterTypes()).length != 0) {
                StringBuffer mess2 = new StringBuffer("Command ");
                mess2.append(this.name);
                mess2.append(": Argument(s) defined for method ");
                mess2.append(exe_method);
                Except.throw_exception("API_MethodArgument", new String(mess2), new String("TemplCommand.analyse_method_exe()"));
            }
            if (!(ret_type = meth.getReturnType()).equals(Void.TYPE)) {
                StringBuffer mess3 = new StringBuffer("Command ");
                mess3.append(this.name);
                mess3.append(": Return type defined for method ");
                mess3.append(exe_method);
                Except.throw_exception("API_MethodArgument", new String(mess3), new String("TemplCommand.analyse_method_exe()"));
            }
        }
        catch (ClassNotFoundException ex) {
            StringBuffer mess = new StringBuffer("Command ");
            mess.append(this.name);
            mess.append(": Can't find class ");
            mess.append(cl_name);
            Except.throw_exception("API_ClassNotFound", new String(mess), new String("TemplCommand.analyse_method_exe()"));
        }
        catch (SecurityException ex) {
            StringBuffer mess = new StringBuffer("Command ");
            mess.append(this.name);
            mess.append(": Security violation when trying to retrieve method list for class ");
            mess.append(cl_name);
            Except.throw_exception("API_JavaRuntimeSecurityException", new String(mess), new String("TemplCommand.analyse_method_exe()"));
        }
        return meth;
    }

    protected Method analyse_method_state(String cl_name, String state_method) throws DevFailed {
        Method s_meth = null;
        try {
            Class<?> s_ret_type;
            Class<?> any_class;
            Class<?>[] s_param_type;
            StringBuffer mess;
            StringBuffer str = new StringBuffer(cl_name);
            str.append(".");
            str.append(cl_name);
            Class<?> cl = Class.forName(str.toString());
            Method[] meth_list = cl.getDeclaredMethods();
            if (meth_list.length == 0) {
                mess = new StringBuffer("Command ");
                mess.append(this.name);
                mess.append(": Can't find method ");
                mess.append(state_method);
                Except.throw_exception("API_MethodNotFound", new String(mess), new String("TemplCommand.analyse_method_state()"));
            }
            if (!Modifier.isPublic((s_meth = this.find_method(meth_list, state_method)).getModifiers())) {
                mess = new StringBuffer("Command ");
                mess.append(this.name);
                mess.append(": The method ");
                mess.append(state_method);
                mess.append(" is not public");
                Except.throw_exception("API_MethodArgument", new String(mess), new String("TemplCommand.analyse_method_state()"));
            }
            if ((s_param_type = s_meth.getParameterTypes()).length != 1) {
                StringBuffer mess2 = new StringBuffer("Command ");
                mess2.append(this.name);
                mess2.append(": Wrong number of argument defined for method ");
                mess2.append(state_method);
                Except.throw_exception("API_MethodArgument", new String(mess2), new String("TemplCommand.analyse_method_state()"));
            }
            if (!s_param_type[0].equals(any_class = Class.forName("org.omg.CORBA.Any"))) {
                StringBuffer mess3 = new StringBuffer("Command ");
                mess3.append(this.name);
                mess3.append(": Incorrect argument type for method ");
                mess3.append(state_method);
                Except.throw_exception("API_MethodArgument", new String(mess3), new String("TemplCommand.analyse_method_state()"));
            }
            if (!(s_ret_type = s_meth.getReturnType()).equals(Boolean.TYPE)) {
                StringBuffer mess4 = new StringBuffer("Command ");
                mess4.append(this.name);
                mess4.append(": Bad return type for method ");
                mess4.append(state_method);
                mess4.append(". Should be boolean");
                Except.throw_exception("API_MethodArgument", new String(mess4), new String("TemplCommand.analyse_method_state()"));
            }
        }
        catch (ClassNotFoundException ex) {
            StringBuffer mess = new StringBuffer("Command ");
            mess.append(this.name);
            mess.append(": Can't find class ");
            mess.append(cl_name);
            Except.throw_exception("API_ClassNotFound", new String(mess), new String("TemplCommand.analyse_method_state()"));
        }
        catch (SecurityException ex) {
            StringBuffer mess = new StringBuffer("Command ");
            mess.append(this.name);
            mess.append(": Security violation when trying to retrieve method list for class ");
            mess.append(cl_name);
            Except.throw_exception("API_JavaRuntimeSecurityException", new String(mess), new String("TemplCommand.analyse_method_state()"));
        }
        return s_meth;
    }

    protected Method find_method(Method[] meth_list, String meth_name) throws DevFailed {
        int i;
        Method meth_found = null;
        for (i = 0; i < meth_list.length; ++i) {
            if (!meth_name.equals(meth_list[i].getName())) continue;
            for (int j = i + 1; j < meth_list.length; ++j) {
                if (!meth_name.equals(meth_list[j].getName())) continue;
                StringBuffer mess = new StringBuffer("Method overloading is not supported for command (Method name = ");
                mess.append(meth_name);
                mess.append(")");
                Except.throw_exception("API_OverloadingNotSupported", new String(mess), new String("TemplCommand.find_method()"));
            }
            meth_found = meth_list[i];
            break;
        }
        if (i == meth_list.length) {
            StringBuffer mess = new StringBuffer("Command ");
            mess.append(this.name);
            mess.append(": Can't find method ");
            mess.append(meth_name);
            Except.throw_exception("API_MethodNotFound", new String(mess), new String("TemplCommand.find_method()"));
        }
        return meth_found;
    }

    protected int get_tango_type(Class type_cl) throws DevFailed {
        int type = 0;
        if (type_cl.isArray()) {
            String type_name = type_cl.getComponentType().getName();
            if (type_name.equals("byte")) {
                type = 9;
            } else if (type_name.equals("short")) {
                type = 10;
            } else if (type_name.equals("int")) {
                type = 11;
            } else if (type_name.equals("float")) {
                type = 12;
            } else if (type_name.equals("double")) {
                type = 13;
            } else if (type_name.equals("java.lang.String")) {
                type = 16;
            } else {
                StringBuffer mess = new StringBuffer("Argument array of ");
                mess.append(type_name);
                mess.append(" not supported");
                Except.throw_exception("API_MethodArgument", new String(mess), new String("TemplCommandIn.get_tango_type()"));
            }
        } else {
            String type_name = type_cl.getName();
            if (type_name.equals("boolean")) {
                type = 1;
            } else if (type_name.equals("short")) {
                type = 2;
            } else if (type_name.equals("int")) {
                type = 3;
            } else if (type_name.equals("float")) {
                type = 4;
            } else if (type_name.equals("double")) {
                type = 5;
            } else if (type_name.equals("java.lang.String")) {
                type = 8;
            } else if (type_name.equals("Tango.DevVarLongStringArray")) {
                type = 17;
            } else if (type_name.equals("Tango.DevVarDoubleStringArray")) {
                type = 18;
            } else if (type_name.equals("Tango.State")) {
                type = 19;
            } else {
                StringBuffer mess = new StringBuffer("Argument ");
                mess.append(type_name);
                mess.append(" not supported");
                Except.throw_exception("API_MethodArgument", new String(mess), new String("TemplCommandIn.get_tango_type()"));
            }
        }
        return type;
    }

    public boolean is_allowed(DeviceImpl dev, Any data_in) {
        if (this.state_method == null) {
            return true;
        }
        try {
            Object[] meth_param = new Object[]{data_in};
            Object obj = this.state_method.invoke((Object)dev, meth_param);
            return (Boolean)obj;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public Any execute(DeviceImpl dev, Any in_any) throws DevFailed {
        try {
            Object[] meth_param = new Object[]{};
            this.exe_method.invoke((Object)dev, meth_param);
        }
        catch (InvocationTargetException e) {
            throw (DevFailed)e.getTargetException();
        }
        catch (IllegalArgumentException e) {
            StringBuffer mess = new StringBuffer("Argument error when trying to invoke method ");
            mess.append(this.exe_method);
            Except.throw_exception("API_MethodArgument", new String(mess), new String("TemplCommand.execute()"));
        }
        catch (IllegalAccessException e) {
            StringBuffer mess = new StringBuffer("Argument error when trying to invoke method ");
            mess.append(this.exe_method);
            Except.throw_exception("API_MethodArgument", new String(mess), new String("TemplCommand.execute()"));
        }
        return this.insert();
    }
}

