/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.Date;
import java.util.Vector;
import org.omg.CORBA.Any;

public class PollRing
extends Vector
implements TangoConst {
    private int max_elt;

    PollRing() {
        this.max_elt = 10;
    }

    PollRing(int max_size) {
        this.max_elt = max_size <= 0 ? 10 : max_size;
    }

    void insert_data(Any any, TimeVal t) {
        if (this.size() >= this.max_elt) {
            this.remove(0);
        }
        this.add(new RingElt(any, t));
    }

    void insert_data(AttributeValue attr_val, TimeVal t) {
        if (this.size() >= this.max_elt) {
            this.remove(0);
        }
        this.add(new RingElt(attr_val, t));
    }

    void insert_except(DevFailed ex, TimeVal t) {
        if (this.size() >= this.max_elt) {
            this.remove(0);
        }
        this.add(new RingElt(ex, t));
    }

    double[] get_delta_t(int nb) throws DevFailed {
        if (this.size() < 2) {
            Except.throw_exception("API_PollRingBufferEmpty", "Not enough data stored yet in polling ring buffer", "PollRing.get_delta_t");
        }
        if (nb >= this.size()) {
            nb = this.size() - 1;
        }
        double[] result = new double[nb];
        int start = this.size() - nb - 1;
        if (start < 0) {
            start = 0;
        }
        int i = start;
        int idx = 0;
        while (i < this.size() - 1) {
            RingElt ref = (RingElt)this.elementAt(i + 1);
            RingElt prev = (RingElt)this.elementAt(i);
            double t_ref = (double)ref.when.tv_sec + (double)ref.when.tv_usec / 1000000.0;
            double t_prev = (double)prev.when.tv_sec + (double)prev.when.tv_usec / 1000000.0;
            result[idx] = t_ref - t_prev;
            ++i;
            ++idx;
        }
        return result;
    }

    TimeVal get_last_insert_date() {
        return this.get_last_element().when;
    }

    boolean is_last_an_error() {
        return this.get_last_element().except != null;
    }

    DevFailed get_last_except() {
        return this.get_last_element().except;
    }

    Any get_last_cmd_result() throws DevFailed {
        RingElt record = this.get_last_element();
        if (record.except == null) {
            return record.cmd_result;
        }
        throw record.except;
    }

    AttributeValue get_last_attr_value() throws DevFailed {
        RingElt record = this.get_last_element();
        if (record.except == null) {
            return record.attr_value;
        }
        throw record.except;
    }

    DevCmdHistory[] get_cmd_history(int nb) {
        int start;
        DevCmdHistory[] histo = new DevCmdHistory[nb];
        for (int i = start = this.size() - nb; i < this.size(); ++i) {
            DevError[] errors;
            boolean cmd_failed;
            RingElt record = (RingElt)this.elementAt(i);
            TimeVal time = record.when;
            Any value = record.cmd_result;
            if (record.except == null) {
                cmd_failed = false;
                errors = new DevError[]{};
            } else {
                cmd_failed = true;
                errors = record.except.errors;
            }
            histo[i - start] = new DevCmdHistory(time, cmd_failed, value, errors);
        }
        return histo;
    }

    DevAttrHistory[] get_attr_history(int nb, int type) {
        int start;
        DevAttrHistory[] histo = new DevAttrHistory[nb];
        for (int i = start = this.size() - nb; i < this.size(); ++i) {
            DevError[] errors;
            boolean attr_failed;
            RingElt record = (RingElt)this.elementAt(i);
            AttributeValue value = record.attr_value;
            if (record.except == null) {
                attr_failed = false;
                errors = new DevError[]{};
            } else {
                attr_failed = true;
                errors = record.except.errors;
            }
            histo[i - start] = new DevAttrHistory(attr_failed, value, errors);
        }
        return histo;
    }

    private RingElt get_last_element() {
        return (RingElt)this.lastElement();
    }

    boolean is_empty() {
        return this.size() == 0;
    }

    class RingElt {
        Any cmd_result;
        DevFailed except;
        TimeVal when;
        AttributeValue attr_value;

        public RingElt() {
            this.when = new TimeVal(0, 0, 0);
            this.cmd_result = null;
            this.attr_value = null;
            this.except = null;
        }

        public RingElt(Any any, TimeVal t) {
            this.when = t;
            this.when.tv_sec += 1002000000;
            this.cmd_result = any;
            this.attr_value = null;
            this.except = null;
        }

        public RingElt(AttributeValue attr_val, TimeVal t) {
            this.when = t;
            this.when.tv_sec += 1002000000;
            this.cmd_result = null;
            this.attr_value = attr_val;
            this.attr_value.time = this.when;
            this.except = null;
        }

        public RingElt(DevFailed ex, TimeVal t) {
            this.when = t;
            this.when.tv_sec += 1002000000;
            this.cmd_result = null;
            try {
                this.cmd_result = ApiUtil.get_orb().create_any();
            }
            catch (DevFailed e) {
                // empty catch block
            }
            this.attr_value = new AttributeValue(this.cmd_result, AttrQuality.ATTR_INVALID, this.when, "", 0, 0);
            this.except = ex;
        }

        public String toString() {
            long t0 = (long)(this.when.tv_sec + 1002000000) * 1000L + (long)(this.when.tv_usec / 1000);
            Date date = new Date(t0);
            return "\t" + date.toString();
        }
    }
}

