/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.AttrReadEvent;
import fr.esrf.TangoApi.AttrWrittenEvent;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.CmdDoneEvent;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import org.omg.CORBA.Request;

class AsyncCallObject
implements ApiDefs {
    int id = 0;
    Request request;
    DeviceProxy dev;
    int cmd_type;
    CallBack cb;
    int reply_model;
    String[] names;

    AsyncCallObject(Request request, DeviceProxy deviceProxy, int n, String[] stringArray, int n2) {
        this.request = request;
        this.dev = deviceProxy;
        this.cmd_type = n;
        this.names = stringArray;
        this.reply_model = n2;
    }

    AsyncCallObject(Request request, DeviceProxy deviceProxy, int n, String[] stringArray) {
        this(request, deviceProxy, n, stringArray, 1);
    }

    void command_inout_reply(int n) {
        DevError[] devErrorArray = null;
        DeviceData deviceData = null;
        try {
            deviceData = n == -1 ? this.dev.command_inout_reply(this) : this.dev.command_inout_reply(this, n);
        }
        catch (AsynReplyNotArrived asynReplyNotArrived) {
            devErrorArray = asynReplyNotArrived.errors;
        }
        catch (DevFailed devFailed) {
            devErrorArray = devFailed.errors;
        }
        this.cb.cmd_ended(new CmdDoneEvent(this.dev, this.names[0], deviceData, devErrorArray));
    }

    void read_attribute_reply(int n) {
        DevError[] devErrorArray = null;
        DeviceAttribute[] deviceAttributeArray = null;
        try {
            deviceAttributeArray = n == -1 ? this.dev.read_attribute_reply(this.id) : this.dev.read_attribute_reply(this.id, n);
        }
        catch (AsynReplyNotArrived asynReplyNotArrived) {
            devErrorArray = asynReplyNotArrived.errors;
        }
        catch (DevFailed devFailed) {
            devErrorArray = devFailed.errors;
        }
        this.cb.attr_read(new AttrReadEvent(this.dev, this.names, deviceAttributeArray, devErrorArray));
    }

    void write_attribute_reply(int n) {
        DevError[] devErrorArray = null;
        try {
            if (n == -1) {
                this.dev.write_attribute_reply(this.id);
            } else {
                this.dev.write_attribute_reply(this.id, 0);
            }
        }
        catch (AsynReplyNotArrived asynReplyNotArrived) {
            devErrorArray = asynReplyNotArrived.errors;
        }
        catch (DevFailed devFailed) {
            devErrorArray = devFailed.errors;
        }
        this.cb.attr_written(new AttrWrittenEvent(this.dev, this.names, devErrorArray));
    }

    void manage_reply(int n) {
        switch (this.cmd_type) {
            case 0: {
                this.command_inout_reply(n);
                break;
            }
            case 1: {
                this.read_attribute_reply(n);
                break;
            }
            case 2: {
                this.write_attribute_reply(n);
            }
        }
    }

    void manage_reply() {
        this.manage_reply(-1);
    }
}

